/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.AsyncListenerWrapper;
import com.ibm.ws.management.event.NotificationService;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ZServantListener
implements NotificationListener {
    private static TraceComponent tc = Tr.register(ZServantListener.class, "Admin", "com.ibm.ws.management.resources.event");
    private NotificationService notifService;
    private static ZServantListener instance = null;

    public ZServantListener(NotificationService notifService) {
        this.notifService = notifService;
        instance = this;
    }

    public static ZServantListener getInstance() {
        return instance;
    }

    public void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String nodeName = adminService.getNodeName();
            String processName = adminService.getProcessName();
            ObjectName queryName = new ObjectName(adminService.getDomainName() + ":" + "type=ControlAdminService,node=" + nodeName + ",process=" + processName + ",*");
            MBeanServer mbServer = adminService.getMBeanFactory().getMBeanServer();
            Set names = mbServer.queryNames(queryName, null);
            if (names.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ControlAdminService MBean not registered");
                }
            } else {
                Iterator iterator = names.iterator();
                ObjectName controlAdmin = (ObjectName)iterator.next();
                AdminServiceFactory.getAdminService().getMBeanFactory().getMBeanServer().addNotificationListener(controlAdmin, new AsyncListenerWrapper(this), (NotificationFilter)new ControlAdminServiceFilter(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void handleNotification(Notification notif, Object obj) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", notif);
            }
            if (notif.getType().equals("websphere.ws390.servant.terminated")) {
                ServantMBeanStatus status = (ServantMBeanStatus)notif.getUserData();
                String stoken = status.getServantStoken();
                String cell = AdminServiceFactory.getAdminService().getCellName();
                String node = AdminServiceFactory.getAdminService().getNodeName();
                ServerInfo serverInfo = new ServerInfo(null, cell, node, stoken, null, null, null);
                try {
                    this.notifService.getServantProcessManager().removeDownstreamProcess(serverInfo);
                }
                catch (ConnectorException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.ZServantListener.servantRemoved", (String)"92", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error removing servant", exc);
                    }
                    break block9;
                }
            }
            if (notif.getType().equals("websphere.ws390.servant.started")) {
                ServantMBeanStatus status = (ServantMBeanStatus)notif.getUserData();
                String stoken = status.getServantStoken();
                String cell = AdminServiceFactory.getAdminService().getCellName();
                String node = AdminServiceFactory.getAdminService().getNodeName();
                ServerInfo serverInfo = new ServerInfo(null, cell, node, stoken, null, null, null);
                try {
                    this.notifService.getServantProcessManager().addDownstreamProcess(serverInfo);
                }
                catch (ConnectorException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.ZServantListener.servantAdded", (String)"82", (Object)this);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "error adding servant", exc);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private class ControlAdminServiceFilter
    implements NotificationFilter {
        private static final long serialVersionUID = -3657264784563371234L;

        private ControlAdminServiceFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ControlAdminServiceFilter.isNotificationEnabled", notification.getType());
            }
            boolean enabled = false;
            if (notification.getType().equals("websphere.ws390.servant.terminated") || notification.getType().equals("websphere.ws390.servant.started")) {
                enabled = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ControlAdminServiceFilter.isNotificationEnabled", new Boolean(enabled));
            }
            return enabled;
        }
    }
}

