/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.ServantAdminService;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.ServantNotificationListener;
import com.ibm.ws.management.util.Utils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

public class PushToServantNotificationSender
implements ServantNotificationListener,
Serializable {
    private static final long serialVersionUID = 2786391804985520316L;
    private static TraceComponent tc = Tr.register(PushToServantNotificationSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private String servantStoken;
    private ObjectName servantNotifServiceMBean;
    private transient ServantAdminService servantAdmin;

    public PushToServantNotificationSender() {
        block9: {
            this.servantStoken = null;
            this.servantNotifServiceMBean = null;
            this.servantAdmin = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>");
            }
            this.servantStoken = AdminHelper.getPlatformHelper().getServantToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servantStoken", this.servantStoken);
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String nodeName = adminService.getNodeName();
                String processName = adminService.getProcessName();
                ObjectName queryName = new ObjectName(adminService.getDomainName() + ":" + "type=NotificationService,node=" + nodeName + ",process=" + processName + ",*");
                MBeanServer mbServer = adminService.getMBeanFactory().getMBeanServer();
                Set names = mbServer.queryNames(queryName, null);
                if (names.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NotificationService MBean not registered");
                    }
                } else {
                    Iterator iterator = names.iterator();
                    this.servantNotifServiceMBean = (ObjectName)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "servantNotifServiceMBean", this.servantNotifServiceMBean);
                    }
                }
            }
            catch (MalformedObjectNameException exc) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "error creating notification service object name", exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void setRunLocally() {
    }

    public void handleNotifications(Notification[] notifications) throws ConnectorException {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotifications", NotificationService.getInfo(notifications));
            }
            if (this.servantAdmin == null) {
                this.initialize();
                if (this.servantAdmin == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleNotifications");
                    }
                    return;
                }
            }
            if (AdminHelper.getPlatformHelper().isServerShuttingDown()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNotifications", "server shutdown");
                }
                return;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Propagating notifs to servant " + this.servantStoken);
                }
                this.servantAdmin.invoke(this.servantNotifServiceMBean, "propagateNotifications", new Object[]{notifications}, new String[]{"[Ljavax.management.Notification;"});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Finished propagating notifs to servant " + this.servantStoken);
                }
            }
            catch (Exception exc) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "error propagating notifs to servant " + this.servantStoken, exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotifications");
        }
    }

    private void initialize() throws ConnectorException {
        block3: {
            if (this.servantStoken != null && this.servantNotifServiceMBean != null) {
                try {
                    this.servantAdmin = Utils.getServantAdminService();
                    this.servantAdmin.setServantToken(this.servantStoken);
                }
                catch (Exception exc) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "error initializing servant admin service", exc);
                }
            }
        }
    }

    public String getServantStoken() {
        return this.servantStoken;
    }

    public String toString() {
        return "PushToServantNotificationSender: servant = " + this.servantStoken;
    }
}

