/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class NotificationInfo
implements NotificationFilter {
    private static final long serialVersionUID = 6448465470064588827L;
    private static TraceComponent tc = Tr.register(NotificationInfo.class, "Admin", "com.ibm.ws.management.resources.event");
    private final ObjectName name;
    private final NotificationFilter filter;
    private transient Vector enabledFilterSupportTypes;

    public NotificationInfo(ObjectName name, NotificationFilter filter) {
        this.name = name;
        this.filter = filter;
        this.initializeFilterSupportTypes();
    }

    private void initializeFilterSupportTypes() {
        if (this.enabledFilterSupportTypes == null && this.filter instanceof NotificationFilterSupport) {
            this.enabledFilterSupportTypes = ((NotificationFilterSupport)this.filter).getEnabledTypes();
        }
    }

    public ObjectName getName() {
        return this.name;
    }

    public NotificationFilter getFilter() {
        return this.filter;
    }

    public boolean contains(ObjectName name, NotificationFilter filter) {
        return this.containsName(name) && this.containsFilter(filter);
    }

    public boolean containsName(ObjectName givenName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsName", givenName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current name:", this.name);
        }
        boolean isContained = NotificationInfo.containsName(this.name, givenName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsName", new Boolean(isContained));
        }
        return isContained;
    }

    public static boolean containsName(ObjectName objName, ObjectName specificName) {
        boolean isContained;
        block5: {
            block4: {
                isContained = true;
                if (objName.isPropertyPattern()) break block4;
                if (objName.getCanonicalName().equals(specificName.getCanonicalName())) break block5;
                isContained = false;
                break block5;
            }
            if (!NotificationInfo.containsDomain(objName.getDomain(), specificName.getDomain())) {
                isContained = false;
            } else {
                Hashtable keys = objName.getKeyPropertyList();
                Enumeration e = keys.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.equals("*")) continue;
                    String value = specificName.getKeyProperty(key);
                    if (value == null) {
                        isContained = false;
                        break;
                    }
                    if (objName.getKeyProperty(key).equals(value)) continue;
                    isContained = false;
                    break;
                }
            }
        }
        return isContained;
    }

    private static boolean containsDomain(String domainName, String specificName) {
        return NotificationInfo.containsPattern(domainName, specificName);
    }

    private static boolean containsPattern(String pattern, String name) {
        int curIndex = -1;
        for (int i = 0; i < pattern.length(); ++i) {
            ++curIndex;
            char c = pattern.charAt(i);
            if (c == '*') {
                return NotificationInfo.matchWildCard(pattern.substring(i), name.substring(curIndex));
            }
            if (name.length() < curIndex + 1) {
                return false;
            }
            char curChar = name.charAt(curIndex);
            if (c == '?' || c == curChar) continue;
            return false;
        }
        return name.length() <= curIndex + 1;
    }

    private static boolean matchWildCard(String pattern, String name) {
        if (pattern.equals("*")) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (!NotificationInfo.containsPattern(pattern.substring(1), name.substring(i))) continue;
            return true;
        }
        return false;
    }

    public boolean containsFilter(NotificationFilter givenFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsFilter", this.toFilterString(givenFilter));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current filter:", this.toFilterString(this.filter));
        }
        boolean isContained = false;
        if (this.filter == null) {
            isContained = true;
        } else if (givenFilter == null) {
            isContained = false;
        } else {
            this.initializeFilterSupportTypes();
            if (this.enabledFilterSupportTypes != null && givenFilter instanceof NotificationFilterSupport) {
                Vector givenEnabledTypes = ((NotificationFilterSupport)givenFilter).getEnabledTypes();
                isContained = this.enabledFilterSupportTypes.containsAll(givenEnabledTypes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsFilter", new Boolean(isContained));
        }
        return isContained;
    }

    private String toFilterString(NotificationFilter filter) {
        if (filter == null) {
            return "null";
        }
        if (filter instanceof NotificationFilterSupport) {
            return "NotificationFilterSupport: " + ((NotificationFilterSupport)filter).getEnabledTypes();
        }
        return filter.toString();
    }

    public boolean isNotificationEnabled(Notification event2) {
        ObjectName source = null;
        try {
            source = (ObjectName)event2.getSource();
        }
        catch (ClassCastException exc) {
            Tr.warning(tc, "ADME0007W", new String[]{event2.getType(), event2.getSource().toString()});
            return false;
        }
        return this.containsName(source) && (this.filter == null || this.filter.isNotificationEnabled(event2));
    }

    public boolean isFilterEnabled(Notification event2) {
        return this.filter == null || this.filter.isNotificationEnabled(event2);
    }

    public String toString() {
        return "NotificationInfo: [name=" + this.name + ";filter=" + this.filter + "]";
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            NotificationInfo entry = (NotificationInfo)o;
            return (entry.name == null && this.name == null || entry.name.equals(this.name)) && (entry.filter == null && this.filter == null || entry.filter.equals(this.filter));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.filter != null) {
            result = 57 * result + this.filter.hashCode();
        }
        return result;
    }
}

