/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.NotificationDispatcher;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.util.ThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class LocalNotificationService
implements WsNotifListener,
WsNotifListenerContainer {
    private static TraceComponent tc = Tr.register(LocalNotificationService.class, "Admin", "com.ibm.ws.management.resources.event");
    public static final long TIME_TO_WAIT_FOR_LISTENER = 60000L;
    private static final int DISPATCH_POOL_MIN = 1;
    private static final int DISPATCH_POOL_MAX = 100;
    private static final int ZOS_DISPATCH_POOL_MAX = 50;
    private final String _traceThis;
    private List listeners;
    private NotificationDispatcher dispatcher;
    private ThreadPool dispatchPool;
    private boolean listenersUpdated = true;

    public LocalNotificationService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LocalNotificationService");
        }
        this.listeners = new ArrayList();
        long keepAliveTime = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Long.getLong("com.ibm.ws.management.event.LocalNotificationService.threadKeepAliveTime", 60000L);
            }
        });
        this.dispatchPool = AdminHelper.getPlatformHelper().isZOS() ? new ThreadPool("LocalNotificationServiceDispatcher", 1, 50) : new ThreadPool("LocalNotificationServiceDispatcher", 1, 100);
        this.dispatchPool.setKeepAliveTime(keepAliveTime);
        if (AdminServiceFactory.getAdminService() != null) {
            this.dispatchPool.setContextClassLoader((ClassLoader)ExtClassLoader.getInstance());
        }
        this._traceThis = "this=LocalNotificationService@" + this.hashCode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LocalNotificationService", this._traceThis);
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{this._traceThis, name, listener, filter, handback});
        }
        this.addListenerInternal(name, listener, filter, handback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListenerExtended", new Object[]{this._traceThis, name, listener, filter, handback});
        }
        this.addListenerInternal(name, listener, filter, handback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListenerExtended");
        }
    }

    protected boolean addListenerInternal(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        ListenerInfo li = this.createListenerInfo(name, listener, filter, handback);
        return this.addListener(li);
    }

    protected ListenerInfo createListenerInfo(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        return new ListenerInfo(name, listener, filter, handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(WsNotifListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", new Object[]{this._traceThis, listener});
        }
        boolean listenerAdded = false;
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                listenerAdded = true;
                this.listenersUpdated = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener", listenerAdded);
        }
        return listenerAdded;
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{this._traceThis, name, listener});
        }
        this.removeListenerInternal(name, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{this._traceThis, name, listener});
        }
        this.removeListenerInternal(name, listener, filter, handback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListenerExtended(ObjectName name, NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListenerExtended", new Object[]{this._traceThis, name, listener});
        }
        this.removeListenerInternal(name, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListenerExtended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListenerInternal(ObjectName name, NotificationListener listener) throws ListenerNotFoundException {
        List list = this.listeners;
        synchronized (list) {
            ListenerInfo info = this.getListenerInfo(name, listener);
            if (info == null) {
                throw new ListenerNotFoundException("Did not find listener " + listener);
            }
            while (info != null) {
                this.listeners.remove(info);
                info = this.getListenerInfo(name, listener);
            }
            this.listenersUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListenerInternal(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        List list = this.listeners;
        synchronized (list) {
            ListenerInfo info = this.getListenerInfo(name, listener, filter, handback);
            if (info == null) {
                throw new ListenerNotFoundException("Did not find listener " + listener);
            }
            while (info != null) {
                this.listeners.remove(info);
                info = this.getListenerInfo(name, listener, filter, handback);
            }
            this.listenersUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(WsNotifListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", new Object[]{this._traceThis, listener});
        }
        boolean listenerRemoved = false;
        List list = this.listeners;
        synchronized (list) {
            listenerRemoved = this.listeners.remove(listener);
            if (listenerRemoved) {
                this.listenersUpdated = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener", listenerRemoved);
        }
        return listenerRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumListeners() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    private ListenerInfo getListenerInfo(ObjectName name, NotificationListener listener) {
        ListenerInfo result = null;
        for (ListenerInfo info : this.listeners) {
            if (!info.isMatching(name, listener)) continue;
            result = info;
            break;
        }
        return result;
    }

    private ListenerInfo getListenerInfo(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        ListenerInfo result = null;
        for (ListenerInfo info : this.listeners) {
            if (!info.isMatching(name, listener, filter, handback)) continue;
            result = info;
            break;
        }
        return result;
    }

    public boolean isNotificationEnabled(Notification n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{this._traceThis, event2.getType() + "[source=" + event2.getSource() + "]"});
        }
        List list = this.listeners;
        synchronized (list) {
            if (this.listenersUpdated) {
                WsNotifListener[] listenersCopy = new ListenerInfo[this.listeners.size()];
                listenersCopy = this.listeners.toArray(listenersCopy);
                this.dispatcher = new NotificationDispatcher(this, listenersCopy, true, this.dispatchPool);
            }
        }
        this.dispatcher.handleNotification(event2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public String toString() {
        return "LocalNotificationService@" + this.hashCode();
    }
}

