/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.RemoteSender;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.NotSerializableException;
import javax.management.Notification;
import javax.security.auth.Subject;
import org.apache.soap.SOAPException;

public abstract class AbstractPushRemoteSender
extends RemoteSender
implements AlarmListener {
    private static TraceComponent tc = Tr.register(AbstractPushRemoteSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int MAX_CACHED = 5;
    private static final int BATCH_SIZE = 20;
    private static final long MAX_NORMAL_WAIT_TIME = 500L;
    private static final long MAX_FAILURE_WAIT_TIME = 60000L;
    private Alarm sendAlarm = null;
    private long currentWaitTime;
    private boolean connectorExceptionOccurred = false;
    private String profileKey = AdminContext.peek();

    public AbstractPushRemoteSender() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "profileKey for Sender is: " + this.profileKey);
        }
        this.currentWaitTime = 500L;
    }

    public void handleNotification(Notification event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", NotificationService.getInfo(event2));
        }
        super.handleNotification(event2);
        if (this.getNumNotifications() >= 5 || this.isStoppingNotification(event2) || this.isStoppedNotification(event2)) {
            this.flushNotifications();
        } else {
            this.createAlarmIfNecessary(this.currentWaitTime);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void stop() {
        super.stop();
        this.cancelAlarm();
    }

    private boolean isStoppingNotification(Notification n) {
        return n.getType().endsWith("stopping");
    }

    private boolean isStoppedNotification(Notification n) {
        return n.getType().endsWith("stopped");
    }

    protected void receiverPermanentlyUnavailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiverPermanentlyUnavailable");
        }
        super.receiverPermanentlyUnavailable();
        this.stop();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiverPermanentlyUnavailable");
        }
    }

    private synchronized void cancelAlarm() {
        if (this.sendAlarm != null) {
            this.sendAlarm.cancel();
            this.deleteAlarm();
        }
    }

    private synchronized void deleteAlarm() {
        this.sendAlarm = null;
    }

    private synchronized void createAlarmIfNecessary(long timeToWait) {
        if (this.isActive() && this.sendAlarm == null && this.getNumNotifications() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting alarm for " + timeToWait + "ms");
            }
            this.sendAlarm = AlarmManager.createNonDeferrable((long)timeToWait, (AlarmListener)this);
        }
    }

    private void flushNotifications() {
        this.cancelAlarm();
        this.createAlarmIfNecessary(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmContext) {
        Object v1;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm");
            }
            Subject subject = null;
            boolean pushed = false;
            try {
                block23: {
                    pushed = AdminContext.push((String)this.profileKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "profileKey for Alarm is: " + this.profileKey);
                    }
                    if ((subject = SecurityHelper.getServerSubject()) != null) {
                        SecurityHelper.pushInvocationSubject(subject);
                    }
                    if (this.getNumNotifications() > 0) {
                        Notification[] notifs = this.getNotifications(20);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Sending " + notifs.length + " notifications " + "to " + this.getIdentifier());
                        }
                        try {
                            if (!this.pushNotifications(notifs)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "send returned false; requeuing");
                                }
                                this.requeueNotifications(notifs);
                            }
                            this.connectorExceptionOccurred = false;
                        }
                        catch (ConnectorException exc) {
                            Throwable th = exc.getCause();
                            if (th instanceof SOAPException) {
                                Throwable th1 = ((SOAPException)th).getTargetException();
                                if (th1 instanceof NotSerializableException) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "NotSerializableException not requeuing", exc);
                                    }
                                } else {
                                    this.connectorExceptionOccurred = true;
                                }
                            } else {
                                this.connectorExceptionOccurred = true;
                            }
                            if (!this.connectorExceptionOccurred) break block23;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "send got ConnectorException; requeuing", exc);
                            }
                            this.requeueNotifications(notifs);
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.AbstractPushRemoteSender.alarm", (String)"199", (Object)this);
                        }
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var9_9 = null;
                try {
                    if (subject != null) {
                        SecurityHelper.popInvocationSubject(subject);
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var11_13 = v0;
                this.deleteAlarm();
                this.currentWaitTime = this.connectorExceptionOccurred ? Math.min(60000L, this.currentWaitTime * 2L) : 500L;
                this.createAlarmIfNecessary(this.currentWaitTime);
                throw throwable;
            }
            try {
                if (subject != null) {
                    SecurityHelper.popInvocationSubject(subject);
                }
                v1 = null;
                break block24;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var11_12 = v1;
        this.deleteAlarm();
        this.currentWaitTime = this.connectorExceptionOccurred ? Math.min(60000L, this.currentWaitTime * 2L) : 500L;
        this.createAlarmIfNecessary(this.currentWaitTime);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    protected abstract boolean pushNotifications(Notification[] var1) throws ConnectorException;
}

