/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLDocument {
    private static TraceComponent tc = Tr.register(XMLDocument.class);
    protected Document xmlDoc;

    public XMLDocument() {
    }

    public XMLDocument(String docType) throws Exception {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setValidating(false);
            DocumentBuilder dataDocBuilder = docBuilderFactory.newDocumentBuilder();
            Document tempdoc = dataDocBuilder.newDocument();
            DOMImplementation domImpl = tempdoc.getImplementation();
            DocumentType doctypeNode = domImpl.createDocumentType(docType, null, null);
            this.xmlDoc = domImpl.createDocument("http://www.jxta.org/jxta", docType, doctypeNode);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.XMLDocument.XMLDocument", (String)"59", (Object)this);
            this.xmlDoc = null;
            throw e;
        }
    }

    public XMLDocument(InputStream stream) throws Exception {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(false);
            docBuilderFactory.setValidating(false);
            DocumentBuilder dataDocBuilder = docBuilderFactory.newDocumentBuilder();
            this.xmlDoc = dataDocBuilder.parse(new InputSource(stream));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.XMLDocument.XMLDocument", (String)"86", (Object)this);
            this.xmlDoc = null;
            throw e;
        }
    }

    public Element createElement(String name) {
        return this.xmlDoc.createElement(name);
    }

    public Element createElement(String name, String value) {
        Element root = this.xmlDoc.createElement(name);
        if (null != value) {
            root.appendChild(this.xmlDoc.createTextNode(value));
        }
        return root;
    }

    public void appendChild(Element element) {
        this.getDocumentElement().appendChild(element);
    }

    public void copyElements(XMLDocument fromDoc, Element intoElement) {
        this.copyElements(this, fromDoc.getDocumentElement(), intoElement);
    }

    private void copyElements(XMLDocument intoDoc, Node from, Element intoElement) {
        String name = from.getNodeName();
        String fromValue = from.getNodeValue();
        if (from.getFirstChild().getNodeType() == 3) {
            fromValue = from.getFirstChild().getNodeValue();
        }
        String value = null;
        if (fromValue != null && fromValue instanceof String) {
            value = fromValue;
        }
        Element newElement = intoDoc.createElement(name, value);
        intoElement.appendChild(newElement);
        for (Node child = from.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            this.copyElements(intoDoc, child, newElement);
        }
    }

    public InputStream getInputStream() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStream");
        }
        try {
            StringWriter stringOut = new StringWriter();
            this.sendToWriter(stringOut);
            String orig = stringOut.toString();
            int orig_count = orig.length();
            char[] trimmed = new char[orig_count];
            int trimmed_count = 0;
            for (int i = 0; i < orig_count; ++i) {
                char ch = orig.charAt(i);
                if (ch == '\n' || ch == '\r') continue;
                trimmed[trimmed_count] = ch;
                ++trimmed_count;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStream - successful");
            }
            return new ByteArrayInputStream(String.valueOf(trimmed, 0, trimmed_count).getBytes("UTF-8"));
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.XMLDocument.getInputStream", (String)"189", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStream - failed");
            }
            return null;
        }
    }

    public void sendToStream(OutputStream stream) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(stream));
        this.sendToWriter(out);
        ((Writer)out).flush();
    }

    public Reader getReader() {
        try {
            StringWriter stringOut = new StringWriter();
            this.sendToWriter(stringOut);
            return new StringReader(stringOut.toString());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.XMLDocument.getReader", (String)"222", (Object)this);
            return null;
        }
    }

    public void sendToWriter(Writer stream) throws IOException {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer serializer = tfactory.newTransformer();
            Properties oprops = new Properties();
            oprops.put("method", "xml");
            oprops.put("omit-xml-declaration", "no");
            oprops.put("version", "1.0");
            oprops.put("encoding", "UTF-8");
            oprops.put("indent", "yes");
            serializer.setOutputProperties(oprops);
            serializer.transform(new DOMSource(this.xmlDoc), new StreamResult(stream));
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.XMLDocument.sendToWriter", (String)"242", (Object)this);
            throw new IOException(ex.toString());
        }
    }

    public Element getDocumentElement() {
        return this.xmlDoc.getDocumentElement();
    }

    public String getName() {
        return this.getDocumentElement().getNodeName();
    }

    public String toString() {
        DOMSource source = new DOMSource(this.xmlDoc);
        StreamResult result = new StreamResult(new StringWriter());
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            FFDCFilter.processException((Throwable)te, (String)"com.ibm.ws.management.discovery.XMLDocument.toString", (String)"280");
        }
        return result.getWriter().toString();
    }
}

