/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TcpAdv
extends TransportAdvertisement {
    private static TraceComponent tc = Tr.register(TcpAdv.class);
    protected String port = null;
    protected String protocol = null;
    protected String publicAddress = null;
    protected String localAddress = null;

    public TcpAdv(String port, String protocol, String publicAddress, String localAddress) {
        this.port = port;
        this.protocol = protocol;
        this.publicAddress = publicAddress;
        this.localAddress = localAddress;
    }

    public TcpAdv(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TcpAdv(Element)");
        }
        this.initialize(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TcpAdv(Element)");
        }
    }

    private void initialize(Node root) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node elem = root.getFirstChild(); elem != null; elem = elem.getNextSibling()) {
            if (elem instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + elem.getNodeName() + " value = " + elem.getFirstChild().getNodeValue());
            }
            if (elem.getNodeName().equalsIgnoreCase("Protocol")) {
                this.setProtocol(elem.getFirstChild().getNodeValue());
                continue;
            }
            if (elem.getNodeName().equals("Port")) {
                this.setPort(elem.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (elem.getNodeName().equals("PublicAddress")) {
                this.setPublicAddress(elem.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!elem.getNodeName().equals("LocalAddress")) continue;
            this.setLocalAddress(elem.getFirstChild().getNodeValue().trim());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public XMLDocument getXMLDocument() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument adv = null;
        try {
            adv = new XMLDocument(this.getAdvertisementType());
            Element e = null;
            if (this.getProtocol() != null) {
                e = adv.createElement("Protocol", this.getProtocol());
                adv.appendChild(e);
            }
            if (this.getPort() != null) {
                e = adv.createElement("Port", this.getPort());
                adv.appendChild(e);
            }
            if (this.getPublicAddress() != null) {
                e = adv.createElement("PublicAddress", this.getPublicAddress());
                adv.appendChild(e);
            }
            if (this.getLocalAddress() != null) {
                e = adv.createElement("LocalAddress", this.getLocalAddress());
                adv.appendChild(e);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.TcpAdv.getXMLDocument", (String)"116", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return adv;
    }

    public String getAdvertisementType() {
        return "jxta:TCPTransportAdvertisement";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPublicAddress() {
        return this.publicAddress;
    }

    public void setPublicAddress(String pa) {
        this.publicAddress = pa;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String pa) {
        this.localAddress = pa;
    }
}

