/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceAdv
implements Advertisement {
    private static TraceComponent tc = Tr.register(ServiceAdv.class);
    private String name = null;
    private Vector accessMethods = null;

    public ServiceAdv(String name, Vector accessMethods) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceAdv(String, Vector)");
        }
        this.name = name;
        this.accessMethods = accessMethods;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceAdv(String, Vector)");
        }
    }

    public ServiceAdv(Element root) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceAdv(Element)");
        }
        this.accessMethods = new Vector();
        this.initialize(root.getElementsByTagName(this.getAdvertisementType()).item(0));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceAdv(Element)");
        }
    }

    private void initialize(Node root) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node element = root.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + element.getNodeName() + " value = " + element.getFirstChild().getNodeValue());
            }
            if (element.getNodeName().equals("Name")) {
                this.setName(element.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!element.getNodeName().equals("AccessMethod")) continue;
            this.accessMethods.addElement(element.getFirstChild().getNodeValue().trim());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getAdvertisementType() {
        return "jxta:ServiceAdvertisement";
    }

    public XMLDocument getXMLDocument() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument adv = null;
        try {
            adv = new XMLDocument(this.getAdvertisementType());
            Element e = null;
            if (this.getName() != null) {
                e = adv.createElement("Name", this.getName());
                adv.appendChild(e);
            }
            for (int i = 0; i < this.accessMethods.size(); ++i) {
                String method = (String)this.accessMethods.elementAt(i);
                e = adv.createElement("AccessMethod", method);
                adv.appendChild(e);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.ServiceAdv.getXMLDocument", (String)"94", (Object)this);
            ex.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return adv;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public Vector getAccessMethods() {
        return this.accessMethods;
    }

    private void setAccessMethods(Vector accessMethods) {
        this.accessMethods = accessMethods;
    }
}

