/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FeaturePackAdv
implements Advertisement {
    private static TraceComponent tc = Tr.register(FeaturePackAdv.class);
    private Properties featurePackVersions = new Properties();

    public FeaturePackAdv() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "FeaturePackAdv");
        }
        Properties nodeProperties = null;
        try {
            String nodeName = AdminServiceFactory.getAdminService().getNodeName();
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            nodeProperties = managedObjectMetadataAccessor.getMetadataProperties(nodeName);
        }
        catch (AdminException ae) {
            FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"57", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Properties", nodeProperties);
        }
        if (nodeProperties != null) {
            Enumeration<Object> allkeys = nodeProperties.keys();
            while (allkeys.hasMoreElements()) {
                String k = (String)allkeys.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking Key: ", k);
                }
                if (k.indexOf("FeaturePackProductVersion") <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a Key with FeaturePackProductVersion" + k);
                }
                this.featurePackVersions.put(k, nodeProperties.getProperty(k));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "FeaturePackAdv");
        }
    }

    public FeaturePackAdv(Element root) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "FeaturePackAdv(Element)", root);
        }
        this.initialize(root);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "FeaturePackAdv(Element)");
        }
    }

    public void initialize(Node root) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node element = root.getFirstChild(); element != null; element = element.getNextSibling()) {
            String value;
            String string = value = element.getFirstChild() == null ? null : element.getFirstChild().getNodeValue();
            if (element instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + element.getNodeName() + " value = " + value);
            }
            if (!element.getNodeName().equals("FeaturePackON") || value == null) continue;
            String featureString = element.getFirstChild().getNodeValue().trim();
            ObjectName featureON = new ObjectName(featureString);
            Hashtable table = featureON.getKeyPropertyList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Properties", table);
            }
            Properties newProps = new Properties();
            newProps.putAll((Map<?, ?>)table);
            this.featurePackVersions = newProps;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.featurePackVersions);
        }
    }

    public String getAdvertisementType() {
        return "jxta:FeaturePackAdvertisement";
    }

    public Properties getFeaturePackVersions() {
        return this.featurePackVersions;
    }

    public String convertToString(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToString", props);
        }
        if (props == null || props.size() == 0) {
            return "";
        }
        ObjectName on = null;
        Hashtable<String, String> hashProps = new Hashtable<String, String>();
        if (props != null) {
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                hashProps.put(key, props.getProperty(key));
            }
        }
        try {
            on = new ObjectName("WebSphereFeaturePack", hashProps);
        }
        catch (MalformedObjectNameException mone) {
            FFDCFilter.processException((Throwable)mone, (String)"com.ibm.ws.management.discovery.FeaturePackeAdv.convertToString", (String)"68", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToString", on);
        }
        return on.toString();
    }

    public XMLDocument getXMLDocument() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument adv = new XMLDocument(this.getAdvertisementType());
        Element e = null;
        if (this.getFeaturePackVersions() != null) {
            e = adv.createElement("FeaturePackON", this.convertToString(this.getFeaturePackVersions()));
            adv.appendChild(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return adv;
    }
}

