/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.descriptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.DescriptorParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.descriptor.DescriptorExtensions;
import com.ibm.ws.management.descriptor.MBeanDescriptorManager;
import com.ibm.ws.management.descriptor.StandardDescriptorFieldName;
import com.ibm.ws.management.descriptor.WsDescriptorSupport;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.xml.ParserFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class MBeanDescriptorLoader
extends DefaultHandler
implements StandardDescriptorFieldName,
DescriptorExtensions {
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.management.descriptor.validateDescriptors";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resource.adminservice");
    private static TraceComponent tc = Tr.register(MBeanDescriptorLoader.class, "MBeanFactory", "com.ibm.ws.management.resources.adminservice");
    private int paramIdx;
    private String paramResourceTypes;
    private String fineGrainAlwaysOn;
    private static final String SERVANT_NOTIFICATION_HANDLER = "com.ibm.ws.management.ServantNotificationHandler";
    private static final String HANDLE_SERVANT_NOTIFICATION = "handleServantNotification";
    private static final String MBEAN_STATE_PROVIDER = "com.ibm.ws.management.MBeanStateProvider";
    private static final String GET_MBEAN_STATE = "getMBeanState";
    private static final String emptyString = "";
    private static final String defaultName = "__internal_defaultName";
    private ModelMBeanInfo info = null;
    private String description = null;
    private Descriptor mbeanDescriptor = null;
    private List parentTypes = new ArrayList();
    private List attributes = new ArrayList();
    private List operations = new ArrayList();
    private List notifications = new ArrayList();
    private List constructors = new ArrayList();
    private List aggregationHandlers = new ArrayList();
    private Stack contextStack = new Stack();
    private Stack currentElement = new Stack();
    private StringBuffer characters = new StringBuffer();
    private Locator locator = null;

    public ModelMBeanInfo loadDescriptor(InputStream descriptorFile, String fileName) throws DescriptorParseException {
        ModelMBeanInfo info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptor", fileName);
        }
        try {
            XMLReader parser = ParserFactory.createXMLReader();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            boolean validateDescriptors = Boolean.getBoolean(VALIDATE_DESCRIPTOR_PROPERTY);
            parser.setFeature("http://xml.org/sax/features/validation", validateDescriptors);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validateDescriptors);
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            InputSource source = new InputSource(descriptorFile);
            source.setSystemId(fileName);
            parser.parse(source);
            info = this.getModelMBeanInfo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.loadDescriptor", (String)"97", (Object)this);
            if (ex instanceof SAXException) {
                ex = ((SAXException)ex).getException();
            }
            DescriptorParseException newEx = new DescriptorParseException(ex, fileName);
            Tr.warning(tc, "ADMN0001W", newEx);
            throw newEx;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDescriptor", info);
        }
        return info;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveEntity", systemId);
        }
        InputSource inputSource = null;
        try {
            if (systemId.endsWith("MbeanDescriptor.dtd")) {
                systemId = "xml/MbeanDescriptor.dtd";
                InputStream in = this.getClass().getResourceAsStream(systemId);
                inputSource = new InputSource(in);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.resolveEntity", (String)"126", (Object)this);
            throw new SAXException(nls.getFormattedMessage("ADMN0003E", new Object[]{systemId}, null), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resovleEntity", inputSource);
        }
        return inputSource;
    }

    public void error(SAXParseException exception) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error", exception);
        }
        throw new SAXException(exception);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endDocument");
        }
        this.loadParentTypes();
        WsDescriptorSupport notifDescriptor = new WsDescriptorSupport();
        notifDescriptor.setField("name", "jmx.attribute.changed");
        notifDescriptor.setField("messageID", "notification.attribute.changed");
        notifDescriptor.setField("visibility", new Integer(3));
        notifDescriptor.setField("severity", "5");
        notifDescriptor.setField("descriptortype", "notification");
        ModelMBeanNotificationInfo notification = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.changed"}, "jmx.attribute.changed", emptyString, notifDescriptor);
        this.addFeatureInfo(this.notifications, notification, true);
        ModelMBeanAttributeInfo[] attributeInfos = new ModelMBeanAttributeInfo[this.attributes.size()];
        this.attributes.toArray(attributeInfos);
        ModelMBeanConstructorInfo[] constructorInfos = new ModelMBeanConstructorInfo[this.constructors.size()];
        this.constructors.toArray(constructorInfos);
        ModelMBeanOperationInfo[] operationInfos = new ModelMBeanOperationInfo[this.operations.size()];
        this.operations.toArray(operationInfos);
        ModelMBeanNotificationInfo[] notificationInfos = new ModelMBeanNotificationInfo[this.notifications.size()];
        this.notifications.toArray(notificationInfos);
        if (this.fineGrainAlwaysOn != null) {
            this.mbeanDescriptor.setField("forceFineGrain", "true");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aggregationHandlerClass changes: ", new Integer(this.aggregationHandlers.size()));
        }
        if (this.aggregationHandlers.size() > 0) {
            String currentValue = (String)this.mbeanDescriptor.getFieldValue("aggregationHandlerClass");
            StringBuffer aggBuff = new StringBuffer();
            Iterator aggIt = this.aggregationHandlers.iterator();
            while (aggIt.hasNext()) {
                aggBuff.append(aggIt.next());
                aggBuff.append(':');
            }
            if (currentValue != null && currentValue.trim().length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Child", currentValue);
                }
                aggBuff.append(currentValue);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aggregationHandlerClasses", aggBuff.toString());
            }
            this.mbeanDescriptor.setField("aggregationHandlerClass", aggBuff.toString());
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no changes, current descriptor ok");
        }
        this.info = new ModelMBeanInfoSupport("javax.management.modelmbean.RequiredModelMBean", this.description, attributeInfos, constructorInfos, operationInfos, notificationInfos, this.mbeanDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDocument", this.mbeanDescriptor);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startElement", localName);
        }
        this.currentElement.push(localName);
        if (localName.equals("MBean")) {
            this.fineGrainAlwaysOn = null;
            this.parseMBeanInfo(attrs);
        } else if (localName.equals("attribute")) {
            this.addFeatureInfo(this.attributes, this.parseAttributeInfo(attrs), true);
        } else if (localName.equals("operation")) {
            this.paramIdx = 0;
            this.paramResourceTypes = emptyString;
            this.parseOperationInfo(attrs);
        } else if (localName.equals("notification")) {
            this.parseNotificationInfo(attrs);
        } else if (localName.equals("parameter")) {
            this.pushContext(this.parseParameterInfo(attrs));
            ++this.paramIdx;
        } else if (localName.equals("parentType")) {
            this.pushContext(this.parseParentType(attrs));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endElement", localName);
        }
        try {
            if (localName.equals("operation")) {
                MBeanParameterInfo[] signature = (MBeanParameterInfo[])this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "signature", signature);
                }
                Descriptor opDescriptor = (Descriptor)this.popupContext().value;
                if (this.paramResourceTypes != null && !this.paramResourceTypes.equals(emptyString)) {
                    opDescriptor.setField("paramResourceTypes", this.paramResourceTypes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "opDescriptor", opDescriptor);
                }
                int impact = (Integer)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "impact," + impact);
                }
                String type = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type", type);
                }
                String description = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "description", description);
                }
                String name = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", name);
                }
                if (name == null) {
                    name = defaultName;
                }
                if (description == null) {
                    description = emptyString;
                }
                if (type == null) {
                    type = emptyString;
                }
                ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(name, description, signature, type, impact, opDescriptor);
                this.addFeatureInfo(this.operations, info, true);
            } else if (localName.equals("constructor")) {
                MBeanParameterInfo[] signature = (MBeanParameterInfo[])this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "signature", signature);
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "descriptor", descriptor);
                }
                String description = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "description", description);
                }
                String name = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", name);
                }
                if (name == null) {
                    name = defaultName;
                }
                if (description == null) {
                    description = emptyString;
                }
                ModelMBeanConstructorInfo info = new ModelMBeanConstructorInfo(name, description, signature, descriptor);
                this.addFeatureInfo(this.constructors, info, true);
            } else if (localName.equals("notification")) {
                int length = this.findSameType("notificationType");
                String[] types = new String[length];
                for (int i = 0; i < length; ++i) {
                    types[i] = (String)this.popupContext().value;
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "descriptor", descriptor);
                }
                String description = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "description", description);
                }
                String name = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", name);
                }
                if (description == null) {
                    description = emptyString;
                }
                if (name == null) {
                    name = defaultName;
                }
                ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo(types, name, description, descriptor);
                this.addFeatureInfo(this.notifications, info, true);
            } else if (localName.equals("signature")) {
                int length = this.findSameType("parameter");
                MBeanParameterInfo[] infos = new MBeanParameterInfo[length];
                for (int i = infos.length - 1; i >= 0; --i) {
                    infos[i] = (MBeanParameterInfo)this.popupContext().value;
                }
                this.pushContext(infos);
            }
            Object var12_26 = null;
            if (this.characters.length() > 0) {
                String trimmedChars = this.characters.toString();
                if ((trimmedChars = trimmedChars.trim()).length() > 0) {
                    this.pushContext(trimmedChars);
                }
                this.characters.setLength(0);
            }
            this.currentElement.pop();
        }
        catch (Throwable throwable) {
            Object var12_27 = null;
            if (this.characters.length() > 0) {
                String trimmedChars = this.characters.toString();
                if ((trimmedChars = trimmedChars.trim()).length() > 0) {
                    this.pushContext(trimmedChars);
                }
                this.characters.setLength(0);
            }
            this.currentElement.pop();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endElement");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    private void loadParentTypes() {
        int numTypes = this.findSameType("parentType");
        for (int i = 0; i < numTypes; ++i) {
            ModelMBeanInfo parentInfo = (ModelMBeanInfo)this.popupContext().value;
            this.addFeatures(this.attributes, parentInfo.getAttributes());
            this.addFeatures(this.operations, parentInfo.getOperations());
            this.addFeatures(this.notifications, parentInfo.getNotifications());
            try {
                this.setJSR77OptionalInterfaceFromParent(parentInfo);
                this.collectAggregationHandlersFromParent(parentInfo);
                continue;
            }
            catch (MBeanException ex) {
                // empty catch block
            }
        }
    }

    private void addFeatures(List featureList, MBeanFeatureInfo[] featuresToAdd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFeatures", new Object[]{featureList, featuresToAdd});
        }
        for (int i = 0; i < featuresToAdd.length; ++i) {
            Iterator iter = featureList.iterator();
            while (iter.hasNext()) {
                Object f = iter.next();
                if (!f.equals(featuresToAdd[i])) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing duplicate feature " + f);
                }
                iter.remove();
                break;
            }
            featureList.add(featuresToAdd[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFeatures");
        }
    }

    private void collectAggregationHandlersFromParent(ModelMBeanInfo parentInfo) throws MBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectAggregationHandlersFromParent", parentInfo);
        }
        Descriptor mbDescriptor = parentInfo.getMBeanDescriptor();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Descriptor", mbDescriptor);
        }
        String[] fields = mbDescriptor.getFieldNames();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fields", fields);
        }
        for (int j = 0; j < fields.length; ++j) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Field:", fields[j]);
            }
            if (!fields[j].equalsIgnoreCase("aggregationHandlerClass")) continue;
            this.aggregationHandlers.add(mbDescriptor.getFieldValue(fields[j]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectAggregationHandlersFromParent", this.aggregationHandlers);
        }
    }

    private void setJSR77OptionalInterfaceFromParent(ModelMBeanInfo parentInfo) throws MBeanException {
        Descriptor mbDescriptor = parentInfo.getMBeanDescriptor();
        String[] fields = mbDescriptor.getFieldNames();
        for (int j = 0; j < fields.length; ++j) {
            if (!fields[j].equalsIgnoreCase("eventProvider") && !fields[j].equalsIgnoreCase("stateManageable") && !fields[j].equalsIgnoreCase("statisticsProvider")) continue;
            this.mbeanDescriptor.setField(fields[j], mbDescriptor.getFieldValue(fields[j]));
        }
    }

    private void setJSR77OptionalInterfaceIntoDescriptor(String mbeanType) {
        if (mbeanType.equals("EventProvider")) {
            this.mbeanDescriptor.setField("eventProvider", Boolean.TRUE);
        } else if (mbeanType.equals("StateManageable")) {
            this.mbeanDescriptor.setField("stateManageable", Boolean.TRUE);
        } else if (mbeanType.equals("StatisticsProvider")) {
            this.mbeanDescriptor.setField("statisticsProvider", Boolean.TRUE);
        }
    }

    private ModelMBeanInfo getModelMBeanInfo() {
        return this.info;
    }

    private void parseMBeanInfo(Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseMBeanInfo", attrs);
        }
        this.mbeanDescriptor = new WsDescriptorSupport();
        this.mbeanDescriptor.setField("name", "Dummy_Name");
        this.mbeanDescriptor.setField("descriptorType", "MBean");
        this.mbeanDescriptor.setField("spec", "1.0");
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName:", attrName);
            }
            String value = attrs.getValue(i);
            if (attrName.equals("description")) {
                this.description = value;
                continue;
            }
            this.setDescriptorFields(attrName, value, this.mbeanDescriptor);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseMBeanInfo", this.mbeanDescriptor);
        }
    }

    private ModelMBeanAttributeInfo parseAttributeInfo(Attributes attrs) throws SAXException {
        String opDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseAttributeInfo", attrs);
        }
        String description = null;
        String name = null;
        String type = null;
        String PIT = "proxyInvokeType";
        String PSIT = "proxySetterInvokeType";
        WsDescriptorSupport attrDescriptor = new WsDescriptorSupport();
        attrDescriptor.setField("descriptorType", "attribute");
        attrDescriptor.setField("value", emptyString);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName:", attrName);
            }
            String value = attrs.getValue(i);
            if (attrName.equals("name")) {
                name = value;
                continue;
            }
            if (attrName.equals("type")) {
                type = value;
                continue;
            }
            if (attrName.equals("description")) {
                description = value;
                continue;
            }
            this.setDescriptorFields(attrName, value, attrDescriptor);
        }
        attrDescriptor.setField("name", name);
        String getMethod = (String)attrDescriptor.getFieldValue("getMethod");
        boolean readable = getMethod != null && getMethod.length() > 0;
        String getMethodPIT = null;
        String setMethod = (String)attrDescriptor.getFieldValue("setMethod");
        boolean writable = setMethod != null && setMethod.length() > 0;
        String setMethodPIT = null;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            getMethodPIT = (String)attrDescriptor.getFieldValue("proxyInvokeType");
            setMethodPIT = (String)attrDescriptor.getFieldValue("proxySetterInvokeType");
        }
        boolean isIs = false;
        if (readable) {
            String methodName;
            int firstIndex = getMethod.lastIndexOf(46) + 1;
            int lastIndex = getMethod.indexOf(40);
            if (lastIndex == -1) {
                lastIndex = getMethod.length();
            }
            if ((methodName = getMethod.substring(firstIndex, lastIndex)).startsWith("is") && (type.equals("boolean") || type.equals("java.lang.Boolean"))) {
                isIs = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrDescriptor", attrDescriptor);
        }
        ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, readable, writable, isIs, attrDescriptor);
        String since = (String)attrDescriptor.getFieldValue("since");
        if (since == null && (since = (String)this.mbeanDescriptor.getFieldValue("since")) == null) {
            since = "5.0";
        }
        if (readable) {
            ModelMBeanOperationInfo getterInfo;
            WsDescriptorSupport opDescriptor;
            opDescription = "getter for attribute " + name;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                opDescriptor = new WsDescriptorSupport();
                opDescriptor.setField("name", getMethod);
                opDescriptor.setField("displayName", getMethod);
                opDescriptor.setField("descriptorType", "operation");
                if (this.isVersionEarlier(since, "6.0")) {
                    opDescriptor.setField("role", "operation");
                } else {
                    opDescriptor.setField("role", "getter");
                }
                opDescriptor.setField("targetObjectType", "ObjectReference");
                opDescriptor.setField("proxyInvokeType", getMethodPIT);
                getterInfo = new ModelMBeanOperationInfo(getMethod, opDescription, new MBeanParameterInfo[0], type, 0, opDescriptor);
                this.addFeatureInfo(this.operations, getterInfo, true);
            } else {
                opDescriptor = new WsDescriptorSupport();
                opDescriptor.setField("name", getMethod);
                opDescriptor.setField("displayName", getMethod);
                opDescriptor.setField("descriptorType", "operation");
                if (this.isVersionEarlier(since, "6.0")) {
                    opDescriptor.setField("role", "operation");
                } else {
                    opDescriptor.setField("role", "getter");
                }
                opDescriptor.setField("targetObjectType", "ObjectReference");
                getterInfo = new ModelMBeanOperationInfo(getMethod, opDescription, new MBeanParameterInfo[0], type, 0, opDescriptor);
                this.addFeatureInfo(this.operations, getterInfo, true);
            }
        }
        if (writable) {
            opDescription = "setter for attribute " + name;
            MBeanParameterInfo[] signature = new MBeanParameterInfo[]{new MBeanParameterInfo(name, type, "setter for attribute")};
            WsDescriptorSupport opDescriptor = new WsDescriptorSupport();
            opDescriptor.setField("name", setMethod);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                opDescriptor.setField("descriptorType", "operation");
                if (this.isVersionEarlier(since, "6.0")) {
                    opDescriptor.setField("role", "setter");
                } else {
                    opDescriptor.setField("role", "operation");
                }
                opDescriptor.setField("targetObjectType", "objectReference");
                opDescriptor.setField("proxyInvokeType", setMethodPIT);
                ModelMBeanOperationInfo setterInfo = new ModelMBeanOperationInfo(setMethod, opDescription, signature, "void", 1, opDescriptor);
                this.addFeatureInfo(this.operations, setterInfo, true);
            } else {
                opDescriptor.setField("displayName", setMethod);
                opDescriptor.setField("descriptorType", "operation");
                if (this.isVersionEarlier(since, "6.0")) {
                    opDescriptor.setField("role", "setter");
                } else {
                    opDescriptor.setField("role", "operation");
                }
                opDescriptor.setField("targetObjectType", "ObjectReference");
                ModelMBeanOperationInfo setterInfo = new ModelMBeanOperationInfo(setMethod, opDescription, signature, "void", 1, opDescriptor);
                this.addFeatureInfo(this.operations, setterInfo, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAttributeInfo", info);
        }
        return info;
    }

    private boolean isVersionEarlier(String v1, String v2) {
        return Utils.compareVersions(v1, v2) < 0;
    }

    private void parseConstructorInfo(Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConstructorInfo", attrs);
        }
        String name = null;
        String description = null;
        WsDescriptorSupport descriptor = new WsDescriptorSupport();
        descriptor.setField("descriptorType", "operation");
        descriptor.setField("role", "constructor");
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName", attrName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", value);
            }
            if (attrName.equals("name")) {
                name = value;
                continue;
            }
            if (attrName.equals("description")) {
                description = value;
                continue;
            }
            this.setDescriptorFields(attrName, value, descriptor);
        }
        descriptor.setField("name", name);
        this.pushContext(name);
        this.pushContext(description);
        this.pushContext(descriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConstructorInfo", descriptor);
        }
    }

    private void parseOperationInfo(Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseOperationInfo");
        }
        String name = null;
        String description = null;
        String type = null;
        int impact = 3;
        WsDescriptorSupport opDescriptor = new WsDescriptorSupport();
        opDescriptor.setField("descriptorType", "operation");
        opDescriptor.setField("role", "operation");
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName", attrName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", value);
            }
            if (attrName.equals("name")) {
                name = value;
                opDescriptor.setField("displayName", name);
                continue;
            }
            if (attrName.equals("description")) {
                description = value;
                continue;
            }
            if (attrName.equals("type")) {
                type = value;
                continue;
            }
            if (attrName.equals("impact")) {
                if (value.compareToIgnoreCase("INFO") == 0) {
                    impact = 0;
                    continue;
                }
                if (value.compareToIgnoreCase("ACTION") == 0) {
                    impact = 1;
                    continue;
                }
                if (value.compareToIgnoreCase("ACTION_INFO") != 0) continue;
                impact = 2;
                continue;
            }
            this.setDescriptorFields(attrName, value, opDescriptor);
        }
        opDescriptor.setField("name", name);
        this.pushContext(name);
        this.pushContext(description);
        this.pushContext(type);
        this.pushContext(new Integer(impact));
        this.pushContext(opDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseOperationInfo");
        }
    }

    private void parseNotificationInfo(Attributes attrs) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseNotificationInfo", attrs);
        }
        String description = null;
        String name = null;
        WsDescriptorSupport notifDescriptor = new WsDescriptorSupport();
        notifDescriptor.setField("descriptorType", "notification");
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (attrName.equals("name")) {
                name = value;
                continue;
            }
            if (attrName.equals("description")) {
                description = value;
                continue;
            }
            this.setDescriptorFields(attrName, value, notifDescriptor);
        }
        notifDescriptor.setField("name", name);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notifDescriptor", notifDescriptor);
        }
        this.pushContext(name);
        this.pushContext(description);
        this.pushContext(notifDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseNotificationInfo");
        }
    }

    private MBeanParameterInfo parseParameterInfo(Attributes attrs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseParameterInfo", attrs);
        }
        String type = null;
        String name = null;
        String description = null;
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String attrName = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (attrName.equals("name")) {
                name = value;
                continue;
            }
            if (attrName.equals("type")) {
                type = value;
                continue;
            }
            if (attrName.equals("description")) {
                description = value;
                continue;
            }
            if (!attrName.equals("resourceType")) continue;
            if (this.paramResourceTypes.length() > 0) {
                this.paramResourceTypes = this.paramResourceTypes + ":";
            }
            this.paramResourceTypes = this.paramResourceTypes + String.valueOf(this.paramIdx) + ";" + value;
        }
        MBeanParameterInfo paramInfo = new MBeanParameterInfo(name, type, description);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseParameterInfo", paramInfo);
        }
        return paramInfo;
    }

    private ModelMBeanInfo parseParentType(Attributes attrs) throws SAXException {
        ModelMBeanInfo parentInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseParentType", attrs);
        }
        String type = null;
        String descriptorFile = null;
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String attrName = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (attrName.equals("type")) {
                type = value;
                continue;
            }
            if (!attrName.equals("descriptorFile")) continue;
            descriptorFile = value;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type", type);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "descriptorFile", descriptorFile);
        }
        MBeanFactoryImpl factory = (MBeanFactoryImpl)AdminServiceFactory.getAdminService().getMBeanFactory();
        try {
            parentInfo = AdminHelper.getPlatformHelper().isZOS() ? (factory == null || factory.getDescriptorManager() == null ? MBeanDescriptorManager.getInstance().getDescriptor(type, descriptorFile) : factory.getDescriptorManager().getDescriptor(type, descriptorFile)) : factory.getDescriptorManager().getDescriptor(type, descriptorFile);
        }
        catch (DescriptorParseException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.parseParentType", (String)"608", (Object)this);
            throw new SAXException(nls.getFormattedMessage("ADMN0004E", new Object[]{type}, null), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseParentType", parentInfo);
        }
        return parentInfo;
    }

    private void setDescriptorFields(String attrName, String value, Descriptor descriptor) throws SAXException {
        if (attrName.equals("collaboratorClass")) {
            descriptor.setField("collaboratorClass", value);
            if (AdminHelper.getPlatformHelper().isControlJvm()) {
                this.setProxyOperationInfo(value);
            }
        } else if (attrName.equals("adminAgentProxyInterface")) {
            descriptor.setField("adminAgentProxyInterface", value);
        } else if (attrName.equals("allowDynamicProxyStaticRegistrationInControlRegion")) {
            descriptor.setField("allowDynamicProxyStaticRegistrationInControlRegion", value);
        } else if (attrName.equals("dynamicProxyInterface")) {
            descriptor.setField("dynamicProxyInterface", value);
        } else if (attrName.equals("proxyInvokeType")) {
            descriptor.setField("proxyInvokeType", value);
        } else if (attrName.equals("proxySetterInvokeType")) {
            descriptor.setField("proxySetterInvokeType", value);
        } else if (attrName.equals("aggregationHandlerClass")) {
            descriptor.setField("aggregationHandlerClass", value);
        } else if (attrName.equals("eventHandlerClass")) {
            descriptor.setField("eventHandlerClass", value);
        } else if (attrName.equals("invocationHandlerClass")) {
            descriptor.setField("invocationHandlerClass", value);
        } else if (attrName.equals("stateObjectClass")) {
            descriptor.setField("stateObjectClass", value);
            if (AdminHelper.getPlatformHelper().isControlJvm()) {
                this.setProxyOperationInfo("stateObjectClass");
            }
        } else if (attrName.equals("type")) {
            descriptor.setField("type", value);
            this.setJSR77OptionalInterfaceIntoDescriptor(value);
        } else if (attrName.equals("class")) {
            descriptor.setField("class", value);
        } else if (attrName.equals("targetObjectType")) {
            descriptor.setField("targetObjectType", this.fixTargetObjectType(value));
        } else if (attrName.equals("default")) {
            descriptor.setField("default", value);
        } else if (attrName.equals("displayName")) {
            descriptor.setField("displayName", value);
        } else if (attrName.equals("getMethod")) {
            descriptor.setField("getMethod", value);
        } else if (attrName.equals("setMethod")) {
            descriptor.setField("setMethod", value);
        } else if (attrName.equals("role")) {
            if (!value.equalsIgnoreCase("setter") && !value.equalsIgnoreCase("getter")) {
                value = "operation";
            }
            descriptor.setField("role", value);
        } else if (attrName.equals("protocolMap")) {
            descriptor.setField("protocolMap", value);
        } else if (attrName.equals("persistPolicy")) {
            descriptor.setField("persistPolicy", value);
        } else if (attrName.equals("persistPeriod")) {
            descriptor.setField("persistPeriod", value);
        } else if (attrName.equals("currencyTimeLimit")) {
            descriptor.setField("currencyTimeLimit", value);
        } else if (attrName.equals("iterable")) {
            descriptor.setField("iterable", Boolean.valueOf(value));
        } else if (attrName.equals("visibility")) {
            Integer intVal = null;
            try {
                intVal = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.setDescriptorFields", (String)"673", (Object)this);
            }
            if (intVal == null || intVal < 1 || intVal > 4) {
                throw new SAXParseException(nls.getFormattedMessage("ADMN0002E", new Object[]{value}, null), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
        } else if (attrName.equals("presentationString")) {
            descriptor.setField("presentationString", value);
        } else if (attrName.equals("severity")) {
            descriptor.setField("severity", value);
        } else if (attrName.equals("messageId")) {
            descriptor.setField("messageId", value);
        } else if (attrName.equals("useLog")) {
            descriptor.setField("log", value);
        } else if (attrName.equals("platform")) {
            descriptor.setField("platform", value);
        } else if (attrName.equals("logFile")) {
            descriptor.setField("logFile", value);
        } else if (attrName.equals("configureMBean")) {
            descriptor.setField("configureMBean", Boolean.valueOf(value));
        } else if (attrName.equals("deployerMBean")) {
            descriptor.setField("deployerMBean", Boolean.valueOf(value));
        } else if (attrName.equals("j2eeType")) {
            descriptor.setField("j2eeType", value);
        } else if (attrName.equals("deprecated")) {
            descriptor.setField("deprecated", value);
        } else if (attrName.equals("since")) {
            descriptor.setField("since", value);
        } else if (attrName.equals("spec")) {
            descriptor.setField("spec", value);
        } else {
            Object temp;
            if (attrName.equals("runAs") || attrName.equals("excludeAccessCheck") || attrName.equals("minimalAccessCheck")) {
                this.fineGrainAlwaysOn = "true";
            }
            descriptor.setField(attrName, value);
            if (attrName.equals("excludeAccessCheck") && value.equals("true") && (temp = descriptor.getFieldValue("type")) != null) {
                Tr.info(tc, "ADMN1216I", new Object[]{descriptor.getFieldValue("type")});
            }
        }
    }

    private String fixTargetObjectType(String targetObjectType) {
        String correctTargetObjectType = targetObjectType;
        if (targetObjectType.equals("objectReference")) {
            correctTargetObjectType = "ObjectReference";
        }
        return correctTargetObjectType;
    }

    private void setProxyOperationInfo(String proxyClassName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProxyOperationInfo", proxyClassName);
        }
        try {
            ModelMBeanOperationInfo info;
            MBeanParameterInfo[] signature;
            boolean servantNotificationHandler = false;
            boolean mbeanStateProvider = false;
            if (proxyClassName.equals("dynamicproxy")) {
                Tr.debug(tc, "setProxyOperationInfo", "dynamicproxy path");
                servantNotificationHandler = true;
            } else if (proxyClassName.equals("stateObjectClass")) {
                Tr.debug(tc, "setProxyOperationInfo", "dynamicproxy state provider path");
                mbeanStateProvider = true;
            } else {
                Class<?> proxyClass = Class.forName(proxyClassName);
                Class<?>[] interfaces = proxyClass.getInterfaces();
                String intName = null;
                for (int i = 0; i < interfaces.length; ++i) {
                    intName = interfaces[i].getName();
                    if (intName.equals(SERVANT_NOTIFICATION_HANDLER)) {
                        servantNotificationHandler = true;
                        continue;
                    }
                    if (!intName.equals(MBEAN_STATE_PROVIDER)) continue;
                    mbeanStateProvider = true;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servantNotificationHandler", new Boolean(servantNotificationHandler));
                Tr.debug(tc, "mbeanStateProvider", new Boolean(mbeanStateProvider));
            }
            if (servantNotificationHandler) {
                signature = new MBeanParameterInfo[]{new MBeanParameterInfo("notification", "javax.management.Notification", "Notifications emitted from servant MBeans")};
                info = new ModelMBeanOperationInfo(HANDLE_SERVANT_NOTIFICATION, "For Internal WebSphere Use Only!!", signature, "void", 3);
                this.addFeatureInfo(this.operations, info, true);
            }
            if (mbeanStateProvider) {
                signature = new MBeanParameterInfo[]{};
                info = new ModelMBeanOperationInfo(GET_MBEAN_STATE, "For Internal WebSphere Use Only!!", signature, "java.io.Serializable", 3);
                this.addFeatureInfo(this.operations, info, true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProxyOperationInfo");
        }
    }

    private int findSameType(String type) {
        int i = this.contextStack.size() - 1;
        int num = 0;
        while (i >= 0) {
            ContextElement e = (ContextElement)this.contextStack.get(i);
            if (!type.equals(e.elementName)) break;
            --i;
            ++num;
        }
        return num;
    }

    private void pushContext(Object value) {
        ContextElement e = new ContextElement((String)this.currentElement.peek(), value);
        this.contextStack.push(e);
    }

    private ContextElement popupContext() {
        ContextElement e = (ContextElement)this.contextStack.pop();
        return e;
    }

    private boolean addFeatureInfo(List list, MBeanFeatureInfo info, boolean replace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFeatureInfo", info);
        }
        boolean exist = false;
        String name = info.getName();
        for (int i = 0; i < list.size(); ++i) {
            MBeanFeatureInfo thisInfo = (MBeanFeatureInfo)list.get(i);
            exist = thisInfo.getName().equals(name);
            if (exist && info instanceof MBeanOperationInfo) {
                MBeanParameterInfo[] parms;
                MBeanParameterInfo[] thisParms = ((MBeanOperationInfo)thisInfo).getSignature();
                exist = thisParms.length == (parms = ((MBeanOperationInfo)info).getSignature()).length;
                for (int j = 0; exist && j < parms.length; ++j) {
                    if (thisParms[j].getType().equals(parms[j].getType())) continue;
                    exist = false;
                    break;
                }
            }
            if (!exist) continue;
            if (!replace) break;
            list.set(i, info);
            break;
        }
        if (!exist) {
            list.add(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFeatureInfo," + exist);
        }
        return exist;
    }

    private class ContextElement {
        public String elementName;
        public Object value;

        public ContextElement(String elementName, Object value) {
            this.elementName = elementName;
            this.value = value;
        }

        public String toString() {
            return "elementName:" + this.elementName + ",value:" + this.value;
        }
    }
}

