/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.ConfigTimeLineDataBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MetadataFilter {
    private List pkgs;
    private static String DIFF_FILE = "META-INF/ws-config-schemadiff.xml";
    private static TraceComponent tc = Tr.register(MetadataFilter.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final MetadataFilter instance = new MetadataFilter();
    private static ConfigTimeLineDataBase ctdb = ConfigTimeLineDataBase.getInstance();

    private MetadataFilter() {
    }

    public boolean isPackageValid(String pack, Properties nodeProps) {
        return false;
    }

    protected static boolean isValidType(EClass type, Properties nodeProp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidType", new Object[]{type, nodeProp});
        }
        String typName = MetadataFilter.getShortType(type.getInstanceClassName());
        String pkgName = type.getEPackage().getName();
        boolean result = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidType", new Boolean(result));
        }
        return result;
    }

    protected static List filterAttrs(EClass typ, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterAttrs", new Object[]{typ, version});
        }
        ArrayList retAttrs = new ArrayList();
        ArrayList attrs = new ArrayList(typ.getEAllAttributes());
        ArrayList<EClass> types = new ArrayList<EClass>(typ.getEAllSuperTypes());
        types.add(typ);
        for (EClass type : types) {
            String pkgName = type.getEPackage().getName();
            String className = MetadataFilter.getShortType(type.getInstanceClassName());
            for (EAttribute attr : attrs) {
                if (!instance.localAttr(type, attr.getName())) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterAttrs", retAttrs);
        }
        return retAttrs;
    }

    protected static void filterSubTypes(EClass parentType, List subTypes, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterSubTypes", new Object[]{parentType, subTypes, version});
        }
        for (Object obj : subTypes) {
            if (!(obj instanceof EClass)) continue;
            EClass subType = (EClass)obj;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Class: " + subType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterSubTypes");
        }
    }

    protected static boolean isSubType(EClass parentType, EClass subType, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSubType", new Object[]{parentType, subType, version});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSubType", new Boolean(true));
        }
        return true;
    }

    protected static void filterAllTypes(Set typs, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterAllTypes", new Object[]{typs, version});
        }
        for (Object obj : typs) {
            if (!(obj instanceof EClass)) continue;
            EClass typ = (EClass)obj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterAllTypes");
        }
    }

    protected static void filterAttributes(List attrs, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterAttributes", new Object[]{attrs, version});
        }
        if (version == null) {
            return;
        }
        for (EAttribute attr : attrs) {
            EDataType dtyp = attr.getEAttributeType();
            String pkgName = dtyp.getEPackage().getName();
            String className = MetadataFilter.getShortType(dtyp.getInstanceClassName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterAttributes");
        }
    }

    protected static boolean isValidAttr(EStructuralFeature feature, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidAttr", new Object[]{feature, version});
        }
        boolean result = true;
        String className = MetadataFilter.getShortType(feature.getEContainingClass().getInstanceClassName());
        String pkgName = feature.getEContainingClass().getEPackage().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "className", className);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pkgName", pkgName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidAttr", new Boolean(result));
        }
        return result;
    }

    protected static String[] getValidRanges(EStructuralFeature feature, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidRanges", new Object[]{feature, version});
        }
        String[] result = null;
        String className = MetadataFilter.getShortType(feature.getEContainingClass().getInstanceClassName());
        String pkgName = feature.getEContainingClass().getEPackage().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "className", className);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pkgName", pkgName);
        }
        result = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValidRanges", result);
        }
        return result;
    }

    private static boolean strippedPkgNameEqual(String pkgName, String newPkgName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "strippedPkgNameEqual", new Object[]{pkgName, newPkgName});
        }
        boolean result = false;
        if (pkgName.lastIndexOf(".") > 0) {
            String stripped = pkgName.substring(pkgName.lastIndexOf(".") + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stripped PKG Name: " + stripped);
            }
            if (stripped.equals(newPkgName)) {
                result = true;
                return result;
            }
        }
        return result;
    }

    private boolean localAttr(EClass type, String attrName) {
        EList attrs = type.getEAttributes();
        for (EAttribute attr : attrs) {
            if (!attr.getName().equals(attrName)) continue;
            return true;
        }
        return false;
    }

    private static String getShortType(String type) {
        return type.substring(type.lastIndexOf(46) + 1, type.length());
    }
}

