/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.schemadiff.ChangedObject;
import com.ibm.ws.management.configservice.schemadiff.Property;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;

public class ConfigChangeId {
    private static TraceComponent tc = Tr.register(ConfigChangeId.class, "management", "com.ibm.ws.management.resources.configservice");
    private String id;
    private Properties props;

    public ConfigChangeId(String schema, Properties changedProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigChangeId", new Object[]{schema, changedProperties});
        }
        this.sort(schema, changedProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigChangeId");
        }
    }

    public ConfigChangeId(String schema, ChangedObject changedObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigChangeId", new Object[]{schema, changedObject});
        }
        EList props = changedObject.getProperty();
        Properties changedProperties = new Properties();
        for (Property pr : props) {
            changedProperties.put(pr.getName(), pr.getValue());
        }
        this.sort(schema, changedProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigChangeId");
        }
    }

    private void sort(String schema, Properties props) {
        this.id = "#" + schema + "#";
        TreeMap<Object, Object> changedTreeMap = new TreeMap<Object, Object>(props);
        for (Map.Entry<Object, Object> entry : changedTreeMap.entrySet()) {
            this.id = this.id + entry.getKey() + "=" + entry.getValue() + "#";
        }
    }

    public String toString() {
        return this.id;
    }

    public Properties getConfigChange() {
        return this.props;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) throws ClassCastException {
        ConfigChangeId config = (ConfigChangeId)obj;
        return this.hashCode() == config.hashCode();
    }
}

