/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigDocumentSaveException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.InvalidSessionException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.websphere.management.exception.VersionNotMatchException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.MetadataFilter;
import com.ibm.ws.management.configservice.RequiredAttributesRegistry;
import com.ibm.ws.management.configservice.SpecialAttributeRegistry;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.Bundle;

public class DocAccessor {
    private static TraceComponent tc;
    private Resource res;
    private static List bundlesProvidingConfig;
    AdminAuthorizer aa = SecurityHelper.getHelper().getAdminAuthorizer();

    public DocAccessor(Resource res) {
        this.res = res;
    }

    public ObjectName createConfigData(Session session, ConfigDataId parentConfigObject, String attributeName, AttributeList attrList, boolean isConfigObject) throws ConfigServiceException {
        EObject parent = this.lookup(parentConfigObject);
        ObjectName objName = ConfigServiceHelper.createObjectName(parentConfigObject);
        Properties nodeProps = MOFUtil.getNodeProperties(WorkspaceHelper.getWorkspace(session), objName);
        EStructuralFeature attrMetaObj = MOFUtil.getAttributeMetaObj((EObject)parent.eClass(), attributeName, isConfigObject, nodeProps);
        if (SpecialAttributeRegistry.isReadOnlyAttribute(attrMetaObj)) {
            throw new ReadOnlyAttributeException(attributeName);
        }
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0801E", new Object[]{attributeName, docUri}, null));
        }
        EObject newObj = MOFUtil.createRefObject(WorkspaceHelper.getContext(this.res), attrMetaObj.getEType(), attrList);
        RequiredAttributesRegistry.checkRequiredAttributes(newObj, nodeProps);
        if (attrMetaObj.isMany()) {
            List currentVal = (List)parent.eGet(attrMetaObj);
            SpecialAttributeRegistry.checkUnique((EClass)attrMetaObj.getEType(), currentVal, newObj);
            currentVal.add(newObj);
        } else {
            parent.eSet(attrMetaObj, newObj);
        }
        ObjectName result = MOFUtil.createObjectName(newObj);
        return result;
    }

    public ObjectName createRootConfigObject(Session session, String type, AttributeList attrList) throws ConfigServiceException {
        EClass metaObj = TypeRegistry.getMetaObject(type);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0800E", new Object[]{docUri}, null));
        }
        EObject newObj = MOFUtil.createRefObject(WorkspaceHelper.getContext(this.res), metaObj, attrList);
        Properties nodeProps = this.getNodeProperties(session);
        RequiredAttributesRegistry.checkRequiredAttributes(newObj, nodeProps);
        SpecialAttributeRegistry.checkUnique(metaObj, this.res.getContents(), newObj);
        this.res.getContents().add(newObj);
        MOFUtil.objectAdded(WorkspaceHelper.getContext(this.res), newObj, new MOFUtil.ReferenceHandler(), new Stack());
        ObjectName result = MOFUtil.createObjectName(newObj);
        return result;
    }

    public void setAttributes(Session session, ConfigDataId configDataId, AttributeList attrList) throws ConfigServiceException {
        this.checkAttributeListVersion(attrList);
        EObject obj = this.lookup(configDataId);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0800E", new Object[]{docUri}, null));
        }
        MOFUtil.setAttributes(WorkspaceHelper.getContext(this.res), obj, attrList);
    }

    public ObjectName addElementAt(Session session, ConfigDataId configDataId, String attributeName, Object element, int position, boolean isConfigObject) throws ConfigServiceException {
        EObject obj = this.lookup(configDataId);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0801E", new Object[]{attributeName, docUri}, null));
        }
        Object elementValue = MOFUtil.addElementAt(WorkspaceHelper.getContext(this.res), obj, attributeName, element, position, isConfigObject);
        ObjectName result = null;
        if (elementValue instanceof EObject) {
            EObject elementRefObj = (EObject)elementValue;
            Properties nodeProps = this.getNodeProperties(session);
            RequiredAttributesRegistry.checkRequiredAttributes(elementRefObj, nodeProps);
            result = MOFUtil.createObjectName(elementRefObj);
        }
        return result;
    }

    public void removeElement(Session session, ConfigDataId configDataId, String attributeName, Object element) throws ConfigServiceException {
        EObject obj = this.lookup(configDataId);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0801E", new Object[]{attributeName, docUri}, null));
        }
        MOFUtil.removeElement(WorkspaceHelper.getContext(this.res), obj, attributeName, element);
    }

    public void unsetAttributes(Session session, ConfigDataId configDataId, String[] attributes) throws ConfigServiceException {
        EObject obj = this.lookup(configDataId);
        EClass metaObj = obj.eClass();
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0800E", new Object[]{docUri}, null));
        }
        for (int i = 0; i < attributes.length; ++i) {
            MOFUtil.unsetAttribute(obj, attributes[i]);
        }
    }

    public void resetAttributes(Session session, ConfigDataId configDataId, AttributeList attrList) throws ConfigServiceException {
        this.checkAttributeListVersion(attrList);
        EObject obj = this.lookup(configDataId);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0800E", new Object[]{docUri}, null));
        }
        MOFUtil.resetAttributes(WorkspaceHelper.getContext(this.res), obj, attrList);
    }

    public ObjectName[] getRootObjects(Session session) throws ConfigDataNotFoundException {
        EList extent = this.res.getContents();
        ObjectName[] result = new ObjectName[extent.size()];
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "monitor")) {
            return null;
        }
        for (int i = 0; i < extent.size(); ++i) {
            EObject rootObj = (EObject)extent.get(i);
            result[i] = MOFUtil.createObjectName(rootObj);
        }
        return result;
    }

    public ObjectName[] getTypedObjects(Session session, String type) throws InvalidConfigDataTypeException {
        Class specifiedClass;
        String docUri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedObjects", new Object[]{session, type});
        }
        if (!this.checkAccess(docUri = this.getDocumentUri(), "monitor")) {
            return null;
        }
        EList extent = this.res.getContents();
        try {
            specifiedClass = this.getConfigClass(TypeRegistry.getFullyQualifiedType(type));
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.DocAccessor.getTypedObjects", (String)"279", (Object)this);
            throw new InvalidConfigDataTypeException(ex, type);
        }
        ArrayList selected = new ArrayList();
        for (int i = 0; extent != null && i < extent.size(); ++i) {
            EObject rootObj = (EObject)extent.get(i);
            this.getTypedObjects(specifiedClass, rootObj, selected);
        }
        ObjectName[] result = new ObjectName[selected.size()];
        selected.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedObjects", result);
        }
        return result;
    }

    private Class getConfigClass(final String className) throws ClassNotFoundException {
        Class clazz;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConfigClass", className);
            }
            clazz = null;
            Iterator it = bundlesProvidingConfig.iterator();
            while (it.hasNext() && clazz == null) {
                final Bundle bundle = (Bundle)it.next();
                if (bundle == null) {
                    return Class.forName(className);
                }
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                }
                catch (Exception e) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to load class " + className + " from bundle " + bundle.getSymbolicName(), e);
                }
            }
            if (clazz == null) {
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Class.forName(className, true, ExtClassLoader.getInstance());
                        }
                    });
                }
                catch (Exception e) {
                    if (!tc.isEventEnabled()) break block11;
                    Tr.event(tc, "unable to load class " + className + "using Extension " + "classloader", e);
                }
            }
        }
        if (clazz == null) {
            ClassNotFoundException cnfe = new ClassNotFoundException(className);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigClass", cnfe);
            }
            throw cnfe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigClass", clazz);
        }
        return clazz;
    }

    public ObjectName[] getTypedObjects(String type, EObject rootObj) throws InvalidConfigDataTypeException {
        Class specifiedClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedObjects", new Object[]{type, rootObj});
        }
        try {
            specifiedClass = this.getConfigClass(TypeRegistry.getFullyQualifiedType(type));
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.DocAccessor.getTypedObjects", (String)"279", (Object)this);
            throw new InvalidConfigDataTypeException(ex, type);
        }
        ArrayList selected = new ArrayList();
        this.getTypedObjects(specifiedClass, rootObj, selected);
        ObjectName[] result = new ObjectName[selected.size()];
        selected.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedObjects", result);
        }
        return result;
    }

    private void getTypedObjects(Class specifiedClass, EObject rootObj, List selected) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedObjects", new Object[]{specifiedClass, rootObj});
        }
        if (specifiedClass.isInstance(rootObj)) {
            if (MetadataFilter.isValidType(rootObj.eClass(), MOFUtil.getNodeProperties(rootObj))) {
                selected.add(MOFUtil.createObjectName(rootObj));
            }
        } else {
            TreeIterator iter = rootObj.eAllContents();
            while (iter.hasNext()) {
                Object val = iter.next();
                if (!specifiedClass.isInstance(val) || !(val instanceof EObject) || !MetadataFilter.isValidType(((EObject)val).eClass(), MOFUtil.getNodeProperties((EObject)val))) continue;
                selected.add(MOFUtil.createObjectName((EObject)val));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedObjects");
        }
    }

    public Object getAttribute(Session session, ConfigDataId configDataId, String attributeName) throws ConfigServiceException {
        EObject obj = this.lookup(configDataId);
        String docUri = this.getDocumentUri();
        String role = "monitor";
        if (docUri.endsWith("admin-authz.xml")) {
            role = "adminsecuritymanager";
        }
        if (docUri.endsWith("audit-authz.xml")) {
            role = "auditor";
        }
        if (!this.checkAccess(docUri, role)) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0800E", new Object[]{docUri}, null));
        }
        Object val = MOFUtil.getAttribute(obj, attributeName, true);
        val = this.clearRestrictedAttribute(this.getDocumentUri(), TypeRegistry.getTypeShortName(obj.eClass()), attributeName, val);
        return val;
    }

    public ObjectName getParent(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException {
        EObject obj = this.lookup(configDataId);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "monitor")) {
            return null;
        }
        EObject parent = obj.eContainer();
        return MOFUtil.createObjectName(parent);
    }

    public ObjectName[] getRelationship(Session session, ConfigDataId configDataId, String relationshipName) throws InvalidAttributeNameException, ConfigDataNotFoundException, ConfigServiceException {
        ObjectName[] result;
        ObjectName objName = ConfigServiceHelper.createObjectName(configDataId);
        Properties nodeProps = MOFUtil.getNodeProperties(WorkspaceHelper.getWorkspace(session), objName);
        EObject obj = this.lookup(configDataId);
        EStructuralFeature attrFeature = MOFUtil.getAttributeMetaObj((EObject)obj.eClass(), relationshipName, true, nodeProps);
        Object refValue = obj.eGet(attrFeature);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "monitor")) {
            return null;
        }
        if (refValue instanceof List) {
            List listVal = (List)refValue;
            result = new ObjectName[listVal.size()];
            for (int i = 0; i < listVal.size(); ++i) {
                EObject refObj = (EObject)listVal.get(i);
                result[i] = MOFUtil.createObjectName(refObj);
            }
        } else if (refValue instanceof EObject) {
            result = new ObjectName[]{MOFUtil.createObjectName((EObject)refValue)};
        } else {
            throw new InvalidAttributeNameException(new String[]{relationshipName});
        }
        return result;
    }

    public ObjectName resolveObjectName(Session session, ConfigDataId id) throws ConfigDataNotFoundException, ConfigDocumentLoadException, InvalidSessionException, SessionTimeoutException {
        EObject obj = this.lookup(id);
        String docUri = this.getDocumentUri();
        if (!this.checkAccess(docUri, "monitor")) {
            return null;
        }
        return MOFUtil.createObjectName(obj);
    }

    public void resolve(Session session, ObjectName parent, AttributeList containmentPath, List result) throws ConfigServiceException {
        String docUri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, parent, containmentPath, result});
        }
        if (!this.checkAccess(docUri = this.getDocumentUri(), "monitor")) {
            return;
        }
        if (containmentPath.size() == 0) {
            result.add(parent);
        } else {
            EObject obj = this.lookup(ConfigServiceHelper.getConfigDataId(parent));
            EList children = obj.eContents();
            Attribute currentQuery = (Attribute)containmentPath.remove(0);
            String type = currentQuery.getName();
            String objectName = (String)currentQuery.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", type);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objectName", objectName);
            }
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ObjectName child = MOFUtil.createObjectName((EObject)iter.next());
                if (!type.equals(ConfigServiceHelper.getConfigDataType(child)) || objectName != null && !objectName.equals(ConfigServiceHelper.getDisplayName(child))) continue;
                this.resolve(session, child, (AttributeList)containmentPath.clone(), result);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exiting DocAccessor.resolve().  The current function argument values are : ", new Object[]{session, parent, containmentPath, result});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve");
        }
    }

    public void resolveXPath(Session session, ObjectName parent, AttributeList containmentPath, List result) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveXPath", new Object[]{session, parent, containmentPath, result});
        }
        if (containmentPath.size() > 0) {
            EObject obj = this.lookup(ConfigServiceHelper.getConfigDataId(parent));
            EList children = obj.eContents();
            Attribute currentQuery = (Attribute)containmentPath.remove(0);
            String type = currentQuery.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", type);
            }
            Attribute typeNamePairs = this.getPredicateAttribute((String)currentQuery.getValue());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "predicate", typeNamePairs);
            }
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ObjectName child = MOFUtil.createObjectName((EObject)iter.next());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "childType", ConfigServiceHelper.getConfigDataType(child));
                }
                if (!type.equals(ConfigServiceHelper.getConfigDataType(child))) continue;
                String attribute = (String)this.getAttribute(session, ConfigServiceHelper.getConfigDataId(child), typeNamePairs.getName());
                if (typeNamePairs != null && !attribute.equals(typeNamePairs.getValue())) continue;
                this.resolveXPath(session, child, containmentPath, result);
            }
        } else {
            result.add(parent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXPath");
        }
    }

    public AttributeList getAttributes(Session session, ConfigDataId configDataId, String[] attributes, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configDataId, attributes});
        }
        EObject obj = this.lookup(configDataId);
        AttributeList attrList = MOFUtil.getAttributes(obj, attributes, recursive);
        String docUri = this.getDocumentUri();
        String role = "monitor";
        if (docUri.endsWith("admin-authz.xml")) {
            role = "adminsecuritymanager";
        }
        if (docUri.endsWith("audit-authz.xml")) {
            role = "auditor";
        }
        if (!this.checkAccess(docUri, role)) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0800E", new Object[]{docUri}, null));
        }
        this.clearRestrictedAttributes(this.getDocumentUri(), attrList);
        attrList.add(new Attribute("_Websphere_Config_Data_Version", this.getDocumentDigest()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attrList);
        }
        return attrList;
    }

    public void deleteConfigData(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException {
        EObject obj = this.lookup(configDataId);
        String documentUri = this.getDocumentUri();
        if (!this.checkAccess(documentUri, "configurator")) {
            throw new ConfigDataNotFoundException(documentUri, configDataId, new Exception("Access Denied"));
        }
        MOFUtil.delete(obj);
        if (this.res.getContents().size() == 0) {
            RepositoryContext context = WorkspaceHelper.getContext(this.res);
            this.res.getResourceSet().getResources().remove(this.res);
            ArrayList<String> fileList = new ArrayList<String>(1);
            fileList.add(this.res.getURI().path());
            try {
                context.notifyChanged(2, fileList);
            }
            catch (WorkSpaceException ex) {
                throw new ConfigDataNotFoundException(documentUri, configDataId, (Exception)((Object)ex));
            }
            this.res = null;
        }
    }

    public String getDocumentUri() {
        RepositoryContext context = WorkspaceHelper.getContext(this.res);
        return context.getURI() + '/' + this.res.getURI();
    }

    public void localSave() throws ConfigDocumentSaveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localSave");
        }
        if (this.res == null) {
            return;
        }
        try {
            if (this.res.isModified()) {
                this.res.save(new HashMap());
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.DocAccessor.localSave", (String)"454", (Object)this);
            throw new ConfigDocumentSaveException(this.getDocumentUri(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localSave");
        }
    }

    public void cleanup() {
        if (this.res == null) {
            return;
        }
        if (this.res.isModified() && this.res.getResourceSet() != null) {
            this.res.getResourceSet().getResources().remove(this.res);
        }
    }

    public EObject lookup(ConfigDataId id) throws ConfigDataNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup", id);
        }
        URI uri = MOFUtil.getURI(id);
        EObject obj = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ref id", uri.fragment());
        }
        if (!uri.hasFragment()) {
            if (this.res.getContents().size() > 0) {
                obj = (EObject)this.res.getContents().get(0);
            }
        } else {
            obj = this.res.getEObject(uri.fragment());
        }
        if (obj == null) {
            throw new ConfigDataNotFoundException(this.getDocumentUri(), id, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup", obj);
        }
        return obj;
    }

    Resource getResource() {
        return this.res;
    }

    private void clearRestrictedAttributes(String docUri, AttributeList attrList) throws ConfigServiceException {
        if (SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable((String)docUri) && !AdminHelper.getPlatformHelper().isZOS()) {
            this.clearRestrictedAttributesBase(docUri, attrList);
        }
    }

    private Object clearRestrictedAttribute(String docUri, String type, String attributeName, Object val) throws ConfigServiceException {
        Object result = val;
        if (SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable((String)docUri) && !AdminHelper.getPlatformHelper().isZOS()) {
            result = this.clearRestrictedAttributeBase(docUri, type, attributeName, val);
        }
        return val;
    }

    private void clearRestrictedAttributesBase(String docUri, AttributeList attrList) throws ConfigServiceException {
        String type = null;
        try {
            type = (String)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Type");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (type != null) {
            for (int i = 0; i < attrList.size(); ++i) {
                String name;
                Object newVal;
                Attribute attr = (Attribute)attrList.get(i);
                Object val = attr.getValue();
                if (val == (newVal = this.clearRestrictedAttributeBase(docUri, type, name = attr.getName(), val))) continue;
                attrList.set(i, new Attribute(name, newVal));
            }
        }
    }

    private Object clearRestrictedAttributeBase(String docUri, String type, String attributeName, Object val) throws ConfigServiceException {
        if (val instanceof AttributeList) {
            this.clearRestrictedAttributesBase(docUri, (AttributeList)val);
        } else if (val instanceof List) {
            if (!RestrictedAccess.isReadable((String)docUri, (String)TypeRegistry.getFullyQualifiedType(type), (String)attributeName)) {
                RoleBasedAuthorizer auth;
                try {
                    auth = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
                }
                catch (Exception ex) {
                    throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
                }
                if (!auth.isCallerInRole("administrator")) {
                    ((List)val).clear();
                }
            } else {
                for (Object element : (List)val) {
                    if (!(element instanceof AttributeList)) continue;
                    this.clearRestrictedAttributesBase(docUri, (AttributeList)element);
                }
            }
        } else if (!RestrictedAccess.isReadable((String)docUri, (String)TypeRegistry.getFullyQualifiedType(type), (String)attributeName)) {
            RoleBasedAuthorizer auth;
            try {
                auth = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception ex) {
                throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
            }
            if (!auth.isCallerInRole("administrator")) {
                val = null;
            }
        }
        return val;
    }

    private void checkAttributeListVersion(AttributeList attrList) throws VersionNotMatchException {
        DocumentDigest docDigest = null;
        try {
            docDigest = (DocumentDigest)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Version");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        docDigest = null;
        if (docDigest != null && !docDigest.equals(this.getDocumentDigest())) {
            throw new VersionNotMatchException();
        }
    }

    private DocumentDigest getDocumentDigest() {
        RepositoryContext context = WorkspaceHelper.getContext(this.res);
        return null;
    }

    private Attribute getPredicateAttribute(String predicate) {
        if (predicate != null && predicate != "") {
            if (predicate.startsWith("@")) {
                predicate = predicate.substring(1);
            }
            String expressionKey = predicate.substring(0, predicate.indexOf("="));
            String expressionValue = predicate.substring(predicate.indexOf("=") + 2, predicate.lastIndexOf("'"));
            AttributeList expresssionAttrList = new AttributeList();
            return new Attribute(expressionKey, expressionValue);
        }
        return null;
    }

    private Properties getNodeProperties(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties");
        }
        Properties nodeProps = null;
        try {
            RepositoryContext context = WorkspaceHelper.getContext(this.res);
            if (context == null) {
                return nodeProps;
            }
            ObjectName objName = MOFUtil.createObjectName(context);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "context = " + context);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objName = " + objName);
            }
            Properties locProps = ConfigServiceHelper.getObjectLocation(objName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "obj props = " + locProps);
            }
            String nodeName = locProps.getProperty("node");
            String serverName = locProps.getProperty("server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName = " + nodeName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName = " + serverName);
            }
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            try {
                ManagedObjectMetadataHelper metaHelper = ws.getMetadataHelper();
                if (nodeName != null && metaHelper != null) {
                    nodeProps = metaHelper.getAccessor().getMetadataProperties(nodeName);
                }
            }
            catch (Exception e) {
                Tr.warning(tc, "Could not getNodeProperties for node: " + nodeName, e);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node props = " + nodeProps);
            }
            if (nodeName == null && serverName != null) {
                nodeProps = new Properties();
                nodeProps.setProperty("com.ibm.websphere.baseProductVersion", "5.0.0.0");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting nodeProps to null");
            }
            nodeProps = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeProperties", nodeProps);
        }
        return nodeProps;
    }

    private boolean checkAccess(String docUri, String role) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess ", new Object[]{docUri, role});
        }
        boolean result = true;
        String res = docUri;
        Object role1 = null;
        if (this.aa != null) {
            if (docUri.endsWith("admin-authz.xml") && role.equals("configurator")) {
                role = "adminsecuritymanager";
            } else if (docUri.endsWith("audit-authz.xml") && role.equals("configurator")) {
                role = "auditor";
            } else if (docUri.endsWith("authorizationgroup.xml") && role.equals("configurator")) {
                role = "adminsecuritymanager";
            } else if (docUri.endsWith("audit.xml") && role.equals("configurator")) {
                role = "auditor";
            } else if (this.isRestricted(docUri) && role.equals("configurator")) {
                res = "";
                role = "administrator";
            }
            result = this.aa.checkAccess(res, role);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess ", new Boolean(result));
        }
        return result;
    }

    private boolean isRestricted(String docUri) {
        if (!RestrictedAccess.isRestricted((String)docUri)) {
            return false;
        }
        if (docUri.endsWith("authorizationgroup.xml")) {
            return false;
        }
        if (docUri.endsWith("admin-authz.xml")) {
            return false;
        }
        return !docUri.endsWith("audit-authz.xml");
    }

    static {
        String epid;
        tc = Tr.register(DocAccessor.class, "management", "com.ibm.ws.management.resources.configservice");
        bundlesProvidingConfig = new ArrayList();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".server-config");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                bundlesProvidingConfig.add(Platform.getBundle((String)extensions[i].getNamespace()));
            }
        }
    }
}

