/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class BaseServerDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(BaseServerDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    protected static final String SERVER_TYPE = "serverType";

    public BaseServerDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers"));
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws InvalidConfigDataTypeException {
        AttributeList metaInfo = super.getAttributesMetaInfo(configDataType);
        AttributeList serverTypeMetaInfo = MOFUtil.getAttributeMetaInfo("ServerEntry", TypeRegistry.getMetaObject("ServerEntry").getEStructuralFeature(SERVER_TYPE), null);
        metaInfo.add(new Attribute(SERVER_TYPE, serverTypeMetaInfo));
        AttributeList adjustPortMetaInfo = new AttributeList();
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Name", "adjustPort"));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Type", "Boolean"));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        metaInfo.add(new Attribute("adjustPort", adjustPortMetaInfo));
        return metaInfo;
    }

    public ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        this.checkServerTypeAttr(attrList);
        ConfigDataId parentId = ConfigServiceHelper.getConfigDataId(parent);
        try {
            Object val = ConfigServiceHelper.getAttributeValue(attrList, "adjustPort");
            if (val instanceof Boolean && !((Boolean)val).booleanValue()) {
                EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            }
            ConfigServiceHelper.removeAttribute(attrList, "adjustPort");
        }
        catch (AttributeNotFoundException anfe) {
            // empty catch block
        }
        RepositoryContext nodeContext = WorkspaceHelper.getContext(session, parentId);
        ObjectName template = this.getTemplate(session, attrList);
        ServerEntry serverEntry = EndpointConfigHelper.createServerEntry(nodeContext, this.getName(attrList), template);
        serverEntry.getDeployedApplications().clear();
        ObjectName server = super.createConfigObject(session, parent, relationshipInfo, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", server);
        }
        EndpointConfigHelper.setAdjustFlag(new Boolean(true));
        return server;
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        ConfigDataId serverId = ConfigServiceHelper.getConfigDataId(configData);
        RepositoryContext context = WorkspaceHelper.getContext(session, serverId);
        context = context.getParent();
        String serverName = ConfigServiceHelper.getDisplayName(configData);
        super.deleteConfigData(session, configData);
        EndpointConfigHelper.deleteServerEntry(context, serverName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        this.checkServerTypeAttr(attrList);
        super.setAttributes(session, configData, attrList);
    }

    public void unsetAttributes(Session session, ObjectName configData, String[] attributes) throws ConfigServiceException {
        this.checkServerTypeAttr(attributes);
        super.unsetAttributes(session, configData, attributes);
    }

    public void resetAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        this.checkServerTypeAttr(attrList);
        super.resetAttributes(session, configData, attrList);
    }

    public AttributeList getAttributes(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)});
        }
        boolean serverTypeNeeded = false;
        if (attributes == null) {
            serverTypeNeeded = true;
        } else {
            ArrayList<String> attrs = new ArrayList<String>(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].equals(SERVER_TYPE)) {
                    serverTypeNeeded = true;
                    continue;
                }
                attrs.add(attributes[i]);
            }
            attributes = new String[attrs.size()];
            attrs.toArray(attributes);
        }
        AttributeList result = super.getAttributes(session, configData, attributes, recursive);
        if (serverTypeNeeded) {
            String val = this.getServerType(session, configData);
            result.add(new Attribute(SERVER_TYPE, val));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, configData, attribute});
        }
        Object result = SERVER_TYPE.equals(attribute) ? this.getServerType(session, configData) : super.getAttribute(session, configData, attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public static void adjustPort(Session session, ConfigService configService, ObjectName server_on) throws ConfigServiceException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "adjustPort", new Object[]{session, configService, server_on});
            }
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("_Websphere_Config_Data_Type", "EndPoint");
            ObjectName typeON = new ObjectName("WebSphere", table);
            ObjectName[] list = configService.queryConfigObjects(session, server_on, typeON, null);
            for (int i = 0; i < list.length; ++i) {
                RepositoryContext context = null;
                try {
                    EndPoint endPoint = (EndPoint)MOFUtil.convertToEObject(session, list[i]);
                    int port = endPoint.getPort();
                    if (port == 0) continue;
                    endPoint.setPort(0);
                    Server serv = (Server)MOFUtil.convertToEObject(session, server_on);
                    context = ((ContextResourceSet)serv.eResource().getResourceSet()).getContext();
                    endPoint.setPort(EndpointConfigHelper.adjustPort(context, port, null));
                    continue;
                }
                catch (ConfigServiceException ex) {
                    Tr.warning(tc, "ADMG0022W", new Object[]{ex, context.getName()});
                }
            }
        }
        catch (ConnectorException ce) {
            throw new ConfigServiceException(ce);
        }
        catch (MalformedObjectNameException mone) {
            throw new ConfigServiceException(mone);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustPort");
        }
    }

    private void checkServerTypeAttr(AttributeList attrList) throws ReadOnlyAttributeException {
        try {
            Object val = ConfigServiceHelper.getAttributeValue(attrList, SERVER_TYPE);
            throw new ReadOnlyAttributeException(SERVER_TYPE);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return;
        }
    }

    private void checkServerTypeAttr(String[] attributes) throws ReadOnlyAttributeException {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].equals(SERVER_TYPE)) continue;
            throw new ReadOnlyAttributeException(SERVER_TYPE);
        }
    }

    private String getServerType(Session session, ObjectName server) throws ConfigServiceException {
        return EndpointConfigHelper.getServerType(WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(server)));
    }
}

