/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportCommand;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportNode
extends ImportCommand {
    private static TraceComponent tc = Tr.register(ImportNode.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.nodeutils", Locale.getDefault());
    private String nodeName = null;
    private String nodeShortName = null;
    private Map serversShortName = null;
    private String nodeGroupName = null;
    private String readLicenseAgreement = null;
    private ManagedObjectMetadataHelper archiveMetadataHelper = null;
    private ManagedObjectMetadataHelper metadataHelper = null;
    private RepositoryContext nodeInArchiveCxt = null;
    private RepositoryContext cellInArchiveCxt = null;

    public ImportNode(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportNode(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ObjectName pattern;
            WorkSpace archivews = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            Collection nodes = this.nodeName == null ? archivews.getRootContext().findContext(metadata2.getContextType("nodes")) : archivews.getRootContext().findContext("nodes", this.nodeName);
            this.nodeInArchiveCxt = (RepositoryContext)nodes.iterator().next();
            if (this.nodeName == null) {
                this.nodeName = this.nodeInArchiveCxt.getName();
                this.setParameter("nodeName", this.nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set new nodeName", this.nodeName);
                }
            }
            Collection cells = archivews.getRootContext().findContext(metadata2.getContextType("cells"));
            this.cellInArchiveCxt = (RepositoryContext)cells.iterator().next();
            Session session = this.getConfigSession();
            this.metadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName[] match = cs.queryConfigObjects(session, null, pattern = ConfigServiceHelper.createObjectName(null, "Cell"), null);
            if (match.length != 1) {
                throw new CommandValidationException("There should only one Cell config object defined");
            }
            ObjectName cell = match[0];
            pattern = ConfigServiceHelper.createObjectName(null, "Node", this.nodeName);
            if ((match = cs.queryConfigObjects(session, match[0], pattern, null)).length != 0) {
                throw new CommandValidationException("The specified node " + this.nodeName + " exists in the cell already");
            }
            this.archiveMetadataHelper = this.getConfigArchiveMetadataHelper();
            if (this.archiveMetadataHelper != null && this.archiveMetadataHelper.isNodeZOS(this.nodeName)) {
                this.nodeShortName = this.getNodeShortName(this.nodeInArchiveCxt);
                this.serversShortName = this.getServersShortName(nodes);
                this.validateNodeShortName(session, cs, cell);
                this.validateServersShortName(session, cs, cell);
                Collection servers = archivews.getRootContext().findContext(metadata2.getContextType("servers"));
                this.deleteExclusionList(session, cs, cell, servers);
                this.readLicenseAgreement(this.cellInArchiveCxt);
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ImportNode.validate", (String)"63");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to load archive", ex);
            }
            InvalidParameterValueException exception = new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            exception.initCause(ex);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Session session = this.getConfigSession();
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            Collection cells = ws.getRootContext().findContext(metadata2.getContextType("cells"));
            RepositoryContext cell = (RepositoryContext)cells.iterator().next();
            ConfigArchiveUtils.copyContext(cell, this.nodeInArchiveCxt, this.nodeName);
            WorkSpace archivews = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            Collection apps = archivews.getRootContext().findContext(metadata2.getContextType("applications"));
            for (RepositoryContext app : apps) {
                ConfigArchiveUtils.copyContext(cell, app, null);
            }
            Collection blas = archivews.getRootContext().findContext(metadata2.getContextType("blas"));
            for (RepositoryContext bla : blas) {
                ConfigArchiveUtils.copyContext(cell, bla, null);
            }
            Collection cus = archivews.getRootContext().findContext(metadata2.getContextType("cus"));
            for (RepositoryContext cu : cus) {
                ConfigArchiveUtils.copyContext(cell, cu, null);
            }
            Collection assets = archivews.getRootContext().findContext(metadata2.getContextType("assets"));
            for (RepositoryContext asset : assets) {
                ConfigArchiveUtils.copyContext(cell, asset, null);
            }
            this.addNodeGroupMember();
            if (this.archiveMetadataHelper != null && this.archiveMetadataHelper.isNodeZOS(this.nodeName)) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
                ObjectName _cell = configService.queryConfigObjects(session, null, pattern, null)[0];
                this.updateZOSConfigDocuments(session, configService, _cell);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ImportNode.beforeStepsExecuted", (String)"175");
            result.setException((Throwable)new ConfigArchiveException(th, "importNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void addNodeGroupMember() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNodeGroupMember()");
        }
        Object th = null;
        Session session = this.getConfigSession();
        AdminCommand cmd = CommandMgr.getCommandMgr().createCommand("addNodeGroupMember");
        cmd.setConfigSession(session);
        this.nodeGroupName = (String)this.getParameter("nodeGroupName");
        if (this.nodeGroupName == null) {
            this.nodeGroupName = "DefaultNodeGroup";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeGroupName", this.nodeGroupName);
        }
        cmd.setTargetObject(this.nodeGroupName);
        cmd.setParameter("nodeName", this.nodeName);
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        Collection c = result.getMessages();
        if (!result.isSuccessful()) {
            throw result.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNodeGroupMember()");
        }
    }

    private void updateZOSConfigDocuments(Session session, ConfigService configService, ObjectName cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateZOSConfigDocuments()");
        }
        String cellShortName = null;
        ObjectName node = configService.resolve(session, "Node=" + this.nodeName)[0];
        if (!this.isZOSCell()) {
            cellShortName = this.getCellShortName(session, configService, cell);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current cell short name", cellShortName);
            }
            if (cellShortName == null || cellShortName.trim().equals("")) {
                cellShortName = this.getCellContextShortName(this.cellInArchiveCxt);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell short name from archive", cellShortName);
                }
                this.updateCellShortName(session, configService, cell, cellShortName);
            }
            this.updateReadLicenseAgreement(session, configService, cell);
        } else {
            cellShortName = this.getCellShortName(session, configService, cell);
        }
        this.updateNodeVariablesDoc(session, configService, node);
        this.updateServersStartCommandArgs(session, configService, node, cellShortName);
        this.updateNodeAgentConfig(session, configService, cell, node, cellShortName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateZOSConfigDocuments()");
        }
    }

    private String getNodeAgentShortName(Session session, ConfigService configService, ObjectName cell, String nodeAgentShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeAgentShortName()", nodeAgentShortName);
        }
        HashSet<String> set = new HashSet<String>();
        ObjectName[] nodes = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < nodes.length; ++i) {
            ObjectName serverIndex = configService.getRelationship(session, nodes[i], "ServerIndex")[0];
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
            ObjectName[] entries = configService.queryConfigObjects(session, serverIndex, pattern, null);
            for (int k = 0; k < entries.length; ++k) {
                String serverShortName;
                String serverType = (String)configService.getAttribute(session, entries[k], "serverType");
                if (serverType == null || serverType.length() <= 0 || !serverType.equals("NODE_AGENT") || (serverShortName = (String)configService.getAttribute(session, entries[k], "serverShortName")) == null) continue;
                set.add(serverShortName);
            }
        }
        if (nodeAgentShortName != null) {
            if (set.contains(nodeAgentShortName)) {
                throw new AdminException(this.getFormattedMessage("ADMU0183E", new Object[]{nodeAgentShortName}, null));
            }
            return nodeAgentShortName;
        }
        nodeAgentShortName = this.nextName(set);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAgentShortName()", nodeAgentShortName);
        }
        return nodeAgentShortName;
    }

    private void validateNodeShortName(Session session, ConfigService configService, ObjectName cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNodeShortName()", this.nodeShortName);
        }
        ObjectName[] nodes = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < nodes.length; ++i) {
            String _nodeShortName;
            String _nodeName = (String)configService.getAttribute(session, nodes[i], "name");
            boolean managedNode = this.isManagedNode(session, configService, nodes[i]);
            if (!this.metadataHelper.isNodeZOS(_nodeName) || !managedNode || (_nodeShortName = (String)configService.getAttribute(session, nodes[i], "shortName")) == null || !_nodeShortName.equalsIgnoreCase(this.nodeShortName)) continue;
            throw new AdminException(this.getFormattedMessage("ADMU0182E", new Object[]{this.nodeShortName}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNodeShortName()");
        }
    }

    private void validateServersShortName(Session session, ConfigService configService, ObjectName cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateServersShortName()", this.serversShortName);
        }
        ObjectName[] nodes = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < nodes.length; ++i) {
            String _nodeName = (String)configService.getAttribute(session, nodes[i], "name");
            if (!this.metadataHelper.isNodeZOS(_nodeName)) continue;
            ObjectName serverIndex = configService.getRelationship(session, nodes[i], "ServerIndex")[0];
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
            ObjectName[] entries = configService.queryConfigObjects(session, serverIndex, pattern, null);
            for (int k = 0; k < entries.length; ++k) {
                String serverType = (String)configService.getAttribute(session, entries[k], "serverType");
                if (serverType == null || !serverType.equals("APPLICATION_SERVER")) continue;
                String _serverShortName = ((String)configService.getAttribute(session, entries[k], "serverShortName")).trim();
                String _genericShortName = ((String)configService.getAttribute(session, entries[k], "genericShortName")).trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_serverShortName,_genericShortName", new Object[]{_serverShortName, _genericShortName});
                }
                for (Map.Entry entry : this.serversShortName.entrySet()) {
                    String serverShortName = ((String)entry.getKey()).trim();
                    String genericShortName = ((String)entry.getValue()).trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverShortName,genericShortName", new Object[]{serverShortName, genericShortName});
                    }
                    if (_serverShortName != null && serverShortName.equalsIgnoreCase(_serverShortName)) {
                        throw new AdminException(this.getFormattedMessage("ADMU0180E", new Object[]{serverShortName, ConfigServiceHelper.getDisplayName(nodes[i])}, null));
                    }
                    if (_genericShortName == null || !genericShortName.equalsIgnoreCase(_genericShortName)) continue;
                    throw new AdminException(this.getFormattedMessage("ADMU0181E", new Object[]{genericShortName, ConfigServiceHelper.getDisplayName(nodes[i])}, null));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateServersShortName()");
        }
    }

    private String nextName(Set set) {
        String prefix = "BBON";
        int counter = 1;
        String next = "";
        if (set != null) {
            for (int i = 0; i < set.size() + 2; ++i) {
                String count = String.valueOf(counter);
                while (count.length() < 3) {
                    count = "0" + count;
                }
                next = prefix + count;
                if (set.contains(next)) {
                    ++counter;
                    continue;
                }
                break;
            }
        } else {
            next = prefix + "001";
        }
        return next;
    }

    private void updateNodeAgentConfig(Session session, ConfigService configService, ObjectName cell, ObjectName node, String cellShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeAgentConfig", new Object[]{cell, node, cellShortName});
        }
        String TRANSITION_NAME = "ClusterTransitionName";
        String nodeAgentShortName = null;
        ObjectName[] servers = configService.getRelationship(session, node, "Server");
        ObjectName processDefObject = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName adminServiceObject = ConfigServiceHelper.createObjectName(null, "AdminService");
        String uniqueId = null;
        AttributeList list = new AttributeList();
        for (int i = 0; i < servers.length; ++i) {
            String serverName = (String)configService.getAttribute(session, servers[i], "name");
            if (!serverName.equalsIgnoreCase("nodeagent")) continue;
            String serverShortName = (String)configService.getAttribute(session, servers[i], "shortName");
            nodeAgentShortName = this.getNodeAgentShortName(session, configService, cell, serverShortName);
            uniqueId = (String)configService.getAttribute(session, servers[i], "uniqueId");
            ConfigServiceHelper.setAttributeValue(list, "shortName", nodeAgentShortName);
            configService.setAttributes(session, servers[i], list);
            ObjectName[] processDefs = configService.queryConfigObjects(session, servers[i], processDefObject, null);
            for (int j = 0; j < processDefs.length; ++j) {
                String processType = (String)configService.getAttribute(session, processDefs[j], "processType");
                if (!processType.equalsIgnoreCase("Control")) continue;
                String controlProcName = this.getSymbolicName(session, configService, node, "WAS_DEFAULT_CONTROL_PROC_NAME");
                String start = "START " + controlProcName;
                String startCmdArg = "JOBNAME=" + nodeAgentShortName + ",ENV=" + cellShortName + "." + this.nodeShortName + "." + nodeAgentShortName;
                String stop = "STOP " + nodeAgentShortName + ";CANCEL " + nodeAgentShortName;
                String term = "FORCE " + nodeAgentShortName;
                ArrayList<String> alist = new ArrayList<String>();
                alist.add(startCmdArg);
                AttributeList newList = new AttributeList();
                newList.add(new Attribute("startCommandArgs", alist));
                configService.setAttributes(session, processDefs[j], newList);
                newList.clear();
                newList.add(new Attribute("startCommand", start));
                newList.add(new Attribute("stopCommand", stop));
                newList.add(new Attribute("terminateCommand", term));
                configService.setAttributes(session, processDefs[j], newList);
                newList.clear();
            }
            list.clear();
            ObjectName adminService = configService.queryConfigObjects(session, servers[i], adminServiceObject, null)[0];
            AttributeList attrList = configService.getAttributes(session, adminService, new String[]{"properties"}, false);
            List props = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName transNameProp : props) {
                String propName = (String)configService.getAttribute(session, transNameProp, "name");
                if (!propName.equalsIgnoreCase(TRANSITION_NAME)) continue;
                ConfigServiceHelper.setAttributeValue(list, "value", nodeAgentShortName);
                configService.setAttributes(session, transNameProp, list);
            }
            String localNodeName = AdminServiceFactory.getAdminService().getNodeName();
            String localProcessName = AdminServiceFactory.getAdminService().getProcessName();
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd1 = cmdMgr.createCommand("getJVMMode");
            cmd1.setConfigSession(session);
            cmd1.setParameter("nodeName", localNodeName);
            cmd1.setParameter("serverName", localProcessName);
            cmd1.execute();
            CommandResult result2 = cmd1.getCommandResult();
            String bitmode = null;
            if (!result2.isSuccessful()) {
                Throwable th = result2.getException();
                throw new Exception(th);
            }
            bitmode = (String)result2.getResult();
            boolean isOldVersionNode = false;
            if (this.metadataHelper.compareNodeVersion(this.nodeName, "6.1") == -1) {
                isOldVersionNode = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isOldVersionNode ", Boolean.toString(isOldVersionNode));
            }
            if (isOldVersionNode) continue;
            AdminCommand cmd = cmdMgr.createCommand("setJVMMode");
            cmd.setConfigSession(session);
            cmd.setParameter("serverName", "nodeagent");
            cmd.setParameter("nodeName", this.nodeName);
            cmd.setParameter("mode", bitmode);
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (result.isSuccessful()) continue;
            Throwable th = result.getException();
            throw new Exception(th);
        }
        ObjectName serverIndex = configService.getRelationship(session, node, "ServerIndex")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] entries = configService.queryConfigObjects(session, serverIndex, pattern, null);
        for (int k = 0; k < entries.length; ++k) {
            String serverType = (String)configService.getAttribute(session, entries[k], "serverType");
            if (!serverType.equals("NODE_AGENT")) continue;
            AttributeList entryList = new AttributeList();
            entryList.add(new Attribute("serverShortName", nodeAgentShortName));
            entryList.add(new Attribute("genericShortName", nodeAgentShortName));
            entryList.add(new Attribute("serverUniqueId", uniqueId));
            configService.setAttributes(session, entries[k], entryList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeAgentConfig");
        }
    }

    private void updateServersStartCommandArgs(Session session, ConfigService configService, ObjectName node, String cellShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServersStartCommandArgs", new Object[]{node, cellShortName});
        }
        ObjectName[] servers = configService.getRelationship(session, node, "Server");
        ObjectName processDefObject = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        for (int i = 0; i < servers.length; ++i) {
            String serverName = (String)configService.getAttribute(session, servers[i], "name");
            String serverShortName = (String)configService.getAttribute(session, servers[i], "shortName");
            if (serverName.equalsIgnoreCase("nodeagent")) continue;
            ObjectName[] processDefs = configService.queryConfigObjects(session, servers[i], processDefObject, null);
            for (int j = 0; j < processDefs.length; ++j) {
                AttributeList newList;
                ArrayList<String> list;
                String startArg;
                String env;
                String jobName;
                Map<String, String> parsedCmd;
                String origStartArgs;
                List origArgList;
                AttributeList attrList;
                String processType = (String)configService.getAttribute(session, processDefs[j], "processType");
                if (processType.equalsIgnoreCase("Control")) {
                    attrList = configService.getAttributes(session, processDefs[j], new String[]{"startCommandArgs"}, false);
                    origArgList = null;
                    if (attrList != null && attrList.size() > 0) {
                        origArgList = (List)((Attribute)attrList.get(0)).getValue();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command arg list=" + origArgList);
                    }
                    origStartArgs = null;
                    parsedCmd = new HashMap();
                    if (origArgList != null && origArgList.size() > 0) {
                        origStartArgs = (String)origArgList.get(0);
                        parsedCmd = this.parseStartCommandArgs(origStartArgs);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command args=" + origStartArgs);
                    }
                    jobName = serverShortName;
                    env = cellShortName + "." + this.nodeShortName + "." + serverShortName;
                    parsedCmd.put("JOBNAME", jobName);
                    parsedCmd.put("ENV", env);
                    parsedCmd.put("REUSASID", "YES");
                    startArg = this.generateStartCommandArgs(parsedCmd);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new start command args=" + startArg);
                    }
                    list = new ArrayList<String>();
                    list.add(startArg);
                    newList = new AttributeList();
                    newList.add(new Attribute("startCommandArgs", list));
                    configService.setAttributes(session, processDefs[j], newList);
                    continue;
                }
                if (processType.equalsIgnoreCase("Servant")) {
                    attrList = configService.getAttributes(session, processDefs[j], new String[]{"startCommandArgs"}, false);
                    origArgList = null;
                    if (attrList != null && attrList.size() > 0) {
                        origArgList = (List)((Attribute)attrList.get(0)).getValue();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command arg list=" + origArgList);
                    }
                    origStartArgs = null;
                    parsedCmd = new HashMap();
                    if (origArgList != null && origArgList.size() > 0) {
                        origStartArgs = (String)origArgList.get(0);
                        parsedCmd = this.parseStartCommandArgs(origStartArgs);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command args=" + origStartArgs);
                    }
                    jobName = "&IWMSSNM.S";
                    env = "'" + cellShortName + "." + this.nodeShortName + "." + "&IWMSSNM." + "'";
                    parsedCmd.put("JOBNAME", jobName);
                    parsedCmd.put("ENV", env);
                    startArg = this.generateStartCommandArgs(parsedCmd);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new start command args=" + startArg);
                    }
                    list = new ArrayList();
                    list.add(startArg);
                    newList = new AttributeList();
                    newList.add(new Attribute("startCommandArgs", list));
                    configService.setAttributes(session, processDefs[j], newList);
                    continue;
                }
                if (!processType.equalsIgnoreCase("Adjunct")) continue;
                attrList = configService.getAttributes(session, processDefs[j], new String[]{"startCommandArgs"}, false);
                origArgList = null;
                if (attrList != null && attrList.size() > 0) {
                    origArgList = (List)((Attribute)attrList.get(0)).getValue();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "original start command arg list=" + origArgList);
                }
                origStartArgs = null;
                parsedCmd = new HashMap();
                if (origArgList != null && origArgList.size() > 0) {
                    origStartArgs = (String)origArgList.get(0);
                    parsedCmd = this.parseStartCommandArgs(origStartArgs);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "original start command args=" + origStartArgs);
                }
                jobName = "&IWMSSNM.A";
                env = "'" + cellShortName + "." + this.nodeShortName + "." + "&IWMSSNM." + "'";
                parsedCmd.put("JOBNAME", jobName);
                parsedCmd.put("ENV", env);
                startArg = this.generateStartCommandArgs(parsedCmd);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new start command args=" + startArg);
                }
                list = new ArrayList();
                list.add(startArg);
                newList = new AttributeList();
                newList.add(new Attribute("startCommandArgs", list));
                configService.setAttributes(session, processDefs[j], newList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServersStartCommandArgs");
        }
    }

    private Map getServersShortName(Collection nodes) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersShortName()", nodes);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        WorkSpaceFile wsFile = null;
        for (RepositoryContext _nodeContext : nodes) {
            wsFile = _nodeContext.getFile("serverindex.xml");
            Resource resource = _nodeContext.getResourceSet().createResource(URI.createURI("serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList list = serverIndex.getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                String type = serverEntry.getServerType();
                if (!type.equals("APPLICATION_SERVER")) continue;
                String serverShortName = serverEntry.getServerShortName();
                String genericShortName = serverEntry.getGenericShortName();
                map.put(serverShortName, genericShortName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersShortName()", map);
        }
        return map;
    }

    private String getNodeShortName(RepositoryContext nodeContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeShortName");
        }
        Resource resource = nodeContext.getResourceSet().createResource(URI.createURI("node.xml"));
        resource.load(new HashMap());
        Node node = (Node)resource.getContents().get(0);
        String result = node.getShortName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeShortName", result);
        }
        return result;
    }

    private void updateNodeVariablesDoc(Session session, ConfigService configService, ObjectName node) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeVariablesDoc()");
        }
        String daemonCellOnlySystemName = this.getSymbolicName(session, configService, node, "WAS_DAEMON_ONLY_server_configured_system_name");
        this.setSymbolicName(session, configService, node, "WAS_DAEMON_daemonInstanceName", daemonCellOnlySystemName);
        this.setSymbolicName(session, configService, node, "WAS_DAEMON_ONLY_server_specific_short_name", daemonCellOnlySystemName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeVariablesDoc()");
        }
    }

    private void setSymbolicName(Session session, ConfigService configService, ObjectName parent, String symbolName, String value) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSymbolicName()");
        }
        ObjectName varMap = configService.getRelationship(session, parent, "VariableMap")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        ObjectName[] entries = configService.queryConfigObjects(session, varMap, pattern, null);
        for (int k = 0; k < entries.length; ++k) {
            String symName = (String)configService.getAttribute(session, entries[k], "symbolicName");
            if (symName == null || symName.length() <= 0 || !symName.equals(symbolName)) continue;
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("value", value));
            configService.setAttributes(session, entries[k], attrList);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSymbolicName()");
        }
    }

    private String getSymbolicName(Session session, ConfigService configService, ObjectName parent, String symbolName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSymbolicName()", symbolName);
        }
        String result = null;
        ObjectName varMap = configService.getRelationship(session, parent, "VariableMap")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        ObjectName[] entries = configService.queryConfigObjects(session, varMap, pattern, null);
        for (int k = 0; k < entries.length; ++k) {
            String symName = (String)configService.getAttribute(session, entries[k], "symbolicName");
            if (symName == null || symName.length() <= 0 || !symName.equals(symbolName)) continue;
            result = (String)configService.getAttribute(session, entries[k], "value");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSymbolicName()", result);
        }
        return result;
    }

    private String getFormattedMessage(String key, Object[] args, String msg) {
        try {
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return msg;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (msg == null) {
                return msg;
            }
            return MessageFormat.format(msg, args);
        }
        catch (NullPointerException npe) {
            return msg;
        }
    }

    private String getNodeGroupShortName(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupShortName");
        }
        String nodeGroupShortName = null;
        ObjectName nodeGroup = configService.resolve(session, "NodeGroup=" + this.nodeGroupName)[0];
        nodeGroupShortName = (String)configService.getAttribute(session, nodeGroup, "shortName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupShortName", nodeGroupShortName);
        }
        return nodeGroupShortName;
    }

    private void updateReadLicenseAgreement(Session session, ConfigService configService, ObjectName cell) throws Exception {
        String readLicense;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateReadLicenseAgreement()");
        }
        if ((readLicense = this.getSymbolicName(session, configService, cell, "was.WAS_DAEMON_read_license_agreement")) != null && readLicense.length() > 0) {
            this.setSymbolicName(session, configService, cell, "was.WAS_DAEMON_read_license_agreement", this.readLicenseAgreement);
        } else {
            AttributeList attrList = new AttributeList();
            ObjectName varMap = configService.getRelationship(session, cell, "VariableMap")[0];
            attrList.add(new Attribute("symbolicName", "was.WAS_DAEMON_read_license_agreement"));
            attrList.add(new Attribute("value", this.readLicenseAgreement));
            configService.createConfigData(session, varMap, "entries", null, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateReadLicenseAgreement()");
        }
    }

    private void deleteExclusionList(Session session, ConfigService configService, ObjectName cell, Collection servers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteExclusionList()", servers);
        }
        if (!this.isZOSCell()) {
            String[] excludeNames = new String[]{"was.env", "trace.dat", "control.jvm.options", "servant.jvm.options", "adjunct.jvm.options"};
            for (RepositoryContext _serverContext : servers) {
                for (int j = 0; j < excludeNames.length; ++j) {
                    _serverContext.delete(excludeNames[j]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteExclusionList()");
        }
    }

    private boolean isZOSCell(Session session, ConfigService configService, ObjectName cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isZOSCell()", cell);
        }
        boolean result = false;
        boolean zNode = false;
        boolean dNode = false;
        String[] nodes = this.getAllNodes(session, configService, cell);
        for (int i = 0; i < nodes.length; ++i) {
            if (this.metadataHelper.isNodeZOS(nodes[i])) {
                zNode = true;
                continue;
            }
            if (this.metadataHelper.isNodeZOS(nodes[i])) continue;
            dNode = true;
        }
        if (zNode && !dNode) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isZOSCell()", new Boolean(result));
        }
        return result;
    }

    private String[] getAllNodes(Session session, ConfigService configService, ObjectName cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNodes", cell);
        }
        ArrayList<String> list = new ArrayList<String>();
        ObjectName[] matches = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < matches.length; ++i) {
            String node = (String)configService.getAttribute(session, matches[i], "name");
            list.add(node);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllNodes", result);
        }
        return result;
    }

    private void readLicenseAgreement(RepositoryContext cellInArchiveCxt) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLicenseAgreement()");
        }
        Resource resource = cellInArchiveCxt.getResourceSet().createResource(URI.createURI("variables.xml"));
        resource.load(new HashMap());
        EList extent = resource.getContents();
        VariableMap varMap = (VariableMap)extent.get(0);
        EList varMapEntries = varMap.getEntries();
        this.readLicenseAgreement = this.getEntryValue(varMapEntries, "WAS_DAEMON_read_license_agreement");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReadLicenseAgreement()", this.readLicenseAgreement);
        }
    }

    private String getEntryValue(List varMapEntries, String symbolName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEntryValue()", symbolName);
        }
        String result = null;
        for (int j = 0; j < varMapEntries.size(); ++j) {
            VariableSubstitutionEntry vse = (VariableSubstitutionEntry)varMapEntries.get(j);
            String sn = vse.getSymbolicName();
            if (!symbolName.equalsIgnoreCase(sn)) continue;
            return vse.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntryValue()", result);
        }
        return result;
    }

    private String getCellShortName(Session session, ConfigService configService, ObjectName cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellShortName()");
        }
        String cellShortName = (String)configService.getAttribute(session, cell, "shortName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellShortNames()", cellShortName);
        }
        return cellShortName;
    }

    private String getCellContextShortName(RepositoryContext cellContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellContextShortName");
        }
        Resource resource = cellContext.getResourceSet().createResource(URI.createURI("cell.xml"));
        resource.load(new HashMap());
        Cell cell = (Cell)resource.getContents().get(0);
        String result = cell.getShortName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellContextShortName", result);
        }
        return result;
    }

    private void updateCellShortName(Session session, ConfigService configService, ObjectName cell, String newCellShortName) throws Exception {
        String cellShortName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellShortName");
        }
        if ((cellShortName = this.getCellShortName(session, configService, cell)) == null || cellShortName.length() <= 0) {
            AttributeList list = new AttributeList();
            list.add(new Attribute("shortName", newCellShortName));
            configService.setAttributes(session, cell, list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellShortName");
        }
    }

    private boolean isManagedNode(Session session, ConfigService configService, ObjectName node) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedNode", node);
        }
        boolean isManagedNode = false;
        ObjectName serverIndex = configService.getRelationship(session, node, "ServerIndex")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] entries = configService.queryConfigObjects(session, serverIndex, pattern, null);
        for (int k = 0; k < entries.length; ++k) {
            String serverType = (String)configService.getAttribute(session, entries[k], "serverType");
            if (serverType == null || serverType.length() <= 0) continue;
            if (serverType.equals("NODE_AGENT")) {
                isManagedNode = true;
                break;
            }
            if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
            isManagedNode = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedNode", new Boolean(isManagedNode));
        }
        return isManagedNode;
    }

    private boolean isZOSCell() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isZOSCell");
        }
        String zOS = "os390";
        boolean retVal = false;
        String cellOS = System.getProperty("os.name");
        if (cellOS != null) {
            cellOS = ManagedObjectMetadataUtilities.normalizeOSName((String)cellOS);
        }
        if (cellOS.equals(zOS)) {
            retVal = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isZOSCell", new Boolean(retVal));
        }
        return retVal;
    }

    private Map parseStartCommandArgs(String startCommand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseStartCommandArgs", startCommand);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(startCommand, ",");
        while (st.hasMoreTokens()) {
            String arg = st.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token", arg);
            }
            int eqIndex = arg.indexOf(61);
            String key = null;
            String value = null;
            if (eqIndex > 0) {
                key = arg.substring(0, eqIndex);
                value = arg.substring(eqIndex + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key", key);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value", value);
                }
                map.put(key, value);
                continue;
            }
            map.put(key, "");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Map", map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseStartCommandArgs", startCommand);
        }
        return map;
    }

    private String generateStartCommandArgs(Map args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateStartCommandArgs", args);
        }
        StringBuffer buff = new StringBuffer();
        Iterator it = args.entrySet().iterator();
        boolean removeLastChar = false;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key", me.getKey());
                Tr.debug(tc, "Value", me.getValue());
            }
            buff.append(me.getKey());
            removeLastChar = false;
            if (me.getValue() == null || ((String)me.getValue()).trim().length() <= 0) continue;
            buff.append("=");
            buff.append(me.getValue());
            buff.append(",");
            removeLastChar = true;
        }
        if (removeLastChar) {
            buff.deleteCharAt(buff.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateStartCommandArgs", buff.toString());
        }
        return buff.toString();
    }

    private boolean contextExists(RepositoryMetaData metadata2, String ctxName, RepositoryContext parent, String contextName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contextExists", new Object[]{ctxName, parent, contextName});
        }
        boolean result = false;
        Collection ctxs = parent.findContext(metadata2.getContextType(contextName));
        if (ctxs != null) {
            for (RepositoryContext ctx : ctxs) {
                if (!ctx.getName().equals(ctxName)) continue;
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contextExists", new Boolean(result));
        }
        return result;
    }
}

