/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configarchive.ExportCommandBase;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.util.Collection;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ExportWsprofile
extends ExportCommandBase {
    private static TraceComponent tc = Tr.register(ExportWsprofile.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public ExportWsprofile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportWsprofile(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
            ObjectName[] queryResult = configService.queryConfigObjects(session, null, pattern, null);
            if (queryResult.length != 1) {
                String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0001E");
                throw new CommandValidationException(msg);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "Server");
            queryResult = configService.queryConfigObjects(session, null, pattern, null);
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ExportCell.validate", (String)"79");
            throw new CommandValidationException(th, "An unexpected exception is thrown.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType cellType = metadata2.getContextType("cells");
            Collection matches = workspace.findContext(cellType);
            RepositoryContext cell = (RepositoryContext)matches.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell", cell);
            }
            WorkSpace archiveWorkspace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            ConfigArchiveUtils.copyContext(archiveWorkspace.getRootContext(), cell, null);
            this.removeSIBresources(archiveWorkspace.getRootContext());
            try {
                this.addRars(archiveWorkspace.getRootContext(), cell.getName());
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "export of rars failed");
                }
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ExportCell.beforeStepsExecuted", (String)"99");
            result.setException((Throwable)new ConfigArchiveException(th, "exportCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void removeSIBresources(RepositoryContext rootContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSIBresources");
        }
        RepositoryContext busesCtx = null;
        RepositoryContext nodeCtx = null;
        RepositoryContext serverCtx2 = null;
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType busesType = metadata2.getContextType("buses");
        if (busesType == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no busesCtx found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeSIBresources");
            }
            return;
        }
        Collection matches = rootContext.findContext(busesType);
        if (matches != null && matches.size() > 0) {
            busesCtx = (RepositoryContext)matches.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing busesCtx ", busesCtx);
            }
            busesCtx.delete(true);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no busesCtx found");
        }
        RepositoryContextType nodeType = metadata2.getContextType("nodes");
        matches = rootContext.findContext(nodeType);
        if (matches != null && matches.size() > 0) {
            nodeCtx = (RepositoryContext)matches.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeCtx ", nodeCtx);
        }
        if (nodeCtx == null) {
            return;
        }
        RepositoryContextType serverType = metadata2.getContextType("servers");
        matches = nodeCtx.findContext(serverType);
        if (matches != null && matches.size() > 0) {
            for (RepositoryContext serverCtx2 : matches) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing sib-engine.xml from serverCtx ", serverCtx2);
                }
                if (serverCtx2 != null) {
                    serverCtx2.delete("sib-engines.xml");
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "removeSIBresources");
            }
        }
    }

    private void addRars(RepositoryContext rootContext, String cellName) throws Exception {
        RepositoryContextType nodeType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRars", rootContext);
        }
        RepositoryContext nodeCtx = null;
        RepositoryContext serverCtx2 = null;
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType cellType = metadata2.getContextType("cells");
        Collection matches = rootContext.findContext(cellType);
        RepositoryContext cell = (RepositoryContext)matches.iterator().next();
        if ((matches = cell.findContext(nodeType = metadata2.getContextType("nodes"))) != null && matches.size() > 0) {
            nodeCtx = (RepositoryContext)matches.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeCtx ", nodeCtx);
        }
        if (nodeCtx == null) {
            return;
        }
        RepositoryContextType serverType = metadata2.getContextType("servers");
        matches = nodeCtx.findContext(serverType);
        if (matches != null && matches.size() > 0) {
            for (RepositoryContext serverCtx2 : matches) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverCtx ", serverCtx2);
                }
                VariableMap vMap = this.createVariableMap(rootContext, cellName, nodeCtx.getName(), serverCtx2.getName());
                Resource res = ConfigArchiveUtils.getResource(nodeCtx, "resources.xml");
                if (res != null) {
                    this.saveRarInArchive(res, nodeCtx, vMap);
                }
                if ((res = ConfigArchiveUtils.getResource(serverCtx2, "resources.xml")) == null) continue;
                this.saveRarInArchive(res, serverCtx2, vMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRars");
        }
    }

    private VariableMap createVariableMap(RepositoryContext root, String cellName, String nodeName, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVariableMap", new Object[]{root, cellName, nodeName, serverName});
        }
        BeanContextServicesSupport bc = new BeanContextServicesSupport();
        String wsRoot = root.getPath();
        Repository repository2 = RepositoryFactory.createRepository((String)"ws-server", (String)wsRoot, (String)cellName, (String)nodeName, (String)serverName);
        bc.addService(Repository.class, (BeanContextServiceProvider)repository2);
        VariableMap map = VariableMapFactory.createVariableMap();
        bc.add(map);
        try {
            map.initialize(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    private void saveRarInArchive(Resource res, RepositoryContext nodeCtx, VariableMap vMap) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveRarInArchive", nodeCtx);
        }
        EList contents = res.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            WorkSpaceFile wsf;
            Object obj = contents.get(i);
            if (!(obj instanceof J2CResourceAdapter)) continue;
            J2CResourceAdapter j2cadapter = (J2CResourceAdapter)obj;
            String archiveLocation = j2cadapter.getArchivePath();
            String resName = j2cadapter.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resName ", resName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archiveLocation ", archiveLocation);
            }
            if ((wsf = nodeCtx.getFile("resources.xml")) == null) continue;
            String uri = wsf.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource uri ", uri);
            }
            uri = uri.substring(0, uri.indexOf("/resources.xml"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node uri ", uri);
            }
            String wsPath = nodeCtx.getWorkSpace().getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archive workspace path ", wsPath);
            }
            wsPath = wsPath + File.separator + uri + File.separator + "rars" + File.separator + resName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rar path ", wsPath);
            }
            archiveLocation = vMap.expand(archiveLocation);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded src rar path ", archiveLocation);
            }
            ConfigArchiveUtils.mkdirs(wsPath);
            ConfigArchiveUtils.copyRar(archiveLocation, wsPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveRarInArchive");
        }
    }
}

