/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigArchiveUtils {
    private static TraceComponent tc = Tr.register(ConfigArchiveUtils.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static String waitTarget = null;
    public static String addNodeServerName = null;

    private static RepositoryContext copyContext(RepositoryContext parentContext, Template template, HashMap data, String contextName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyContext", new Object[]{parentContext, template, data});
        }
        TemplateManager templateMgr = TemplateManagerFactory.getManager((WorkSpace)parentContext.getWorkSpace());
        RepositoryContext result = templateMgr.createContext(parentContext, contextName == null ? template.getName() : contextName, template, data);
        List children = template.getContext().getChildren();
        for (RepositoryContext child : children) {
            ConfigArchiveUtils.copyContext(result, templateMgr.getTemplate(child), data, null);
        }
        if (result != null && result.toString().indexOf("/servers/") != -1 && !result.toString().contains("nodeagent")) {
            addNodeServerName = result.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server name set to: " + addNodeServerName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyContext", result);
        }
        return result;
    }

    public static RepositoryContext copyContext(RepositoryContext parentContext, RepositoryContext templateContext, String contextName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyContext", new Object[]{parentContext, templateContext});
        }
        RepositoryContext result = null;
        TemplateManager templateMgr = TemplateManagerFactory.getManager((WorkSpace)parentContext.getWorkSpace());
        Template template = templateMgr.getTemplate(templateContext);
        result = ConfigArchiveUtils.copyContext(parentContext, template, null, contextName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyContext", result);
        }
        if (result != null && result.toString().indexOf("/servers/") != -1 && !result.toString().contains("nodeagent")) {
            addNodeServerName = result.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server name set to: " + addNodeServerName);
            }
        }
        return result;
    }

    public static RepositoryContext createContext(RepositoryContext parentContext, String childName, RepositoryContext template) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContext", new Object[]{parentContext, childName, template});
        }
        RepositoryContext result = null;
        TemplateManager templateMgr = TemplateManagerFactory.getManager((WorkSpace)parentContext.getWorkSpace());
        result = templateMgr.createContext(parentContext, childName, templateMgr.getTemplate(template), null);
        RepositoryDocumentType documentType = result.getType().getRootDocumentType();
        ConfigDataId id = new ConfigDataId(result.getURI(), documentType.getFilePattern());
        Session session = new Session(result.getWorkSpace().getUserName(), true);
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, "name", childName);
            cs.setAttributes(session, ConfigServiceHelper.createObjectName(id), attrList);
        }
        catch (InvalidAttributeNameException ex) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContext", result);
        }
        return result;
    }

    public static void mergeList(List baseList, List addList, String keyAttr, boolean overwrite) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeList", new Object[]{baseList, addList, keyAttr, new Boolean(overwrite)});
        }
        for (int i = 0; i < addList.size(); ++i) {
            EObject thisVal = (EObject)addList.get(i);
            EObject match = ConfigArchiveUtils.match(baseList, thisVal, keyAttr);
            if (match != null && overwrite) {
                baseList.remove(match);
            }
            if (match != null && !overwrite) continue;
            baseList.add(thisVal);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeList");
        }
    }

    static void mergeVariableList(List baseList, List addList, String keyAttr, boolean overwrite) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeVariableList", new Object[]{baseList, addList, keyAttr, new Boolean(overwrite)});
        }
        for (int i = 0; i < addList.size(); ++i) {
            EObject thisVal = (EObject)addList.get(i);
            String variableVal = ((VariableSubstitutionEntry)thisVal).getValue();
            if (variableVal == null || variableVal.length() == 0) continue;
            EObject match = ConfigArchiveUtils.match(baseList, thisVal, keyAttr);
            if (match != null && overwrite) {
                baseList.remove(match);
            }
            if (match != null && !overwrite) continue;
            baseList.add(thisVal);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeVariableList");
        }
    }

    private static EObject match(List baseList, EObject element, String keyAttr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "match", new Object[]{baseList, element, keyAttr});
        }
        EObject result = null;
        Object elementVal = element.eGet(element.eClass().getEStructuralFeature(keyAttr));
        for (EObject thisVar : baseList) {
            Object thisVal = thisVar.eGet(thisVar.eClass().getEStructuralFeature(keyAttr));
            if (thisVal == null || !thisVal.equals(elementVal)) continue;
            result = thisVar;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "match", result);
        }
        return result;
    }

    static void mergeVirtualHostList(List baseList, List addList, String keyAttr, boolean overwrite) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeVirtualHostList", new Object[]{baseList, addList, keyAttr, new Boolean(overwrite)});
        }
        for (int i = 0; i < addList.size(); ++i) {
            EObject thisVal = (EObject)addList.get(i);
            String nameVal = ((VirtualHost)thisVal).getName();
            if (nameVal == null || nameVal.length() == 0) continue;
            EObject match = ConfigArchiveUtils.match(baseList, thisVal, keyAttr);
            if (match != null && overwrite) {
                baseList.remove(match);
                ConfigArchiveUtils.mergeList(((VirtualHost)thisVal).getAliases(), ((VirtualHost)match).getAliases(), "port", false);
            }
            if (match != null && !overwrite) continue;
            baseList.add(thisVal);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeVirtualHostList");
        }
    }

    public static Resource getResource(RepositoryContext context, String fileName) throws Exception {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResource", new Object[]{context, fileName});
            }
            try {
                WorkspaceHelper.getDocAccessor(context, fileName);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getDocAccessor failed");
            }
        }
        Resource res = context.getResourceSet().getResource(URI.createURI(fileName), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", res);
        }
        return res;
    }

    public static AdminCommand getCreateTemplateCommand(ConfigService configService, Session session, ObjectName server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTemplateCommand", new Object[]{configService, session, server});
        }
        String serverType = (String)configService.getAttribute(session, server, "serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", serverType);
        }
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand showServerTypeInfoCmd = cmdMgr.createCommand("showServerTypeInfo");
        showServerTypeInfoCmd.setConfigSession(session);
        showServerTypeInfoCmd.setTargetObject(serverType);
        showServerTypeInfoCmd.execute();
        AttributeList serverTypeInfo = (AttributeList)showServerTypeInfoCmd.getCommandResult().getResult();
        String createTemplateCmd = (String)ConfigServiceHelper.getAttributeValue(serverTypeInfo, "createTemplateCommand");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createTemplateCmd", createTemplateCmd);
        }
        AdminCommand cmd = cmdMgr.createCommand(createTemplateCmd);
        cmd.setConfigSession(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTemplateCommand", cmd);
        }
        return cmd;
    }

    public static AdminCommand getCreateCommand(ConfigService configService, Session session, Session templateSession, ObjectName serverTemplate) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateCommand", new Object[]{configService, session, templateSession, serverTemplate});
        }
        String serverType = (String)configService.getAttribute(templateSession, serverTemplate, "serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", serverType);
        }
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand showServerTypeInfoCmd = cmdMgr.createCommand("showServerTypeInfo");
        showServerTypeInfoCmd.setConfigSession(session);
        showServerTypeInfoCmd.setTargetObject(serverType);
        showServerTypeInfoCmd.execute();
        AttributeList serverTypeInfo = (AttributeList)showServerTypeInfoCmd.getCommandResult().getResult();
        String createCmd = (String)ConfigServiceHelper.getAttributeValue(serverTypeInfo, "createCommand");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createCmd", createCmd);
        }
        AdminCommand cmd = cmdMgr.createCommand(createCmd);
        cmd.setConfigSession(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateCommand", cmd);
        }
        return cmd;
    }

    public static RepositoryContext createContextIfNeeded(RepositoryContext parent, String typeName, String name) throws Throwable {
        RepositoryMetaData metadata2;
        RepositoryContextType type;
        RepositoryContext child;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContextIfNeeded", new Object[]{parent, typeName, name});
        }
        if ((child = parent.getChild(type = (metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData()).getContextType(typeName), name)) == null) {
            child = parent.create(type, name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContextIfNeeded", child);
        }
        return child;
    }

    public static Object[] toNames(Collection contexts) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toNames", contexts);
        }
        Object[] result = new Object[contexts.size()];
        Iterator iter = contexts.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i] = ((RepositoryContext)iter.next()).getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "result[" + i + "]", result[i]);
            }
            ++i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toNames");
        }
        return result;
    }

    public static String getCellName() {
        AdminService adminService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        String cellName = (adminService = AdminServiceFactory.getAdminService()) != null ? adminService.getCellName() : System.getProperty("local.cell");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", cellName);
        }
        return cellName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployApplication(ApplicationDeployment appDepl, Session session, String appName, Session archiveSession, String appNameInArchive, String nodeName, String serverName) throws Exception {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deployApplication", new Object[]{session, appName, archiveSession, appNameInArchive});
            }
            AppManagement appManagement = CommandMgr.getCommandMgr().getCommandProviderHelper().getAppManagement();
            File temp = null;
            String tempAppNameInArchive = null;
            try {
                AppInstallListener l;
                tempAppNameInArchive = appNameInArchive.length() < 3 ? appNameInArchive + "tmp" : appNameInArchive;
                temp = File.createTempFile(tempAppNameInArchive, ".ear");
                String tempPath = temp.getAbsolutePath();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "temp path", tempPath);
                }
                Hashtable<String, String> options = new Hashtable<String, String>(1);
                String looseConfig = null;
                EList props = appDepl.getProperties();
                for (int i = 0; i < props.size(); ++i) {
                    Property p = (Property)props.get(i);
                    if (!"was.loose.config".equals(p.getName())) continue;
                    looseConfig = p.getValue();
                }
                if (!appDepl.isEnableDistribution() && looseConfig != null) {
                    options.put("was.loose.config", looseConfig);
                }
                ConfigService cs = ConfigServiceFactory.getConfigService();
                ObjectName cell = cs.queryConfigObjects(archiveSession, null, ConfigServiceHelper.createObjectName(null, "Cell"), null)[0];
                String cellName = ConfigServiceHelper.getDisplayName(cell);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellName", cellName);
                }
                options.put("cell.name", cellName);
                appManagement.exportApplication(appNameInArchive, tempPath, options, archiveSession.toString());
                cellName = ConfigArchiveUtils.getCellName();
                options = new Hashtable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellName", cellName);
                }
                options.put("cell.name", cellName);
                options.put("node.name", nodeName);
                options.put("server.name", serverName);
                options.put("import.archive", "true");
                if (!appDepl.isEnableDistribution() && looseConfig != null) {
                    options.put("was.loose.config", looseConfig);
                }
                if (appName == null) {
                    appName = appNameInArchive;
                }
                AppInstallListener appInstallListener = l = new AppInstallListener(appName, temp);
                synchronized (appInstallListener) {
                    waitTarget = "InstallApplication";
                    if (AdminServiceFactory.getAdminService() == null) {
                        appManagement.installApplicationLocal(tempPath, appName, options, l, session.toString());
                    } else {
                        appManagement.installApplication(tempPath, appName, options, session.toString());
                    }
                    if (!l.isComplete()) {
                        l.wait();
                    }
                }
                if (!l.isSuccess()) {
                    throw new ConfigArchiveException("fail to deploy application " + appName);
                }
                Object var21_21 = null;
                if (temp == null || !temp.exists()) break block19;
                temp.delete();
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (temp != null && temp.exists()) {
                    temp.delete();
                }
                throw throwable;
            }
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deployApplication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateApplication(ApplicationDeployment appDepl, Session session, String appName, Session archiveSession, String appNameInArchive, String binURL, String nodeName, String serverName) throws Exception {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateApplication", new Object[]{session, appName, archiveSession, appNameInArchive});
            }
            AppManagement appManagement = CommandMgr.getCommandMgr().getCommandProviderHelper().getAppManagement();
            File temp = null;
            String tempAppNameInArchive = null;
            try {
                AppInstallListener l;
                tempAppNameInArchive = appNameInArchive.length() < 3 ? appNameInArchive + "tmp" : appNameInArchive;
                temp = File.createTempFile(tempAppNameInArchive, ".ear");
                Hashtable<String, String> options = new Hashtable<String, String>(1);
                ConfigService cs = ConfigServiceFactory.getConfigService();
                ObjectName cell = cs.queryConfigObjects(archiveSession, null, ConfigServiceHelper.createObjectName(null, "Cell"), null)[0];
                String cellName = ConfigServiceHelper.getDisplayName(cell);
                options.put("node.name", nodeName);
                options.put("server.name", serverName);
                options.put("was.profile.import", "was.profile.import");
                options.put("import.archive", "true");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellName", cellName);
                }
                cellName = ConfigArchiveUtils.getCellName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellName", cellName);
                }
                options.put("cell.name", cellName);
                options.put("contenttype", "app");
                String looseConfig = null;
                EList props = appDepl.getProperties();
                for (int i = 0; i < props.size(); ++i) {
                    Property p = (Property)props.get(i);
                    if (!"was.loose.config".equals(p.getName())) continue;
                    looseConfig = p.getValue();
                }
                if (!appDepl.isEnableDistribution() && looseConfig != null) {
                    options.put("was.loose.config", looseConfig);
                }
                if (appName == null) {
                    appName = appNameInArchive;
                }
                AppInstallListener appInstallListener = l = new AppInstallListener(appName, temp);
                synchronized (appInstallListener) {
                    waitTarget = "InstallApplication";
                    if (AdminServiceFactory.getAdminService() == null) {
                        appManagement.updateApplicationLocal(appName, null, binURL, "update", options, l, session.toString());
                    } else {
                        appManagement.updateApplication(appName, null, binURL, "update", options, session.toString());
                    }
                    if (!l.isComplete()) {
                        l.wait();
                    }
                    if (!l.isSuccess()) {
                        throw new ConfigArchiveException("fail to deploy application " + appName);
                    }
                }
                Object var21_21 = null;
                if (temp == null || !temp.exists()) break block17;
                temp.delete();
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (temp != null && temp.exists()) {
                    temp.delete();
                }
                throw throwable;
            }
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplication");
        }
    }

    public static void copyFile(RepositoryContext parentContext, RepositoryContext templateContext, String contextName, String uri) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{parentContext, templateContext, contextName, uri});
        }
        TemplateManager templateMgr = TemplateManagerFactory.getManager((WorkSpace)parentContext.getWorkSpace());
        Template template = templateMgr.getTemplate(templateContext);
        templateMgr.createFile(parentContext, uri, template, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void copyFile(String src, String dst) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy file (" + src + " " + dst + ")");
        }
        File srcFile = new File(src);
        File dstFile = new File(dst);
        ConfigArchiveUtils.copyFile(srcFile, dstFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void copyFile(File srcFile, File dstFile) throws IOException {
        int nbytes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy file (" + srcFile + " " + dstFile + ")");
        }
        FileInputStream ins = new FileInputStream(srcFile);
        FileOutputStream os = new FileOutputStream(dstFile);
        byte[] buffer = new byte[1024];
        while ((nbytes = ins.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, nbytes);
        }
        os.flush();
        os.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void copyDir(String src, String dst) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDir", src + " " + dst);
        }
        File srcFile = new File(src);
        File dstFile = new File(dst);
        ConfigArchiveUtils.copyDir(srcFile, dstFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDir");
        }
    }

    public static void copyDir(File src, File dst) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDir", src + " " + dst);
        }
        if (src.isDirectory()) {
            if (!dst.exists() && !dst.mkdirs()) {
                throw new IOException("Cannot create directory " + dst);
            }
            String[] children = src.list();
            for (int i = 0; i < children.length; ++i) {
                File srcDir = new File(src, children[i]);
                File dstDir = new File(dst, children[i]);
                ConfigArchiveUtils.copyDir(srcDir, dstDir);
            }
        } else {
            ConfigArchiveUtils.copyFile(src, dst);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDir");
        }
    }

    public static void mkdirs(String dst) throws IOException {
        File dstFile = new File(dst);
        if (!dstFile.exists() && !dstFile.mkdirs()) {
            throw new IOException("Cannot create directory " + dst);
        }
    }

    public static void deleteDir(File dir) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDir", dir);
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                File delDir = new File(dir, children[i]);
                ConfigArchiveUtils.deleteDir(delDir);
            }
        }
        dir.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDir");
        }
    }

    public static void copyRar(String src, String dst) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyRar ", src + " " + dst);
        }
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (srcFile.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy dir");
            }
            ConfigArchiveUtils.copyDir(srcFile, dstFile);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy file");
            }
            File dFile = new File(dstFile, srcFile.getName());
            ConfigArchiveUtils.copyFile(srcFile, dFile);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyRar");
        }
    }

    public static void getRar(String dst, String src) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRar ", src + " " + dst);
        }
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (srcFile.exists()) {
            if (!dstFile.exists()) {
                File[] files = srcFile.listFiles();
                boolean dir = false;
                int inx = 0;
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        dir = true;
                    }
                    if (!files[i].getName().endsWith("rar")) continue;
                    inx = i;
                }
                if (!dir) {
                    File parent;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy single rar file ", files[0] + " " + dstFile);
                    }
                    if (!(parent = dstFile.getParentFile()).exists()) {
                        parent.mkdirs();
                    }
                    ConfigArchiveUtils.copyFile(files[inx], dstFile);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy rar directory ", srcFile + " " + dstFile);
                    }
                    dstFile.mkdirs();
                    ConfigArchiveUtils.copyDir(srcFile, dstFile);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delete  " + srcFile + " " + " as " + dstFile + "exists");
                }
                srcFile.delete();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRar");
        }
    }

    private static class AppInstallListener
    implements AppNotification.Listener,
    NotificationListener {
        private ObjectName appmgmtMBean = null;
        private String appName;
        private File earFile;
        private boolean success = false;
        private boolean complete = false;
        private String task = null;

        public AppInstallListener(String appName, File earFile) {
            this.appName = appName;
            this.earFile = earFile;
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    Set match;
                    String process = adminService.getProcessName();
                    String node = adminService.getNodeName();
                    String query = "WebSphere:type=AppManagement,node=" + node + ",process=" + process + ",*";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "query", query);
                    }
                    if ((match = adminService.queryNames(new ObjectName(query), null)).size() >= 1) {
                        this.appmgmtMBean = (ObjectName)match.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appmgmtMBean", this.appmgmtMBean);
                        }
                        adminService.addNotificationListener(this.appmgmtMBean, this, null, null);
                    }
                }
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", ex);
                }
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", (String)"313");
            }
        }

        public void handleNotification(Notification notf, Object handback) {
            Object ud;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notf, handback});
            }
            if ((ud = notf.getUserData()) instanceof AppNotification) {
                this.appEventReceived((AppNotification)ud);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", ud);
            }
            if (this.complete) {
                try {
                    AdminServiceFactory.getAdminService().removeNotificationListener(this.appmgmtMBean, this);
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception", ex);
                    }
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", (String)"331");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        public synchronized void appEventReceived(AppNotification ev) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "appEventReceived", ev);
            }
            String thisAppName = ev.props.getProperty("appname");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "thisAppName", thisAppName);
            }
            if (this.appName.equals(thisAppName)) {
                if (ev.taskStatus.equals("Completed")) {
                    this.success = true;
                    this.complete = true;
                    this.task = ev.taskName;
                } else if (ev.taskStatus.equals("Failed")) {
                    this.success = false;
                    this.complete = true;
                    this.task = ev.taskName;
                }
                if (this.complete) {
                    if (ev.taskName.equals(waitTarget)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "", thisAppName);
                        }
                        waitTarget = null;
                        this.notifyAll();
                    } else if (!this.success) {
                        waitTarget = null;
                        this.notifyAll();
                    } else {
                        this.complete = false;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appEventReceived");
            }
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public String getTask() {
            return this.task;
        }
    }
}

