/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityFactory;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariablesFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveComposer;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.configarchive.ApplicationConfigurator;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class ApplicationConfiguratorImpl
extends ApplicationConfigurator {
    private static TraceComponent tc = Tr.register(ApplicationConfiguratorImpl.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private FileAccessor fileAccessor = null;
    private WorkSpace archiveWorkspace = null;
    private RepositoryContext cellContext = null;
    private RepositoryContext applicationContext = null;
    private RepositoryContext appDeploymentContext = null;
    private RepositoryContext serverContext = null;
    private RepositoryContext nodeContext = null;
    public static final String CELL_NAME = "defaultCell";
    private static final String NODE_NAME = "defaultNode";
    private static final String SERVER_NAME = "defaultServer";
    public static final String APPLICATION_NAME = "defaultApp";
    public static final String APPLICATION_BIN_NAME = "defaultApp.ear_";

    public ApplicationConfiguratorImpl(FileAccessor inFileAccessor) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationConfiguratorImpl", inFileAccessor);
        }
        this.fileAccessor = inFileAccessor;
        this.archiveWorkspace = ConfigArchiveComposer.loadConfigArchive(null, this.fileAccessor);
        WorkSpaceImpl archiveWorkspaceImpl = (WorkSpaceImpl)this.archiveWorkspace;
        archiveWorkspaceImpl.setDisableCleanup();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationConfiguratorImpl");
        }
    }

    public ApplicationConfiguratorImpl(WorkSpace inArchiveWorkspace) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationConfiguratorImpl", inArchiveWorkspace);
        }
        this.archiveWorkspace = inArchiveWorkspace;
        WorkSpaceImpl inArchiveWorkspaceImpl = (WorkSpaceImpl)inArchiveWorkspace;
        inArchiveWorkspaceImpl.setDisableCleanup();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationConfiguratorImpl");
        }
    }

    private void init() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        try {
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType type = metadata2.getContextType("cells");
            RepositoryContext rootContext = this.archiveWorkspace.getRootContext();
            Collection match = rootContext.findContext("cells", CELL_NAME);
            this.cellContext = match == null || match.size() == 0 ? rootContext.create(type, CELL_NAME) : (RepositoryContext)match.iterator().next();
            type = metadata2.getContextType("nodes");
            match = this.cellContext.findContext("nodes", NODE_NAME);
            this.nodeContext = match == null || match.size() == 0 ? this.cellContext.create(type, NODE_NAME) : (RepositoryContext)match.iterator().next();
            type = metadata2.getContextType("servers");
            match = this.cellContext.findContext("servers", SERVER_NAME);
            this.serverContext = match == null || match.size() == 0 ? this.nodeContext.create(type, SERVER_NAME) : (RepositoryContext)match.iterator().next();
            type = metadata2.getContextType("applications");
            match = this.cellContext.findContext("applications", APPLICATION_NAME);
            this.applicationContext = match == null || match.size() == 0 ? this.cellContext.create(type, APPLICATION_NAME) : (RepositoryContext)match.iterator().next();
            type = metadata2.getContextType("deployments");
            match = this.applicationContext.findContext("deployments", APPLICATION_NAME);
            this.appDeploymentContext = match == null || match.size() == 0 ? this.applicationContext.create(type, APPLICATION_NAME) : (RepositoryContext)match.iterator().next();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ApplicationConfiguratorImpl.init", (String)"147");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "init failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public List listResourceProvider() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourceProvider");
        }
        EList result = null;
        try {
            Resource res = ConfigArchiveUtils.getResource(this.appDeploymentContext, "resources.xml");
            result = res.getContents();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listResourceProvider", (String)"111");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "listResourceProvider failed");
        }
        if (result.size() == 0) {
            this.addDefaultResources(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listResourceProvider", result);
        }
        return result;
    }

    public List listVirtualHost() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listVirtualHost");
        }
        EList result = null;
        try {
            Resource res = ConfigArchiveUtils.getResource(this.cellContext, "virtualhosts.xml");
            result = res.getContents();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listVirtualHost", (String)"142");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "listVirtualHost failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listVirtualHost", result);
        }
        return result;
    }

    public List listVariables() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listVariables");
        }
        EList result = null;
        try {
            Resource res = ConfigArchiveUtils.getResource(this.appDeploymentContext, "variables.xml");
            EList topObjs = res.getContents();
            VariableMap map = null;
            if (topObjs.size() == 0) {
                map = VariablesFactory.eINSTANCE.createVariableMap();
                topObjs.add(map);
            } else {
                map = (VariableMap)topObjs.get(0);
            }
            result = map.getEntries();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listVariables", (String)"179");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "listVariables failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listVariables", result);
        }
        return result;
    }

    public List listLibraries() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listLibraries");
        }
        EList result = null;
        try {
            Resource res = ConfigArchiveUtils.getResource(this.serverContext, "libraries.xml");
            result = res.getContents();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listLibraries", (String)"197");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "listLibraries failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listLibraries", result);
        }
        return result;
    }

    public List listJAASAuthData() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJAASAuthData");
        }
        EList result = null;
        try {
            Resource res = ConfigArchiveUtils.getResource(this.cellContext, "security.xml");
            EList topObjs = res.getContents();
            Security security = null;
            if (topObjs.size() == 0) {
                security = SecurityFactory.eINSTANCE.createSecurity();
                topObjs.add(security);
            } else {
                security = (Security)topObjs.get(0);
            }
            result = security.getAuthDataEntries();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listJAASAuthData", (String)"235");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "listJAASAuthData failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listJAASAuthData", result);
        }
        return result;
    }

    public void save() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save");
        }
        this.saveContext(this.archiveWorkspace.getRootContext());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
    }

    private void saveContext(RepositoryContext context) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveContext");
        }
        try {
            ResourceSet set = context.getResourceSet();
            for (Resource res : set.getResources()) {
                if (!res.isModified()) continue;
                res.save(Collections.EMPTY_MAP);
            }
            List children = context.getChildren();
            for (RepositoryContext child : children) {
                this.saveContext(child);
            }
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.saveContext", (String)"271");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "saveContext failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveContext");
        }
    }

    public void cleanup() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        ConfigArchiveComposer.unloadConfigArchive(this.archiveWorkspace.getUserName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public List listDeployments() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listDeployments");
        }
        EList result = null;
        try {
            Resource res = ConfigArchiveUtils.getResource(this.appDeploymentContext, "deployment.xml");
            result = res.getContents();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listDeployment", (String)"311");
            if (ex instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)ex;
            }
            throw new ConfigArchiveException(ex, "listDeployments failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listDeployments", result);
        }
        return result;
    }

    private void addDefaultResources(List result) {
        try {
            Resource res;
            String serverType;
            RepositoryContext serverTypeContext;
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            String rraTempalteName = "WebSphere Relational Resource Adapter";
            Session session = new Session();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addDefaultResources");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a builin_rra");
            }
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            RepositoryContextType serverContextType = metadata2.getContextType("servers");
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)ws);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            if (templateContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template context");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context ", templateContext);
            }
            if ((serverTypeContext = templateContext.getChild(serverTypeContextType, serverType = "APPLICATION_SERVER")) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find server type context");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for servertypes", serverTypeContext);
            }
            List servers = serverTypeContext.getChildren();
            RepositoryContext sCtx = null;
            Iterator it = servers.iterator();
            while (it.hasNext() && !(sCtx = (RepositoryContext)it.next()).getName().equals("default")) {
            }
            if (sCtx == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template for default server");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for server", sCtx.getName());
            }
            if ((res = ConfigArchiveUtils.getResource(sCtx, "resources.xml")) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find resources.xml for default server");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found resource", res);
            }
            EList objs = res.getContents();
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                EObject obj = (EObject)itr.next();
                Resource r = obj.eResource();
                String id = null;
                if (r instanceof XMIResource) {
                    id = ((XMIResource)r).getID(obj);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding ", id);
                }
                itr.remove();
                result.add(obj);
                r = obj.eResource();
                if (!(r instanceof XMIResource)) continue;
                ((XMIResource)r).setID(obj, id);
            }
            WorkSpaceManager workspaceMan = WorkSpaceManagerFactory.getManager();
            workspaceMan.removeWorkSpace(session.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDefaultResources", result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

