/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.exception.DumpNotSupportedException;
import com.ibm.websphere.management.exception.DumpOnDiskLimitReachedException;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.websphere.management.exception.HeapDumpOnDiskLimitReachedException;
import com.ibm.ws.management.component.JVMMBean;
import com.ibm.ws.pmi.dynamicproxy.MBeanStatsAggregationHandler;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.j2ee.statistics.Stats;

public class JVMMBeanProxy
extends ProxyMBeanSupport {
    private int seqNum = 0;
    private ServantMBeanInvoker mbeanInvoker = new ServantMBeanInvoker();
    private MBeanStatsAggregationHandler aggregator = new MBeanStatsAggregationHandler();
    protected static TraceComponent tc = Tr.register(JVMMBeanProxy.class, null, null);
    private JVMMBean jvmBean = new JVMMBean();

    public JVMMBeanProxy() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JVMMBeanProxy constructor");
        }
    }

    public String getTotalMemory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTotalMemory");
        }
        String retval = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getTotalMemory", params, sig);
            StringBuffer stateBuf = new StringBuffer();
            stateBuf.append("Controller: " + Long.toString(Runtime.getRuntime().totalMemory()) + ";");
            for (ServantMBeanInvokerData data : results) {
                stateBuf.append("\nServant " + data.getStoken() + ": " + data.getResult() + ";");
            }
            retval = stateBuf.toString();
        } else {
            retval = this.jvmBean.getTotalMemory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTotalMemory");
        }
        return retval;
    }

    public void setVerbose(boolean verbose, String processType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose", new Object[]{new Boolean(verbose), processType});
        }
        this.jvmBean.setVerbose(verbose, processType);
        Object[] params = new Object[]{new Boolean(verbose), processType};
        String[] sig = new String[]{"Z", "java.lang.String"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setVerbose", params, sig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose");
        }
    }

    public void setVerbose(boolean verbose) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose", new Object[]{new Boolean(verbose)});
        }
        this.jvmBean.setVerbose(verbose);
        Object[] params = new Object[]{new Boolean(verbose)};
        String[] sig = new String[]{"Z"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setVerbose", params, sig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose");
        }
    }

    public boolean isVerbose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVerbose");
        }
        boolean verbose = this.jvmBean.isVerbose();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVerbose", new Boolean(verbose));
        }
        return verbose;
    }

    public String getFreeMemory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreeMemory");
        }
        String retval = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getFreeMemory", params, sig);
            StringBuffer stateBuf = new StringBuffer();
            stateBuf.append("Controller: " + Long.toString(Runtime.getRuntime().freeMemory()) + ";");
            for (ServantMBeanInvokerData data : results) {
                stateBuf.append("\nServant " + data.getStoken() + ": " + data.getResult() + ";");
            }
            retval = stateBuf.toString();
        } else {
            retval = this.jvmBean.getFreeMemory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFreeMemory");
        }
        return retval;
    }

    public String getJavaVendor() {
        return this.jvmBean.getJavaVendor();
    }

    public String getJavaVersion() {
        return this.jvmBean.getJavaVersion();
    }

    public String getProperty(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty");
        }
        String retval = null;
        Object[] params = new Object[]{key};
        String[] sig = new String[]{"java.lang.String"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getProperty", params, sig);
            StringBuffer stateBuf = new StringBuffer();
            boolean sameValues = true;
            String controlValue = null;
            if (results.size() > 0) {
                controlValue = this.jvmBean.getProperty(key);
            }
            String servantVal = null;
            for (ServantMBeanInvokerData data : results) {
                servantVal = (String)data.getResult();
                if (controlValue != null && servantVal == null) {
                    sameValues = false;
                } else if (controlValue == null && servantVal != null) {
                    sameValues = false;
                } else if (controlValue != null) {
                    sameValues = controlValue.equals(servantVal);
                }
                stateBuf.append("Servant " + data.getStoken() + ": " + servantVal + ";\n");
            }
            retval = sameValues ? controlValue : stateBuf.toString();
        } else {
            retval = this.jvmBean.getProperty(key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", retval);
        }
        return retval;
    }

    public String getIPAddress(String hostname) {
        return this.jvmBean.getIPAddress(hostname);
    }

    public long getCurrentTimeInMillis() {
        return this.jvmBean.getCurrentTimeInMillis();
    }

    public String getJVMNode() {
        return this.jvmBean.getJVMNode();
    }

    public void dumpThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpThreads");
        }
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "dumpThreads", params, sig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpThreads");
        }
    }

    public void setMaxDumpsOnDisk(Integer max) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaxDumpsOnDisk");
        }
        Object[] params = new Object[]{max};
        String[] sig = new String[]{"java.lang.Integer"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setMaxDumpsOnDisk", params, sig);
        } else {
            this.jvmBean.setMaxDumpsOnDisk(max);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaxDumpsOnDisk");
        }
    }

    public Integer getMaxDumpsOnDisk() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxDumpsOnDisk");
        }
        Integer result = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getMaxDumpsOnDisk", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            result = (Integer)data.getResult();
        } else {
            result = this.jvmBean.getMaxDumpsOnDisk();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxDumpsOnDisk", result);
        }
        return result;
    }

    public void setMaxSystemDumpsOnDisk(Integer max) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaxSystemDumpsOnDisk");
        }
        Object[] params = new Object[]{max};
        String[] sig = new String[]{"java.lang.Integer"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setMaxSystemDumpsOnDisk", params, sig);
        } else {
            this.jvmBean.setMaxSystemDumpsOnDisk(max);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaxSystemDumpsOnDisk");
        }
    }

    public Integer getMaxSystemDumpsOnDisk() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxDumpsOnDisk");
        }
        Integer result = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getMaxSystemDumpsOnDisk", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            result = (Integer)data.getResult();
        } else {
            result = this.jvmBean.getMaxSystemDumpsOnDisk();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxSystemDumpsOnDisk", result);
        }
        return result;
    }

    public String getMaxMemory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxMemory");
        }
        String retval = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getMaxMemory", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            retval = (String)data.getResult();
        } else {
            retval = this.jvmBean.getMaxMemory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxMemory", retval);
        }
        return retval;
    }

    public String generateHeapDump() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDump");
        }
        String retval = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "generateHeapDump", params, sig);
            for (ServantMBeanInvokerData data : results) {
                if (data.resultThrowable()) {
                    Throwable th = (Throwable)data.getResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result was throwable", th);
                    }
                    if (th instanceof HeapDumpNotSupportedException) {
                        throw (HeapDumpNotSupportedException)th;
                    }
                    if (th instanceof HeapDumpOnDiskLimitReachedException) {
                        throw (HeapDumpOnDiskLimitReachedException)th;
                    }
                    if (th instanceof MBeanException) {
                        throw (MBeanException)th;
                    }
                    throw new UndeclaredThrowableException(th);
                }
                retval = (String)data.getResult();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Expected Result", retval);
            }
        } else {
            this.sendNotification(new Notification("websphere.jvm.heapdump.attempting", this.getObjectName(), this.seqNum++));
            retval = this.jvmBean.generateHeapDump();
            this.sendNotification(new Notification("websphere.jvm.heapdump.generated", (Object)this.getObjectName(), (long)this.seqNum++, retval));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expected Result", retval);
            }
            return retval;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDump", null);
        }
        return null;
    }

    public String[] generateHeapDumps() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDumps");
        }
        int size = this.currentServants().size();
        String[] retval = new String[size];
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "generateHeapDumps", params, sig);
            Iterator it = results.iterator();
            String servantVal = null;
            int i = 0;
            while (it.hasNext()) {
                ServantMBeanInvokerData data = (ServantMBeanInvokerData)it.next();
                if (data.resultThrowable()) {
                    Throwable th = (Throwable)data.getResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result was throwable", th);
                    }
                    if (th instanceof HeapDumpNotSupportedException) {
                        throw (HeapDumpNotSupportedException)th;
                    }
                    if (th instanceof HeapDumpOnDiskLimitReachedException) {
                        throw (HeapDumpOnDiskLimitReachedException)th;
                    }
                    if (th instanceof MBeanException) {
                        throw (MBeanException)th;
                    }
                    throw new UndeclaredThrowableException(th);
                }
                servantVal = (String)data.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expected Result", servantVal);
                }
                retval[i++] = servantVal;
                servantVal = (String)data.getResult();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "generateHeapDumps stoken " + data.getStoken() + "  --  " + servantVal);
            }
        } else {
            retval = this.jvmBean.generateHeapDumps();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDumps", retval);
        }
        return retval;
    }

    public String[] generateHeapDump(String stoken) throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDump", stoken);
        }
        String[] retval = null;
        if (stoken == null || stoken.trim().equalsIgnoreCase("")) {
            retval = this.generateHeapDumps();
        } else {
            HashSet<String> specified = new HashSet<String>(1);
            specified.add(stoken);
            Object[] params = new Object[]{stoken};
            String[] sig = new String[]{"java.lang.String"};
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(specified, this.getObjectName(), "generateHeapDump", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            if (data.resultThrowable()) {
                Throwable th = (Throwable)data.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", th);
                }
                if (th instanceof HeapDumpNotSupportedException) {
                    throw (HeapDumpNotSupportedException)th;
                }
                if (th instanceof HeapDumpOnDiskLimitReachedException) {
                    throw (HeapDumpOnDiskLimitReachedException)th;
                }
                if (th instanceof MBeanException) {
                    throw (MBeanException)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            retval = (String[])data.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDump", retval);
        }
        return retval;
    }

    public String generateSystemDump() throws MBeanException, DumpNotSupportedException, DumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSystemDump");
        }
        String retval = null;
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "generateSystemDump", params, sig);
            for (ServantMBeanInvokerData data : results) {
                if (data.resultThrowable()) {
                    Throwable th = (Throwable)data.getResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result was throwable", th);
                    }
                    if (th instanceof DumpNotSupportedException) {
                        throw (DumpNotSupportedException)th;
                    }
                    if (th instanceof DumpOnDiskLimitReachedException) {
                        throw (DumpOnDiskLimitReachedException)th;
                    }
                    if (th instanceof MBeanException) {
                        throw (MBeanException)th;
                    }
                    throw new UndeclaredThrowableException(th);
                }
                retval = (String)data.getResult();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Expected Result", retval);
            }
        } else {
            this.sendNotification(new Notification("websphere.jvm.systemdump.attempting", this.getObjectName(), this.seqNum++));
            retval = this.jvmBean.generateSystemDump();
            this.sendNotification(new Notification("websphere.jvm.systempdump.generated", (Object)this.getObjectName(), (long)this.seqNum++, retval));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expected Result", retval);
            }
            return retval;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateSystemDump");
        }
        return retval;
    }

    public String generateSystemDump(String stoken) throws MBeanException, DumpNotSupportedException, DumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSystemDump", stoken);
        }
        String retval = null;
        if (stoken == null || stoken.trim().equalsIgnoreCase("")) {
            retval = this.generateSystemDump();
        } else {
            HashSet<String> specified = new HashSet<String>(1);
            specified.add(stoken);
            Object[] params = new Object[]{stoken};
            String[] sig = new String[]{"java.lang.String"};
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(specified, this.getObjectName(), "generateSystemDump", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            if (data.resultThrowable()) {
                Throwable th = (Throwable)data.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", th);
                }
                if (th instanceof DumpNotSupportedException) {
                    throw (DumpNotSupportedException)th;
                }
                if (th instanceof DumpOnDiskLimitReachedException) {
                    throw (DumpOnDiskLimitReachedException)th;
                }
                if (th instanceof MBeanException) {
                    throw (MBeanException)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            retval = (String)data.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateSystemDump " + stoken, retval);
        }
        return retval;
    }

    public String getObjectNameStr() {
        return this.getObjectName().toString();
    }

    public boolean isStateManageable() {
        boolean retval;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStateManageable");
        }
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "isStateManageable", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            Boolean result = (Boolean)data.getResult();
            retval = result;
        } else {
            retval = this.jvmBean.isStateManageable();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStateManageable", new Boolean(retval));
        }
        return retval;
    }

    public boolean isStatisticsProvider() {
        boolean retval;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStatisticsProvider");
        }
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "isStatisticsProvider", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            Boolean result = (Boolean)data.getResult();
            retval = result;
        } else {
            retval = this.jvmBean.isStatisticsProvider();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStatisticsProvider", new Boolean(retval));
        }
        return retval;
    }

    public boolean isEventProvider() {
        boolean retval;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEventProvider");
        }
        Object[] params = null;
        String[] sig = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "isEventProvider", params, sig);
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.get(0);
            Boolean result = (Boolean)data.getResult();
            retval = result;
        } else {
            retval = this.jvmBean.isEventProvider();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEventProvider", new Boolean(retval));
        }
        return retval;
    }

    public Stats getStats() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStats");
        }
        Object[] params = null;
        String[] sig = null;
        Stats result = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector results = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getStats", params, sig);
            ServantMBeanResult[] servantMBeanResults = results.toArray(new ServantMBeanResult[0]);
            result = (Stats)this.aggregator.aggregateResults("getStats", params, sig, servantMBeanResults, null);
        } else {
            result = this.jvmBean.getStats();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStats", result);
        }
        return result;
    }
}

