/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.authorizer.service.AdminAuthzService;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceListener;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.ipc.IPCConnectorServer;
import com.ibm.ws.management.connector.ipc.LocalCommUtil;
import com.ibm.ws.management.connector.rmi.RMIConnectorController;
import com.ibm.ws.management.connector.soap.JMXSoapAdapter;
import com.ibm.ws.management.discovery.CMDiscoveryAdapter;
import com.ibm.ws.management.discovery.DiscoveryAdapter;
import com.ibm.ws.management.discovery.MBeanDiscoveryService;
import com.ibm.ws.management.discovery.MPDiscoveryAdapter;
import com.ibm.ws.management.discovery.NADiscoveryAdapter;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper;
import com.ibm.ws.management.discovery.transport.MulticastServer;
import com.ibm.ws.management.dmgrmode.DmgrModeFactory;
import com.ibm.ws.management.dmgrmode.DmgrModeListener;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.nodeagent.Forwarder;
import com.ibm.ws.management.remote.RMIServer;
import com.ibm.ws.management.repository.FileRepository;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.xcf.common.plugin.GenJoinEventListener;
import com.ibm.ws.xcf.common.plugin.GenLeaveEventListener;
import com.ibm.ws.xcf.common.plugin.GenLivenessPlugin;
import com.ibm.ws.xcf.common.plugin.GenLivenessPluginFactory;
import com.ibm.wsspi.management.profile.ProfileUtility;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class JMXConnectors
extends ComponentImpl
implements IWorkloadRegulator,
PropertyChangeListener,
SecurityServiceListener,
DmgrModeListener,
AlarmListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(JMXConnectors.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    public static String FILETRANSFER_BUNDLE_NAME = "com.ibm.ws.management.resources.fileservice";
    private static final ResourceBundle FILETRANSFER_RESOURCE_BUNDLE = ResourceBundle.getBundle(FILETRANSFER_BUNDLE_NAME, Locale.getDefault());
    private static final String TMX4J_HTTP_PORT_PROPERTY = "tmx4j.httpadaptor.port";
    public static final String DEFAULT_HTTP_CONNECTOR_PORT = "8082";
    private SecurityService securityService;
    private EndPointMgr endPtMgr;
    private ConfigService configService;
    String myXCFMemberName = null;
    String myXCFHostCellNode = null;
    String myXCFGroup = null;
    String theXCFGroup = "TheXCFGroup";
    Integer myXCFcheckInterval = new Integer(60);
    private boolean xcfMonitor_Enabled = false;
    GenLivenessPlugin lp = null;
    private static Integer CHECK_ALARM_CONTEXT = new Integer(3);
    private static String XCF_CHECK_INTERVAL_PROP = "com.ibm.websphere.management.xcfcheck.interval";
    private Alarm checkAlarm = null;
    private String configRoot;
    private String cellName;
    private String nodeName;
    private String serverName;
    private String adminType;
    private boolean isCellRegistered;
    private int cellDiscoveryProtocol;
    private int nodeDiscoveryProtocol;
    private String localAdminConnectorType;
    private String remoteAdminConnectorType;
    private EndPtCollector epCollector;
    private ThreadPoolMgr threadPoolMgr;
    private JMXConnector soapConnector;
    private JMXConnector rmiConnector;
    private JMXConnector jsr160rmiConnector;
    private JMXConnector ipcConnectorServer;
    private boolean soapConnectorEnabled = false;
    private boolean rmiConnectorEnabled = false;
    private boolean httpConnectorEnabled = false;
    private boolean jsr160rmiConnectorEnabled = false;
    private boolean ipcConnectorEnabled;
    private boolean jsr160Enabled = true;
    private boolean soapConnectorThreadPoolGrowable = true;
    private String httpAdapterPort;
    private Properties soapConnectorProperties;
    private String sslConfigProp;
    private boolean connectorStopped = false;
    private String RMI_CONNECTOR_PROP = "disableJDKRMIConnector";
    private Properties ipcConnectorProps;
    private long lastXCFContext = -1L;

    public void initialize(Object config) {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", config);
            }
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant process - exiting initialize");
                }
                return;
            }
            this.endPtMgr = (EndPointMgr)this.getService(EndPointMgr.class);
            this.threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
            try {
                this.configService = (ConfigService)this.getService(ConfigService.class);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.initialize", (String)"195", (Object)this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Got Exception initializing:", ex);
            }
        }
        this.configRoot = this.configService.getPath();
        this.cellName = this.configService.getCellName();
        this.nodeName = this.configService.getNodeName();
        this.serverName = this.configService.getServerName();
        Server serverComp = (Server)this.getService(Server.class);
        serverComp.addPropertyChangeListener("state", (PropertyChangeListener)this);
        WorkloadController.registerRegulator((IWorkloadRegulator)this);
        Properties configProps = AdminInitializer.getInstance().getProperties();
        this.adminType = (String)configProps.get("adminTypeProperty");
        this.isCellRegistered = new Boolean(configProps.getProperty("cellRegisteredConfigProperty"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isCellRegistered " + this.isCellRegistered);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminType: " + this.adminType);
        }
        if (AdminHelper.getPlatformHelper().isZOS() && !this.adminType.equals("DeploymentManager") && !this.adminType.equals("JobManager") && (!this.adminType.equals("UnManagedProcess") || this.adminType.equals("UnManagedProcess") && this.isCellRegistered)) {
            RoutingTable rt = RoutingTable.getInstance();
            this.xcfMonitor_Enabled = rt.isXCFMonitorEnabled();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xcfMonitor_Enabled: " + this.xcfMonitor_Enabled);
            }
            if (this.xcfMonitor_Enabled) {
                String profileKey;
                block16: {
                    profileKey = null;
                    this.myXCFHostCellNode = "MyHost" + this.cellName + this.nodeName;
                    this.myXCFMemberName = this.myXCFHostCellNode + this.serverName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "myXCFMemberName: " + this.myXCFMemberName);
                    }
                    this.myXCFcheckInterval = Integer.getInteger(XCF_CHECK_INTERVAL_PROP, 60);
                    try {
                        profileKey = ProfileUtility.getUUID();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.JMXConnectors.initialize", (String)"271", (Object)this);
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "profileKey not found. Exception " + e.getMessage());
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "profileKey: " + profileKey);
                }
                this.myXCFGroup = profileKey != null ? this.theXCFGroup + profileKey : this.theXCFGroup;
            }
        }
        this.releaseService(this.endPtMgr);
        this.releaseService(this.threadPoolMgr);
        this.releaseService(serverComp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        boolean isServant = AdminHelper.getPlatformHelper().isServantJvm();
        this.securityService = (SecurityService)this.getService(SecurityService.class);
        AdminAuthzService adminAuthzService = (AdminAuthzService)this.getService(AdminAuthzService.class);
        SecurityHelper.getHelper().setSecurityService(this.securityService);
        this.securityService.addListener((SecurityServiceListener)SecurityHelper.getHelper());
        adminAuthzService.addListener((AdminAuthzServiceListener)SecurityHelper.getHelper());
        this.securityService.addListener((SecurityServiceListener)this);
        this.releaseService(this.securityService);
        DmgrModeFactory.getDmgrModeManager().addListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initDiscovery() {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initDiscovery");
            }
            try {
                Properties configProps = AdminInitializer.getInstance().getProperties();
                this.adminType = (String)configProps.get("adminTypeProperty");
                this.isCellRegistered = new Boolean(configProps.getProperty("cellRegisteredConfigProperty"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isCellRegistered " + this.isCellRegistered);
                }
                if (!this.adminType.equals("UnManagedProcess") && !this.adminType.equals("AdminAgent")) {
                    String cellDiscProtocol;
                    if (!this.adminType.equals("ManagedProcess")) {
                        this.epCollector = new EndPtCollector(this.endPtMgr);
                    }
                    if ((cellDiscProtocol = (String)configProps.get("cellDiscoveryProtocolConfigProperty")) != null) {
                        if (cellDiscProtocol.equals("TCP")) {
                            this.cellDiscoveryProtocol = 1;
                        } else if (cellDiscProtocol.equals("UDP")) {
                            this.cellDiscoveryProtocol = 0;
                        } else {
                            if (!cellDiscProtocol.equals("MULTICAST")) throw new IllegalStateException();
                            this.cellDiscoveryProtocol = 2;
                        }
                    } else {
                        this.cellDiscoveryProtocol = 1;
                    }
                    String nodeDiscProtocol = (String)configProps.get("nodeDiscoveryProtocolConfigProperty");
                    if (nodeDiscProtocol != null) {
                        if (nodeDiscProtocol.equals("TCP")) {
                            this.nodeDiscoveryProtocol = 1;
                        } else if (nodeDiscProtocol.equals("UDP")) {
                            this.nodeDiscoveryProtocol = 0;
                        } else {
                            if (!nodeDiscProtocol.equals("MULTICAST")) throw new IllegalStateException();
                            this.nodeDiscoveryProtocol = 2;
                        }
                    } else {
                        this.nodeDiscoveryProtocol = 1;
                    }
                    this.interprocessRegistration();
                    if (this.epCollector != null && !this.adminType.equals("NodeAgent")) {
                        this.epCollector.discard();
                        this.epCollector = null;
                    }
                } else if (this.adminType.equals("UnManagedProcess") && this.isCellRegistered) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registered Standalone cell type. Proceed with discovery");
                    }
                    this.interprocessRegistration();
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.initDiscovery", (String)"202", (Object)this);
                if (!tc.isDebugEnabled()) break block22;
                Tr.debug(tc, "Got Exception initializing discovery:", ex);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "initDiscovery");
    }

    public void stop() {
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant process - exiting stop");
            }
            return;
        }
        if (this.soapConnectorEnabled && this.soapConnector != null) {
            this.soapConnector.stop();
        }
        if (this.ipcConnectorEnabled && this.ipcConnectorServer != null) {
            this.ipcConnectorServer.stop();
        }
        RoutingTable.getInstance().shutdown();
    }

    public void destroy() {
    }

    public void initializeConnectors(ConfigObject adminServiceCO) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeConnectors", adminServiceCO);
        }
        List connectors = adminServiceCO.getObjectList("connectors");
        ConfigObject connector2 = null;
        List plist = null;
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            block0: for (int i = 0; i < connectors.size(); ++i) {
                connector2 = (ConfigObject)connectors.get(i);
                if (!connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "SOAPConnector")) continue;
                plist = connector2.getObjectList("properties");
                for (int p = 0; p < plist.size(); ++p) {
                    ConfigObject prop = (ConfigObject)plist.get(p);
                    String pName = prop.getString("name", null);
                    if (!"sslConfig".equals(pName)) continue;
                    this.sslConfigProp = prop.getString("value", null);
                    if (!tc.isDebugEnabled()) continue block0;
                    Tr.debug(tc, "Servant Process - initializeConnectors " + this.sslConfigProp);
                    continue block0;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant process - exiting initializeConnectors");
            }
            return;
        }
        ConfigObject pConnector = adminServiceCO.getObject("preferredConnector");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Preferred Connector", pConnector);
        }
        ConfigObject remoteAdminProtocol = adminServiceCO.getObject("remoteAdminProtocol");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RemoteAdminProtocol", remoteAdminProtocol);
        }
        ConfigObject localAdminProtocol = adminServiceCO.getObject("localAdminProtocol");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LocalAdminProtocol", localAdminProtocol);
        }
        EndPointMgr.NodeEndPoints nodeEndpoints = this.endPtMgr.getNodeEndPoints("@");
        EndPointMgr.ServerEndPoints serverEndpoints = nodeEndpoints.getServerEndPoints("@");
        for (int i = 0; i < connectors.size(); ++i) {
            connector2 = (ConfigObject)connectors.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connector", connector2);
            }
            plist = connector2.getObjectList("properties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Properties List", plist);
            }
            Properties initProps = new Properties();
            for (int p = 0; p < plist.size(); ++p) {
                ConfigObject wccmProp = (ConfigObject)plist.get(p);
                String pname = wccmProp.getString("name", null);
                String pval = wccmProp.getString("value", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Testing Property", new Object[]{pname, pval});
                }
                if (pname == null || pval == null) continue;
                initProps.put(pname, pval);
                if (pname.equals("sslConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Client SSL config initialized to: " + pval);
                    }
                    SecurityHelper.getHelper().setClientSSLAlias(pval);
                    continue;
                }
                if (!pname.equals(this.RMI_CONNECTOR_PROP) || !pval.equalsIgnoreCase("true")) continue;
                this.jsr160Enabled = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP Connector?: " + connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "SOAPConnector"));
            }
            if (connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "SOAPConnector")) {
                this.soapConnectorEnabled = connector2.getBoolean("enable", true);
                if (this.soapConnectorEnabled) {
                    this.initSOAPConnector(initProps, (EndPointMgr.EndPoints)serverEndpoints, this.threadPoolMgr);
                    String requestTimeout = initProps.getProperty("requestTimeout");
                    if (requestTimeout != null) {
                        System.getProperties().setProperty("com.ibm.SOAP.requestTimeout", requestTimeout);
                    }
                } else {
                    Tr.info(tc, "ADMC0055I");
                }
                if (connector2.equals(remoteAdminProtocol)) {
                    this.remoteAdminConnectorType = "SOAP";
                }
                if (!connector2.equals(localAdminProtocol)) continue;
                this.localAdminConnectorType = "SOAP";
                continue;
            }
            if (connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "RMIConnector")) {
                this.rmiConnectorEnabled = connector2.getBoolean("enable", true);
                if (this.rmiConnectorEnabled) {
                    this.initRMIConnector(initProps, (EndPointMgr.EndPoints)serverEndpoints);
                } else {
                    Tr.info(tc, "ADMC0056I");
                }
                if (connector2.equals(remoteAdminProtocol)) {
                    this.remoteAdminConnectorType = "RMI";
                }
                if (!connector2.equals(localAdminProtocol)) continue;
                this.localAdminConnectorType = "RMI";
                continue;
            }
            if (connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "IPCConnector")) {
                this.ipcConnectorEnabled = connector2.getBoolean("enable", true);
                if (this.ipcConnectorEnabled) {
                    this.initIPCConnector(initProps, (EndPointMgr.EndPoints)serverEndpoints);
                    String requestTimeout = initProps.getProperty("requestTimeout");
                    if (requestTimeout != null) {
                        System.getProperties().setProperty("com.ibm.IPC.requestTimeout", requestTimeout);
                    }
                } else {
                    Tr.info(tc, "ADMC0067I");
                }
                if (connector2.equals(remoteAdminProtocol)) {
                    this.remoteAdminConnectorType = "IPC";
                }
                if (!connector2.equals(localAdminProtocol)) continue;
                this.localAdminConnectorType = "IPC";
                continue;
            }
            if (connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "JSR160RMIConnector")) {
                this.jsr160rmiConnectorEnabled = connector2.getBoolean("enable", true);
                if (this.jsr160Enabled && this.jsr160rmiConnectorEnabled) {
                    this.initJSR160RMIConnector(initProps, (EndPointMgr.EndPoints)serverEndpoints);
                } else {
                    Tr.info(tc, "ADMC0057I");
                }
                if (connector2.equals(remoteAdminProtocol)) {
                    this.remoteAdminConnectorType = "JSR160RMI";
                }
                if (!connector2.equals(localAdminProtocol)) continue;
                this.localAdminConnectorType = "JSR160RMI";
                continue;
            }
            if (!connector2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "HTTPConnector")) continue;
            this.initHTTPConnector(initProps);
            this.httpConnectorEnabled = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeConnectors");
        }
    }

    private void initSOAPConnector(Properties properties, EndPointMgr.EndPoints serverEndpoints, ThreadPoolMgr threadPoolMgr) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSOAPConnector");
        }
        String soapPort = null;
        String soapHost = null;
        EndPointMgr.EndPointInfo endPtInfo = null;
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (processType.equals("DeploymentManager")) {
            endPtInfo = serverEndpoints.getEndPointInfo("SOAP_PROXY_CONNECTOR_ADDRESS");
        }
        if (endPtInfo == null) {
            endPtInfo = serverEndpoints.getEndPointInfo("SOAP_CONNECTOR_ADDRESS");
        }
        if (endPtInfo != null) {
            soapPort = new Integer(endPtInfo.getPort()).toString();
            soapHost = endPtInfo.getHost();
            if (soapHost == null) {
                try {
                    soapHost = AdminHelper.getInstance().getHostName();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.initSOAPConnector", (String)"296", (Object)this);
                }
            }
        } else {
            throw new RuntimeError(connectorNLS.getString("ADMC0016E"));
        }
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", soapHost);
        properties.setProperty("port", soapPort);
        this.soapConnectorProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initSOAPConnector", this.soapConnectorProperties);
        }
    }

    private void startSOAPConnector() throws Exception {
        String threadPoolGrowable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startSOAPConnector");
        }
        if (!this.soapConnectorEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "soapConnector is not enabled");
            }
            return;
        }
        int maxThreads = 5;
        String threadString = System.getProperty("com.ibm.websphere.management.soapThreads");
        if (threadString != null) {
            maxThreads = new Integer(threadString);
        }
        if ((threadPoolGrowable = System.getProperty("com.ibm.websphere.management.soapConnectorThreadPoolGrowable")) != null) {
            this.soapConnectorThreadPoolGrowable = new Boolean(threadPoolGrowable);
        }
        ThreadPool tp = this.getThreadPool("SoapConnectorThreadPool", maxThreads, this.soapConnectorThreadPoolGrowable);
        JMXSoapAdapter theConnector = new JMXSoapAdapter(tp);
        this.soapConnector = theConnector;
        theConnector.initialize(this.soapConnectorProperties);
        this.soapConnectorProperties = null;
        DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator((Object)theConnector, "SOAPConnector");
        AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", (RuntimeCollaborator)collab, "SOAPConnector", null);
        this.soapConnector.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startSOAPConnector");
        }
    }

    private void initRMIConnector(Properties properties, EndPointMgr.EndPoints serverEndpoints) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initRMIConnector", new Object[]{properties, serverEndpoints});
        }
        try {
            this.rmiConnector = new RMIConnectorController();
            Properties props = new Properties();
            String bootstrapPort = null;
            String bootstrapHost = null;
            EndPointMgr.EndPointInfo endPtInfo = serverEndpoints.getEndPointInfo("RMI_CONNECTOR_ADDRESS");
            if (endPtInfo != null) {
                bootstrapPort = new Integer(endPtInfo.getPort()).toString();
                bootstrapHost = endPtInfo.getHost();
            } else {
                endPtInfo = serverEndpoints.getEndPointInfo("BOOTSTRAP_ADDRESS");
                if (endPtInfo != null) {
                    bootstrapPort = new Integer(endPtInfo.getPort()).toString();
                    bootstrapHost = endPtInfo.getHost();
                } else {
                    throw new RuntimeError(connectorNLS.getString("ADMC0018E"));
                }
            }
            props.setProperty("type", "RMI");
            props.setProperty("port", bootstrapPort);
            props.setProperty("host", bootstrapHost);
            this.rmiConnector.initialize(props);
            AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", (RuntimeCollaborator)new DefaultRuntimeCollaborator((Object)this.rmiConnector, "RMIConnector"), "RMIConnector", null);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.JMXConnectors.initRMIConnector", (String)"396", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to initialize the RMI connector", th);
            }
            Tr.error(tc, "ADMC0020E", th.getMessage());
            throw new RuntimeError(th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initRMIConnector");
        }
    }

    public void startRMIConnector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startRMIConnector");
        }
        try {
            if (this.rmiConnectorEnabled) {
                this.rmiConnector.start();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startRMIConnector");
        }
    }

    private void initIPCConnector(Properties properties, EndPointMgr.EndPoints serverEndpoints) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initIPCConnector", new Object[]{properties, serverEndpoints});
        }
        try {
            EndPointMgr.EndPointInfo endPtInfo;
            this.ipcConnectorProps = new Properties();
            String ipcServerPort = null;
            String ipcServerHost = null;
            if (properties == null) {
                properties = new Properties();
            }
            if ((endPtInfo = serverEndpoints.getEndPointInfo("IPC_CONNECTOR_ADDRESS")) != null) {
                ipcServerPort = new Integer(endPtInfo.getPort()).toString();
                ipcServerHost = endPtInfo.getHost();
            } else {
                Tr.error(tc, "ADMC0069E");
            }
            properties.setProperty("type", "IPC");
            if (ipcServerHost != null && ipcServerPort != null) {
                properties.setProperty("port", ipcServerPort);
                properties.setProperty("host", ipcServerHost);
            }
            this.ipcConnectorProps = properties;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.JMXConnectors.initIPCConnector", (String)"400", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to initialize the IPC connector", th);
            }
            throw new RuntimeError(th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initIPCConnector");
        }
    }

    public void startIPCConnector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startIPCConnector");
        }
        try {
            if (this.ipcConnectorEnabled) {
                this.ipcConnectorServer = new IPCConnectorServer(null);
                this.ipcConnectorServer.initialize(this.ipcConnectorProps);
                this.ipcConnectorServer.start();
                AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", (RuntimeCollaborator)new DefaultRuntimeCollaborator((Object)this.ipcConnectorServer, "IPCConnector"), "IPCConnector", null);
            }
        }
        catch (Exception ex) {
            RuntimeException rte = new RuntimeException("Connector Error:" + ex.getMessage());
            rte.initCause(ex);
            throw rte;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startIPCConnector");
        }
    }

    private void initJSR160RMIConnector(Properties properties, EndPointMgr.EndPoints serverEndpoints) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initJSR160RMIConnector", new Object[]{properties, serverEndpoints});
        }
        try {
            Properties props = new Properties();
            String bootstrapPort = null;
            String bootstrapHost = null;
            EndPointMgr.EndPointInfo endPtInfo = serverEndpoints.getEndPointInfo("JSR160RMI_CONNECTOR_ADDRESS");
            if (endPtInfo != null) {
                bootstrapPort = new Integer(endPtInfo.getPort()).toString();
                bootstrapHost = endPtInfo.getHost();
            } else {
                endPtInfo = serverEndpoints.getEndPointInfo("BOOTSTRAP_ADDRESS");
                if (endPtInfo != null) {
                    bootstrapPort = new Integer(endPtInfo.getPort()).toString();
                    bootstrapHost = endPtInfo.getHost();
                } else {
                    throw new RuntimeError(connectorNLS.getString("ADMC0018E"));
                }
            }
            props.setProperty("type", "JSR160RMI");
            props.setProperty("port", bootstrapPort);
            props.setProperty("host", bootstrapHost);
            try {
                this.jsr160rmiConnector = new RMIServer();
                this.jsr160rmiConnector.initialize(props);
            }
            catch (ConnectorException ce) {
                RuntimeException rte = new RuntimeException("Connector Error:" + ce.getMessage());
                rte.initCause(ce);
                throw rte;
            }
            AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", (RuntimeCollaborator)new DefaultRuntimeCollaborator((Object)this.jsr160rmiConnector, "JSR160RMIConnector"), "JSR160RMIConnector", null);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.JMXConnectors.initJSR160RMIConnector", (String)"396", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to initialize the JSR160RMI connector", th);
            }
            Tr.error(tc, "ADMC0020E", th.getMessage());
            throw new RuntimeError(th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initJSR160RMIConnector");
        }
    }

    public void startJSR160RMIConnector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startJSR160RMIConnector");
        }
        try {
            if (this.jsr160Enabled && this.jsr160rmiConnectorEnabled) {
                this.jsr160rmiConnector.start();
                String port = ((RMIServer)this.jsr160rmiConnector).getProperties().getProperty("port");
                Tr.info(tc, "ADMC0058I", port);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startJSR160RMIConnector");
        }
    }

    private void initHTTPConnector(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initHTTPConnector");
        }
        this.httpAdapterPort = properties.getProperty("port");
        if (this.httpAdapterPort == null || this.httpAdapterPort.equals("")) {
            this.httpAdapterPort = DEFAULT_HTTP_CONNECTOR_PORT;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initHTTPConnector", this.httpAdapterPort);
        }
    }

    private void startHTTPConnector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startHTTPConnector");
        }
        if (!this.httpConnectorEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "httpConnector is not enabled");
            }
            return;
        }
        try {
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                Tr.audit(tc, "ADMC0040I");
            } else {
                System.setProperty(TMX4J_HTTP_PORT_PROPERTY, this.httpAdapterPort);
                ObjectName httppa = new ObjectName("WebSphere", "name", "HTTPAdapter");
                ObjectInstance httppaOI = AdminServiceFactory.getMBeanFactory().getMBeanServer().createMBean("com.tivoli.jmx.http_pa.Listener", httppa);
                AdminServiceFactory.getMBeanFactory().getMBeanServer().invoke(httppa, "startListener", null, null);
                Tr.audit(tc, "ADMC0027I", this.httpAdapterPort);
                this.httpAdapterPort = null;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.JMXConnectors.startHTTPConnector", (String)"381", (Object)this);
            Tr.warning(tc, "ADMC0028W", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startHTTPConnector");
        }
    }

    private void interprocessRegistration() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interprocessRegistration");
        }
        if (this.adminType.equals("UnManagedProcess") && !this.isCellRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "interprocessRegistration - standalone");
            }
            return;
        }
        String configuredSystemName = AdminHelper.getInstance().getWasConfiguredSystemName();
        Process myproc = ProcessFactory.createSelf();
        String pid = myproc.id();
        Vector<String> accessPoints = new Vector<String>();
        EndPointMgr.EndPointInfo endPtInfo = this.endPtMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPointInfo("BOOTSTRAP_ADDRESS");
        if (endPtInfo != null) {
            String bootstrapPort = new Integer(endPtInfo.getPort()).toString();
            String bootstrapHost = endPtInfo.getHost();
            StringBuffer sb = new StringBuffer("endpoint:");
            sb.append("name=").append("BOOTSTRAP_ADDRESS");
            sb.append(";host=").append(bootstrapHost);
            sb.append(";port=").append(bootstrapPort);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bootstrap endpoint:", sb);
            }
            accessPoints.addElement(sb.toString());
        }
        JMXConnector[] connectors = new JMXConnector[]{this.soapConnector, this.rmiConnector, this.jsr160rmiConnector, this.ipcConnectorServer};
        for (int i = 0; i < connectors.length; ++i) {
            int idx;
            String port;
            Properties p;
            JMXConnector connector2 = connectors[i];
            if (connectors[i] == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping connector at position " + i);
                continue;
            }
            StringBuffer name = new StringBuffer("connector:");
            name.append(connector2.getName());
            if (name.indexOf("type=IPC") >= 0 && AdminHelper.getPlatformHelper().isZOS() && !AdminHelper.getPlatformHelper().isServantJvm() && (p = LocalCommUtil.getMagicNames(this, port = name.substring((idx = name.indexOf("port=")) + "port".length() + 1))) != null) {
                name.append(";");
                name.append("zos.targetServer.serverShortName");
                name.append("=");
                name.append(p.getProperty("zos.targetServer.serverShortName"));
                name.append(";");
                name.append("zos.targetServer.genericServerName");
                name.append("=");
                name.append(p.getProperty("zos.targetServer.genericServerName"));
                name.append(";");
                name.append("zos.targetServer.daemonName");
                name.append("=");
                name.append(p.getProperty("zos.targetServer.daemonName"));
            }
            if (this.localAdminConnectorType != null && connector2.getType().equals(this.localAdminConnectorType)) {
                name.append(";localAdminProtocol=true");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the local Admin Procotol connector name: ", name);
                }
            }
            if (this.remoteAdminConnectorType != null && connector2.getType().equals(this.remoteAdminConnectorType)) {
                name.append(";remoteAdminProtocol=true");
                name.append(";preferred=true");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the remote Admin Procotol connector name: ", name);
                }
            }
            if (configuredSystemName != null) {
                name.append(";").append("was.ConfiguredSystemName").append("=").append(configuredSystemName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "was.ConfiguredSystemName=" + configuredSystemName);
                }
            }
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security enabled connector");
                }
                name.append(";").append("securityEnabled").append("=true");
            }
            name.append(";").append("isInternal").append("=true");
            accessPoints.addElement(name.toString());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "connector URI: " + name);
        }
        ServerInfo info = new ServerInfo(pid, this.cellName, this.nodeName, this.serverName, this.adminType, Utils.getProductVersion(), accessPoints);
        info.setHostName(AdminHelper.getInstance().getNodeHostName(this.nodeName));
        RoutingTable.getInstance().setOwnInfo(info);
        if (this.adminType.equals("DeploymentManager")) {
            this.doCellMgrDiscovery(info);
        } else if (this.adminType.equals("NodeAgent")) {
            this.doNodeAgentDiscovery(info);
        } else if (this.adminType.equals("ManagedProcess")) {
            this.doManagedProcessDiscovery(info);
        } else if (this.adminType.equals("UnManagedProcess")) {
            this.doStandAloneProcessDiscovery(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interprocessRegistration");
        }
    }

    private void doCellMgrDiscovery(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCellMgrDiscovery");
        }
        Map epMap = this.epCollector.getNodeAgents();
        String cellPort = new Integer(this.epCollector.getCellDiscoveryEndPoint().getPort()).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initialize the CellManager discovery service");
        }
        CMDiscoveryAdapter da = new CMDiscoveryAdapter(info, cellPort, this.cellDiscoveryProtocol);
        try {
            da.initialize(this.threadPoolMgr);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doCellMgrDiscovery", (String)"455", (Object)this);
            Tr.error(tc, "ADMC0029E", ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doCellMgrDiscovery - failed");
            }
            return;
        }
        HashMap nodeProtocols = this.loadNodeProtocols();
        for (String ndName : epMap.keySet()) {
            EndPointMgr.EndPointInfo ep = (EndPointMgr.EndPointInfo)epMap.get(ndName);
            String nodeHost = ep.getHost();
            String nodePort = new Integer(ep.getPort()).toString();
            ServerInfo nodeInfo = new ServerInfo(this.cellName, ndName, "NodeAgent");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The deployment manager is looking for the node agent: ", new Object[]{ndName, nodeHost, nodePort, nodeInfo});
            }
            Integer prot = (Integer)nodeProtocols.get(ndName);
            int ndDiscoveryProtocol = 1;
            if (prot != null) {
                ndDiscoveryProtocol = prot;
            }
            da.discovery(nodeHost, nodePort, ndDiscoveryProtocol, nodeInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCellMgrDiscovery");
        }
    }

    private void doNodeAgentDiscovery(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doNodeAgentDiscovery");
        }
        String nodePort = new Integer(this.epCollector.getNodeDiscoveryEndPoint().getPort()).toString();
        NADiscoveryAdapter da = new NADiscoveryAdapter(info, nodePort, this.nodeDiscoveryProtocol);
        try {
            da.initialize(this.threadPoolMgr);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doNodeAgentDiscovery", (String)"501", (Object)this);
            Tr.error(tc, "ADMC0030E", ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doNodeAgentDiscovery - failed");
            }
            return;
        }
        Map epMap = this.epCollector.getDmgrs();
        for (String cellNodeName : epMap.keySet()) {
            EndPointMgr.EndPointInfo ep = (EndPointMgr.EndPointInfo)epMap.get(cellNodeName);
            String cellHost = ep.getHost();
            String cellPort = new Integer(ep.getPort()).toString();
            ServerInfo cellInfo = new ServerInfo(this.cellName, cellNodeName, "DeploymentManager");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The node agent is looking for the cell manager: ", new Object[]{cellNodeName, cellHost, cellPort, cellInfo});
            }
            da.discovery(cellHost, cellPort, this.cellDiscoveryProtocol, cellInfo);
        }
        EndPointMgr.EndPointInfo multicast = this.getServerMulticastDiscoveryEndPoint();
        EndPointMgr.EndPointInfo ipv6_multicast = this.getServerIPv6MulticastDiscoveryEndPoint();
        ServerInfo serverInfo = new ServerInfo(this.cellName, this.nodeName, "ManagedProcess");
        String serverHost = null;
        String serverPort = null;
        MulticastVerifier verifier = null;
        if (multicast != null) {
            serverHost = multicast.getHost();
            serverPort = new Integer(multicast.getPort()).toString();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "looking for the managed process (multicast based):", new Object[]{serverHost, serverPort, serverInfo});
            }
            verifier = new MulticastVerifier(serverHost, serverPort, 30000);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                verifier.setDaemon(true);
            }
            verifier.start();
            verifier.waitForListening();
            da.discovery(serverHost, serverPort, 2, serverInfo);
            try {
                verifier.join();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((multicast == null || verifier.failed) && ipv6_multicast != null) {
            serverHost = ipv6_multicast.getHost();
            serverPort = new Integer(ipv6_multicast.getPort()).toString();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "looking for the managed process (ipv6_multicast based):", new Object[]{serverHost, serverPort, serverInfo});
            }
            verifier = new MulticastVerifier(serverHost, serverPort, 30000);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                verifier.setDaemon(true);
            }
            verifier.start();
            verifier.waitForListening();
            da.discovery(serverHost, serverPort, 2, serverInfo);
            try {
                verifier.join();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (multicast == null && ipv6_multicast == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for app servers, non-multicast based");
            }
            HashMap serverDiscoveryEndPoints = this.epCollector.getServerDiscoveryEndPoints();
            for (String name : serverDiscoveryEndPoints.keySet()) {
                EndPointMgr.EndPointInfo endPt = (EndPointMgr.EndPointInfo)serverDiscoveryEndPoints.get(name);
                serverHost = endPt.getHost();
                serverPort = new Integer(endPt.getPort()).toString();
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "looking for server: ", new Object[]{name, serverHost, serverPort});
                }
                da.discovery(serverHost, serverPort, this.nodeDiscoveryProtocol, serverInfo);
            }
        } else if (verifier.failed) {
            Tr.warning(tc, "ADMC0051W");
            verifier.rediscover();
        }
        if (this.epCollector != null) {
            this.epCollector.discard();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doNodeAgentDiscovery");
        }
    }

    private void doManagedProcessDiscovery(ServerInfo info) throws Exception {
        boolean init_succeeded;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doManagedProcessDiscovery");
        }
        MulticastServer.setupNodeAgentConnector(this.configRoot, this.cellName, this.nodeName, Utils.getNodeAgentName());
        EndPointMgr.EndPointInfo serverMulticastEndpoint = this.getServerMulticastDiscoveryEndPoint();
        EndPointMgr.EndPointInfo ipv6_serverMulticastEndpoint = this.getServerIPv6MulticastDiscoveryEndPoint();
        ServerInfo nodeInfo = new ServerInfo(this.cellName, this.nodeName, "NodeAgent");
        MPDiscoveryAdapter da = null;
        DiscoveryAdapter good_da = null;
        String serverMulticastAddress = null;
        String serverMulticastPort = null;
        if (serverMulticastEndpoint != null) {
            serverMulticastAddress = serverMulticastEndpoint.getHost();
            serverMulticastPort = new Integer(serverMulticastEndpoint.getPort()).toString();
            da = new MPDiscoveryAdapter(info, serverMulticastPort, 2, serverMulticastAddress);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialize the managed process discovery service: multicast");
                }
                if (init_succeeded = da.initialize(this.threadPoolMgr)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IPv4 multicast initialization appeared OK");
                    }
                    good_da = da;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"565", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - failed");
                }
                return;
            }
        }
        if (ipv6_serverMulticastEndpoint != null) {
            serverMulticastAddress = ipv6_serverMulticastEndpoint.getHost();
            serverMulticastPort = new Integer(ipv6_serverMulticastEndpoint.getPort()).toString();
            da = new MPDiscoveryAdapter(info, serverMulticastPort, 2, serverMulticastAddress);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialize the managed process discovery service: IPv6 multicast");
                }
                if (init_succeeded = da.initialize(this.threadPoolMgr)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IPv6 multicast initialization appeared OK");
                    }
                    good_da = da;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"565", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - IPv6 multicast failed");
                }
                return;
            }
        }
        if (serverMulticastEndpoint == null && ipv6_serverMulticastEndpoint == null) {
            EndPointMgr.EndPointInfo endPt = this.getServerDiscoveryEndPoint();
            if (endPt == null) {
                NullPointerException ex = new NullPointerException("getServerDiscoveryEndPoint returned null value");
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"714", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - failed");
                }
                throw ex;
            }
            da = new MPDiscoveryAdapter(info, new Integer(endPt.getPort()).toString(), this.nodeDiscoveryProtocol);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialize the managed process discovery service: non-multicast");
                }
                if (init_succeeded = da.initialize(this.threadPoolMgr)) {
                    good_da = da;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"714", (Object)this);
                Tr.error(tc, "ADMC0031E", ex);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - failed");
                }
                return;
            }
        }
        EndPointMgr.EndPointInfo nodeDiscoveryEndPoint = this.getNodeDiscoveryEndPoint();
        String nodeHost = nodeDiscoveryEndPoint.getHost();
        String nodePort = new Integer(nodeDiscoveryEndPoint.getPort()).toString();
        if (good_da != null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The managed process is looking for its node agent:", new Object[]{this.nodeName, nodeHost, nodePort, nodeInfo});
            }
            good_da.discovery(nodeHost, nodePort, this.nodeDiscoveryProtocol, nodeInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doManagedProcessDiscovery");
        }
    }

    private void doStandAloneProcessDiscovery(ServerInfo info) throws Exception {
        ConfigService localConfigService;
        List list;
        ConfigObject cellObject;
        boolean cellRegistered;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doStandAloneProcessDiscovery");
        }
        if (!(cellRegistered = (cellObject = (ConfigObject)(list = (localConfigService = (ConfigService)WsServiceRegistry.getService((Object)this, ConfigService.class)).getDocumentObjects(localConfigService.getScope(0), "cell.xml")).get(0)).getBoolean("cellRegistered", false))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doStandAloneProcessDiscovery: cell not registered");
            }
            return;
        }
        try {
            List adminAgentRegistrations;
            String profileKey = JMXConnectors.getProfileKey();
            String defaultHostName = AdminHelper.getInstance().getHostName();
            if (defaultHostName == null || defaultHostName.length() <= 0) {
                defaultHostName = "localhost";
            }
            if ((adminAgentRegistrations = cellObject.getObjectList("adminAgentRegistration")) == null || adminAgentRegistrations.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doStandaloneDiscovery: no adminAgentRegistration");
                }
                return;
            }
            ConfigObject adminAgentRegistration = (ConfigObject)adminAgentRegistrations.get(0);
            String cellName = adminAgentRegistration.getString("cellName", null);
            String nodeName = adminAgentRegistration.getString("nodeName", null);
            String serverName = adminAgentRegistration.getString("serverName", null);
            String configRoot = adminAgentRegistration.getString("profileRoot", null);
            String managedNodeName = adminAgentRegistration.getString("managedNodeName", null);
            if (configRoot != null) {
                configRoot = configRoot + File.separator + "config";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "admin agent information: configRoot: " + configRoot + ", cellName: " + cellName + ", nodeName: " + nodeName + ", serverName: " + serverName + ", managedNodeName: " + managedNodeName);
            }
            if (configRoot == null || cellName == null || nodeName == null || serverName == null) {
                Exception t = new Exception("Insufficient information to locate admin agent: configRoot: " + configRoot + ", cellName: " + cellName + ", nodeName: " + nodeName + ", serverName: " + serverName + ", managedNodeName: " + managedNodeName);
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.component.JMXConnectors.doStandAloneDiscovery", (String)"2492", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doStandAloneDiscovery constructor: no admin agent information");
                }
                return;
            }
            MBeanDiscoveryHelper helper = new MBeanDiscoveryHelper(configRoot, cellName, nodeName, serverName, profileKey, defaultHostName, managedNodeName);
            MBeanDiscoveryService discService = new MBeanDiscoveryService(helper);
            discService.startDiscovery();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Standalone discovery started ");
            }
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.doStandAloneDiscovery", (String)"2582", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doStandAloneProcessDiscovery");
        }
    }

    private HashMap loadNodeProtocols() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNodeProtocols");
        }
        HashMap<String, Integer> maps = new HashMap<String, Integer>();
        ConfigScope scope = this.configService.createScope(3);
        String[] nodes = scope.list(null);
        String oldNode = scope.get(3);
        for (int i = 0; i < nodes.length; ++i) {
            try {
                scope.set(3, nodes[i]);
                List l = this.configService.getDocumentObjects(scope, "node.xml");
                ConfigObject node = (ConfigObject)l.get(0);
                Integer prot = new Integer(0);
                if (node.isSet("discoveryProtocol")) {
                    String protocol = node.getString("discoveryProtocol", "TCP");
                    if (protocol.equals("UDP")) {
                        prot = new Integer(0);
                    }
                    if (protocol.equals("TCP")) {
                        prot = new Integer(1);
                    }
                    if (protocol.equals("MULTICAST")) {
                        prot = new Integer(2);
                    }
                } else {
                    prot = new Integer(1);
                }
                if (prot == null) continue;
                maps.put(node.getString("name", "__null__"), prot);
                continue;
            }
            catch (Exception e) {
                Tr.service(tc, "ADMC0050E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNodeProtocols");
        }
        return maps;
    }

    private EndPointMgr.EndPointInfo getServerDiscoveryEndPoint() throws Exception {
        return this.endPtMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPointInfo("SERVER_DISCOVERY_ADDRESS");
    }

    private EndPointMgr.EndPointInfo getServerMulticastDiscoveryEndPoint() {
        EndPointMgr.EndPointInfo ep = null;
        EndPointMgr.NodeEndPoints nodeEps = this.endPtMgr.getNodeEndPoints("@");
        ep = nodeEps.getEndPointInfo("NODE_MULTICAST_DISCOVERY_ADDRESS");
        return ep;
    }

    private EndPointMgr.EndPointInfo getServerIPv6MulticastDiscoveryEndPoint() {
        EndPointMgr.EndPointInfo ep = null;
        EndPointMgr.NodeEndPoints nodeEps = this.endPtMgr.getNodeEndPoints("@");
        ep = nodeEps.getEndPointInfo("NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS");
        return ep;
    }

    private EndPointMgr.EndPointInfo getNodeDiscoveryEndPoint() throws Exception {
        EndPointMgr.EndPointInfo ep = null;
        EndPointMgr.NodeEndPoints nodeEps = this.endPtMgr.getNodeEndPoints("@");
        ep = nodeEps.getEndPointInfo("NODE_DISCOVERY_ADDRESS");
        return ep;
    }

    private ThreadPool getThreadPool(String name, int maxThreads, boolean growable) throws Exception {
        ThreadPool pool = null;
        pool = this.threadPoolMgr.getThreadPool(name, null);
        pool.setMinimumPoolSize(3);
        pool.setMaximumPoolSize(maxThreads);
        pool.setGrowAsNeeded(growable);
        return pool;
    }

    public void modeChanged(String type, String mode) {
        if (type.equals("discovery") && mode.equals("active")) {
            this.initDiscovery();
        }
    }

    public void propertyChange(PropertyChangeEvent event2) {
        String currentState;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertyChange");
        }
        if ((currentState = (String)event2.getNewValue()).equals("STARTED") && DmgrModeFactory.getDmgrModeManager().isActive("discovery")) {
            this.initDiscovery();
            Properties configProps = AdminInitializer.getInstance().getProperties();
            this.adminType = (String)configProps.get("adminTypeProperty");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminType: " + this.adminType);
            }
            if (!(!this.xcfMonitor_Enabled || this.adminType.equals("NodeAgent") || this.adminType.equals("DeploymentManager") || this.adminType.equals("JobManager") || this.adminType.equals("AdminAgent"))) {
                this.useXCFMonitor();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyChange");
        }
    }

    public void stateChanged(SecurityServiceEvent sse) {
        int sss;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if ((sss = sse.getState()) == 1) {
            Properties configProps = AdminInitializer.getInstance().getProperties();
            this.adminType = (String)configProps.get("adminTypeProperty");
            String serverType = AdminServiceFactory.getAdminService().getServerType();
            if (!(this.adminType.equals("NodeAgent") || this.adminType.equals("ManagedProcess") || serverType.equals("PROXY_SERVER") || serverType.equals("ONDEMAND_ROUTER") || this.isSecureProxy())) {
                this.startFileTransferService();
            }
            try {
                if (AdminHelper.getPlatformHelper().isZOS()) {
                    if (AdminHelper.getPlatformHelper().isServantJvm()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Servant process - exiting initialize");
                        }
                        return;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "SecurityService Event was STARTED");
                    }
                    if (serverType.equals("PROXY_SERVER") || serverType.equals("ONDEMAND_ROUTER")) {
                        MBeanFactoryImpl mfactoryImpl = (MBeanFactoryImpl)AdminServiceFactory.getMBeanFactory();
                        mfactoryImpl.completeApplySecurityPolicy();
                    }
                    boolean startConnectors = true;
                    if (!AdminServiceImpl.getPlatformUtils().runningWhereConfigured()) {
                        startConnectors = false;
                    }
                    if (startConnectors) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SOAP Connector Enabled " + this.soapConnectorEnabled);
                            Tr.debug(tc, "HTTP Connector Enabled " + this.httpConnectorEnabled);
                            Tr.debug(tc, "RMI Connector Enabled " + this.rmiConnectorEnabled);
                            Tr.debug(tc, "JSR160RMI Connector Enabled " + this.jsr160rmiConnectorEnabled);
                            Tr.debug(tc, "IPC Connector Enabled " + this.ipcConnectorEnabled);
                        }
                        if (this.soapConnectorEnabled) {
                            this.startSOAPConnector();
                        }
                        if (this.httpConnectorEnabled) {
                            this.startHTTPConnector();
                        }
                        if (this.rmiConnectorEnabled) {
                            this.startRMIConnector();
                        }
                        if (this.jsr160rmiConnectorEnabled) {
                            this.startJSR160RMIConnector();
                        }
                        if (this.ipcConnectorEnabled) {
                            this.startIPCConnector();
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SOAP Connector Enabled " + this.soapConnectorEnabled);
                        Tr.debug(tc, "HTTP Connector Enabled " + this.httpConnectorEnabled);
                        Tr.debug(tc, "IPC Connector Enabled " + this.ipcConnectorEnabled);
                    }
                    if (this.soapConnectorEnabled) {
                        this.startSOAPConnector();
                    }
                    if (this.httpConnectorEnabled) {
                        this.startHTTPConnector();
                    }
                    if (this.ipcConnectorEnabled) {
                        this.startIPCConnector();
                    }
                }
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connector start error", ex);
                }
                throw new WsRuntimeException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    public boolean started() {
        try {
            if (this.rmiConnectorEnabled) {
                this.startRMIConnector();
            }
            if (this.jsr160Enabled && this.jsr160rmiConnectorEnabled) {
                this.startJSR160RMIConnector();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    public boolean quiesce() {
        try {
            if (this.rmiConnectorEnabled) {
                this.rmiConnector.stop();
            }
            if (this.jsr160Enabled && this.jsr160rmiConnectorEnabled && !this.connectorStopped) {
                this.jsr160rmiConnector.stop();
                this.connectorStopped = true;
            }
        }
        catch (Exception ex) {
            StackTraceElement[] ste = ex.getStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stack trace in JMXConnectors.quiesce()", ste);
            }
            throw new RuntimeException(ex);
        }
        return true;
    }

    public boolean starting() {
        return true;
    }

    public boolean quiesceComplete() {
        return true;
    }

    public String getTypeName() {
        return "RMIConnector";
    }

    public int getType() {
        return 16;
    }

    public String getName() {
        return "";
    }

    private boolean isSecureProxy() {
        String METHOD = "isSecureProxy";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecureProxy");
        }
        boolean ret = false;
        try {
            ManagedObjectMetadataAccessor accessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            String baseProductShortName = accessor.getMetadataProperty(this.nodeName, "com.ibm.websphere.baseProductShortName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "baseProductShortName = " + baseProductShortName + " (nodeName = " + this.nodeName + ")");
            }
            if (baseProductShortName != null && baseProductShortName.equals("NDDMZ")) {
                ret = true;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.JMXConnectors.isSecureProxy", (String)"2249", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecureProxy", ret);
        }
        return ret;
    }

    private void startFileTransferService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startFileTransferService");
        }
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant process exit - startFileTransferService ");
            }
            return;
        }
        FileTransferConfig ftsConfig = this.getFileTransferConfig();
        try {
            FileTransferFactory.initialize((FileTransferConfig)ftsConfig);
        }
        catch (Throwable e) {
            String error = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0102");
            Tr.error(tc, error, e);
        }
        ConfigRepository rep = ConfigRepositoryFactory.getConfigRepository();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config repository is", rep);
        }
        if (rep instanceof FileRepository) {
            ((FileRepository)rep).setFileTransferConfig(ftsConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startFileTransferService");
        }
    }

    private FileTransferConfig getFileTransferConfig() {
        FileTransferConfig config;
        String serverName;
        String securePort;
        String port;
        String hostName;
        block41: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFileTransferConfig");
            }
            hostName = null;
            port = null;
            securePort = null;
            serverName = null;
            config = null;
            String endpointName = null;
            try {
                Class<?> ftConfigClass = Class.forName("com.ibm.ws.management.filetransfer.FileTransferConfigImpl");
                config = (FileTransferConfig)ftConfigClass.newInstance();
                boolean secEnabled = SecurityHelper.getHelper().isSecurityEnabled();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security enabled = " + secEnabled);
                }
                config.setSecurityEnabled(secEnabled);
                VariableMap variableMap = (VariableMap)this.getService(VariableMap.class);
                config.setVariableMap((Object)variableMap);
                serverName = AdminServiceFactory.getAdminService().getProcessName();
                String ftepName = this.getServerEndPointName("WCInboundFileTransfer");
                if (ftepName != null) {
                    port = this.getServerPortFromEndpoint(serverName, ftepName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCInboundFileTransfer! Port = " + port);
                    }
                } else {
                    endpointName = this.getServerEndPointName("WCInboundAdmin");
                    if (endpointName != null) {
                        port = this.getServerPortFromEndpoint(serverName, endpointName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WCInboundAdmin! Port = " + port);
                        }
                    }
                }
                if ((ftepName = this.getServerEndPointName("WCInboundFileTransferSecure")) != null) {
                    securePort = this.getServerPortFromEndpoint(serverName, ftepName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCInboundFileTransferSecure! Port = " + port);
                    }
                } else {
                    endpointName = this.getServerEndPointName("WCInboundAdminSecure");
                    if (endpointName != null) {
                        securePort = this.getServerPortFromEndpoint(serverName, endpointName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WCinBoundAdminSecure! Port = " + port);
                        }
                    }
                }
                if (port == null || securePort == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Get the ports the old way!");
                    }
                    boolean done1 = false;
                    boolean done2 = false;
                    ConfigService configService = (ConfigService)this.getService(ConfigService.class);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ConfigService", configService);
                    }
                    ConfigScope scope = configService.getScope(4);
                    List resource = configService.getDocumentObjects(scope, "server.xml");
                    ConfigObject server = (ConfigObject)resource.get(0);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server ConfigObject", server);
                    }
                    List componentList = server.getObjectList("components");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Components List", componentList);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Number of components = " + componentList.size());
                    }
                    block4: for (int i = 0; i < componentList.size(); ++i) {
                        ConfigObject comp = (ConfigObject)componentList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server Component", comp);
                        }
                        if (!comp.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
                        ConfigObject as = comp;
                        List subCompList = as.getObjectList("components");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Number of Subcomponents = " + subCompList.size());
                        }
                        for (int j = 0; j < subCompList.size(); ++j) {
                            ConfigObject subComp = (ConfigObject)subCompList.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Number of Subcomponents = " + subCompList.size());
                            }
                            if (!subComp.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi", "WebContainer")) continue;
                            List transportList = subComp.getObjectList("transports");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Number of transports = " + transportList.size());
                            }
                            for (int k = 0; k < transportList.size(); ++k) {
                                ConfigObject transport = (ConfigObject)transportList.get(k);
                                ConfigObject endPoint = transport.getObject("address");
                                boolean sslEnabled = endPoint.getBoolean("sslEnabled", false);
                                if (sslEnabled) {
                                    if (securePort != null) continue;
                                    securePort = new Integer(endPoint.getInt("port", -1)).toString();
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "securePort = " + securePort);
                                    continue;
                                }
                                if (port != null) continue;
                                port = new Integer(endPoint.getInt("port", -1)).toString();
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "port = " + port);
                            }
                            if (securePort != null && port != null) continue block4;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.getFileTransferConfig", (String)"258", (Object)this);
                if (!tc.isDebugEnabled()) break block41;
                Tr.debug(tc, "Error occurred initializing config: " + e.getMessage());
            }
        }
        boolean onlySecurePortAvailable = false;
        if (port == null) {
            port = FileTransferConfigImpl.DEFAULT_PORT_STRING_VALUE;
            String serverType = AdminServiceFactory.getAdminService().getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType = " + serverType);
            }
            String error = null;
            error = "DEPLOYMENT_MANAGER".equals(serverType) ? FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0114") : FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0136");
            String message = MessageFormat.format(error, port);
            Tr.warning(tc, message);
            if (securePort != null) {
                onlySecurePortAvailable = true;
            }
        }
        if (hostName == null || hostName.equals("127.0.0.1")) {
            try {
                hostName = AdminHelper.getInstance().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (hostName == null) {
            hostName = "localhost";
            String error = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0132");
            Tr.warning(tc, error);
        } else if (hostName.equals("127.0.0.1")) {
            String error = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0131");
            Tr.warning(tc, error);
        }
        config.getProperties().put("host", hostName);
        config.getProperties().put("port", port);
        config.getProperties().put("server_name", serverName);
        if (securePort != null) {
            config.getProperties().put("secure_port", securePort);
            if (onlySecurePortAvailable) {
                config.setSecurityEnabled(true);
            }
        }
        String repositoryRoot = null;
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Properties repositoryProps = configRepository.getConfig();
        repositoryRoot = repositoryProps.getProperty("was.repository.temp");
        config.setStagingLocation(repositoryRoot);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Configuration: " + config.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileTransferConfig", config);
        }
        return config;
    }

    private String getServerEndPointName(String inChainName) {
        String endpointName;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerEndPointName", inChainName);
            }
            endpointName = null;
            try {
                ConfigService configService = (ConfigService)this.getService(ConfigService.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigService", configService);
                }
                ConfigScope scope = configService.getScope(4);
                List resource = configService.getDocumentObjects(scope, "server.xml");
                ConfigObject server = (ConfigObject)resource.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server ConfigObject", server);
                }
                List services = server.getObjectList("services");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Services", services);
                }
                for (int i = 0; i < services.size(); ++i) {
                    ConfigObject s = (ConfigObject)services.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Service", s);
                    }
                    if (s.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.xmi", "TransportChannelService")) {
                        ConfigObject tps = s;
                        List chains = tps.getObjectList("chains");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TransportChannelService chains", chains);
                        }
                        for (int c = 0; c < chains.size(); ++c) {
                            ConfigObject chain = (ConfigObject)chains.get(c);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Chain", chain);
                            }
                            List transports = chain.getObjectList("transportChannels");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "transportChannels", transports);
                            }
                            if (transports == null || transports.size() == 0) break;
                            String chainName = chain.getString("name", null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Chain Name", chainName);
                            }
                            if (chainName != null && chainName.equalsIgnoreCase(inChainName)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Searching for ports for", inChainName);
                                }
                                for (int t = 0; t < transports.size(); ++t) {
                                    ConfigObject tranc = (ConfigObject)transports.get(t);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Transport Channel", tranc);
                                    }
                                    if (!tranc.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel")) continue;
                                    endpointName = tranc.getString("endPointName", null);
                                    if (!tc.isDebugEnabled()) break;
                                    Tr.debug(tc, "Chain EndPoint Name:" + endpointName);
                                    break;
                                }
                            }
                            if (endpointName != null) break;
                        }
                    }
                    if (endpointName == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.getServerEndPointName", (String)"377", (Object)this);
                if (!tc.isDebugEnabled()) break block20;
                Tr.debug(tc, "Error occurred initializing config: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerEndPointName", endpointName);
        }
        return endpointName;
    }

    private String getServerPortFromEndpoint(String serverName, String endpointName) {
        String port;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerPortFromEndpoint", new Object[]{serverName, endpointName});
            }
            port = null;
            try {
                if (endpointName == null) break block9;
                ConfigObject serverEntry = this.getServerEntry(serverName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerEntry", serverEntry);
                }
                List eps = serverEntry.getObjectList("specialEndpoints");
                for (int e = 0; e < eps.size(); ++e) {
                    ConfigObject nep = (ConfigObject)eps.get(e);
                    String epName = nep.getString("endPointName", null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EndPointName", epName);
                    }
                    if (epName == null || !epName.equals(endpointName)) continue;
                    ConfigObject ep = nep.getObject("endPoint");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EndPoint", ep);
                    }
                    int iPort = ep.getInt("port", 0);
                    port = new String("" + iPort);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EndPoint Port", port);
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.getServerPortFromEndpoint", (String)"433", (Object)this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Error occurred initializing config: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerPortFromEndpoint", port);
        }
        return port;
    }

    private ConfigObject getServerEntry(String serverName) throws Exception {
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        ConfigScope scope = configService.createScope(0);
        scope = configService.createScope(3);
        List resource = configService.getDocumentObjects(scope, "serverindex.xml");
        ConfigObject serverEntryCO = null;
        List serverEntryList = ((ConfigObject)resource.get(0)).getObjectList("serverEntries");
        for (int i = 0; i < serverEntryList.size(); ++i) {
            ConfigObject serverEntry = (ConfigObject)serverEntryList.get(i);
            String name = serverEntry.getString("serverName", null);
            if (!serverName.equals(name)) continue;
            serverEntryCO = serverEntry;
            break;
        }
        return serverEntryCO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProfileKey() throws IOException {
        String profileKey;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getProfileKey");
            }
            String profilePath = System.getProperty("user.install.root");
            String propFileName = profilePath + File.separator + "properties" + File.separator + "profileKey.metadata";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "path for profile metadata is:" + propFileName);
            }
            File propFile = new File(propFileName);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                Properties props = new Properties();
                props.load(fis);
                profileKey = props.getProperty("com.ibm.ws.profile.key");
                Object var7_6 = null;
                if (fis == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProfileKey:" + profileKey);
        }
        return profileKey;
    }

    private void useXCFMonitor() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "useXCFMonitor");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "myXCFMemberName: " + this.myXCFMemberName + " myXCFGroup: " + this.myXCFGroup + " myXCFcheckInterval: " + this.myXCFcheckInterval);
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("LP_THIS_MEMBER_NAME", this.myXCFMemberName);
            config.put("LP_GROUP_NAME", this.myXCFGroup);
            config.put("LP_CHECK_INTERVAL_SECS", this.myXCFcheckInterval);
            try {
                GenLivenessPluginFactory factory = (GenLivenessPluginFactory)Class.forName("com.ibm.ws.xcf.groupservices.GenLivenessPluginZoSFactory").newInstance();
                this.lp = factory.createInstance(config);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.component.JMXConnectors.useXCFMonitor", (String)"2606", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Got Exception trying to createInstance of Generic Liveness Plugin:", t);
            }
        }
        XCFJoinEventListener jel = new XCFJoinEventListener();
        this.lp.addJoinEventListener((GenJoinEventListener)jel);
        XCFLeaveEventListener lel = new XCFLeaveEventListener();
        this.lp.addLeaveEventListener((GenLeaveEventListener)lel);
        this.lp.start();
        long timeout = (this.myXCFcheckInterval.longValue() - 10L) * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial check alarm with timeout(millisecs): " + timeout);
        }
        this.checkAlarm = AlarmManager.createNonDeferrable((long)timeout, (AlarmListener)this, (Object)CHECK_ALARM_CONTEXT);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "useXCFMonitor");
        }
    }

    public void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm - XCF check");
        }
        if (CHECK_ALARM_CONTEXT.equals(alarmContext)) {
            this.lp.check();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New check alarm with timeout(secs): " + this.myXCFcheckInterval.longValue());
            }
            AlarmManager.createNonDeferrable((long)(this.myXCFcheckInterval.longValue() * 1000L), (AlarmListener)this, (Object)CHECK_ALARM_CONTEXT);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm - XCF check");
        }
    }

    private class XCFLeaveEventListener
    implements GenLeaveEventListener {
        private XCFLeaveEventListener() {
        }

        public synchronized void memberLeft(String memberName, long context, String reason, long rc) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberLeft called for: " + memberName);
                Tr.debug(tc, "context:" + context + ",Reason:" + reason + ",Return code:" + rc + ",lastXCFContext:" + JMXConnectors.this.lastXCFContext);
            }
            if (context <= JMXConnectors.this.lastXCFContext) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "memberLeft");
                }
                return;
            }
            JMXConnectors.this.lastXCFContext = context;
            RoutingTable rt = RoutingTable.getInstance();
            int x = memberName.indexOf("nodeagent");
            int y = memberName.indexOf("adminagent");
            if (x != -1 || y != -1) {
                if (x != -1) {
                    if (memberName.substring(1, x).equals(JMXConnectors.this.myXCFHostCellNode) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nodeagent has left the XCF group.");
                    }
                } else if (y != -1 && memberName.substring(1, y).equals(JMXConnectors.this.myXCFHostCellNode) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "AdminAgent has left the XCF group.");
                }
                rt.removeParent();
            }
            rt.removeXCFGroupMember(memberName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XCF group members: " + rt.getXCFGroupMembers());
            }
        }
    }

    private class XCFJoinEventListener
    implements GenJoinEventListener {
        private XCFJoinEventListener() {
        }

        public synchronized void memberJoined(String memberName, long context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberJoined called for: " + memberName + "with context:" + context + ",lastXCFContext:" + JMXConnectors.this.lastXCFContext);
            }
            if (context > JMXConnectors.this.lastXCFContext) {
                JMXConnectors.this.lastXCFContext = context;
            }
        }
    }

    private class MulticastVerifier
    extends Thread {
        MulticastSocket serverSocket;
        boolean failed;
        boolean listening;
        boolean ignore;
        int timeout;

        MulticastVerifier(String address, String port, int to) {
            super("MulticastVerifier");
            this.failed = false;
            this.listening = false;
            this.ignore = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MulticastVerifier", new Object[]{address, port, new Integer(this.timeout)});
            }
            int p = Integer.parseInt(port);
            this.timeout = to;
            try {
                this.serverSocket = new MulticastSocket(p);
                this.serverSocket.joinGroup(InetAddress.getByName(address));
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.MulticastVerifier", (String)"959", (Object)this);
                this.failed = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MulticastVerifier");
            }
        }

        synchronized boolean isLisetening() {
            return this.listening;
        }

        void waitForListening() {
            int counter = 0;
            while (true) {
                ++counter;
                if (this.isLisetening()) {
                    return;
                }
                if (counter > 10) {
                    this.ignore = true;
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block12: {
                block13: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "MulticastVerifier.run");
                    }
                    if (this.serverSocket == null) break block13;
                    byte[] buffer = new byte[16384];
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                    this.serverSocket.setSoTimeout(this.timeout);
                    this.listening = true;
                    this.serverSocket.receive(dp);
                    Object var4_5 = null;
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception ex2) {}
                    break block12;
                    {
                        catch (InterruptedIOException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.MulticastVerifier.run", (String)"979", (Object)this);
                            this.failed = true;
                            Object var4_6 = null;
                            try {
                                this.serverSocket.close();
                            }
                            catch (Exception ex2) {}
                            break block12;
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.JMXConnectors.MulticastVerifier.run", (String)"987", (Object)this);
                            Object var4_7 = null;
                            try {
                                this.serverSocket.close();
                            }
                            catch (Exception ex2) {}
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        try {
                            this.serverSocket.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                this.failed = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MulticastVerifier.run");
            }
        }

        void rediscover() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "rediscover");
            }
            HashMap eps = JMXConnectors.this.epCollector.getServerConnectorEndPoints();
            AdminClient client = null;
            ObjectName query = null;
            boolean secEnabled = SecurityHelper.getHelper().isSecurityEnabled();
            String secString = secEnabled ? "true" : "false";
            try {
                query = new ObjectName("*:*,type=Discovery");
            }
            catch (MalformedObjectNameException ex) {
                // empty catch block
            }
            Subject subject = SecurityHelper.getServerSubject();
            if (subject != null) {
                SecurityHelper.pushInvocationSubject(subject);
            }
            for (String name : eps.keySet()) {
                boolean warning;
                block16: {
                    EndPointMgr.EndPointInfo endPt = (EndPointMgr.EndPointInfo)eps.get(name);
                    String hostname = endPt.getHost();
                    String port = new Integer(endPt.getPort()).toString();
                    warning = false;
                    Properties props = new Properties();
                    String type = Forwarder.getServerConnectorType(name);
                    if (hostname != null && hostname.length() > 0) {
                        props.setProperty("host", hostname);
                    } else {
                        props.setProperty("host", "localhost");
                    }
                    props.setProperty("port", port);
                    props.setProperty("type", type);
                    props.setProperty("securityEnabled", secString);
                    props.setProperty("isInternal", "true");
                    try {
                        client = AdminClientFactory.createAdminClient(props);
                    }
                    catch (ConnectorException ex) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "unable to create client to remote process", new Object[]{props, ex});
                    }
                }
                if (client != null) {
                    try {
                        Set s = client.queryNames(query, null);
                        if (s.iterator().hasNext()) {
                            ObjectName discoveryMBean = (ObjectName)s.iterator().next();
                            client.invoke(discoveryMBean, "query", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{ServerInfo.class.getName()});
                        } else {
                            warning = true;
                        }
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "failed to send out discover message", ex);
                        }
                        warning = true;
                    }
                }
                if (!warning) continue;
                Tr.warning(tc, "ADMC0052W", name);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rediscover");
            }
        }
    }

    private class EndPtCollector {
        Map dmgrs;
        Map nodeAgents;
        EndPointMgr.EndPointInfo cellDiscoveryEndPoint;
        EndPointMgr.EndPointInfo nodeDiscoveryEndPoint;
        EndPointMgr.EndPointInfo serverDiscoveryEndPoint;
        HashMap serverDiscoveryEndPoints;
        HashMap serverConnectorEndPoints;

        EndPtCollector(EndPointMgr epMgr) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "EndPtCollector");
            }
            this.dmgrs = new HashMap();
            this.nodeAgents = new HashMap();
            this.serverDiscoveryEndPoints = new HashMap();
            this.serverConnectorEndPoints = new HashMap();
            Map allNodeEndPts = epMgr.getNodeEndPoints();
            for (String nextNodeName : allNodeEndPts.keySet()) {
                if (nextNodeName.equals("@")) continue;
                EndPointMgr.NodeEndPoints nodeEndPts = (EndPointMgr.NodeEndPoints)allNodeEndPts.get(nextNodeName);
                Map allServerEndPts = nodeEndPts.getServerEndPoints();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing node: ", nextNodeName);
                }
                for (String nextServerName : allServerEndPts.keySet()) {
                    if (nextServerName.equals("@")) continue;
                    EndPointMgr.EndPoints serverEndPts = (EndPointMgr.EndPoints)allServerEndPts.get(nextServerName);
                    Map endPts = serverEndPts.getEndPointInfo();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing server: ", nextServerName);
                    }
                    for (String endPtName : endPts.keySet()) {
                        String type;
                        EndPointMgr.EndPointInfo endPt = (EndPointMgr.EndPointInfo)endPts.get(endPtName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing endPoint: ", endPtName);
                        }
                        if (endPtName.equals("NODE_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "node agent discovery endpoint found for node: " + nextNodeName);
                            }
                            this.nodeAgents.put(nextNodeName, endPt);
                            if (!nextNodeName.equals(JMXConnectors.this.nodeName)) continue;
                            this.nodeDiscoveryEndPoint = endPt;
                            continue;
                        }
                        if (endPtName.equals("NODE_MULTICAST_DISCOVERY_ADDRESS")) {
                            if (!nextNodeName.equals(JMXConnectors.this.nodeName)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "server discovery endpoint found for server: " + nextServerName);
                            }
                            this.serverDiscoveryEndPoint = endPt;
                            continue;
                        }
                        if (endPtName.equals("CELL_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cellmgr node name: " + nextNodeName);
                            }
                            if (JMXConnectors.this.cellDiscoveryProtocol == 2) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "tcp ip protocol type is not multicast");
                            }
                            this.dmgrs.put(nextNodeName, endPt);
                            if (!nextNodeName.equals(JMXConnectors.this.nodeName)) continue;
                            this.cellDiscoveryEndPoint = endPt;
                            continue;
                        }
                        if (endPtName.equals("CELL_MULTICAST_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cellmgr node name: " + nextNodeName);
                            }
                            if (JMXConnectors.this.cellDiscoveryProtocol != 2) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "tcp ip protocol type is multicast");
                            }
                            this.dmgrs.put(nextNodeName, endPt);
                            if (!nextNodeName.equals(JMXConnectors.this.nodeName)) continue;
                            this.cellDiscoveryEndPoint = endPt;
                            continue;
                        }
                        if (endPtName.equals("SERVER_DISCOVERY_ADDRESS")) {
                            this.serverDiscoveryEndPoints.put(nextServerName, endPt);
                            continue;
                        }
                        if (endPtName.equals("SOAP_CONNECTOR_ADDRESS")) {
                            if (!nextNodeName.equals(JMXConnectors.this.nodeName) || nextServerName.equals(JMXConnectors.this.serverName) || !(type = Forwarder.getServerConnectorType(nextServerName)).equals("SOAP")) continue;
                            this.serverConnectorEndPoints.put(nextServerName, endPt);
                            continue;
                        }
                        if (!endPtName.equals("BOOTSTRAP_ADDRESS") || !nextNodeName.equals(JMXConnectors.this.nodeName) || nextServerName.equals(JMXConnectors.this.serverName) || !(type = Forwarder.getServerConnectorType(nextServerName)).equals("RMI")) continue;
                        this.serverConnectorEndPoints.put(nextServerName, endPt);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "EndPtCollector");
            }
        }

        EndPointMgr.EndPointInfo getCellDiscoveryEndPoint() {
            return this.cellDiscoveryEndPoint;
        }

        Map getDmgrs() {
            return this.dmgrs;
        }

        EndPointMgr.EndPointInfo getNodeDiscoveryEndPoint() {
            return this.nodeDiscoveryEndPoint;
        }

        Map getNodeAgents() {
            return this.nodeAgents;
        }

        EndPointMgr.EndPointInfo getServerMulticastDiscoveryEndPoint() {
            return this.serverDiscoveryEndPoint;
        }

        HashMap getServerDiscoveryEndPoints() {
            return this.serverDiscoveryEndPoints;
        }

        HashMap getServerConnectorEndPoints() {
            return this.serverConnectorEndPoints;
        }

        void discard() {
            this.nodeAgents.clear();
            this.serverDiscoveryEndPoints.clear();
            this.serverConnectorEndPoints.clear();
            this.cellDiscoveryEndPoint = null;
            this.nodeDiscoveryEndPoint = null;
            this.serverDiscoveryEndPoint = null;
        }
    }
}

