/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.management.commands.server.CreateApplicationServer;
import com.ibm.ws.management.commands.server.CreateApplicationServerTemplate;
import com.ibm.ws.management.commands.server.GetServerType;
import com.ibm.ws.management.commands.server.ListServers;
import com.ibm.ws.management.commands.server.ServerConfigHelper;
import com.ibm.ws.management.commands.server.ShowServerInfo;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.management.commands.server.CreateServerTemplate;
import com.ibm.wsspi.management.commands.server.DeleteServer;
import com.ibm.wsspi.management.commands.server.DeleteServerTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class ServerConfigCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ServerConfigCommands.class, "management", "com.ibm.ws.management.resources.configservice");

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        String cmdName = metadata2.getName();
        if (cmdName.equals("createApplicationServerTemplate")) {
            return new CreateApplicationServerTemplate((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("createApplicationServer")) {
            return new CreateApplicationServer((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("deleteServerTemplate")) {
            return new DeleteServerTemplate((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("deleteServer")) {
            return new DeleteServer((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getServerType")) {
            return new GetServerType((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listServers")) {
            return new ListServers((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("showServerInfo")) {
            return new ShowServerInfo((TaskCommandMetadata)metadata2);
        }
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        String cmdName = cmdData.getName();
        if (cmdName.equals("createApplicationServerTemplate")) {
            return new CreateServerTemplate(cmdData);
        }
        if (cmdName.equals("deleteServerTemplate")) {
            return new DeleteServerTemplate(cmdData);
        }
        if (cmdName.equals("createApplicationServer")) {
            return new CreateApplicationServer(cmdData);
        }
        if (cmdName.equals("deleteServer")) {
            return new DeleteServer(cmdData);
        }
        if (cmdName.equals("getServerType")) {
            return new GetServerType(cmdData);
        }
        if (cmdName.equals("listServers")) {
            return new ListServers(cmdData);
        }
        if (cmdName.equals("showServerInfo")) {
            return new ShowServerInfo(cmdData);
        }
        return super.loadCommand(cmdData);
    }

    public AttributeList showTemplateInfo(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showTemplateInfo", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName target = (ObjectName)cmd.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target: " + target);
        }
        Properties props = ConfigServiceHelper.getObjectLocation(target);
        String serverTypes = props.getProperty("servertype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerType: " + serverTypes);
        }
        String server = props.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        if (server.endsWith("|server.xml")) {
            server = server.substring(0, server.indexOf("|server.xml"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server: " + server);
            }
        }
        AttributeList attrList = new AttributeList();
        PropertySet set = null;
        if (serverTypes != null) {
            set = ServerConfigHelper.getMetadata(session, configService, serverTypes, server);
        } else {
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            String contextUri = ConfigServiceHelper.getConfigDataId(target).getContextUri();
            RepositoryContext context = ws.findContext(contextUri);
            set = TemplateConfigHelper.getPropertySetFromServerType(configService, session, context);
        }
        if (set == null) {
            throw new ConfigServiceException("No metadata associated with template: " + target);
        }
        EList list_props = set.getProperties();
        for (Property p : list_props) {
            attrList.add(new Attribute(p.getName(), p.getValue()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showTemplateInfo", attrList);
        }
        return attrList;
    }

    public List listServerTypes(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTypes", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        ArrayList<String> serverTypes = new ArrayList<String>();
        String nodeName = (String)cmd.getTargetObject();
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        try {
            Collection serverTypeContexts = ServerConfigHelper.getServertypesContexts(workspace);
            for (RepositoryContext serverTypeContext : serverTypeContexts) {
                if (serverTypeContext.getName().trim().equals("")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding ServerType: " + serverTypeContext.getName());
                }
                serverTypes.add(serverTypeContext.getName());
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTypes", new Object[]{serverTypes});
        }
        return serverTypes;
    }

    public List listServerTemplates(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTemplates", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        List templates = new ArrayList();
        String serverType = (String)cmd.getParameter("serverType");
        String templateName = (String)cmd.getParameter("name");
        String version = (String)cmd.getParameter("version");
        String[] queryExp = (String[])cmd.getParameter("queryExp");
        String nodeName = (String)cmd.getParameter("nodeName");
        if (templateName != null && templateName.trim().length() > 0 || version != null && version.length() > 0) {
            LinkedList<String> sList = new LinkedList<String>();
            for (int i = 0; queryExp != null && i < queryExp.length; ++i) {
                sList.add(queryExp[i]);
            }
            if (templateName != null && templateName.trim().length() > 0) {
                sList.add("name=" + templateName);
            }
            if (version != null && version.length() > 0 && version.startsWith("6.1")) {
                sList.add("com.ibm.websphere.baseProductMajorVersion=6.1");
            } else if (version != null && version.length() > 0) {
                if (version.indexOf(".") > 0) {
                    version = version.substring(0, version.indexOf("."));
                }
                sList.add("com.ibm.websphere.baseProductMajorVersion=" + version);
            }
            queryExp = sList.toArray(new String[0]);
        }
        templates = ServerConfigHelper.listServerTemplates(configService, session, serverType, queryExp, nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTemplates");
        }
        return templates;
    }

    public String createServerType(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerType", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        String serverType = (String)cmd.getParameter("serverType");
        String createTemplateCmd = (String)cmd.getParameter("createTemplateCommand");
        String createCommand = (String)cmd.getParameter("createCommand");
        String version = (String)cmd.getParameter("version");
        String defaultTemplateName = (String)cmd.getParameter("defaultTemplateName");
        String defaultzOSTemplateName = (String)cmd.getParameter("defaultzOSTemplateName");
        String configValidator = (String)cmd.getParameter("configValidator");
        if (ServerConfigHelper.doesServerTypeExist(configService, session, serverType)) {
            throw new ConfigServiceException("Server Type: " + serverType + " already exists");
        }
        ObjectName serverTypeId = ServerConfigHelper.buildServerType(configService, session, serverType);
        DocAccessor docAccess = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(serverTypeId));
        AttributeList prop = new AttributeList();
        ConfigServiceHelper.setAttributeValue(prop, "name", "name");
        ConfigServiceHelper.setAttributeValue(prop, "value", serverType);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        ConfigServiceHelper.setAttributeValue(prop, "name", "createCommand");
        ConfigServiceHelper.setAttributeValue(prop, "value", createTemplateCmd);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        ConfigServiceHelper.setAttributeValue(prop, "name", "createTemplateCommand");
        ConfigServiceHelper.setAttributeValue(prop, "value", createCommand);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        ConfigServiceHelper.setAttributeValue(prop, "name", "version");
        ConfigServiceHelper.setAttributeValue(prop, "value", version);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        ConfigServiceHelper.setAttributeValue(prop, "name", "defaultTemplateName");
        ConfigServiceHelper.setAttributeValue(prop, "value", defaultTemplateName);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        ConfigServiceHelper.setAttributeValue(prop, "name", "defaultzOSTemplateName");
        ConfigServiceHelper.setAttributeValue(prop, "value", defaultzOSTemplateName);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        ConfigServiceHelper.setAttributeValue(prop, "name", "configValidator");
        ConfigServiceHelper.setAttributeValue(prop, "value", configValidator);
        docAccess.createRootConfigObject(session, "Property", prop);
        prop.clear();
        docAccess.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerType");
        }
        return "";
    }

    public AttributeList showServerTypeInfo(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showServerTypeInfo", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        String serverType = (String)cmd.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType ", serverType);
        }
        AttributeList attrList = new AttributeList();
        ObjectName serverTypeId = ServerConfigHelper.buildServerType(configService, session, serverType);
        DocAccessor docAccess = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(serverTypeId));
        ObjectName[] props = docAccess.getRootObjects(session);
        for (int i = 0; i < props.length; ++i) {
            String propName = (String)configService.getAttribute(session, props[i], "name");
            Object propValue = configService.getAttribute(session, props[i], "value");
            attrList.add(new Attribute(propName, propValue));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showServerTypeInfo", attrList);
        }
        return attrList;
    }

    public void changeServerSpecificShortName(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerSpecificShortName", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        String nodeName = (String)cmd.getParameter("nodeName");
        String serverName = (String)cmd.getParameter("serverName");
        String shortName = (String)cmd.getParameter("specificShortName");
        if (!ServerConfigCommands.isNodeZOS(session, nodeName)) {
            throw new InvalidParameterValueException(cmd.getName(), "nodeName", nodeName + " is not zOS");
        }
        if (!ServerConfigCommands.isValidShortName(shortName)) {
            throw new InvalidParameterValueException(cmd.getName(), "specificShortName", shortName);
        }
        String nodeSpec = "Node=" + nodeName;
        ObjectName[] matches = configService.resolve(session, nodeSpec);
        ObjectName node = null;
        if (matches.length <= 0) {
            throw new InvalidParameterValueException(cmd.getName(), "nodeName", nodeName);
        }
        node = matches[0];
        String serverSpec = "Node=" + nodeName + ":Server=" + serverName;
        matches = configService.resolve(session, serverSpec);
        ObjectName server = null;
        if (matches.length <= 0) {
            throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
        }
        server = matches[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        PlatformServerConfigHelper helper = ConfigHelperFactory.getPlatformServerConfigHelper((Node)((Node)MOFUtil.convertToEObject(session, node)));
        Server s = (Server)MOFUtil.convertToEObject(session, server);
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "shortName", shortName);
        configService.setAttributes(session, server, attrList);
        helper.modifyShortName(s, "Server");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerSpecificShortName");
        }
    }

    public void changeServerGenericShortName(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerGenericShortName", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        String nodeName = (String)cmd.getParameter("nodeName");
        String serverName = (String)cmd.getParameter("serverName");
        String shortName = (String)cmd.getParameter("genericShortName");
        if (!ServerConfigCommands.isNodeZOS(session, nodeName)) {
            throw new InvalidParameterValueException(cmd.getName(), "nodeName", nodeName + " is not zOS");
        }
        if (!ServerConfigCommands.isValidShortName(shortName)) {
            throw new InvalidParameterValueException(cmd.getName(), "specificShortName", shortName);
        }
        String nodeSpec = "Node=" + nodeName;
        ObjectName[] matches = configService.resolve(session, nodeSpec);
        ObjectName node = null;
        if (matches.length <= 0) {
            throw new InvalidParameterValueException(cmd.getName(), "nodeName", nodeName);
        }
        node = matches[0];
        String serverSpec = "Node=" + nodeName + ":Server=" + serverName;
        matches = configService.resolve(session, serverSpec);
        ObjectName server = null;
        if (matches.length <= 0) {
            throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
        }
        server = matches[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        PlatformServerConfigHelper helper = ConfigHelperFactory.getPlatformServerConfigHelper((Node)((Node)MOFUtil.convertToEObject(session, node)));
        Server s = (Server)MOFUtil.convertToEObject(session, server);
        helper.modifyClusterShortName(s, "Server", shortName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerGenericShortName");
        }
    }

    public void changeClusterShortName(AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeClusterShortName", new Object[]{cmd});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        String clusterName = (String)cmd.getParameter("clusterName");
        String shortName = (String)cmd.getParameter("shortName");
        if (!ServerConfigCommands.isAnyNodeZOS(configService, session)) {
            throw new Exception("The cluster is not zOS");
        }
        if (!ServerConfigCommands.isValidShortName(shortName)) {
            throw new InvalidParameterValueException(cmd.getName(), "shortName", shortName);
        }
        String clusterSpec = "ServerCluster=" + clusterName;
        ObjectName[] matches = configService.resolve(session, clusterSpec);
        ObjectName cluster = null;
        if (matches.length <= 0) {
            throw new InvalidParameterValueException(cmd.getName(), "clusterName", clusterName);
        }
        cluster = matches[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster: " + cluster);
        }
        matches = configService.resolve(session, "Node");
        ObjectName node = matches[0];
        PlatformClusterConfigHelper helper = ConfigHelperFactory.getPlatformClusterConfigHelper((Node)((Node)MOFUtil.convertToEObject(session, node)));
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "shortName", shortName);
        configService.setAttributes(session, cluster, attrList);
        ServerCluster sc = (ServerCluster)MOFUtil.convertToEObject(session, cluster);
        helper.modifyClusterShortName(sc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeClusterShortName");
        }
    }

    private static boolean isValidShortName(String shortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidShortName", shortName);
        }
        boolean result = true;
        if (shortName == null || shortName.length() > 8) {
            result = false;
        }
        for (int i = 0; shortName != null && i < shortName.length(); ++i) {
            char ch = shortName.charAt(i);
            if (i == 0 && Character.isDigit(ch)) {
                result = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "First char is digit ", shortName);
                break;
            }
            if (!Character.isLetterOrDigit(ch)) {
                result = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Not letter or digit ", shortName);
                break;
            }
            if (!Character.isLetter(ch) || Character.isUpperCase(ch)) continue;
            result = false;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Letter is not uppercase ", shortName);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidShortName", new Boolean(result));
        }
        return result;
    }

    protected static boolean isNodeZOS(Session session, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeZOS", nodeName);
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper metadataHelper = workSpace.getMetadataHelper();
        boolean result = metadataHelper.isNodeZOS(nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeZOS", new Boolean(result));
        }
        return result;
    }

    private static boolean isAnyNodeZOS(ConfigService configService, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnyNodeZOS");
        }
        boolean result = false;
        ObjectName[] matches = configService.resolve(session, "Node");
        if (matches.length > 0) {
            ObjectName node = matches[0];
            String nodeName = ConfigServiceHelper.getDisplayName(node);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeName: " + nodeName);
            }
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            ManagedObjectMetadataHelper metadataHelper = workSpace.getMetadataHelper();
            result = metadataHelper.isNodeZOS(nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAnyNodeZOS", new Boolean(result));
        }
        return result;
    }
}

