/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.reports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.management.commands.reports.BaseReport;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class ReportConfigInconsistencies
extends BaseReport {
    private static TraceComponent tc = Tr.register(ReportConfigInconsistencies.class, "ReportConfigInconsistencies", "com.ibm.ws.management.commands.reports");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
    private static String configRoot;

    public static String getReport(AbstractAdminCommand cmd) throws Exception {
        return ReportConfigInconsistencies.getReport();
    }

    public static String getReport() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReport");
        }
        StringBuffer output = new StringBuffer();
        int problems = 0;
        output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.title", new Object[]{ReportConfigInconsistencies.getCellName()}, "Configuration consistency report for cell {0}\n\n"));
        problems += ReportConfigInconsistencies.checkForEmptyDocs(output);
        problems += ReportConfigInconsistencies.checkForInvalidApps(output);
        if ((problems += ReportConfigInconsistencies.checkForInvalidNodes(output)) > 0) {
            output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.summary2", new Object[]{new Integer(problems)}, "\n\n{0} consistency problems were found.\n"));
        } else {
            output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.summary1", new Object[0], "\n\nNo consistency problems were found.\n"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReport", output);
        }
        return output.toString();
    }

    private static int checkForEmptyDocs(StringBuffer output) throws Exception {
        File dir = ReportConfigInconsistencies.getConfigRootDir();
        int problems = 0;
        problems = ReportConfigInconsistencies.checkForEmptyDocs(dir, problems, output);
        return problems;
    }

    private static int checkForEmptyDocs(File dir, int problems, StringBuffer output) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForEmptyDocs", new Object[]{dir, new Integer(problems)});
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                problems = ReportConfigInconsistencies.checkForEmptyDocs(files[i], problems, output);
                continue;
            }
            if (files[i].length() > 0L) continue;
            ++problems;
            String docURI = files[i].getPath().substring(configRoot.length() + 1);
            output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.zeroLength", new Object[]{docURI}, "   {0} is a zero byte length file.\n"));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Found zero length file", new Object[]{docURI, new Integer(problems)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForEmptyDocs", new Object[]{dir, new Integer(problems)});
        }
        return problems;
    }

    private static int checkForInvalidApps(StringBuffer output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForInvalidApps");
        }
        int problems = 0;
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        String[] apps = repository2.listResourceNames("cells/" + ReportConfigInconsistencies.getCellName() + "/applications", 2, 1);
        for (int i = 0; i < apps.length; ++i) {
            String[] docs;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + apps[i]);
            }
            if ((docs = repository2.listResourceNames(apps[i] + "/deployments", 2, 1)).length == 0) {
                ++problems;
                output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.emptyDeployment", new Object[]{apps[i]}, "   Missing contents from deployments folder {0}\n"));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Missing contents from deployments folder", new Object[]{apps[i], new Integer(problems)});
                continue;
            }
            String earFolder = docs[0];
            if ((docs = repository2.listResourceNames(earFolder + "/deployment.xml", 1, 0)).length != 0) continue;
            ++problems;
            output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.missingDeployment", new Object[]{apps[i]}, "   Missing deployment.xml from {0}\n"));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Missing deployment.xml from", new Object[]{earFolder + "/deployment.xml", new Integer(problems)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForInvalidApps", new Integer(problems));
        }
        return problems;
    }

    private static int checkForInvalidNodes(StringBuffer output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForInvalidNodes");
        }
        int problems = 0;
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        String[] nodes = repository2.listResourceNames("cells/" + ReportConfigInconsistencies.getCellName() + "/nodes", 2, 1);
        for (int i = 0; i < nodes.length; ++i) {
            String[] docs;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + nodes[i]);
            }
            if ((docs = repository2.listResourceNames(nodes[i] + "/serverindex.xml", 1, 0)).length != 0) continue;
            ++problems;
            output.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.missingServerIndex", new Object[]{nodes[i]}, "   Missing serverindex.xml from {0}\n"));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Missing serverindex.xml", new Object[]{nodes[i], new Integer(problems)});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForInvalidNodes", new Integer(problems));
        }
        return problems;
    }

    private static File getConfigRootDir() throws Exception {
        File root;
        String rootDir;
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        Properties config = repository2.getConfig();
        configRoot = rootDir = config.getProperty("was.repository.root");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Repository root dir is " + rootDir);
        }
        if (!(root = new File(rootDir)).exists()) {
            throw new Exception(rootDir + " is listed as the repository root directory but it either does not exist or cannot be accessed.");
        }
        if (!root.isDirectory()) {
            throw new Exception(rootDir + " is listed as the repository root directory but it is not a directory.");
        }
        return root;
    }
}

