/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.commands.properties.PropertiesBasedConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class UserDefinedVariableMap {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(UserDefinedVariableMap.class, "PropertiesFileData", "com.ibm.ws.management.resources.configservice");
    public Properties userDefinedVariableMap = new Properties();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadVariableMapFile(String fileName) throws PropertiesBasedConfigException {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadVariableMapFile", fileName);
            }
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(new File(fileName));
                    this.userDefinedVariableMap.load(in);
                }
                catch (Exception e) {
                    throw new PropertiesBasedConfigException("UserDefinedVariable map file does not exist or is not a properties file " + fileName);
                }
                Object var5_3 = null;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ioe) {}
            in.close();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "loadVariableMapFile");
    }

    public String getValue(String name) {
        String res = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValue", name);
        }
        res = this.userDefinedVariableMap.getProperty(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValue", res);
        }
        return res;
    }

    public String expand(String value) {
        return this.expandRecursively(value);
    }

    public String expandOnce(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandOnce", value);
        }
        String res = value;
        int start = value.indexOf("!{");
        if (start > 0) {
            int end = value.indexOf("}", start += 2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start = " + new Integer(start) + " end = " + new Integer(end));
            }
            if (end > 0) {
                String var = value.substring(start, end);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "var = " + var);
                }
                String val = this.getValue(var);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value = " + val);
                }
                var = "!{" + var + "}";
                res = this.replace(var, val, res);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandOnce", res);
        }
        return res;
    }

    public String expandRecursively(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandRecursively", value);
        }
        String res = value;
        boolean done = false;
        while (!done) {
            int start = value.indexOf("!{");
            if (start >= 0) {
                int end = value.indexOf("}", start += 2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "start = " + new Integer(start) + " end = " + new Integer(end));
                }
                if (end > 0) {
                    String var = value.substring(start, end);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "var = " + var);
                    }
                    String val = this.getValue(var);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "value = " + val);
                    }
                    var = "!{" + var + "}";
                    res = this.replace(var, val, res);
                } else {
                    done = true;
                }
            } else {
                done = true;
            }
            value = new String(res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandRecursively", res);
        }
        return res;
    }

    private String replace(String var, String val, String str) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replace", new Object[]{var, val, str});
        }
        String newStr = null;
        StringBuffer sb = new StringBuffer();
        int varInx = str.indexOf(var);
        int varLen = var.length();
        sb = sb.append(str.substring(0, str.indexOf(var)));
        sb = sb.append(val);
        sb = sb.append(str.substring(varInx + varLen));
        newStr = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replace", newStr);
        }
        return newStr;
    }

    public void clear() {
        this.userDefinedVariableMap.clear();
    }

    public void loadVarMap(Properties props) {
        this.userDefinedVariableMap.putAll((Map<?, ?>)props);
    }

    public static List getAllVars(String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllVars", val);
        }
        ArrayList<String> res = new ArrayList<String>();
        String value = new String(val);
        boolean done = false;
        while (!done) {
            int start = value.indexOf("!{");
            if (start > 0) {
                int end = value.indexOf("}", start += 2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "start = " + new Integer(start) + " end = " + new Integer(end));
                }
                if (end > 0) {
                    String var = value.substring(start, end);
                    var = "!{" + var + "}";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "var = " + var);
                    }
                    if (!res.contains(var)) {
                        res.add(var);
                    }
                    value = value.substring(end + 1);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllVars", res);
        }
        return res;
    }

    public static boolean isVariable(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVariable", value);
        }
        boolean res = false;
        int start = value.indexOf("!{");
        if (start > 0) {
            int end = value.indexOf("}", start += 2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start = " + new Integer(start) + " end = " + new Integer(end));
            }
            if (end > 0) {
                String var = value.substring(start, end);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "var = " + var);
                }
                res = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVariable", new Boolean(res));
        }
        return res;
    }
}

