/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.ApplyProperties;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class Server
extends PropWASResource {
    private static final TraceComponent tc = Tr.register(Server.class, null, null);

    public String getResourceType() {
        return "Server";
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        SectionedProperties[] props = null;
        try {
            Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
            ArrayList<SectionedProperties> allProps = new ArrayList<SectionedProperties>();
            if (create != null && create.booleanValue()) {
                String configType;
                String resType = this.getCurrentResourceType();
                String string = configType = this.getConfigData() != null ? ConfigServiceHelper.getConfigDataType(this.getConfigData()) : null;
                if (resType != null && resType.equals(this.getResourceType()) && (configType == null || configType != null && configType.equals(resType))) {
                    int i;
                    SectionedProperties[] props5;
                    SectionedProperties[] props1 = ConfigPropertiesHelper.getPropertiesForCommand("createApplicationServer", this, true);
                    for (int i2 = 0; props1 != null && i2 < props1.length; ++i2) {
                        allProps.add(props1[i2]);
                    }
                    SectionedProperties[] props2 = ConfigPropertiesHelper.getPropertiesForCommand("createGenericServer", this, true);
                    for (int i3 = 0; props2 != null && i3 < props2.length; ++i3) {
                        allProps.add(props2[i3]);
                    }
                    SectionedProperties[] props3 = ConfigPropertiesHelper.getPropertiesForCommand("createWebServer", this, true);
                    for (int i4 = 0; props3 != null && i4 < props3.length; ++i4) {
                        allProps.add(props3[i4]);
                    }
                    SectionedProperties[] props4 = ConfigPropertiesHelper.getPropertiesForCommand("createProxyServer", this, true);
                    for (int i5 = 0; props4 != null && i5 < props4.length; ++i5) {
                        allProps.add(props4[i5]);
                    }
                    String clusterName = null;
                    if (this.getConfigData() != null) {
                        clusterName = (String)this.getConfigService().getAttribute(this.getSession(), this.getConfigData(), "clusterName");
                    } else {
                        props5 = ConfigPropertiesHelper.getPropertiesForCommand("createClusterMember", this, true);
                        for (i = 0; props5 != null && i < props5.length; ++i) {
                            allProps.add(props5[i]);
                        }
                    }
                    if (clusterName != null && !clusterName.equals("")) {
                        props5 = ConfigPropertiesHelper.getPropertiesForCommand("createClusterMember", this, true);
                        for (i = 0; props5 != null && i < props5.length; ++i) {
                            allProps.add(props5[i]);
                        }
                    }
                }
            }
            if (allProps.size() > 0) {
                props = allProps.toArray(new SectionedProperties[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WASResourceException(e);
        }
        return props;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        SectionedProperties[] props = null;
        try {
            Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
            ArrayList<SectionedProperties> allProps = new ArrayList<SectionedProperties>();
            if (delete != null && delete.booleanValue()) {
                String configType;
                String resType = this.getCurrentResourceType();
                String string = configType = this.getConfigData() != null ? ConfigServiceHelper.getConfigDataType(this.getConfigData()) : null;
                if (resType != null && resType.equals(this.getResourceType()) && (configType == null || configType != null && configType.equals(resType))) {
                    StringBuffer sb;
                    String comments;
                    SectionedProperties[] props4;
                    SectionedProperties[] props3;
                    SectionedProperties[] props1 = ConfigPropertiesHelper.getPropertiesForCommand("deleteServer", this, false);
                    for (int i = 0; props1 != null && i < props1.length; ++i) {
                        allProps.add(props1[i]);
                    }
                    if (props1 != null && props1.length > 0) {
                        SectionedProperties sp = props1[0];
                        String comments2 = sp.getComments();
                        StringBuffer sb2 = new StringBuffer(comments2);
                        sb2 = sb2.append("\n# Update ResourceId field with actual serverName ( ResourceId=Server=serverName ) \n#\n");
                        sp.setComments(sb2.toString());
                    }
                    if ((props3 = ConfigPropertiesHelper.getPropertiesForCommand("deleteWebServer", this, false)) != null && props3.length > 0) {
                        SectionedProperties sp = props3[0];
                        String comments3 = sp.getComments();
                        StringBuffer sb3 = new StringBuffer(comments3);
                        sb3 = sb3.append("\n# Update ResourceId field with actual serverName ( ResourceId=Server=serverName ) \n#\n");
                        sp.setComments(sb3.toString());
                    }
                    for (int i = 0; props3 != null && i < props3.length; ++i) {
                        allProps.add(props3[i]);
                    }
                    String clusterName = null;
                    if (this.getConfigData() != null) {
                        clusterName = (String)this.getConfigService().getAttribute(this.getSession(), this.getConfigData(), "clusterName");
                    } else {
                        props4 = ConfigPropertiesHelper.getPropertiesForCommand("deleteClusterMember", this, false);
                        if (props4 != null && props4.length > 0) {
                            SectionedProperties sp = props4[0];
                            comments = sp.getComments();
                            sb = new StringBuffer(comments);
                            sb = sb.append("\n# Update ResourceId field with actual serverName ( ResourceId=Server=serverName ) \n#\n");
                            sp.setComments(sb.toString());
                        }
                        for (int i = 0; props4 != null && i < props4.length; ++i) {
                            allProps.add(props4[i]);
                        }
                    }
                    if (clusterName != null && !clusterName.equals("")) {
                        props4 = ConfigPropertiesHelper.getPropertiesForCommand("deleteClusterMember", this, false);
                        if (props4 != null && props4.length > 0) {
                            SectionedProperties sp = props4[0];
                            comments = sp.getComments();
                            sb = new StringBuffer(comments);
                            sb = sb.append("\n# Update ResourceId field with actual serverName ( ResourceId=Server=serverName ) \n#\n");
                            sp.setComments(sb.toString());
                        }
                        for (int i = 0; props4 != null && i < props4.length; ++i) {
                            allProps.add(props4[i]);
                        }
                    }
                }
            }
            if (allProps.size() > 0) {
                props = allProps.toArray(new SectionedProperties[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WASResourceException(e);
        }
        return props;
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        Properties props = null;
        String resType = this.getCurrentResourceType();
        if (resType.equals("EndPoint")) {
            Properties serverProps = ConfigServiceHelper.getObjectLocation(this.getConfigData());
            String serverName = serverProps.getProperty("server");
            String nodeName = serverProps.getProperty("node");
            try {
                props = this.getAllPorts(this.getConfigService(), this.getSession(), nodeName, serverName);
            }
            catch (Exception e) {
                throw new WASResourceException(e);
            }
        } else {
            props = super.getProperties();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        String propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", name);
        }
        propValue = super.getProperty(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", propValue);
        }
        return propValue;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        super.setProperty(name, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public String[] validateProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        String resType;
        String[] result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateProperties", props);
        }
        if ((resType = this.getCurrentResourceType()).equals("EndPoint")) {
            result = null;
        } else {
            super.validateProperties(props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProperties");
        }
        return result;
    }

    public void setProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        String resType = this.getCurrentResourceType();
        Boolean useCommands = (Boolean)this.getReferenceProperties().get("USECOMMANDS");
        if (useCommands != null && useCommands.booleanValue()) {
            String rType;
            Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
            Boolean delete = (Boolean)this.getReferenceProperties().get("DELETEALLCONTENTS");
            if (create != null && create.booleanValue()) {
                String rType2 = (String)this.getReferenceProperties().get("RESOURCETYPE");
                if (rType2.equals(this.getResourceType())) {
                    throw new WASResourceException("Cannot create server. Use server creation template");
                }
            } else if (delete != null && delete.booleanValue() && (rType = (String)this.getReferenceProperties().get("RESOURCETYPE")).equals(this.getResourceType())) {
                throw new WASResourceException("Cannot delete server. Use server deletion template");
            }
            super.setProperties(props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperties");
            }
            return;
        }
        if (resType.equals("EndPoint")) {
            Properties serverProps = ConfigServiceHelper.getObjectLocation(this.getConfigData());
            String serverName = serverProps.getProperty("server");
            String nodeName = serverProps.getProperty("node");
            try {
                this.setAllPorts(this.getConfigService(), this.getSession(), nodeName, serverName, props);
            }
            catch (Exception e) {
                throw new WASResourceException(e);
            }
        } else {
            super.setProperties(props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public List getRelationships(int type, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{new Integer(type), new Boolean(recursive)});
        }
        List result = super.getRelationships(type, recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        List result = super.getAllPropertyNames();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    private Properties getAllPorts(ConfigService cs, Session session, String nodeName, String serverName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPorts", new Object[]{cs, session, nodeName, serverName});
        }
        String nodePath = "Node=" + nodeName;
        ObjectName node = cs.resolve(session, nodePath)[0];
        Properties props = new Properties();
        EnvVariables varObject = (EnvVariables)this.getReferenceProperties().get("EnvironmentVariablesObject");
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] serverEntries = cs.queryConfigObjects(session, node, pattern, null);
        for (int i = 0; i < serverEntries.length; ++i) {
            ObjectName serverEntry = serverEntries[i];
            String serverType = (String)cs.getAttribute(session, serverEntry, "serverType");
            String sName = (String)cs.getAttribute(session, serverEntry, "serverName");
            if (!sName.equals(serverName)) continue;
            ArrayList endpoints = (ArrayList)cs.getAttribute(session, serverEntry, "specialEndpoints", false);
            for (int j = 0; j < endpoints.size(); ++j) {
                ObjectName specEndpoint = (ObjectName)endpoints.get(j);
                String endPointName = (String)cs.getAttribute(session, specEndpoint, "endPointName");
                ObjectName endpoint = (ObjectName)cs.getAttribute(session, specEndpoint, "endPoint", false);
                String hostname = (String)cs.getAttribute(session, endpoint, "host");
                Integer p = (Integer)cs.getAttribute(session, endpoint, "port");
                hostname = varObject.variablize(hostname, "hostName");
                String e = p + ":" + hostname + " # integer ";
                props.setProperty(endPointName, e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllProps", props);
        }
        return props;
    }

    private void setAllPorts(ConfigService cs, Session session, String nodeName, String serverName, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAllPorts", new Object[]{cs, session, nodeName, serverName, props});
        }
        String nodePath = "Node=" + nodeName;
        ObjectName node = cs.resolve(session, nodePath)[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] serverEntries = cs.queryConfigObjects(session, node, pattern, null);
        for (int i = 0; i < serverEntries.length; ++i) {
            ObjectName serverEntry = serverEntries[i];
            String serverType = (String)cs.getAttribute(session, serverEntry, "serverType");
            String sName = (String)cs.getAttribute(session, serverEntry, "serverName");
            if (!sName.equals(serverName)) continue;
            ArrayList endpoints = (ArrayList)cs.getAttribute(session, serverEntry, "specialEndpoints", false);
            for (int j = 0; j < endpoints.size(); ++j) {
                ObjectName specEndpoint = (ObjectName)endpoints.get(j);
                String endPointName = (String)cs.getAttribute(session, specEndpoint, "endPointName");
                ObjectName endpoint = (ObjectName)cs.getAttribute(session, specEndpoint, "endPoint", false);
                String oldHostName = (String)cs.getAttribute(session, endpoint, "host");
                Integer oldPort = (Integer)cs.getAttribute(session, endpoint, "port");
                String newHostName = this.getHostName(props, endPointName);
                String newPort = this.getPortNumber(props, endPointName);
                if (newPort == null) continue;
                if (!ApplyProperties.checkInt(newPort)) {
                    ApplyProperties.logReport(this, "ADMG0831I", new Object[]{endPointName + ":port", newPort, "integer"});
                }
                if (this.isValidating()) continue;
                AttributeList alist = new AttributeList();
                alist.add(new Attribute("port", new Integer(newPort)));
                alist.add(new Attribute("host", newHostName));
                cs.setAttributes(session, endpoint, alist);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPorts");
        }
    }

    private String getHostName(Properties props, String endPointName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName", new Object[]{props, endPointName});
        }
        String result = null;
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.equals(endPointName)) continue;
            String val = props.getProperty(key);
            StringTokenizer st = new StringTokenizer(val, ":#");
            String port = st.nextToken();
            if (!st.hasMoreTokens()) break;
            result = st.nextToken();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName", result);
        }
        return result;
    }

    private String getPortNumber(Properties props, String endPointName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortNumber", new Object[]{props, endPointName});
        }
        String result = null;
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.equals(endPointName)) continue;
            String val = props.getProperty(key);
            StringTokenizer st = new StringTokenizer(val, ":#");
            result = st.nextToken();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortNumber", result);
        }
        return result;
    }
}

