/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.node;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.ContextUtil;
import com.ibm.ws.sm.workspace.ContextUtilFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.TreeIterator;

public class RenameNode
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RenameNode.class, "admin", "com.ibm.ws.management.resources.configservice");
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
    private Session session = null;
    private ConfigService configService = null;
    private ObjectName newNodeObject = null;
    private String nodeName = null;
    private String newNodeName = null;
    private String shortName = null;
    private ObjectName cell = null;

    public RenameNode(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public RenameNode(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            this.session = this.getConfigSession();
            this.configService = ConfigServiceFactory.getConfigService();
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            this.newNodeName = (String)this.getParameter("newNodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newNodeName", this.newNodeName);
            }
            this.shortName = (String)this.getParameter("shortName");
            if (this.shortName != null && this.shortName.length() > 0) {
                this.shortName = this.shortName.toUpperCase();
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            this.cell = this.configService.queryConfigObjects(this.session, null, pattern, null)[0];
            ObjectName[] nodes = this.configService.resolve(this.session, "Node=" + this.nodeName);
            if (nodes == null || nodes.length == 0) {
                String msg = this.getFormattedMessage("ADMG9218E", new Object[]{this.nodeName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new CommandValidationException(msg);
            }
            nodes = this.configService.resolve(this.session, "Node=" + this.newNodeName);
            if (nodes != null && nodes.length > 0) {
                String msg = "The specified node " + this.newNodeName + " exists in the cell already";
                throw new CommandValidationException(msg);
            }
            if (this.shortName != null && this.shortName.length() > 8) {
                String msg = "The specified shortName " + this.shortName + " has more than 8 characters";
                throw new CommandValidationException(msg);
            }
            if (this.shortName != null && this.shortName.length() > 0) {
                this.validateNodeShortName();
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.node.RenameNode.validate", (String)"114");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", ex);
            }
            CommandValidationException exception = new CommandValidationException(ex, "unexpected exception during validation");
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.changeNodeDir();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.node.RenameNode.beforeStepsExecuted", (String)"134");
            result.setException(new CommandException(th, "renameNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.newNodeObject = this.configService.resolve(this.session, "Node=" + this.newNodeName)[0];
            this.changeNodeName();
            this.changeNodeDeployment();
            this.changeSecuritySSLConfig();
            this.changeServerSSLConfig();
            this.changeNodeGroupConfig();
            this.changeCoreGroupConfig();
            this.changeClusterConfig();
            this.changeNodeVariables();
            this.changeAuthorizationGroups();
            if (this.shortName != null && this.shortName.length() > 0) {
                this.changeServersStartCommandArgs();
                this.changeNodeShortNameVariables();
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.node.RenameNode.afterStepsExecuted", (String)"126");
            result.setException(new CommandException(th, "renameNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private String getFormattedMessage(String key, Object[] args, String msg) {
        try {
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return msg;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (msg == null) {
                return msg;
            }
            return MessageFormat.format(msg, args);
        }
        catch (NullPointerException npe) {
            return msg;
        }
    }

    private void changeNodeVariables() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeVariables");
        }
        ObjectName varMap = this.configService.getRelationship(this.session, this.newNodeObject, "VariableMap")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        AttributeList attrList = new AttributeList();
        String thisNode = "";
        ObjectName[] entries = this.configService.queryConfigObjects(this.session, varMap, pattern, null);
        for (int i = 0; i < entries.length; ++i) {
            String value;
            String symName = (String)this.configService.getAttribute(this.session, entries[i], "symbolicName");
            if (symName == null || symName.length() <= 0) continue;
            if (symName.equalsIgnoreCase("WAS_NODE") || symName.equalsIgnoreCase("WAS_SERVER_ONLY_node_name")) {
                attrList.clear();
                attrList.add(new Attribute("value", this.newNodeName));
                this.configService.setAttributes(this.session, entries[i], attrList);
                continue;
            }
            if (!"WAS_SERVER_ONLY_default_jvm_options".equals(symName) || (value = (String)this.configService.getAttribute(this.session, entries[i], "value")) == null || value.length() <= 0) continue;
            String[] vals = value.split(this.nodeName);
            StringBuffer buf = new StringBuffer();
            if (vals != null && vals.length == 2) {
                buf.append(vals[0]);
                buf.append(this.newNodeName);
                buf.append(vals[1]);
                thisNode = buf.toString();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newNode ", thisNode);
            }
            attrList.clear();
            attrList.add(new Attribute("value", thisNode));
            this.configService.setAttributes(this.session, entries[i], attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeVariables");
        }
    }

    private void changeNodeShortNameVariables() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeShortVariables");
        }
        ObjectName varMap = this.configService.getRelationship(this.session, this.newNodeObject, "VariableMap")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        AttributeList attrList = new AttributeList();
        ObjectName[] entries = this.configService.queryConfigObjects(this.session, varMap, pattern, null);
        for (int i = 0; i < entries.length; ++i) {
            String symName = (String)this.configService.getAttribute(this.session, entries[i], "symbolicName");
            if (symName == null || symName.length() <= 0 || !symName.equalsIgnoreCase("WAS_SERVER_ONLY_node_short_name")) continue;
            attrList.clear();
            attrList.add(new Attribute("value", this.shortName));
            this.configService.setAttributes(this.session, entries[i], attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeShortVariables");
        }
    }

    private void validateNodeShortName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNodeShortName()", this.shortName);
        }
        ObjectName[] nodes = this.configService.getRelationship(this.session, this.cell, "Node");
        for (int i = 0; i < nodes.length; ++i) {
            String _nodeShortName = (String)this.configService.getAttribute(this.session, nodes[i], "shortName");
            if (_nodeShortName == null || !_nodeShortName.equalsIgnoreCase(this.shortName)) continue;
            String msg = this.getFormattedMessage("ADMU0182E", new Object[]{this.shortName}, null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNodeShortName()");
        }
    }

    private String normalizeSSLConfig(String sslConfig, String name) {
        String result = name + sslConfig.substring(sslConfig.indexOf("/"));
        return result;
    }

    private void changeSecuritySSLConfig() throws Exception {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeSecuritySSLConfig");
        }
        AttributeList attrList = new AttributeList();
        String thisNode = "";
        String sslConfig = "";
        ObjectName pattern = null;
        ObjectName security = this.configService.getRelationship(this.session, this.cell, "Security")[0];
        pattern = ConfigServiceHelper.createObjectName(null, "SSLConfig");
        ObjectName[] matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (i = 0; i < matches.length; ++i) {
            int idx;
            sslConfig = (String)this.configService.getAttribute(this.session, matches[i], "alias");
            if (sslConfig == null || sslConfig.length() <= 0 || (idx = sslConfig.indexOf("/")) <= 0 || (thisNode = sslConfig.substring(0, idx)) == null || !thisNode.equalsIgnoreCase(this.nodeName)) continue;
            attrList.add(new Attribute("alias", this.normalizeSSLConfig(sslConfig, this.newNodeName)));
            this.configService.setAttributes(this.session, matches[i], attrList);
        }
        attrList.clear();
        pattern = ConfigServiceHelper.createObjectName(null, "IIOPTransport");
        matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (i = 0; i < matches.length; ++i) {
            sslConfig = (String)this.configService.getAttribute(this.session, matches[i], "sslConfig");
            if (sslConfig == null || sslConfig.length() <= 0 || (thisNode = sslConfig.substring(0, sslConfig.indexOf("/"))) == null || !thisNode.equalsIgnoreCase(this.nodeName)) continue;
            attrList.add(new Attribute("sslConfig", this.normalizeSSLConfig(sslConfig, this.newNodeName)));
            this.configService.setAttributes(this.session, matches[i], attrList);
        }
        attrList.clear();
        String scopeName = "";
        String prefix = "\\(node\\):";
        pattern = ConfigServiceHelper.createObjectName(null, "ManagementScope");
        matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (int i2 = 0; i2 < matches.length; ++i2) {
            scopeName = (String)this.configService.getAttribute(this.session, matches[i2], "scopeName");
            if (scopeName == null || scopeName.length() <= 0) continue;
            String newScopeName = scopeName.replaceAll(prefix + this.nodeName, prefix + this.newNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope name", newScopeName);
            }
            attrList.add(new Attribute("scopeName", newScopeName));
            this.configService.setAttributes(this.session, matches[i2], attrList);
        }
        attrList.clear();
        String location = "";
        pattern = ConfigServiceHelper.createObjectName(null, "KeyStore");
        matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        String prefix2 = "nodes/";
        for (int i3 = 0; i3 < matches.length; ++i3) {
            location = (String)this.configService.getAttribute(this.session, matches[i3], "location");
            if (scopeName == null || location.length() <= 0) continue;
            String newLocation = location.replaceAll(prefix2 + this.nodeName, prefix2 + this.newNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "location", newLocation);
            }
            attrList.add(new Attribute("location", newLocation));
            this.configService.setAttributes(this.session, matches[i3], attrList);
        }
        attrList.clear();
        String name = "";
        pattern = ConfigServiceHelper.createObjectName(null, "SSLConfigGroup");
        matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (int i4 = 0; i4 < matches.length; ++i4) {
            name = (String)this.configService.getAttribute(this.session, matches[i4], "name");
            if (name == null || name.length() <= 0) continue;
            String newName = name.replaceAll(this.nodeName, this.newNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name", newName);
            }
            attrList.add(new Attribute("name", newName));
            this.configService.setAttributes(this.session, matches[i4], attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeSecuritySSLConfig");
        }
    }

    private void changeServerSSLConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerSSLConfig");
        }
        ObjectName server = null;
        ObjectName[] servers = this.configService.getRelationship(this.session, this.newNodeObject, "Server");
        ObjectName pattern = null;
        ObjectName[] matches = null;
        AttributeList attrList = new AttributeList();
        String sslConfig = null;
        String thisNode = null;
        for (int j = 0; j < servers.length; ++j) {
            int i;
            server = servers[j];
            pattern = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            matches = this.configService.queryConfigObjects(this.session, server, pattern, null);
            if (matches.length >= 1) {
                ObjectName soapConnector = matches[0];
                List props = (List)this.configService.getAttribute(this.session, soapConnector, "properties", false);
                for (ObjectName prop : props) {
                    if (prop == null || !"sslConfig".equals(this.configService.getAttribute(this.session, prop, "name")) || (sslConfig = (String)this.configService.getAttribute(this.session, prop, "value")) == null || sslConfig.length() <= 0 || (thisNode = sslConfig.substring(0, sslConfig.indexOf("/"))) == null || !thisNode.equalsIgnoreCase(this.nodeName)) continue;
                    attrList.clear();
                    ConfigServiceHelper.setAttributeValue(attrList, "value", this.normalizeSSLConfig(sslConfig, this.newNodeName));
                    this.configService.setAttributes(this.session, prop, attrList);
                }
            }
            pattern = ConfigServiceHelper.createObjectName(null, "SSLInboundChannel");
            matches = this.configService.queryConfigObjects(this.session, server, pattern, null);
            for (i = 0; i < matches.length; ++i) {
                sslConfig = (String)this.configService.getAttribute(this.session, matches[i], "sslConfigAlias");
                if (sslConfig == null || sslConfig.length() <= 0 || (thisNode = sslConfig.substring(0, sslConfig.indexOf("/"))) == null || !thisNode.equalsIgnoreCase(this.nodeName)) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "sslConfigAlias", this.normalizeSSLConfig(sslConfig, this.newNodeName));
                this.configService.setAttributes(this.session, matches[i], attrList);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "SSLOutboundChannel");
            matches = this.configService.queryConfigObjects(this.session, server, pattern, null);
            for (i = 0; i < matches.length; ++i) {
                sslConfig = (String)this.configService.getAttribute(this.session, matches[i], "sslConfigAlias");
                if (sslConfig == null || sslConfig.length() <= 0 || (thisNode = sslConfig.substring(0, sslConfig.indexOf("/"))) == null || !thisNode.equalsIgnoreCase(this.nodeName)) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "sslConfigAlias", this.normalizeSSLConfig(sslConfig, this.newNodeName));
                this.configService.setAttributes(this.session, matches[i], attrList);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "HTTPTransport");
            matches = this.configService.queryConfigObjects(this.session, server, pattern, null);
            for (i = 0; i < matches.length; ++i) {
                sslConfig = (String)this.configService.getAttribute(this.session, matches[i], "sslConfig");
                if (sslConfig == null || sslConfig.length() <= 0 || (thisNode = sslConfig.substring(0, sslConfig.indexOf("/"))) == null || !thisNode.equalsIgnoreCase(this.nodeName)) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "sslConfig", this.normalizeSSLConfig(sslConfig, this.newNodeName));
                this.configService.setAttributes(this.session, matches[i], attrList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerSSLConfig");
        }
    }

    private void changeNodeDeployment() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeDeployment");
        }
        Session session = this.getConfigSession();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Deployment");
        ObjectName[] deployments = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < deployments.length; ++i) {
            Deployment deployment = (Deployment)MOFUtil.convertToEObject(session, deployments[i]);
            this.updateDeploymentTarget(deployment);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeDeployment");
        }
    }

    private void updateDeploymentTarget(Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentTarget");
        }
        TreeIterator iter = deployment.eAllContents();
        while (iter.hasNext()) {
            ServerTarget svrTarget;
            Object obj = iter.next();
            if (!(obj instanceof ServerTarget) || !(svrTarget = (ServerTarget)obj).getNodeName().equals(this.nodeName)) continue;
            svrTarget.setNodeName(this.newNodeName);
        }
        deployment.eResource().save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateDeploymentTarget");
        }
    }

    private void changeNodeName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeName");
        }
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("name", this.newNodeName));
        if (this.shortName != null && this.shortName.length() > 0) {
            attrList.add(new Attribute("shortName", this.shortName));
        }
        this.configService.setAttributes(this.session, this.newNodeObject, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeName");
        }
    }

    private void changeNodeDir() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeDir");
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(this.session);
        RepositoryContext nodeContext = workspace.findContext("cells/" + ConfigServiceHelper.getDisplayName(this.cell) + "/nodes/" + this.nodeName);
        ContextUtil contextHelper = ContextUtilFactory.getUtil();
        RepositoryContext newNodeContext = contextHelper.rename(nodeContext, this.newNodeName);
        nodeContext.delete(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeDir");
        }
    }

    private void changeCoreGroupConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeCoreGroupConfig");
        }
        ObjectName pattern = null;
        AttributeList list = new AttributeList();
        ObjectName[] coreGroups = this.configService.getRelationship(this.session, this.cell, "CoreGroup");
        for (int j = 0; j < coreGroups.length; ++j) {
            pattern = ConfigServiceHelper.createObjectName(null, "CoreGroupServer");
            ObjectName[] matches = this.configService.queryConfigObjects(this.session, coreGroups[j], pattern, null);
            for (int i = 0; i < matches.length; ++i) {
                String nodeMember = (String)this.configService.getAttribute(this.session, matches[i], "nodeName");
                if (nodeMember == null || !nodeMember.equals(this.nodeName)) continue;
                list.clear();
                list.add(new Attribute("nodeName", this.newNodeName));
                this.configService.setAttributes(this.session, matches[i], list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeCoreGroupConfig");
        }
    }

    private void changeNodeGroupConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeGroupConfig");
        }
        AttributeList list = new AttributeList();
        Object pattern = null;
        ObjectName[] matches = this.configService.getRelationship(this.session, this.cell, "NodeGroup");
        for (int i = 0; i < matches.length; ++i) {
            AttributeList attrList = this.configService.getAttributes(this.session, matches[i], new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                String nodeMember = (String)this.configService.getAttribute(this.session, member, "nodeName");
                if (nodeMember == null || !nodeMember.equals(this.nodeName)) continue;
                list.clear();
                list.add(new Attribute("nodeName", this.newNodeName));
                this.configService.setAttributes(this.session, member, list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeGroupConfig");
        }
    }

    private void changeClusterConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeClusterConfig");
        }
        AttributeList list = new AttributeList();
        Object pattern = null;
        ObjectName[] matches = this.configService.getRelationship(this.session, this.cell, "ServerCluster");
        for (int i = 0; i < matches.length; ++i) {
            AttributeList attrList = this.configService.getAttributes(this.session, matches[i], new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                String nodeMember = (String)this.configService.getAttribute(this.session, member, "nodeName");
                if (nodeMember == null || !nodeMember.equals(this.nodeName)) continue;
                list.clear();
                list.add(new Attribute("nodeName", this.newNodeName));
                this.configService.setAttributes(this.session, member, list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeClusterConfig");
        }
    }

    private void changeServersStartCommandArgs() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServersStartCommandArgs");
        }
        ObjectName[] servers = this.configService.getRelationship(this.session, this.newNodeObject, "Server");
        ObjectName processDefObject = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        String cellShortName = this.getCellShortName();
        for (int i = 0; i < servers.length; ++i) {
            String serverName = (String)this.configService.getAttribute(this.session, servers[i], "name");
            String serverShortName = (String)this.configService.getAttribute(this.session, servers[i], "shortName");
            ObjectName[] processDefs = this.configService.queryConfigObjects(this.session, servers[i], processDefObject, null);
            for (int j = 0; j < processDefs.length; ++j) {
                AttributeList newList;
                ArrayList<String> list;
                String startArg;
                String processType = (String)this.configService.getAttribute(this.session, processDefs[j], "processType");
                if (processType == null || processType.length() <= 0) continue;
                if (processType.equalsIgnoreCase("Control")) {
                    List cmdArgList = (List)this.configService.getAttribute(this.session, processDefs[j], "startCommandArgs");
                    if (cmdArgList == null || cmdArgList.size() <= 0) continue;
                    String startCmd = (String)cmdArgList.get(0);
                    String jobName = startCmd.substring("JOBNAME=".length(), startCmd.indexOf(","));
                    String startArg2 = "JOBNAME=" + jobName + ",ENV=" + cellShortName + "." + this.shortName + "." + serverShortName;
                    ArrayList<String> list2 = new ArrayList<String>();
                    list2.add(startArg2);
                    AttributeList newList2 = new AttributeList();
                    newList2.add(new Attribute("startCommandArgs", list2));
                    this.configService.setAttributes(this.session, processDefs[j], newList2);
                    continue;
                }
                if (processType.equalsIgnoreCase("Servant")) {
                    startArg = "JOBNAME=&IWMSSNM.S,ENV='" + cellShortName + "." + this.shortName + "." + "&IWMSSNM." + "'";
                    list = new ArrayList<String>();
                    list.add(startArg);
                    newList = new AttributeList();
                    newList.add(new Attribute("startCommandArgs", list));
                    this.configService.setAttributes(this.session, processDefs[j], newList);
                    continue;
                }
                if (!processType.equalsIgnoreCase("Adjunct")) continue;
                startArg = "JOBNAME=&IWMSSNM.A,ENV='" + cellShortName + "." + this.shortName + "." + "&IWMSSNM." + "'";
                list = new ArrayList();
                list.add(startArg);
                newList = new AttributeList();
                newList.add(new Attribute("startCommandArgs", list));
                this.configService.setAttributes(this.session, processDefs[j], newList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServersStartCommandArgs");
        }
    }

    private String getCellShortName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellShortName()");
        }
        String cellShortName = (String)this.configService.getAttribute(this.session, this.cell, "shortName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellShortNames()", cellShortName);
        }
        return cellShortName;
    }

    private void changeAuthorizationGroups() throws Exception {
        final ConfigService csFinal = this.configService;
        final Session sessionFinal = this.session;
        final String nodeFinal = this.nodeName;
        final String newNodeFinal = this.newNodeName;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.changeNodeName(csFinal, sessionFinal, nodeFinal, newNodeFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new Exception(pae.getException());
        }
        catch (Exception e) {
            throw e;
        }
    }
}

