/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.node;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ChangeHost
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ChangeHost.class, "Admin", "com.ibm.ws.management.resources.configarchive");
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
    private Session session = null;
    private ConfigService configService = null;
    private String nodeName = null;
    private String hostName = null;
    private String systemName = null;
    private boolean regenCerts = false;
    private static String WAS_DAEMON_ONLY_SERVER_CONFIGURED_SYSTEM_NAME = "WAS_DAEMON_ONLY_server_configured_system_name";
    private static String WAS_DAEMON_ONLY_CONTROL_REGION_CONFIGURED_SYSTEM = "WAS_DAEMON_ONLY_control_region_configured_system";
    private static String WAS_DAEMON_DAEMONINSTANCENAME = "WAS_DAEMON_daemonInstanceName";
    private static final String IPC_CONNECTOR_ADDRESS_NEP = "IPC_CONNECTOR_ADDRESS";
    private static final String NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS_NEP = "NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS";
    private static final String NODE_MULTICAST_DISCOVERY_ADDRESS_NEP = "NODE_MULTICAST_DISCOVERY_ADDRESS";
    private static final String ORB_LISTENER_ADDRESS_NEP = "ORB_LISTENER_ADDRESS";

    public ChangeHost(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ChangeHost(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ObjectName[] nodes;
            this.session = this.getConfigSession();
            this.configService = ConfigServiceFactory.getConfigService();
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            this.hostName = (String)this.getParameter("hostName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hostName", this.hostName);
            }
            this.systemName = (String)this.getParameter("systemName");
            String regenCertsStr = (String)this.getParameter("regenDefaultCert");
            this.regenCerts = Boolean.parseBoolean(regenCertsStr);
            if (this.nodeName != null && this.nodeName.length() > 0 && ((nodes = this.configService.resolve(this.session, "Node=" + this.nodeName)) == null || nodes.length == 0)) {
                String msg = this.getFormattedMessage("ADMG9218E", new Object[]{this.nodeName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new CommandValidationException(msg);
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.node.ChangeHost.validate", (String)"100");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", ex);
            }
            CommandValidationException exception = new CommandValidationException(ex, "unexpected exception during validation");
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        ObjectName[] nodes = null;
        try {
            if (this.nodeName != null && this.nodeName.length() > 0) {
                nodes = this.configService.resolve(this.session, "Node=" + this.nodeName);
            } else {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
                nodes = this.configService.queryConfigObjects(this.session, null, pattern, null);
            }
            this.changeHost(nodes);
            if (this.nodeName != null && this.nodeName.length() > 0 && this.systemName != null && this.systemName.length() > 0) {
                this.changeSystemName(nodes, this.systemName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Regenerate Certs: " + this.regenCerts);
            }
            if (this.regenCerts) {
                this.regenerateNodeCertificates(nodes);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.node.ChangeHost.beforeStepsExecuted", (String)"147");
            result.setException(new CommandException(th, "change host command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private String getFormattedMessage(String key, Object[] args, String msg) {
        try {
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return msg;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (msg == null) {
                return msg;
            }
            return MessageFormat.format(msg, args);
        }
        catch (NullPointerException npe) {
            return msg;
        }
    }

    private void regenerateNodeCertificates(ObjectName[] nodes) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regenerateNodeCertificates", new Object[]{nodes, this.hostName});
        }
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand cmd = cmdMgr.createCommand("createChainedCertificate");
        cmd.setConfigSession(this.session);
        cmd.setParameter("keyStoreName", "NodeDefaultKeyStore");
        cmd.setParameter("keyStoreScope", "(node):" + this.nodeName);
        cmd.setParameter("certificateAlias", "default_" + this.hostName);
        cmd.setParameter("certificateCommonName", this.nodeName);
        cmd.setParameter("certificateOrganization", "IBM");
        cmd.setParameter("certificateOrganizationalUnit", this.nodeName);
        cmd.setParameter("certificateCountry", "US");
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            Throwable th = result.getException();
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw new Exception(th);
        }
        ObjectName securityObject = this.configService.resolve(this.session, "Cell=:Security=")[0];
        ObjectName cell = this.configService.resolve(this.session, "Cell=")[0];
        String cellName = ConfigServiceHelper.getDisplayName(cell);
        String defaultCertDN = "cn=" + this.hostName + ",ou=" + cellName + ",ou=" + this.nodeName + ",o=IBM,c=US";
        String rootCertDN = "cn=" + this.hostName + ",ou=Root Certificate,ou=" + cellName + ",ou=" + this.nodeName + ",o=IBM,c=US";
        ChangeHost.setSecurityProperties(this.session, this.configService, securityObject, "com.ibm.ssl.defaultCertReqSubjectDN", defaultCertDN);
        ChangeHost.setSecurityProperties(this.session, this.configService, securityObject, "com.ibm.ssl.rootCertSubjectDN", rootCertDN);
        AdminCommand cmd2 = cmdMgr.createCommand("replaceCertificate");
        cmd2.setConfigSession(this.session);
        cmd2.setParameter("certificateAlias", "default");
        cmd2.setParameter("replacementCertificateAlias", "default_" + this.hostName);
        cmd2.setParameter("certificateAlias", "default");
        cmd2.setParameter("deleteOldCert", "true");
        cmd2.execute();
        CommandResult result2 = cmd2.getCommandResult();
        if (!result2.isSuccessful()) {
            Throwable th = result2.getException();
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw new Exception(th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "regenerateNodeCertificates");
        }
    }

    private void changeHost(ObjectName[] nodes) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeHost", new Object[]{nodes, this.hostName});
        }
        AttributeList attrs = new AttributeList();
        for (int j = 0; j < nodes.length; ++j) {
            ObjectName serverIndex = this.configService.getRelationship(this.session, nodes[j], "ServerIndex")[0];
            if (serverIndex != null) {
                attrs.clear();
                attrs.add(new Attribute("hostName", this.hostName));
                this.configService.setAttributes(this.session, serverIndex, attrs);
            }
            attrs.clear();
            attrs.add(new Attribute("host", this.hostName));
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
            ObjectName[] entries = this.configService.queryConfigObjects(this.session, serverIndex, pattern, null);
            String targetNodeName = ConfigServiceHelper.getDisplayName(nodes[j]);
            boolean isTargetNodeZOS = TemplateConfigHelper.isNodeZOS(this.session, targetNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Is node " + targetNodeName + " a ZOS node? " + isTargetNodeZOS);
            }
            for (int i = 0; i < entries.length; ++i) {
                pattern = ConfigServiceHelper.createObjectName(null, "NamedEndPoint");
                ObjectName[] namedEndPoints = this.configService.queryConfigObjects(this.session, entries[i], pattern, null);
                for (int k = 0; k < namedEndPoints.length; ++k) {
                    String namedEndPointName = (String)this.configService.getAttribute(this.session, namedEndPoints[k], "endPointName");
                    if (namedEndPointName.equals(IPC_CONNECTOR_ADDRESS_NEP) || namedEndPointName.equals(NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS_NEP) || namedEndPointName.equals(NODE_MULTICAST_DISCOVERY_ADDRESS_NEP)) continue;
                    boolean isOrbListenerChange = namedEndPointName.equals(ORB_LISTENER_ADDRESS_NEP);
                    pattern = ConfigServiceHelper.createObjectName(null, "EndPoint");
                    ObjectName[] endPoints = this.configService.queryConfigObjects(this.session, namedEndPoints[k], pattern, null);
                    String hostNameValue = (String)this.configService.getAttribute(this.session, endPoints[0], "host");
                    if (hostNameValue.equals("*")) continue;
                    String dottedDecimalIP = null;
                    if (isOrbListenerChange && isTargetNodeZOS) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Changing the hostName for the ORB listener on a ZOS node");
                        }
                        if ((dottedDecimalIP = ChangeHost.getHostIPAddress(this.hostName)) == null || dottedDecimalIP.length() == 0) {
                            throw new Exception("IP address lookup for given hostName failed");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The returned IP was " + dottedDecimalIP);
                        }
                        AttributeList zosOrbList = new AttributeList();
                        zosOrbList.clear();
                        zosOrbList.add(new Attribute("host", dottedDecimalIP));
                        this.configService.setAttributes(this.session, endPoints[0], zosOrbList);
                        continue;
                    }
                    this.configService.setAttributes(this.session, endPoints[0], attrs);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeHost", new Object[]{nodes});
        }
    }

    private void changeSystemName(ObjectName[] nodes, String systemName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeSystemName");
        }
        if (systemName.length() > 8) {
            String msg = "The specified systemName " + systemName + " has more than 8 characters";
            throw new CommandValidationException(msg);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        AttributeList attrList = new AttributeList();
        for (int j = 0; j < nodes.length; ++j) {
            ObjectName varMap = this.configService.getRelationship(this.session, nodes[j], "VariableMap")[0];
            ObjectName[] servers = this.configService.getRelationship(this.session, nodes[j], "Server");
            if (servers != null && servers.length > 0) {
                this.changeConfiguredSystemName(servers, systemName);
            }
            ObjectName[] entries = this.configService.queryConfigObjects(this.session, varMap, pattern, null);
            for (int i = 0; i < entries.length; ++i) {
                String symName = (String)this.configService.getAttribute(this.session, entries[i], "symbolicName");
                if (symName == null || symName.length() <= 0) continue;
                if (WAS_DAEMON_ONLY_SERVER_CONFIGURED_SYSTEM_NAME.equals(symName)) {
                    attrList.clear();
                    attrList.add(new Attribute("value", systemName));
                    this.configService.setAttributes(this.session, entries[i], attrList);
                    continue;
                }
                if (WAS_DAEMON_ONLY_CONTROL_REGION_CONFIGURED_SYSTEM.equals(symName)) {
                    attrList.clear();
                    attrList.add(new Attribute("value", systemName));
                    this.configService.setAttributes(this.session, entries[i], attrList);
                    continue;
                }
                if (!WAS_DAEMON_DAEMONINSTANCENAME.equals(symName)) continue;
                attrList.clear();
                attrList.add(new Attribute("value", systemName));
                this.configService.setAttributes(this.session, entries[i], attrList);
            }
            if (!tc.isEntryEnabled()) continue;
            Tr.exit(tc, "changeSystemName");
        }
    }

    private void changeConfiguredSystemName(ObjectName[] servers, String systemName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeConfiguredSystemName", new Object[]{servers, systemName});
        }
        ObjectName appServer = ConfigServiceHelper.createObjectName(null, "ApplicationServer");
        ObjectName adminService = ConfigServiceHelper.createObjectName(null, "AdminService");
        ObjectName[] serversObj = null;
        AttributeList list = new AttributeList();
        list.add(new Attribute("value", systemName));
        block0: for (int i = 0; i < servers.length; ++i) {
            serversObj = !ConfigServiceHelper.getDisplayName(servers[i]).equals("nodeagent") ? this.configService.queryConfigObjects(this.session, servers[i], appServer, null) : this.configService.queryConfigObjects(this.session, servers[i], adminService, null);
            if (serversObj == null || serversObj.length <= 0) continue;
            ObjectName serverObj = serversObj[0];
            AttributeList attrList = this.configService.getAttributes(this.session, serverObj, new String[]{"properties"}, false);
            List props = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)this.configService.getAttribute(this.session, property, "name");
                if (!propName.equals("was.ConfiguredSystemName")) continue;
                this.configService.setAttributes(this.session, property, list);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeConfiguredSystemName");
        }
    }

    public static void setSecurityProperties(Session session, ConfigService cs, ObjectName sec, String propName, String propValue) {
        boolean propertySet = false;
        try {
            AttributeList customProp = new AttributeList();
            customProp.add(new Attribute("name", propName));
            customProp.add(new Attribute("value", propValue));
            AttributeList attrList = cs.getAttributes(session, sec, new String[]{"properties"}, false);
            if (attrList != null) {
                List props = (List)((Attribute)attrList.get(0)).getValue();
                for (int i = 0; i < props.size(); ++i) {
                    ObjectName property = (ObjectName)props.get(i);
                    String name = (String)cs.getAttribute(session, property, "name");
                    if (!name.equals(propName)) continue;
                    cs.deleteConfigData(session, property);
                    if (propValue != null && propValue.length() > 0) {
                        cs.createConfigData(session, sec, "properties", null, customProp);
                    }
                    propertySet = true;
                    break;
                }
                if (!propertySet && propValue != null && propValue.length() > 0) {
                    cs.createConfigData(session, sec, "properties", null, customProp);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static String getHostIPAddress(String hostname) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostIPAddress", new Object[]{hostname});
        }
        InetAddress inetAddr = null;
        inetAddr = hostname.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostIPAddress", new Object[]{inetAddr});
        }
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }
}

