/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.jca;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.tasks.InstallRARTask;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class J2CCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(J2CCommandProvider.class, "management", "com.ibm.ws.management.resources.configservice");

    public ObjectName createJ2CConnectionFactory(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CConnectionFactory", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        Object connectionFactoryInterface = cmd.getParameter("connectionFactoryInterface");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input connectionFactoryInterface", connectionFactoryInterface);
        }
        ObjectName connDef = null;
        List connDefs = this.getConnectionDefs(configService, session, ra);
        ArrayList attrList = null;
        if (connDefs != null && connectionFactoryInterface != null) {
            for (ObjectName thisConnDef : connDefs) {
                attrList = configService.getAttributes(session, thisConnDef, new String[]{"connectionFactoryInterface"}, false);
                String cfInterface = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, "connectionFactoryInterface");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "retrieve connectionFactoryInterface", cfInterface);
                }
                if (!cfInterface.equals(connectionFactoryInterface)) continue;
                connDef = thisConnDef;
                break;
            }
        }
        if (attrList == null) {
            attrList = new AttributeList();
        } else {
            attrList.clear();
        }
        if (connDefs != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "connectionDefinition", connDef);
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "name", cmd.getParameter("name"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "jndiName", cmd.getParameter("jndiName"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "description", cmd.getParameter("description"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "authDataAlias", cmd.getParameter("authDataAlias"));
        ObjectName cf = configService.createConfigData(session, ra, "J2CConnectionFactory", "J2CConnectionFactory", (AttributeList)attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CConnectionFactory", cf);
        }
        return cf;
    }

    public String[] listConnectionFactoryInterfaces(AbstractAdminCommand cmd) throws Exception {
        ObjectName ra;
        Session session;
        CommandProviderHelper helper;
        ConfigService configService;
        List connDefs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listConnectionFactoryInterface", cmd);
        }
        if ((connDefs = this.getConnectionDefs(configService = (helper = this.getCommandProviderHelper()).getConfigService(), session = cmd.getConfigSession(), ra = (ObjectName)cmd.getTargetObject())) == null) {
            return new String[0];
        }
        ArrayList<String> CFInterfaces = new ArrayList<String>(connDefs.size());
        for (ObjectName thisConnDef : connDefs) {
            AttributeList attrList = configService.getAttributes(session, thisConnDef, new String[]{"connectionFactoryInterface"}, false);
            String cfInterface = (String)ConfigServiceHelper.getAttributeValue(attrList, "connectionFactoryInterface");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve connectionFactoryInterface", cfInterface);
            }
            CFInterfaces.add(cfInterface);
        }
        String[] result = new String[CFInterfaces.size()];
        CFInterfaces.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listConnectionFactoryInterface", result);
        }
        return result;
    }

    private List getConnectionDefs(ConfigService configService, Session session, ObjectName ra) throws Exception {
        AttributeList attrList = configService.getAttributes(session, ra, new String[]{"deploymentDescriptor"}, false);
        ObjectName dd = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "deploymentDescriptor");
        attrList = configService.getAttributes(session, dd, new String[]{"resourceAdapter"}, false);
        ObjectName resourceAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "resourceAdapter");
        attrList = configService.getAttributes(session, resourceAdapter, new String[]{"outboundResourceAdapter"}, false);
        ObjectName outBoundResourceAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "outboundResourceAdapter");
        if (outBoundResourceAdapter == null) {
            return null;
        }
        attrList = configService.getAttributes(session, outBoundResourceAdapter, new String[]{"connectionDefinitions"}, false);
        List connDefs = (List)ConfigServiceHelper.getAttributeValue(attrList, "connectionDefinitions");
        return connDefs;
    }

    public ObjectName[] listJ2CConnectionFactories(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJ2CConnectionFactories", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        String connectionFactoryInterface = (String)cmd.getParameter("connectionFactoryInterface");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input connectionFactoryInterface", connectionFactoryInterface);
        }
        AttributeList attrList = null;
        ObjectName[] j2cCFs = configService.getRelationship(session, ra, "J2CConnectionFactory");
        ObjectName[] cmpCFs = configService.getRelationship(session, ra, "CMPConnectorFactory");
        int jn = j2cCFs.length;
        int cn = cmpCFs.length;
        ObjectName[] CFs = new ObjectName[jn + cn];
        if (j2cCFs.length != 0) {
            System.arraycopy(j2cCFs, 0, CFs, 0, jn);
        }
        if (cmpCFs.length != 0) {
            System.arraycopy(cmpCFs, 0, CFs, jn, cn);
        }
        ArrayList<ObjectName> matchedJ2CCFs = new ArrayList<ObjectName>(CFs.length);
        for (int i = 0; i < CFs.length; ++i) {
            ObjectName thisCF = CFs[i];
            attrList = configService.getAttributes(session, thisCF, new String[]{"connectionDefinition"}, false);
            ObjectName cd = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "connectionDefinition");
            attrList = configService.getAttributes(session, cd, new String[]{"connectionFactoryInterface"}, false);
            String cfIf = (String)ConfigServiceHelper.getAttributeValue(attrList, "connectionFactoryInterface");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve connectionFactoryInterface", cfIf);
            }
            if (!cfIf.equals(connectionFactoryInterface)) continue;
            matchedJ2CCFs.add(thisCF);
        }
        Tr.debug(tc, "matchedJ2CCFs = " + matchedJ2CCFs.size());
        ObjectName[] result = new ObjectName[matchedJ2CCFs.size()];
        matchedJ2CCFs.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listJ2CConnectionFactories", result);
        }
        return result;
    }

    public ObjectName createJ2CAdminObject(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CAdminObject", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        String adminObjectInterface = (String)cmd.getParameter("adminObjectInterface");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input adminObjectInterface", adminObjectInterface);
        }
        ObjectName admObj = null;
        List admObjs = this.getAdminObjs(configService, session, ra);
        ArrayList attrList = null;
        for (ObjectName thisAdmObj : admObjs) {
            attrList = configService.getAttributes(session, thisAdmObj, new String[]{"adminObjectInterface"}, false);
            String aoInterface = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, "adminObjectInterface");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve adminObjectInterface", aoInterface);
            }
            if (!aoInterface.equals(adminObjectInterface)) continue;
            admObj = thisAdmObj;
            break;
        }
        if (admObj == null) {
            throw new InvalidParameterValueException(cmd.getName(), "adminObjectInterface", adminObjectInterface);
        }
        if (attrList == null) {
            attrList = new AttributeList();
        } else {
            attrList.clear();
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "adminObject", admObj);
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "name", cmd.getParameter("name"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "jndiName", cmd.getParameter("jndiName"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "description", cmd.getParameter("description"));
        ObjectName ao = configService.createConfigData(session, ra, "J2CAdminObject", "J2CAdminObject", (AttributeList)attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CAdminObject", ao);
        }
        return ao;
    }

    public String[] listAdminObjectInterfaces(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAdminObjectInterfaces", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        List admObjs = this.getAdminObjs(configService, session, ra);
        ArrayList<String> AOInterfaces = new ArrayList<String>(admObjs.size());
        for (ObjectName thisAdmObj : admObjs) {
            AttributeList attrList = configService.getAttributes(session, thisAdmObj, new String[]{"adminObjectInterface"}, false);
            String aoInterface = (String)ConfigServiceHelper.getAttributeValue(attrList, "adminObjectInterface");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve adminObjectInterface", aoInterface);
            }
            AOInterfaces.add(aoInterface);
        }
        String[] result = new String[AOInterfaces.size()];
        AOInterfaces.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAdminObjectInterfaces", result);
        }
        return result;
    }

    private List getAdminObjs(ConfigService configService, Session session, ObjectName ra) throws Exception {
        AttributeList attrList = configService.getAttributes(session, ra, new String[]{"deploymentDescriptor"}, false);
        ObjectName dd = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "deploymentDescriptor");
        attrList = configService.getAttributes(session, dd, new String[]{"resourceAdapter"}, false);
        ObjectName resourceAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "resourceAdapter");
        attrList = configService.getAttributes(session, resourceAdapter, new String[]{"adminObjects"}, false);
        List admObjs = (List)ConfigServiceHelper.getAttributeValue(attrList, "adminObjects");
        return admObjs;
    }

    public ObjectName[] listJ2CAdminObjects(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJ2CAdminObjects", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        String adminObjectInterface = (String)cmd.getParameter("adminObjectInterface");
        AttributeList attrList = configService.getAttributes(session, ra, new String[]{"j2cAdminObjects"}, false);
        List j2cAOs = (List)ConfigServiceHelper.getAttributeValue(attrList, "j2cAdminObjects");
        ArrayList<ObjectName> matchedJ2CAOs = new ArrayList<ObjectName>(j2cAOs.size());
        for (ObjectName thisAO : j2cAOs) {
            attrList = configService.getAttributes(session, thisAO, new String[]{"adminObject"}, false);
            ObjectName ao = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "adminObject");
            attrList = configService.getAttributes(session, ao, new String[]{"adminObjectInterface"}, false);
            String aoIf = (String)ConfigServiceHelper.getAttributeValue(attrList, "adminObjectInterface");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve adminObjectInterface", aoIf);
            }
            if (!aoIf.equals(adminObjectInterface)) continue;
            matchedJ2CAOs.add(thisAO);
        }
        ObjectName[] result = new ObjectName[matchedJ2CAOs.size()];
        matchedJ2CAOs.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listJ2CAdminObjects", result);
        }
        return result;
    }

    public ObjectName createJ2CActivationSpec(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CActivationSpec", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        String messageListenerType = (String)cmd.getParameter("messageListenerType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input messageListenerType", messageListenerType);
        }
        ObjectName actSpec = null;
        List msgLs = this.getMessageListeners(configService, session, ra);
        if (msgLs == null) {
            throw new InvalidParameterValueException(cmd.getName(), "Target", ra);
        }
        ArrayList attrList = null;
        for (ObjectName thisMsgl : msgLs) {
            ObjectName thisActSpec;
            attrList = configService.getAttributes(session, thisMsgl, new String[]{"messageListenerType"}, false);
            String mslType = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, "messageListenerType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve messageListenerType", mslType);
            }
            if (!mslType.equals(messageListenerType)) continue;
            attrList = configService.getAttributes(session, thisMsgl, new String[]{"activationSpec"}, false);
            actSpec = thisActSpec = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, "activationSpec");
            break;
        }
        if (actSpec == null) {
            throw new InvalidParameterValueException(cmd.getName(), "messageListenerType", messageListenerType);
        }
        if (attrList == null) {
            attrList = new AttributeList();
        } else {
            attrList.clear();
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "activationSpec", actSpec);
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "name", cmd.getParameter("name"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "jndiName", cmd.getParameter("jndiName"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "destinationJndiName", cmd.getParameter("destinationJndiName"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "description", cmd.getParameter("description"));
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "authenticationAlias", cmd.getParameter("authenticationAlias"));
        ObjectName act = configService.createConfigData(session, ra, "J2CActivationSpec", "J2CActivationSpec", (AttributeList)attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CActivationSpec", act);
        }
        return act;
    }

    public String[] listMessageListenerTypes(AbstractAdminCommand cmd) throws Exception {
        ObjectName ra;
        Session session;
        CommandProviderHelper helper;
        ConfigService configService;
        List msgLs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listMessageListenerTypes", cmd);
        }
        if ((msgLs = this.getMessageListeners(configService = (helper = this.getCommandProviderHelper()).getConfigService(), session = cmd.getConfigSession(), ra = (ObjectName)cmd.getTargetObject())) == null) {
            return new String[0];
        }
        ArrayList<String> ACTmsgTypes = new ArrayList<String>(msgLs.size());
        for (ObjectName thisActSpec : msgLs) {
            AttributeList attrList = configService.getAttributes(session, thisActSpec, new String[]{"messageListenerType"}, false);
            String mslType = (String)ConfigServiceHelper.getAttributeValue(attrList, "messageListenerType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve messageListenerType", mslType);
            }
            ACTmsgTypes.add(mslType);
        }
        String[] result = new String[ACTmsgTypes.size()];
        ACTmsgTypes.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listMessageListenerTypes", result);
        }
        return result;
    }

    private List getMessageListeners(ConfigService configService, Session session, ObjectName ra) throws Exception {
        AttributeList attrList = configService.getAttributes(session, ra, new String[]{"deploymentDescriptor"}, false);
        ObjectName dd = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "deploymentDescriptor");
        attrList = configService.getAttributes(session, dd, new String[]{"resourceAdapter"}, false);
        ObjectName resourceAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "resourceAdapter");
        attrList = configService.getAttributes(session, resourceAdapter, new String[]{"inboundResourceAdapter"}, false);
        ObjectName inBoundResourceAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "inboundResourceAdapter");
        if (inBoundResourceAdapter == null) {
            return null;
        }
        attrList = configService.getAttributes(session, inBoundResourceAdapter, new String[]{"messageAdapter"}, false);
        ObjectName messageAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "messageAdapter");
        attrList = configService.getAttributes(session, messageAdapter, new String[]{"messageListeners"}, false);
        List mesListeners = (List)ConfigServiceHelper.getAttributeValue(attrList, "messageListeners");
        return mesListeners;
    }

    public ObjectName[] listJ2CActivationSpecs(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJ2CActivationSpecs", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        String messageListenerType = (String)cmd.getParameter("messageListenerType");
        AttributeList attrList = configService.getAttributes(session, ra, new String[]{"j2cActivationSpec"}, false);
        List j2cACTs = (List)ConfigServiceHelper.getAttributeValue(attrList, "j2cActivationSpec");
        ArrayList<ObjectName> matchedJ2CACTs = new ArrayList<ObjectName>(j2cACTs.size());
        attrList = configService.getAttributes(session, ra, new String[]{"deploymentDescriptor"}, false);
        ObjectName dd = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "deploymentDescriptor");
        attrList = configService.getAttributes(session, dd, new String[]{"resourceAdapter"}, false);
        ObjectName resourceAdapter = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "resourceAdapter");
        ObjectName ira = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList = configService.getAttributes(session, resourceAdapter, new String[]{"inboundResourceAdapter"}, false), "inboundResourceAdapter");
        if (ira == null) {
            return null;
        }
        attrList = configService.getAttributes(session, ira, new String[]{"messageAdapter"}, false);
        ObjectName mad = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "messageAdapter");
        attrList = configService.getAttributes(session, mad, new String[]{"messageListeners"}, false);
        List msLs = (List)ConfigServiceHelper.getAttributeValue(attrList, "messageListeners");
        for (ObjectName thisACT : j2cACTs) {
            attrList = configService.getAttributes(session, thisACT, new String[]{"activationSpec"}, false);
            ObjectName act = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "activationSpec");
            String mstype = this.getMessageType(configService, session, msLs, act);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieve connectionFactoryInterface", mstype);
            }
            if (mstype == null || !mstype.equals(messageListenerType)) continue;
            matchedJ2CACTs.add(thisACT);
        }
        ObjectName[] result = new ObjectName[matchedJ2CACTs.size()];
        matchedJ2CACTs.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listJ2CActivationSpecs", result);
        }
        return result;
    }

    private String getMessageType(ConfigService configService, Session session, List msLs, ObjectName act) throws Exception {
        String mstype = null;
        for (int i = 0; i < msLs.size(); ++i) {
            ObjectName msl = (ObjectName)msLs.get(i);
            AttributeList attrList = configService.getAttributes(session, msl, new String[]{"activationSpec"}, false);
            ObjectName acttmp = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "activationSpec");
            if (!acttmp.equals(act)) continue;
            attrList = configService.getAttributes(session, msl, new String[]{"messageListenerType"}, false);
            mstype = (String)ConfigServiceHelper.getAttributeValue(attrList, "messageListenerType");
        }
        return mstype;
    }

    public ObjectName copyResourceAdapter(AbstractAdminCommand cmd) throws Exception {
        ArrayList attrList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "redeployResourceAdapter", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName ra = (ObjectName)cmd.getTargetObject();
        ObjectName scope = (ObjectName)cmd.getParameter("scope");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input scope", scope);
        }
        Boolean useDeepCopy = (Boolean)cmd.getParameter("useDeepCopy");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input useDeepCopy", useDeepCopy);
        }
        if ((attrList = null) == null) {
            attrList = new AttributeList();
        } else {
            attrList.clear();
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attrList, "name", cmd.getParameter("name"));
        ObjectName nra = configService.createConfigDataByTemplate(session, scope, "J2CResourceAdapter", (AttributeList)attrList, ra);
        if (!useDeepCopy.booleanValue()) {
            ObjectName[] j2cCFs = configService.getRelationship(session, nra, "J2CConnectionFactory");
            for (int i = 0; i < j2cCFs.length; ++i) {
                ObjectName thisCF = j2cCFs[i];
                configService.deleteConfigData(session, thisCF);
            }
            ObjectName[] cmpCFs = configService.getRelationship(session, nra, "CMPConnectorFactory");
            for (int i = 0; i < cmpCFs.length; ++i) {
                ObjectName thisCF = cmpCFs[i];
                configService.deleteConfigData(session, thisCF);
            }
            attrList = configService.getAttributes(session, nra, new String[]{"j2cAdminObjects"}, false);
            List aoList = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, "j2cAdminObjects");
            for (int i = 0; i < aoList.size(); ++i) {
                ObjectName jao = (ObjectName)aoList.get(i);
                configService.deleteConfigData(session, jao);
            }
            attrList = configService.getAttributes(session, nra, new String[]{"j2cActivationSpec"}, false);
            List acList = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attrList, "j2cActivationSpec");
            for (int i = 0; i < acList.size(); ++i) {
                ObjectName jac = (ObjectName)acList.get(i);
                configService.deleteConfigData(session, jac);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "redeployResourceAdapter", nra);
        }
        return nra;
    }

    public ObjectName installResourceAdapter(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{cmd});
        }
        String rarIsolatedClassLoaderStr = null;
        String rarEnableHASupportStr = null;
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        InstallRARTask myRARTask = new InstallRARTask(configService);
        String nodeName = (String)cmd.getParameter("nodeName");
        String rarPath = (String)cmd.getParameter("rarPath");
        String rarName = (String)cmd.getParameter("rar.name");
        String rarDesc = (String)cmd.getParameter("rar.desc");
        String rarArchivePath = (String)cmd.getParameter("rar.archivePath");
        String rarClasspath = (String)cmd.getParameter("rar.classpath");
        String rarNativePath = (String)cmd.getParameter("rar.nativePath");
        String rarThreadPoolAlias = (String)cmd.getParameter("rar.threadPoolAlias");
        Properties rarPropertiesSet = (Properties)cmd.getParameter("rar.propertiesSet");
        Boolean rarDeleteSourceRar = (Boolean)cmd.getParameter("rar.DeleteSourceRar");
        Boolean rarIsolatedClassLoader = (Boolean)cmd.getParameter("rar.isolatedClassLoader");
        Boolean rarEnableHASupport = (Boolean)cmd.getParameter("rar.enableHASupport");
        String rarHACapability = (String)cmd.getParameter("rar.HACapability");
        if (rarIsolatedClassLoader != null) {
            String string = rarIsolatedClassLoaderStr = rarIsolatedClassLoader != false ? "true" : "false";
        }
        if (rarEnableHASupport != null) {
            String string = rarEnableHASupportStr = rarEnableHASupport != false ? "true" : "false";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input nodeName", nodeName);
            Tr.debug(tc, "input rarPath", rarPath);
            Tr.debug(tc, "input rar.name", rarName);
            Tr.debug(tc, "input rar.desc", rarDesc);
            Tr.debug(tc, "input rar.archivePath", rarArchivePath);
            Tr.debug(tc, "input rar.classpath", rarClasspath);
            Tr.debug(tc, "input rar.nativePath", rarNativePath);
            Tr.debug(tc, "input rar.threadPoolAlias", rarThreadPoolAlias);
            Tr.debug(tc, "input rar.propertiesSet", rarPropertiesSet);
            Tr.debug(tc, "input rar.DeleteSourceRar", rarDeleteSourceRar);
            Tr.debug(tc, "input rar.isolatedClassLoader", rarIsolatedClassLoader);
            Tr.debug(tc, "input rar.enableHASupport", rarEnableHASupport);
            Tr.debug(tc, "input rar.HACapability", rarHACapability);
        }
        Hashtable<String, Object> optProps = new Hashtable<String, Object>();
        if (rarName != null) {
            optProps.put("rar.name", rarName);
        }
        if (rarDesc != null) {
            optProps.put("rar.desc", rarDesc);
        }
        if (rarArchivePath != null) {
            optProps.put("rar.archivePath", rarArchivePath);
        }
        if (rarClasspath != null) {
            optProps.put("rar.classpath", rarClasspath);
        }
        if (rarNativePath != null) {
            optProps.put("rar.nativePath", rarNativePath);
        }
        if (rarThreadPoolAlias != null) {
            optProps.put("rar.threadPoolAlias", rarThreadPoolAlias);
        }
        if (rarPropertiesSet != null) {
            optProps.put("rar.propertiesSet", rarPropertiesSet);
        }
        if (rarDeleteSourceRar != null) {
            optProps.put("rar.DeleteSourceRar", rarDeleteSourceRar);
        }
        if (rarIsolatedClassLoaderStr != null) {
            optProps.put("rar.isolatedClassLoader", rarIsolatedClassLoaderStr);
        }
        if (rarEnableHASupportStr != null) {
            optProps.put("rar.enableHASupport", rarEnableHASupportStr);
        }
        if (rarHACapability != null) {
            optProps.put("rar.HACapability", rarHACapability);
        }
        ObjectName newObj = myRARTask.installResourceAdapter(session, nodeName, rarPath, optProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter");
        }
        return newObj;
    }
}

