/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cluster;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.bla.model.ModelHelper;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.MemberNodeVersionException;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.management.commands.server.CreateServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ClusterConfigHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ClusterConfigHelper.class, "ClusterConfig", "com.ibm.ws.management.resources.configservice");
    private static String RESOURCES_SCOPE = "resourcesScope";
    private static String RESOURCES_SCOPE_BOTH = "both";
    private static String RESOURCES_SCOPE_CLUSTER = "cluster";
    private static String RESOURCES_SCOPE_SERVER = "server";

    public static ObjectName getClusterObj(ConfigService cs, Session session, String clusterName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterObj");
        }
        ObjectName[] matches = null;
        ObjectName theClusterObj = null;
        String clusterSpec = "ServerCluster=" + clusterName;
        Tr.debug(tc, "Resolving cluster object " + clusterSpec);
        matches = cs.resolve(session, clusterSpec);
        if (matches.length > 0) {
            theClusterObj = matches[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterObj");
        }
        return theClusterObj;
    }

    public static ObjectName getServerObj(ConfigService cs, Session session, String serverNode, String serverName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerObj");
        }
        ObjectName[] matches = null;
        ObjectName theServerObj = null;
        String serverSpec = "Node=" + serverNode + ":Server=" + serverName;
        Tr.debug(tc, "Resolving server object " + serverSpec);
        matches = cs.resolve(session, serverSpec);
        if (matches.length > 0) {
            theServerObj = matches[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerObj");
        }
        return theServerObj;
    }

    public static ObjectName getNodeObj(ConfigService cs, Session session, String nodeName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeObj");
        }
        ObjectName[] matches = null;
        ObjectName theNodeObj = null;
        Tr.debug(tc, "Resolving node object " + nodeName);
        matches = cs.resolve(session, "Node=" + nodeName);
        if (matches.length > 0) {
            theNodeObj = matches[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeObj");
        }
        return theNodeObj;
    }

    public static AppManagement getAppManagement(ConfigService cs) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppManagement");
        }
        AppManagement appmgr = null;
        try {
            appmgr = cs instanceof ConfigServiceProxy ? AppManagementProxy.getJMXProxyForClient(((ConfigServiceProxy)cs).getAdminClient()) : (AdminServiceFactory.getAdminService() == null ? AppManagementProxy.getLocalProxy() : AppManagementProxy.getJMXProxyForServer());
        }
        catch (Exception e) {
            String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9240E", new Object[]{e.toString()});
            throw new ClusterConfigException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagement");
        }
        return appmgr;
    }

    public static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args) {
        String message = null;
        try {
            message = bundle.getString(key);
            if (message == null) {
                message = new String("Cannot find message key " + key + "in resource bundle" + bundle.toString());
                Tr.event(tc, message);
            }
            message = MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            message = new String("Cannot find message key " + key + "in resource bundle " + bundle.toString());
            Tr.event(tc, message);
            return message;
        }
        catch (NullPointerException npe) {
            message = new String("Null pointer exception caught trying to find message key " + key + " in resource bundle " + bundle.toString());
            Tr.event(tc, message);
        }
        return message;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectName convertServerToClusterMember(ConfigService cs, Session session, ObjectName serverObj, ObjectName clusterObj, Integer memberWeight) throws ClusterConfigException, ConfigServiceException, ConnectorException {
        ObjectName memberObj;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertServerToClusterMember");
            }
            memberObj = null;
            ObjectName nodeObj = null;
            Object pattern = null;
            ObjectName[] matches = null;
            AttributeList attrList = new AttributeList();
            String clusterName = ConfigServiceHelper.getDisplayName(clusterObj);
            String serverName = ConfigServiceHelper.getDisplayName(serverObj);
            String serverNode = null;
            boolean success = false;
            try {
                matches = null;
                matches = cs.getRelationship(session, serverObj, "parent");
                if (matches.length < 1) {
                    String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9241E", new Object[]{serverName});
                    throw new ClusterConfigException(msg);
                }
                nodeObj = matches[0];
                serverNode = ConfigServiceHelper.getDisplayName(nodeObj);
                Tr.debug(tc, "Adding server to new cluster.");
                attrList.clear();
                attrList.add(new Attribute("memberName", serverName));
                attrList.add(new Attribute("nodeName", serverNode));
                if (memberWeight != null) {
                    attrList.add(new Attribute("weight", memberWeight));
                }
                String memberUUID = String.valueOf(System.currentTimeMillis());
                ConfigServiceHelper.setAttributeValue(attrList, "uniqueId", memberUUID);
                memberObj = cs.createConfigData(session, clusterObj, "members", "ClusterMember", attrList);
                Tr.debug(tc, "Setting server's cluster name.");
                attrList.clear();
                attrList.add(new Attribute("clusterName", clusterName));
                cs.setAttributes(session, serverObj, attrList);
                Tr.debug(tc, "Informing App Management that server is now a member.");
                AppManagement appmgr = ClusterConfigHelper.getAppManagement(cs);
                Properties props = ConfigServiceHelper.getObjectLocation(serverObj);
                ObjectName serverId = ConfigServiceHelper.createObjectName("WebSphere", props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverId", serverId);
                }
                Properties cellProps = new Properties();
                String cellName = props.getProperty("cell");
                cellProps.put("cell", cellName);
                cellProps.put("cluster", clusterName);
                ObjectName clusterId = ConfigServiceHelper.createObjectName("WebSphere", cellProps);
                appmgr.changeServerToCluster(serverId, clusterId, null, session.toString());
                ModelHelper fact = ModelHelper.getSingleton();
                fact.changeServerToClusterForCUs(serverId, clusterId, session.toString());
                success = true;
                if (success || memberObj == null) break block14;
            }
            catch (ClusterConfigException e) {
                try {
                    throw e;
                    catch (MalformedObjectNameException e2) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{serverName, serverNode, clusterName, e2.toString()});
                        throw new ClusterConfigException(e2, msg);
                    }
                    catch (ConfigServiceException e3) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{serverName, serverNode, clusterName, e3.toString()});
                        throw new ClusterConfigException(e3, msg);
                    }
                    catch (ConnectorException e4) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{serverName, serverNode, clusterName, e4.toString()});
                        throw new ClusterConfigException(e4, msg);
                    }
                    catch (AdminException e5) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{serverName, serverNode, clusterName, e5.toString()});
                        throw new ClusterConfigException(e5, msg);
                    }
                }
                catch (Throwable throwable) {
                    if (!success && memberObj != null) {
                        cs.deleteConfigData(session, memberObj);
                    }
                    throw throwable;
                }
            }
            cs.deleteConfigData(session, memberObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertServerToClusterMember");
        }
        return memberObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectName createClusterMemberFromTemplate(ConfigService cs, Session session, String memberName, String memberNode, ObjectName clusterObj, ObjectName templateObj, String memberUUID, String cgName, String ngName, Boolean genUniquePorts, String clusterType, String templateName, Boolean enableDataReplication, String shortName) throws ClusterConfigException, ConfigServiceException, ConnectorException {
        String clusterName;
        AttributeList serverAttrList;
        String cName;
        ObjectName memberObj;
        block49: {
            block50: {
                AttributeList memberAttrList;
                ObjectName serverObj;
                block48: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "createClusterMemberFromTemplate", new Object[]{memberName, memberNode, clusterObj, templateObj, cgName, ngName, enableDataReplication});
                    }
                    memberObj = null;
                    serverObj = null;
                    ObjectName nodeObj = null;
                    Object matches = null;
                    nodeObj = ClusterConfigHelper.getNodeObj(cs, session, memberNode);
                    if (nodeObj == null) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9218E", new Object[]{memberNode});
                        throw new ClusterConfigException(msg);
                    }
                    memberAttrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(memberAttrList, "memberName", memberName);
                    ConfigServiceHelper.setAttributeValue(memberAttrList, "nodeName", ConfigServiceHelper.getDisplayName(nodeObj));
                    if (memberUUID == null) {
                        memberUUID = String.valueOf(System.currentTimeMillis());
                    }
                    ConfigServiceHelper.setAttributeValue(memberAttrList, "uniqueId", memberUUID);
                    cName = null;
                    serverAttrList = new AttributeList();
                    clusterName = ConfigServiceHelper.getDisplayName(clusterObj);
                    try {
                        if (templateObj != null) {
                            cName = (String)cs.getAttribute(session, templateObj, "clusterName");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterName in template is " + cName);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot set clusterName when template is not choosen");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clusterName in template is " + cName);
                        }
                        if (templateObj == null || cName != null && !cName.equals("") && (cName == null || cName.equals(clusterName))) break block48;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clusterName is not set in template");
                        }
                        ConfigServiceHelper.setAttributeValue(serverAttrList, "clusterName", clusterName);
                        cs.setAttributes(session, templateObj, serverAttrList);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clusterName is set in template");
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                serverAttrList.clear();
                if (genUniquePorts != null) {
                    ConfigServiceHelper.setAttributeValue(serverAttrList, "adjustPort", genUniquePorts);
                }
                boolean success = false;
                try {
                    try {
                        ObjectName templateLocation = null;
                        if (templateName != null) {
                            templateLocation = templateObj;
                        } else if (templateObj != null) {
                            templateName = ConfigServiceHelper.getDisplayName(templateObj);
                            templateLocation = ClusterConfigHelper.getTemplateLocation(cs, session, templateObj);
                        }
                        String clusterShortName = null;
                        if (AdminHelper.getPlatformHelper().isZOS()) {
                            clusterShortName = (String)cs.getAttribute(session, clusterObj, "shortName");
                        }
                        serverObj = ClusterConfigHelper.createClusterMember(cs, session, memberNode, memberName, templateLocation, cgName, genUniquePorts, templateName, clusterType, shortName, clusterShortName, clusterName);
                        if (enableDataReplication != null && enableDataReplication.booleanValue()) {
                            ObjectName sessionMgr = cs.queryConfigObjects(session, serverObj, ConfigServiceHelper.createObjectName(null, "SessionManager"), null)[0];
                            AttributeList attrList = new AttributeList();
                            attrList.add(new Attribute("sessionPersistenceMode", "DATA_REPLICATION"));
                            cs.setAttributes(session, sessionMgr, attrList);
                            attrList.clear();
                            attrList.add(new Attribute("messageBrokerDomainName", ConfigServiceHelper.getDisplayName(clusterObj)));
                            cs.createConfigData(session, sessionMgr, "sessionDRSPersistence", "DRSSettings", attrList);
                        }
                        memberObj = cs.createConfigData(session, clusterObj, "members", "ClusterMember", memberAttrList);
                        serverAttrList.clear();
                        ConfigServiceHelper.setAttributeValue(serverAttrList, "name", memberName);
                        ConfigServiceHelper.setAttributeValue(serverAttrList, "clusterName", ConfigServiceHelper.getDisplayName(clusterObj));
                        cs.setAttributes(session, serverObj, serverAttrList);
                        ObjectName serverId = ConfigServiceHelper.createObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(serverObj));
                        ObjectName clusterId = ConfigServiceHelper.createObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(clusterObj));
                        ClusterConfigHelper.getAppManagement(cs).clusterMemberAdded(serverId, clusterId, null, session.toString());
                        if (ngName != null && ngName.length() > 0) {
                            String oldNodeGroupName = (String)cs.getAttribute(session, clusterObj, "nodeGroupName");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nodeGroupName", oldNodeGroupName);
                            }
                            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
                            ObjectName[] currentMemberObjs = cs.queryConfigObjects(session, clusterObj, pattern, null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "There are currently " + currentMemberObjs.length + " members in cluster " + ConfigServiceHelper.getDisplayName(clusterObj));
                            }
                            if (currentMemberObjs != null && currentMemberObjs.length == 1) {
                                AttributeList list = new AttributeList();
                                ConfigServiceHelper.setAttributeValue(list, "nodeGroupName", ngName);
                                cs.setAttributes(session, clusterObj, list);
                            }
                        }
                        success = true;
                    }
                    catch (ClusterConfigException e) {
                        throw e;
                    }
                    catch (MalformedObjectNameException e) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{memberName, memberNode, ConfigServiceHelper.getDisplayName(clusterObj), e.toString()});
                        throw new ClusterConfigException(e, msg);
                    }
                    catch (ConfigServiceException e) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{memberName, memberNode, ConfigServiceHelper.getDisplayName(clusterObj), e.toString()});
                        throw new ClusterConfigException(e, msg);
                    }
                    catch (ConnectorException e) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{memberName, memberNode, ConfigServiceHelper.getDisplayName(clusterObj), e.toString()});
                        throw new ClusterConfigException(e, msg);
                    }
                    catch (AdminException e) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{memberName, memberNode, ConfigServiceHelper.getDisplayName(clusterObj), e.toString()});
                        throw new ClusterConfigException(e, msg);
                    }
                    catch (Exception e) {
                        String msg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{memberName, memberNode, ConfigServiceHelper.getDisplayName(clusterObj), e.toString()});
                        throw new ClusterConfigException(e, msg);
                    }
                    Object var32_44 = null;
                    if (success) break block49;
                    if (serverObj == null) break block50;
                }
                catch (Throwable throwable) {
                    Object var32_45 = null;
                    if (!success) {
                        if (serverObj != null) {
                            cs.deleteConfigData(session, serverObj);
                        }
                        if (memberObj != null) {
                            cs.deleteConfigData(session, memberObj);
                        }
                    }
                    try {
                        if (templateObj != null && (cName == null || cName.equals(""))) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterName is being removed from template");
                            }
                            String[] aList = new String[]{"clusterName"};
                            cs.unsetAttributes(session, templateObj, aList);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterName is removed from template");
                            }
                            cName = (String)cs.getAttribute(session, templateObj, "clusterName");
                            if (!tc.isDebugEnabled()) throw throwable;
                            Tr.debug(tc, "check again for clusterName " + cName);
                            throw throwable;
                        }
                        if (cName == null) throw throwable;
                        if (cName.equals(clusterName)) throw throwable;
                        serverAttrList.clear();
                        ConfigServiceHelper.setAttributeValue(serverAttrList, "clusterName", cName);
                        cs.setAttributes(session, templateObj, serverAttrList);
                        if (!tc.isDebugEnabled()) throw throwable;
                        Tr.debug(tc, "clusterName is reset in template");
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                cs.deleteConfigData(session, serverObj);
            }
            if (memberObj != null) {
                cs.deleteConfigData(session, memberObj);
            }
        }
        try {}
        catch (Exception e) {}
        if (templateObj != null && (cName == null || cName.equals(""))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterName is being removed from template");
            }
            String[] aList = new String[]{"clusterName"};
            cs.unsetAttributes(session, templateObj, aList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterName is removed from template");
            }
            cName = (String)cs.getAttribute(session, templateObj, "clusterName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "check again for clusterName " + cName);
            }
        } else if (cName != null && !cName.equals(clusterName)) {
            serverAttrList.clear();
            ConfigServiceHelper.setAttributeValue(serverAttrList, "clusterName", cName);
            cs.setAttributes(session, templateObj, serverAttrList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterName is reset in template");
            }
        }
        if (!tc.isEntryEnabled()) return memberObj;
        Tr.exit(tc, "createClusterMemberFromTemplate");
        return memberObj;
    }

    public static ObjectName createClusterMember(ConfigService cs, Session session, String nodeName, String serverName, ObjectName templateLocation, String cgName, Boolean genUniquePorts, String templateName, String clusterType, String shortName) throws ClusterConfigException {
        return ClusterConfigHelper.createClusterMember(cs, session, nodeName, serverName, templateLocation, cgName, genUniquePorts, templateName, clusterType, shortName, null);
    }

    public static ObjectName createClusterMember(ConfigService cs, Session session, String nodeName, String serverName, ObjectName templateLocation, String cgName, Boolean genUniquePorts, String templateName, String clusterType, String shortName, String clusterShortName) throws ClusterConfigException {
        return ClusterConfigHelper.createClusterMember(cs, session, nodeName, serverName, templateLocation, cgName, genUniquePorts, templateName, clusterType, shortName, clusterShortName, null);
    }

    private static ObjectName createClusterMember(ConfigService cs, Session session, String nodeName, String serverName, ObjectName templateLocation, String cgName, Boolean genUniquePorts, String templateName, String clusterType, String shortName, String clusterShortName, String clusterName) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember");
        }
        ObjectName obj = null;
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            TaskCommand cmd = null;
            cmd = clusterType != null ? (clusterType.equals("PROXY_SERVER") ? (TaskCommand)cmdMgr.createCommand("createProxyServer") : (clusterType.equals("ONDEMAND_ROUTER") ? (TaskCommand)cmdMgr.createCommand("createOnDemandRouter") : (TaskCommand)cmdMgr.createCommand("createApplicationServer"))) : (TaskCommand)cmdMgr.createCommand("createApplicationServer");
            cmd.setConfigSession(session);
            cmd.setTargetObject(nodeName);
            cmd.setParameter("name", serverName);
            if (genUniquePorts == null) {
                cmd.setParameter("genUniquePorts", new Boolean(true));
            } else {
                cmd.setParameter("genUniquePorts", genUniquePorts);
            }
            if (templateName != null) {
                cmd.setParameter("templateName", templateName);
                if (templateLocation != null) {
                    cmd.setParameter("templateLocation", templateLocation);
                }
            } else if (templateLocation != null) {
                cmd.setParameter("templateName", "clusterMember");
                cmd.setParameter("templateLocation", templateLocation);
            }
            if (shortName != null) {
                cmd.setParameter("specificShortName", shortName);
            }
            if (clusterShortName != null) {
                cmd.setParameter("genericShortName", clusterShortName);
            }
            if (clusterName != null) {
                cmd.setParameter("clusterName", clusterName);
            }
            if (cgName != null) {
                CommandStep step = cmd.getCommandStep("ConfigCoreGroup");
                step.setParameter("coregroupName", cgName);
            }
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ClusterConfigException(res.getException(), (String)errMsg);
                }
                throw new ClusterConfigException(res.getException());
            }
            obj = (ObjectName)res.getResult();
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember");
        }
        return obj;
    }

    public static void deleteClusterMember(ConfigService cs, Session session, String nodeName, String serverName, String cgName) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteClusterMember");
        }
        Object obj = null;
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            TaskCommand cmd = (TaskCommand)cmdMgr.createCommand("deleteServer");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("serverName", serverName);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ClusterConfigException(res.getException(), (String)errMsg);
                }
                throw new ClusterConfigException(res.getException());
            }
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteClusterMember");
        }
    }

    public static void addDefaultResources(ConfigService cs, Session session, String clusterName) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDefaultResources", clusterName);
        }
        try {
            RepositoryContextType type;
            RepositoryContext rootContext;
            Collection match;
            String serverType;
            RepositoryContext serverTypeContext;
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            RepositoryContextType serverContextType = metadata2.getContextType("servers");
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)ws);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            if (templateContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template context");
                }
                throw new ClusterConfigException("Cannot find template context");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context ", templateContext);
            }
            if ((serverTypeContext = templateContext.getChild(serverTypeContextType, serverType = "APPLICATION_SERVER")) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find server type context");
                }
                throw new ClusterConfigException("Cannot find server type context");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for servertypes", serverTypeContext);
            }
            List servers = serverTypeContext.getChildren();
            RepositoryContext sCtx = null;
            Iterator it = servers.iterator();
            while (it.hasNext() && !(sCtx = (RepositoryContext)it.next()).getName().equals("default")) {
            }
            if (sCtx == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template for default server");
                }
                throw new ClusterConfigException("Cannot find default server template context");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for server", sCtx.getName());
            }
            if ((match = (rootContext = ws.getRootContext()).findContext(type = metadata2.getContextType("cells"))) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find cell context");
                }
                throw new ClusterConfigException("Cannot find cell context");
            }
            RepositoryContext cellContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cell", cellContext.getName());
            }
            if ((match = cellContext.findContext("clusters", clusterName)) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find cluster context for cluster " + clusterName);
                }
                throw new ClusterConfigException("Cannot find cluster context for " + clusterName);
            }
            RepositoryContext clusterContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cluster", clusterContext.getName());
            }
            ClusterConfigHelper.copyFile(clusterContext, sCtx, clusterName, "resources.xml");
            ObjectName clusterObj = ClusterConfigHelper.getClusterObj(cs, session, clusterName);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "DataSource");
            ObjectName[] dataSources = cs.queryConfigObjects(session, clusterObj, pattern, null);
            if (dataSources != null) {
                if (dataSources.length != 1 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Warning: Number of cluster data sources = " + dataSources.length + "!");
                }
                for (int i = 0; i < dataSources.length; ++i) {
                    String name;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dataSources[" + i + "] = " + dataSources[i]);
                    }
                    if ((name = ConfigServiceHelper.getDisplayName(dataSources[i])).equals("DefaultEJBTimerDataSource")) {
                        cs.deleteConfigData(session, dataSources[i]);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Removed data source " + name);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Warning: data source " + name + " did not match!");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: dataSources is null!");
            }
            try {
                ClusterConfigHelper.copyFile(clusterContext, sCtx, clusterName, "resources-pme.xml");
                ClusterConfigHelper.copyFile(clusterContext, sCtx, clusterName, "resources-pme502.xml");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to copy PME resources to cluster ", clusterContext.getName());
                }
            }
        }
        catch (ClusterConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDefaultResources");
        }
    }

    private static void copyFile(RepositoryContext parentContext, RepositoryContext templateContext, String contextName, String uri) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{parentContext, templateContext, contextName, uri});
        }
        TemplateManager templateMgr = TemplateManagerFactory.getManager((WorkSpace)parentContext.getWorkSpace());
        Template template = templateMgr.getTemplate(templateContext);
        templateMgr.createFile(parentContext, uri, template, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static Boolean isMemberCompatibleWithNode(ConfigService cs, Session session, String nodeName, ObjectName nodeObj, String memberNode, String memberName, ObjectName firstMemberObj) throws ClusterConfigException, MemberNodeVersionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMemberCompatibleWithNode");
        }
        Boolean compatible = new Boolean(true);
        Properties mhProps = new Properties();
        Object nodeProps = null;
        Object clusterName = null;
        String errorMsg = null;
        ObjectName cellObj = null;
        Object pattern = null;
        ObjectName[] matches = null;
        AttributeList attrList = new AttributeList();
        try {
            matches = cs.resolve(session, "Cell");
            if (matches.length < 1) {
                errorMsg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9211E", null);
                throw new ClusterConfigException(errorMsg);
            }
            cellObj = matches[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper.");
            }
            mhProps.setProperty("local.cell", ConfigServiceHelper.getDisplayName(cellObj));
            String installRoot = System.getProperty("was.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "was.install.root=" + (installRoot == null ? "null" : installRoot));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper");
            }
            ManagedObjectMetadataHelper mh = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            String memberVersion = mh.getNodeBaseProductVersion(memberNode);
            String nodeVersion = mh.getNodeBaseProductVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberNode=" + memberNode + "  memberVersion=" + memberVersion);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName=" + nodeName + "  nodeVersion=" + nodeVersion);
            }
            compatible = ClusterConfigHelper.checkNodeVersions(memberVersion, nodeVersion);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Excption caught during checkoing node version for compatibility ", nodeName + " " + memberNode);
            }
            throw new ClusterConfigException(e, errorMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMemberCompatibleWithNode");
        }
        return compatible;
    }

    public static String getEffectiveNodeVersion(String nodeVersion) {
        int index = nodeVersion.indexOf(".");
        String effectiveVersion = nodeVersion;
        if (index < 0) {
            return effectiveVersion;
        }
        effectiveVersion = nodeVersion.startsWith("6.1") ? "6.1" : nodeVersion.substring(0, index);
        return effectiveVersion;
    }

    public static Boolean checkNodeVersions(String nodeVersion1, String nodeVersion2) {
        String v2;
        Boolean compatible = Boolean.FALSE;
        if (nodeVersion1 == null || nodeVersion2 == null) {
            return compatible;
        }
        String v1 = ClusterConfigHelper.getEffectiveNodeVersion(nodeVersion1);
        compatible = !v1.equals(v2 = ClusterConfigHelper.getEffectiveNodeVersion(nodeVersion2)) ? Boolean.FALSE : Boolean.TRUE;
        return compatible;
    }

    public static String getMemberNodeVersion(ConfigService cs, Session session, String nodeName) throws ClusterConfigException, MemberNodeVersionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberNodeVersion");
        }
        ObjectName[] matches = null;
        Properties mhProps = new Properties();
        Object nodeProps = null;
        String nodeVersion = null;
        String errorMsg = null;
        ObjectName cellObj = null;
        try {
            matches = cs.resolve(session, "Cell");
            if (matches.length < 1) {
                errorMsg = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9211E", null);
                throw new ClusterConfigException(errorMsg);
            }
            cellObj = matches[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper.");
            }
            mhProps.setProperty("local.cell", ConfigServiceHelper.getDisplayName(cellObj));
            String installRoot = System.getProperty("was.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "was.install.root=" + (installRoot == null ? "null" : installRoot));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper");
            }
            ManagedObjectMetadataHelper mh = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            nodeVersion = mh.getNodeBaseProductVersion(nodeName);
            nodeVersion = ClusterConfigHelper.getEffectiveNodeVersion(nodeVersion);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName=" + nodeName + "  nodeVersion=" + nodeVersion);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Excption caught during get node major version for node ", nodeName);
            }
            throw new ClusterConfigException(e, errorMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberNodeVersion");
        }
        return nodeVersion;
    }

    public static String getClusterType(ConfigService cs, Session session, ObjectName cluster) {
        String type = null;
        try {
            type = (String)cs.getAttribute(session, cluster, "serverType");
        }
        catch (ConfigServiceException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return type;
    }

    public static ObjectName getBestMemberTemplate(ConfigService cs, Session session, ObjectName clusterObj, String memberNodeVersion, String nodeName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBestMemberTemplate", clusterObj + " " + memberNodeVersion + " " + nodeName);
        }
        ObjectName memberTemplate2 = null;
        ObjectName finalMemberTemplate = null;
        boolean i = false;
        String serverType = "APPLICATION_SERVER";
        serverType = ClusterConfigHelper.getClusterType(cs, session, clusterObj);
        if (serverType == null || serverType.equals("")) {
            serverType = "APPLICATION_SERVER";
        }
        int lastMatch = 0;
        Integer lastMatchInt = null;
        try {
            lastMatchInt = TemplateConfigHelper.getDefaultTemplateMatchCount(cs, session, serverType, nodeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (lastMatchInt != null) {
            lastMatch = lastMatchInt;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "required matchcount = ", new Integer(lastMatch));
        }
        List memberTemplates = new ArrayList();
        try {
            memberTemplates = ClusterConfigHelper.getMemberTemplates(cs, session, clusterObj, memberNodeVersion);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ObjectName memberTemplate2 : memberTemplates) {
            int newMatch = 0;
            try {
                newMatch = TemplateConfigHelper.getMatchCount(cs, session, memberTemplate2, nodeName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (newMatch < lastMatch) continue;
            ArrayList errors = new ArrayList();
            try {
                Class<?> appClass = Class.forName("com.ibm.websphere.management.application.AppDeploymentUtil");
                Method method = appClass.getMethod("isNodeValidForCluster", String.class, String.class, String.class, String.class, Locale.class, List.class);
                method.invoke(null, TemplateConfigHelper.getCellName(cs, session, clusterObj), nodeName, ConfigServiceHelper.getDisplayName(clusterObj), session.toString(), Locale.getDefault(), errors);
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", (String)"291");
            }
            if (errors.size() > 0) continue;
            lastMatch = newMatch;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new match = ", lastMatch + " for " + memberTemplate2);
            }
            finalMemberTemplate = memberTemplate2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBestMemberTemplate", finalMemberTemplate);
        }
        return finalMemberTemplate;
    }

    public static ObjectName getMemberTemplate(ConfigService cs, Session session, ObjectName clusterObj, String memberNodeVersion) throws ConfigServiceException, ConnectorException {
        Collection servers;
        block19: {
            RepositoryContext clusterContext;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getMemberTemplate", clusterObj + " " + memberNodeVersion);
                }
                String clusterName = ConfigServiceHelper.getDisplayName(clusterObj);
                Object matches = null;
                clusterContext = null;
                try {
                    clusterContext = ClusterConfigHelper.getClusterTemplateContext(clusterName, session);
                }
                catch (ClusterConfigException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMemberTemplate", "Cannot get cluster template context");
                    }
                    try {
                        throw new ClusterConfigException(e, e.getMessage());
                    }
                    catch (ClusterConfigException e2) {
                        if (!tc.isEntryEnabled()) break block18;
                        Tr.exit(tc, "getMemberTemplate", "Failed throwing ClusterConfigException " + e2);
                    }
                }
            }
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            servers = null;
            try {
                servers = clusterContext.findContext(metadata2.getContextType("servers"));
            }
            catch (WorkSpaceException we) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMemberTemplate", "Cannot get cluster template server list");
                }
                try {
                    throw new ClusterConfigException(we, we.getMessage());
                }
                catch (ClusterConfigException e2) {
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit(tc, "getMemberTemplate", "Failed throwing ClusterConfigException " + e2);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of server contexts = " + servers.size());
        }
        Iterator iterator = servers.iterator();
        RepositoryContext finalContext = null;
        while (iterator.hasNext()) {
            RepositoryContext rc = (RepositoryContext)iterator.next();
            String name = rc.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template for server " + name);
            }
            if (!name.equals("V" + memberNodeVersion + "MemberTemplate")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching server context name " + name);
            }
            finalContext = rc;
        }
        if (finalContext != null) {
            ObjectName serverObj = MOFUtil.createObjectName(finalContext);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMemberTemplate", serverObj);
            }
            return serverObj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberTemplate", null);
        }
        return null;
    }

    public static ObjectName createMemberTemplate(ConfigService cs, Session session, ObjectName memberObject, ObjectName clusterObject, String memberNodeVersion) throws ClusterConfigException {
        ObjectName templateObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMemberTemplate", clusterObject + " " + memberNodeVersion);
        }
        try {
            List memberTemplates = ClusterConfigHelper.getMemberTemplates(cs, session, clusterObject, memberNodeVersion);
            String newTemplateName = ClusterConfigHelper.getNewMemberTemplate(cs, session, memberTemplates, memberNodeVersion);
            Properties props = ConfigServiceHelper.getObjectLocation(memberObject);
            String nodeName = props.getProperty("node");
            String serverName = props.getProperty("server");
            String clusterName = ConfigServiceHelper.getDisplayName(clusterObject);
            String templateName = newTemplateName;
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            TaskCommand cmd = (TaskCommand)cmdMgr.createCommand("createApplicationServerTemplate");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("serverName", serverName);
            cmd.setParameter("templateName", templateName);
            RepositoryContext clusterContext = null;
            try {
                clusterContext = ClusterConfigHelper.getClusterTemplateContext(clusterName, session);
            }
            catch (ClusterConfigException e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMemberTemplate", "Cannot get cluster template context");
                }
                throw new ClusterConfigException(e, e.getMessage());
            }
            ObjectName clusterCtxON = MOFUtil.createObjectName(clusterContext);
            cmd.setParameter("templateLocation", clusterCtxON);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ClusterConfigException(res.getException(), (String)errMsg);
                }
                throw new ClusterConfigException(res.getException());
            }
            templateObj = (ObjectName)res.getResult();
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMemberTemplate", templateObj);
        }
        return templateObj;
    }

    public static ObjectName getTemplateLocation(ConfigService cs, Session session, ObjectName templateObj) throws ConfigServiceException, ConnectorException {
        ObjectName templateLocation = null;
        Properties loc = ConfigServiceHelper.getObjectLocation(templateObj);
        String templateServerType = loc.getProperty("servertype");
        String templateServerName = loc.getProperty("server");
        String templateNodeName = loc.getProperty("node");
        if (templateNodeName != null) {
            templateLocation = ClusterConfigHelper.getNodeObj(cs, session, templateNodeName);
        }
        return templateLocation;
    }

    public static String getCoreGroupForServer(ConfigService cs, Session session, String nodeName, String serverName) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoreGroupForServer", nodeName + " " + serverName);
        }
        String coreGroup = null;
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = cmdMgr.createCommand("getCoreGroupNameForServer");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("serverName", serverName);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ClusterConfigException(res.getException(), (String)errMsg);
                }
                throw new ClusterConfigException(res.getException());
            }
            coreGroup = (String)res.getResult();
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoreGroupForServer", coreGroup);
        }
        return coreGroup;
    }

    public static void changeClusterShortName(ConfigService cs, Session session, String clusterName, String shortName) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterShortName", clusterName + " " + shortName);
        }
        Object coreGroup = null;
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = cmdMgr.createCommand("changeClusterShortName");
            cmd.setConfigSession(session);
            cmd.setParameter("clusterName", clusterName);
            cmd.setParameter("shortName", shortName);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ClusterConfigException(res.getException(), (String)errMsg);
                }
                throw new ClusterConfigException(res.getException());
            }
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterShortName", clusterName);
        }
    }

    private static boolean noMoreMembers(ConfigService cs, Session session, ObjectName[] members, String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "noMoreMembers ", version);
        }
        boolean result = true;
        for (int i = 0; i < members.length; ++i) {
            String nodeName = null;
            String nodeVersion = null;
            try {
                nodeName = (String)cs.getAttribute(session, members[i], "nodeName");
                nodeVersion = ClusterConfigHelper.getMemberNodeVersion(cs, session, nodeName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node  ", nodeName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "version ", nodeVersion);
            }
            if (nodeVersion == null || !nodeVersion.equals(version)) continue;
            result = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "noMoreMembers", new Boolean(result));
        }
        return result;
    }

    public static void deleteMemberTemplate(ConfigService cs, Session session, String clusterName, ObjectName clusterObj, String memberNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTemplate ", memberNode);
        }
        ObjectName memberPattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
        ObjectName[] currentMemberObjs = cs.queryConfigObjects(session, clusterObj, memberPattern, null);
        String memberNodeVersion = ClusterConfigHelper.getMemberNodeVersion(cs, session, memberNode);
        boolean done = false;
        boolean j = false;
        List memberTemplates = ClusterConfigHelper.getMemberTemplates(cs, session, clusterObj, memberNodeVersion);
        for (ObjectName templateObj : memberTemplates) {
            if (ClusterConfigHelper.templateBeingUsed(cs, session, templateObj, currentMemberObjs)) continue;
            String templateName = ConfigServiceHelper.getDisplayName(templateObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting member template ", templateName);
            }
            ConfigDataId serverId = ConfigServiceHelper.getConfigDataId(templateObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting member template  metadata ", serverId);
            }
            RepositoryContext clusterContext = null;
            try {
                clusterContext = ClusterConfigHelper.getClusterTemplateContext(clusterName, session);
            }
            catch (ClusterConfigException e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteMemberTemplate", "Cannot get cluster template context");
                }
                throw new ClusterConfigException(e, e.getMessage());
            }
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(clusterContext, "template-metadata.xml");
            if (docAccessor != null) {
                ObjectName[] objNames = docAccessor.getRootObjects(session);
                for (int i = 0; objNames != null && i < objNames.length; ++i) {
                    PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, objNames[i]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got PropertySet: " + set);
                    }
                    boolean found = false;
                    EList props = set.getProperties();
                    for (Property p : props) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Props ", p);
                        }
                        if (!p.getName().equals("name") || !p.getValue().equals(templateName)) continue;
                        ObjectName serverTemplateMetadata = MOFUtil.createObjectName(set);
                        cs.deleteConfigData(session, serverTemplateMetadata);
                        found = true;
                        break;
                    }
                    if (found) break;
                }
            }
            BaseServerDelegator delegator = new BaseServerDelegator(ConfigServiceImpl.getInstance());
            delegator.deleteConfigData(session, templateObj);
        }
    }

    public static boolean isShortNameValid(String shortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isShortNameValid " + shortName);
        }
        boolean result = true;
        result = CreateServer.isShortNameValid((String)shortName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isShortNameValid " + new Boolean(result));
        }
        return result;
    }

    public static boolean isClusterShortNameValid(String shortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClusterConfigHelper.isClusterShortNameValid " + shortName);
        }
        boolean result = true;
        result = CreateServer.isClusterShortNameValid((String)shortName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClusterConfigHelper.isClusterShortNameValid " + new Boolean(result));
        }
        return result;
    }

    public static void promoteServerResources(ConfigService cs, Session session, String clusterName, String nodeName, String serverName, String resourcesScope, ObjectName cellObj) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promoteServerResources", clusterName + " " + " " + nodeName + " " + serverName);
        }
        try {
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            RepositoryContext rootContext = ws.getRootContext();
            RepositoryContextType type = metadata2.getContextType("cells");
            Collection match = rootContext.findContext(type);
            if (match == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find cell context");
                }
                throw new ClusterConfigException("Cannot find cell context");
            }
            RepositoryContext cellContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cell", cellContext.getName());
            }
            if ((match = cellContext.findContext("nodes", nodeName)) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find node context for node " + nodeName);
                }
                throw new ClusterConfigException("Cannot find node context for " + nodeName);
            }
            RepositoryContext nodeContext = (RepositoryContext)match.iterator().next();
            if ((match = nodeContext.findContext("servers", serverName)) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find server context for " + serverName);
                }
                throw new ClusterConfigException("Cannot find server context for " + serverName);
            }
            RepositoryContext serverContext = (RepositoryContext)match.iterator().next();
            if (serverContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Server context for " + serverName + " is null");
                }
                throw new ClusterConfigException("Server context for " + serverName + " is null");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for server", serverContext.getName());
            }
            if ((match = cellContext.findContext("clusters", clusterName)) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find cluster context for cluster " + clusterName);
                }
                throw new ClusterConfigException("Cannot find cluster context for " + clusterName);
            }
            RepositoryContext clusterContext = (RepositoryContext)match.iterator().next();
            if (clusterContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find cluster context for server");
                }
                throw new ClusterConfigException("Cannot find cluster context for server");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cluster", clusterContext.getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper");
            }
            ManagedObjectMetadataHelper mh = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mh.getNodeBaseProductVersion(" + nodeName + ")=" + mh.getNodeBaseProductVersion(nodeName));
            }
            if (mh.compareNodeVersion(nodeName, "6.0") >= 0 && (null == resourcesScope || resourcesScope.trim().equals("") || resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) || resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER))) {
                block49: {
                    ObjectName[] dataSources;
                    block46: {
                        try {
                            clusterContext.delete("resources.xml");
                        }
                        catch (WorkSpaceException wse) {
                            if (!tc.isDebugEnabled()) break block46;
                            Tr.debug(tc, "Ignoring " + (Object)((Object)wse) + " while deleting resources.xml");
                        }
                    }
                    ClusterConfigHelper.copyFile(clusterContext, serverContext, clusterName, "resources.xml");
                    String cellName = ConfigServiceHelper.getDisplayName(cellObj);
                    String clusterSpec = "Cell=" + cellName + ":ServerCluster=" + clusterName + ":JDBCProvider:DataSource:";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "clusterSpec = " + clusterSpec);
                    }
                    if ((dataSources = cs.resolve(session, clusterSpec)) != null) {
                        if (dataSources.length != 1 && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Warning: Number of cluster data sources = " + dataSources.length + "!");
                        }
                        for (int i = 0; i < dataSources.length; ++i) {
                            String name;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "dataSources[" + i + "] = " + dataSources[i]);
                            }
                            if ((name = ConfigServiceHelper.getDisplayName(dataSources[i])).equals("DefaultEJBTimerDataSource")) {
                                cs.deleteConfigData(session, dataSources[i]);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Removed data source " + name);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Warning: data source " + name + " did not match!");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Warning: dataSources is null!");
                    }
                    String nodeVersion = ClusterConfigHelper.getMemberNodeVersion(cs, session, nodeName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeVersion = " + nodeVersion);
                    }
                    if (nodeVersion != null && nodeVersion.charAt(0) >= '6') {
                        try {
                            block48: {
                                block47: {
                                    try {
                                        clusterContext.delete("resources-pme.xml");
                                    }
                                    catch (WorkSpaceException wse) {
                                        if (!tc.isDebugEnabled()) break block47;
                                        Tr.debug(tc, "Ignoring " + (Object)((Object)wse) + " while deleting resources-pme.xml");
                                    }
                                }
                                ClusterConfigHelper.copyFile(clusterContext, serverContext, clusterName, "resources-pme.xml");
                                try {
                                    clusterContext.delete("resources-pme502.xml");
                                }
                                catch (WorkSpaceException wse) {
                                    if (!tc.isDebugEnabled()) break block48;
                                    Tr.debug(tc, "Ignoring " + (Object)((Object)wse) + " while deleting resources-pme502.xml");
                                }
                            }
                            ClusterConfigHelper.copyFile(clusterContext, serverContext, clusterName, "resources-pme502.xml");
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block49;
                            Tr.debug(tc, "Failed to copy PME resources to cluster ", clusterContext.getName());
                        }
                    }
                }
                if (resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER)) {
                    ClusterConfigHelper.removeServerResources(session, nodeName, clusterName, serverName);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeVersion is null!");
                }
            } else if (!resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_SERVER) && mh.compareNodeVersion(nodeName, "6.0") >= 0) {
                throw new ClusterConfigException("resourcesScope parameter value: " + resourcesScope + " is not valid");
            }
            ClusterConfigHelper.saveResourcesScopeProperty(cs, session, clusterName, resourcesScope);
        }
        catch (ClusterConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClusterConfigException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteServerResources");
        }
    }

    private static void saveResourcesScopeProperty(ConfigService cs, Session session, String clusterName, String resourcesScope) throws ConfigServiceException, WorkSpaceException, IOException, ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveResourceScopeProperty");
        }
        if (!(resourcesScope == null || resourcesScope.trim().equals("") || resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) || resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER) || resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_SERVER))) {
            throw new ClusterConfigException("resourcesScope parameter value: " + resourcesScope + " is not valid");
        }
        OutputStream out = null;
        RepositoryContext clusterContext = ClusterConfigHelper.getClusterContext(session, clusterName);
        out = clusterContext.getOutputStream("resourcesScope.properties");
        Properties resourcesScopeProp = new Properties();
        resourcesScopeProp.setProperty(RESOURCES_SCOPE, resourcesScope);
        resourcesScopeProp.store(out, "Possible resourcesScope values are null, both, cluster, and server");
        out.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveResourceScopeProperty");
        }
    }

    public static InputStream getResourcesScopePropertyInputFile(Session session, String clusterName) throws ConfigServiceException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesScopePropertyFile");
        }
        RepositoryContext clusterContext = ClusterConfigHelper.getClusterContext(session, clusterName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesScopePropertyFile");
        }
        return clusterContext.getInputStream("resourcesScope.properties");
    }

    private static RepositoryContext getClusterContext(Session session, String clusterName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterContext");
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryContext context = workspace.getRootContext();
        RepositoryContext retValue = null;
        List children = context.getChildren();
        block0: for (RepositoryContext child : children) {
            String contextName = child.getType().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "contextName=" + contextName);
            }
            if (!contextName.equalsIgnoreCase("cells")) continue;
            List cellChildren = child.getChildren();
            for (RepositoryContext cellChild : cellChildren) {
                String cellClusterName = cellChild.getName();
                if (!cellChild.getType().getName().equalsIgnoreCase("clusters") || !clusterName.equalsIgnoreCase(cellClusterName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clusterName=" + clusterName);
                    Tr.debug(tc, "cellClusterName=" + cellClusterName);
                }
                retValue = cellChild;
                break block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterContext");
        }
        return retValue;
    }

    public static void removeServerResources(Session session, String memberNode, String clusterName, String serverName) throws Exception {
        block17: {
            RepositoryContext serverContext;
            block16: {
                RepositoryContextType type;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "removeServerResources");
                }
                RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
                WorkSpace ws = WorkspaceHelper.getWorkspace(session);
                RepositoryContext rootContext = ws.getRootContext();
                Collection match = rootContext.findContext(type = metadata2.getContextType("cells"));
                if (match == null || match.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Cannot find cell context");
                    }
                    throw new ClusterConfigException("Cannot find cell context");
                }
                RepositoryContext cellContext = (RepositoryContext)match.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found context for cell", cellContext.getName());
                }
                if ((match = cellContext.findContext("nodes", memberNode)) == null || match.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Cannot find node context for node " + memberNode);
                    }
                    throw new ClusterConfigException("Cannot find node context for " + memberNode);
                }
                RepositoryContext nodeContext = (RepositoryContext)match.iterator().next();
                if ((match = nodeContext.findContext("servers", serverName)) == null || match.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Cannot find server context for " + serverName);
                    }
                    throw new ClusterConfigException("Cannot find server context for " + serverName);
                }
                serverContext = (RepositoryContext)match.iterator().next();
                if (serverContext == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Server context for " + serverName + " is null");
                    }
                    throw new ClusterConfigException("Server context for " + serverName + " is null");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found context for server", serverContext.getName());
                }
                ClusterConfigHelper.preserveEJBTimerServerResources(serverContext);
                try {
                    serverContext.delete("resources-pme502.xml");
                }
                catch (WorkSpaceException wse) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Ignoring " + (Object)((Object)wse) + " while deleting resources-pme502.xml");
                }
            }
            try {
                serverContext.delete("resources-pme.xml");
            }
            catch (WorkSpaceException wse) {
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "Ignoring " + (Object)((Object)wse) + " while deleting resources-pme502.xml");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServerResources");
        }
    }

    private static void preserveEJBTimerServerResources(RepositoryContext serverContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preserveEJBTimer");
        }
        boolean foundEJBTimer = false;
        Resource res = ConfigArchiveUtils.getResource(serverContext, "resources.xml");
        EList contents = res.getContents();
        Iterator itr = contents.iterator();
        while (itr.hasNext()) {
            J2CResourceAdapter j2c;
            Object obj = itr.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found resource ", obj);
            }
            boolean found = false;
            if (obj instanceof JDBCProvider) {
                JDBCProvider jdbcProvider = (JDBCProvider)obj;
                EList factories = jdbcProvider.getFactories();
                Iterator itr1 = factories.iterator();
                while (itr1.hasNext()) {
                    Object obj1 = itr1.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Datasource ", obj1);
                    }
                    if (!(obj1 instanceof DataSource)) continue;
                    DataSource ds = (DataSource)obj1;
                    if (ds.getName().equals("DefaultEJBTimerDataSource")) {
                        foundEJBTimer = true;
                        found = true;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleting DataSource ", ds);
                    }
                    itr1.remove();
                }
            } else if (obj instanceof J2CResourceAdapter && (j2c = (J2CResourceAdapter)obj).getName().equals("WebSphere Relational Resource Adapter")) {
                found = true;
            }
            if (found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleting Resource ", obj);
            }
            itr.remove();
        }
        if (foundEJBTimer) {
            res.save(new HashMap());
        } else {
            serverContext.delete("resources.xml");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preserveEJBTimer");
        }
    }

    protected static RepositoryContext createContextIfNeeded(RepositoryContext parent, String typeName, String name) throws Throwable {
        RepositoryMetaData metadata2;
        RepositoryContextType type;
        RepositoryContext child;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContextIfNeeded", new Object[]{parent, typeName, name});
        }
        if ((child = parent.getChild(type = (metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData()).getContextType(typeName), name)) == null) {
            child = parent.create(type, name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContextIfNeeded", child);
        }
        return child;
    }

    public static RepositoryContext getClusterTemplateContext(String clusterName, Session session) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterContext", clusterName);
        }
        WorkSpace ws = null;
        try {
            ws = WorkspaceHelper.getWorkspace(session);
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot get workspace");
            }
            throw new ClusterConfigException(e, e.getMessage());
        }
        TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)ws);
        RepositoryContext templateContext = null;
        try {
            templateContext = templateMan.getRootTemplateContext();
        }
        catch (WorkSpaceException we) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find template context");
            }
            throw new ClusterConfigException(we, we.getMessage());
        }
        if (templateContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "template context is null");
            }
            throw new ClusterConfigException("template context is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found template context ", templateContext);
        }
        RepositoryContext clusterContext = null;
        try {
            clusterContext = ClusterConfigHelper.createContextIfNeeded(templateContext, "clusters", clusterName);
        }
        catch (Throwable t) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find cluster template context");
            }
            throw new ClusterConfigException(t, t.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterContext", clusterName);
        }
        return clusterContext;
    }

    private static boolean templateBeingUsed(ConfigService cs, Session session, ObjectName templateObj, ObjectName[] members) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "templateBeingUsed", new Object[]{templateObj, members});
        }
        boolean result = false;
        for (int i = 0; i < members.length; ++i) {
            String nodeName = null;
            String nodeVersion = null;
            try {
                nodeName = (String)cs.getAttribute(session, members[i], "nodeName");
                nodeVersion = ClusterConfigHelper.getMemberNodeVersion(cs, session, nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node  ", nodeName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "version ", nodeVersion);
                }
                if (!TemplateConfigHelper.isTemplateMatchWithNode(cs, session, templateObj, nodeName)) continue;
                result = true;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "templateBeingUsed", new Boolean(result));
        }
        return result;
    }

    private static List getMemberTemplates(ConfigService cs, Session session, ObjectName clusterObj) throws ConfigServiceException, ConnectorException {
        return ClusterConfigHelper.getMemberTemplates(cs, session, clusterObj, null);
    }

    private static List getMemberTemplates(ConfigService cs, Session session, ObjectName clusterObj, String memberNodeVersion) throws ConfigServiceException, ConnectorException {
        Collection servers;
        ArrayList<ObjectName> result;
        block18: {
            RepositoryContext clusterContext;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getMemberTemplates", new Object[]{clusterObj, memberNodeVersion});
                }
                String clusterName = ConfigServiceHelper.getDisplayName(clusterObj);
                Object matches = null;
                result = new ArrayList<ObjectName>();
                clusterContext = null;
                try {
                    clusterContext = ClusterConfigHelper.getClusterTemplateContext(clusterName, session);
                }
                catch (ClusterConfigException e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMemberTemplates", "Cannot get cluster template context");
                    }
                    try {
                        throw new ClusterConfigException(e, e.getMessage());
                    }
                    catch (ClusterConfigException e2) {
                        if (!tc.isEntryEnabled()) break block17;
                        Tr.exit(tc, "getMemberTemplates", "Failed throwing ClusterConfigException " + e2);
                    }
                }
            }
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            servers = null;
            try {
                servers = clusterContext.findContext(metadata2.getContextType("servers"));
            }
            catch (WorkSpaceException we) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMemberTemplates", "Cannot get cluster template server list");
                }
                try {
                    throw new ClusterConfigException(we, we.getMessage());
                }
                catch (ClusterConfigException e2) {
                    if (!tc.isEntryEnabled()) break block18;
                    Tr.exit(tc, "getMemberTemplates", "Failed throwing ClusterConfigException " + e2);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of server contexts = " + servers.size());
        }
        Iterator iterator = servers.iterator();
        Object finalContext = null;
        while (iterator.hasNext()) {
            RepositoryContext rc = (RepositoryContext)iterator.next();
            String name = rc.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template for server " + name);
            }
            ObjectName templateObj = MOFUtil.createObjectName(rc);
            if (memberNodeVersion == null) {
                result.add(templateObj);
                continue;
            }
            if (!name.startsWith("V" + memberNodeVersion + "MemberTemplate")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching server context name " + name);
            }
            result.add(templateObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberTemplates", result);
        }
        return result;
    }

    private static String getNewMemberTemplate(ConfigService cs, Session session, List memberTemplates, String memberNodeVersion) throws Exception {
        String name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewMemberTemplate", new Object[]{cs, session, memberTemplates});
        }
        Object result = null;
        ArrayList<String> names = new ArrayList<String>();
        for (ObjectName memberTemplate : memberTemplates) {
            String templateName = ConfigServiceHelper.getDisplayName(memberTemplate);
            names.add(templateName);
        }
        String newName = name = "V" + memberNodeVersion + "MemberTemplate";
        int i = 0;
        while (names.contains(newName)) {
            newName = name + new Integer(i);
            ++i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNewMemberTemplate", newName);
        }
        return newName;
    }
}

