/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RoleRelations {
    private static TraceComponent tc = Tr.register(RoleRelations.class, "RoleRelationsHandler", "com.ibm.ws.management.authorizer");
    private static HashMap roleRelations;
    private static List customRoles;
    private static RoleRelations roleRelationsInstance;
    private static WebSphereRuntimePermission adminPermission;

    private RoleRelations() {
        roleRelations = new HashMap(5);
    }

    public static RoleRelations getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        return roleRelationsInstance;
    }

    public synchronized void addRoleRelations(String roleName, List parentRoleNames) {
        Iterator ditr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRoleRelations", roleName);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        List parentRoles = (List)roleRelations.get(roleName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parent roles = ");
            ditr = parentRoleNames.iterator();
            while (ditr.hasNext()) {
                Tr.debug(tc, (String)ditr.next());
            }
        }
        if (parentRoles == null || parentRoles.isEmpty()) {
            roleRelations.put(roleName, parentRoleNames);
        } else {
            Iterator itr = parentRoleNames.iterator();
            while (itr.hasNext()) {
                boolean duplicate = false;
                String pRoleName = (String)itr.next();
                Tr.debug(tc, "parent role = ", pRoleName);
                for (String pRole : parentRoles) {
                    Tr.debug(tc, "matching with ", pRole);
                    if (!pRole.equals(pRoleName)) continue;
                    duplicate = true;
                    break;
                }
                if (!duplicate) continue;
                Tr.debug(tc, "removing role = ", pRoleName);
                removeList.add(pRoleName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Duplicates list = ");
                ditr = removeList.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            for (String pRoleName : removeList) {
                if (!parentRoleNames.contains(pRoleName)) continue;
                parentRoleNames.remove(pRoleName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding these parents ");
                ditr = parentRoleNames.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            for (String pRoleName : parentRoleNames) {
                List lst = (List)roleRelations.get(roleName);
                lst.add(pRoleName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRoleRelations");
        }
    }

    public synchronized List getParentRoles(String roleName) {
        List parentRoles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentRoles", roleName);
        }
        if ((parentRoles = (List)roleRelations.get(roleName)) == null) {
            return new ArrayList();
        }
        ArrayList parents = new ArrayList();
        parents.addAll(parentRoles);
        return parents;
    }

    public synchronized List getAllParentRoles(String roleName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentRoles", roleName);
        }
        HashSet lst = new HashSet();
        this.getAllParentRoles(roleName, lst);
        ArrayList newList = new ArrayList(lst);
        return newList;
    }

    private void getAllParentRoles(String roleName, Set lst) {
        List parentRoles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentRoles", roleName);
        }
        if ((parentRoles = (List)roleRelations.get(roleName)) == null) {
            return;
        }
        if (parentRoles.isEmpty()) {
            return;
        }
        lst.addAll(parentRoles);
        for (String parentRole : parentRoles) {
            this.getAllParentRoles(parentRole, lst);
        }
    }

    public void display() {
        Set keys = roleRelations.keySet();
        Iterator itr = keys.iterator();
        System.out.println("---------------------");
        System.out.println("---------------------");
        while (itr.hasNext()) {
            String roleName = (String)itr.next();
            List parentRoleNames = (List)roleRelations.get(roleName);
            if (parentRoleNames == null) continue;
            System.out.println("Role = " + roleName);
            for (String parentRole : parentRoleNames) {
                System.out.println("    ParentRole = " + parentRole);
            }
            System.out.println("---------------------");
        }
        System.out.println("---------------------");
        System.out.println("---------------------");
    }

    public void addCustomRoles(String roleName) {
        customRoles.add(roleName);
    }

    public List getCustomRoles() {
        return customRoles;
    }

    static {
        customRoles = new ArrayList();
        roleRelationsInstance = new RoleRelations();
        adminPermission = new WebSphereRuntimePermission("AdminPermission");
    }
}

