/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.ResourceIdentifier;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.GroupsUtil;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class ResourceInstanceIdentifier
implements ResourceIdentifier {
    private static TraceComponent tc = Tr.register(ResourceInstanceIdentifier.class, "ResourceInstanceIdentifier", "com.ibm.ws.management.authorizer");

    public List getParentInstances(String resourceName, String parentResourceType, Session session, ConfigService cs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentInstances", "ResourceName = " + resourceName + " parentResourceType = " + parentResourceType);
        }
        try {
            String parentCfgId;
            ObjectName[] matches;
            String nodeName;
            ArrayList<String> parentInstances = new ArrayList<String>();
            ObjectName parentObj = null;
            if (parentResourceType.equals("Node")) {
                nodeName = GroupsUtil.getInstance().getNodeName(resourceName, false);
                String nodeSpec = "Node=" + nodeName;
                matches = null;
                matches = cs.resolve(session, nodeSpec);
                if (matches.length > 0) {
                    parentObj = matches[0];
                    parentCfgId = ConfigServiceHelper.getConfigDataId(parentObj).toString();
                    parentInstances.add(parentCfgId);
                }
            }
            if (parentResourceType.equals("Cell")) {
                String cellName = GroupsUtil.getInstance().getCellName(resourceName, false);
                String cellSpec = "Cell=" + cellName;
                matches = null;
                matches = cs.resolve(session, cellSpec);
                if (matches.length > 0) {
                    parentObj = matches[0];
                    parentCfgId = ConfigServiceHelper.getConfigDataId(parentObj).toString();
                    parentInstances.add(parentCfgId);
                }
            }
            if (parentResourceType.equals("ServerCluster")) {
                String serverName = GroupsUtil.getInstance().getServerName(resourceName, false);
                String nodeName2 = GroupsUtil.getInstance().getNodeName(resourceName, false);
                String serverSpec = "Node=" + nodeName2 + ":" + "Server=" + serverName;
                ObjectName serverObj = null;
                ObjectName[] matches2 = null;
                matches2 = cs.resolve(session, serverSpec);
                if (matches2.length > 0) {
                    serverObj = matches2[0];
                }
                String clusterName = (String)cs.getAttribute(session, serverObj, "clusterName");
                String clusterSpec = "ServerCluster=" + clusterName;
                matches2 = null;
                matches2 = cs.resolve(session, clusterSpec);
                if (matches2.length > 0) {
                    parentObj = matches2[0];
                    String parentCfgId2 = ConfigServiceHelper.getConfigDataId(parentObj).toString();
                    parentInstances.add(parentCfgId2);
                }
            }
            if (parentResourceType.equals("NodeGroup")) {
                nodeName = GroupsUtil.getInstance().getNodeName(resourceName, false);
                String[] nodeGroups = NodeGroupHelper.listNodeGroups(session, cs, nodeName);
                for (int i = 0; nodeGroups != null && i < nodeGroups.length; ++i) {
                    String nodeGroup = nodeGroups[i];
                    String nodegroupSpec = "NodeGroup=" + nodeGroup;
                    ObjectName[] matches3 = null;
                    matches3 = cs.resolve(session, nodegroupSpec);
                    if (matches3.length <= 0) continue;
                    parentObj = matches3[0];
                    String parentCfgId3 = ConfigServiceHelper.getConfigDataId(parentObj).toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NodeGroup is ", parentCfgId3);
                    }
                    parentInstances.add(parentCfgId3);
                }
            }
            if (parentResourceType.equals("Application")) {
                return null;
            }
            if (parentResourceType.equals("Server")) {
                return null;
            }
            if (parentResourceType.equals("AuthorizationGroup")) {
                return null;
            }
            if (parentResourceType.equals("BLA") || parentResourceType.equals("ASSET") || parentResourceType.equals("CUS")) {
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parent list = ");
                Iterator ditr = parentInstances.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentInstances");
            }
            return parentInstances;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.ResourceInstanceIdentifier.getParentInstances", (String)"180", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentInstances");
            }
            return new ArrayList();
        }
    }

    public String getResourceName(String resourceName, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceName", resourceName);
        }
        if (type == null) {
            String resName = resourceName.substring(resourceName.indexOf("cells/"), resourceName.indexOf("|"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stripped resource name = " + resName);
            }
            return resName;
        }
        String cellName = GroupsUtil.getInstance().getCellName(resourceName, false);
        String nodeName = GroupsUtil.getInstance().getNodeName(resourceName, false);
        String serverName = GroupsUtil.getInstance().getServerName(resourceName, false);
        String nodeGroupName = GroupsUtil.getInstance().getNodeGroupName(resourceName, false);
        String clusterName = GroupsUtil.getInstance().getClusterName(resourceName, false);
        String appName = GroupsUtil.getInstance().getAppName(resourceName, null, false);
        String authzGroupName = GroupsUtil.getInstance().getAuthzGroupName(resourceName, false);
        String blaName = GroupsUtil.getInstance().getBlaName(resourceName, false);
        String cusName = GroupsUtil.getInstance().getCusName(resourceName, false);
        String assetName = GroupsUtil.getInstance().getAssetName(resourceName, false);
        String resName = null;
        resName = type.equals("Server") ? "cells/" + cellName + "/nodes/" + nodeName + "/servers/" + serverName : (type.equals("Node") ? "cells/" + cellName + "/nodes/" + nodeName : (type.equals("NodeGroup") ? "cells/" + cellName + "/nodegroups/" + nodeGroupName : (type.equals("ServerCluster") ? "cells/" + cellName + "/clusters/" + clusterName : (type.equals("Application") ? "cells/" + cellName + "/deployments/" + appName : (type.equals("Deployment") ? "cells/" + cellName + "/deployments/" + appName : (type.equals("Cell") ? "cells/" + cellName : (type.equals("AuthorizationGroup") ? "cells/" + cellName + "/authorizationgroups/" + authzGroupName : (type.equals("BLA") ? "cells/" + cellName + "/blas/" + blaName : (type.equals("CUS") ? "cells/" + cellName + "/cus/" + cusName : (type.equals("ASSET") ? "cells/" + cellName + "/assets/" + assetName : "cells/" + cellName))))))))));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceName", resName);
        }
        return resName;
    }

    public String getResourceName(ObjectName obj, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceName", obj.toString() + " type =  " + type);
        }
        String resourceName = obj.toString();
        String cellName = GroupsUtil.getInstance().getCellName(resourceName, false);
        String nodeName = GroupsUtil.getInstance().getNodeName(resourceName, false);
        String serverName = GroupsUtil.getInstance().getServerName(resourceName, false);
        String nodeGroupName = GroupsUtil.getInstance().getNodeGroupName(resourceName, false);
        String clusterName = GroupsUtil.getInstance().getClusterName(resourceName, false);
        String appName = GroupsUtil.getInstance().getAppName(resourceName, null, false);
        String resName = null;
        resName = type.equals("Server") ? "cells/" + cellName + "/nodes/" + nodeName + "/servers/" + serverName : (type.equals("Node") ? "cells/" + cellName + "/nodes/" + nodeName : (type.equals("NodeGroup") ? "cells/" + cellName + "/nodegroups/" + nodeGroupName : (type.equals("ServerCluster") ? "cells/" + cellName + "/clusters/" + clusterName : (type.equals("Application") ? "cells/" + cellName + "/deployments/" + appName : (type.equals("Deployment") ? "cells/" + cellName + "/deployments/" + appName : (type.equals("Cell") ? "cells/" + cellName : "cells/" + cellName))))));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceName", resName);
        }
        return resName;
    }

    public String getResourceType(String resourceName) {
        String resType = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceType", resourceName);
        }
        if (GroupsUtil.getInstance().contains(resourceName, "servers")) {
            resType = "Server";
        } else if (GroupsUtil.getInstance().contains(resourceName, "nodes")) {
            resType = "Node";
        } else if (GroupsUtil.getInstance().contains(resourceName, "nodegroups")) {
            resType = "NodeGroup";
        } else if (GroupsUtil.getInstance().contains(resourceName, "clusters")) {
            resType = "ServerCluster";
        } else if (GroupsUtil.getInstance().contains(resourceName, "applications")) {
            resType = "Application";
        } else if (GroupsUtil.getInstance().contains(resourceName, "deployments")) {
            resType = "Application";
        } else if (GroupsUtil.getInstance().contains(resourceName, "application")) {
            resType = "Application";
        } else if (GroupsUtil.getInstance().contains(resourceName, "authorizationgroups")) {
            resType = "AuthorizationGroup";
        } else if (GroupsUtil.getInstance().contains(resourceName, "blas")) {
            resType = "BLA";
        } else if (GroupsUtil.getInstance().contains(resourceName, "cus")) {
            resType = "CUS";
        } else if (GroupsUtil.getInstance().contains(resourceName, "assets")) {
            resType = "ASSET";
        } else if (GroupsUtil.getInstance().contains(resourceName, "cells")) {
            resType = "Cell";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceType", resType);
        }
        return resType;
    }

    public boolean isValidResourceType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidResourceType", type);
        }
        boolean valid = false;
        if (type.equals("Server")) {
            valid = true;
        } else if (type.equals("Node")) {
            valid = true;
        } else if (type.equals("NodeGroup")) {
            valid = true;
        } else if (type.equals("ServerCluster")) {
            valid = true;
        } else if (type.equals("Application")) {
            valid = true;
        } else if (type.equals("Deployment")) {
            valid = true;
        } else if (type.equals("Cell")) {
            valid = true;
        } else if (type.equals("AuthorizationGroup")) {
            valid = true;
        } else if (type.equals("BLA")) {
            valid = true;
        } else if (type.equals("CUS")) {
            valid = true;
        } else if (type.equals("ASSET")) {
            valid = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidResourceType", new Boolean(valid));
        }
        return valid;
    }

    public boolean isValidResource(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidResource", resourceName);
        }
        boolean valid = false;
        int i = 0;
        i = resourceName.indexOf("/servers/");
        if (i > 0) {
            if (resourceName.indexOf("/", i) < 0) {
                valid = true;
            }
        } else {
            i = resourceName.indexOf("/nodes/");
            if (i > 0) {
                if (resourceName.indexOf("/", i) < 0) {
                    valid = true;
                }
            } else {
                i = resourceName.indexOf("/nodegroups/");
                if (i > 0) {
                    if (resourceName.indexOf("/", i) < 0) {
                        valid = true;
                    }
                } else {
                    i = resourceName.indexOf("/clusters/");
                    if (i > 0) {
                        if (resourceName.indexOf("/", i) < 0) {
                            valid = true;
                        }
                    } else {
                        i = resourceName.indexOf("/applications/");
                        if (i > 0) {
                            if (resourceName.indexOf("/", i) < 0) {
                                valid = true;
                            }
                        } else {
                            i = resourceName.indexOf("/deployments/");
                            if (i > 0) {
                                if (resourceName.indexOf("/", i) < 0) {
                                    valid = true;
                                }
                            } else {
                                i = resourceName.indexOf("/application/");
                                if (i > 0) {
                                    if (resourceName.indexOf("/", i) < 0) {
                                        valid = true;
                                    }
                                } else {
                                    i = resourceName.indexOf("/authorizationgroups/");
                                    if (i > 0) {
                                        if (resourceName.indexOf("/", i) < 0) {
                                            valid = true;
                                        }
                                    } else {
                                        i = resourceName.indexOf("/blas/");
                                        if (i > 0) {
                                            if (resourceName.indexOf("/", i) < 0) {
                                                valid = true;
                                            }
                                        } else {
                                            i = resourceName.indexOf("/cus/");
                                            if (i > 0) {
                                                if (resourceName.indexOf("/", i) < 0) {
                                                    valid = true;
                                                }
                                            } else {
                                                i = resourceName.indexOf("/assets/");
                                                if (i > 0) {
                                                    if (resourceName.indexOf("/", i) < 0) {
                                                        valid = true;
                                                    }
                                                } else {
                                                    i = resourceName.indexOf("/cells/");
                                                    if (i >= 0 && resourceName.indexOf("/", i) < 0) {
                                                        valid = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidResource", new Boolean(valid));
        }
        return valid;
    }

    public String getUniversalResourceType(String cfgType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniversalResourceType", cfgType);
        }
        String type = null;
        if (cfgType.equalsIgnoreCase("Server")) {
            type = "servers";
        } else if (cfgType.equalsIgnoreCase("Node")) {
            type = "nodes";
        } else if (cfgType.equalsIgnoreCase("NodeGroup")) {
            type = "nodegroups";
        } else if (cfgType.equalsIgnoreCase("ServerCluster")) {
            type = "clusters";
        } else if (cfgType.equalsIgnoreCase("Application")) {
            type = "deployments";
        } else if (cfgType.equalsIgnoreCase("Deployment")) {
            type = "deployments";
        } else if (cfgType.equalsIgnoreCase("Cell")) {
            type = "cells";
        } else if (cfgType.equalsIgnoreCase("AuthorizationGroup")) {
            type = "authorizationgroups";
        } else if (cfgType.equalsIgnoreCase("Cluster")) {
            type = "clusters";
        } else if (cfgType.equalsIgnoreCase("BLA")) {
            type = "blas";
        } else if (cfgType.equalsIgnoreCase("CUS")) {
            type = "cus";
        } else if (cfgType.equalsIgnoreCase("ASSET")) {
            type = "assets";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniversalResourceType", type);
        }
        return type;
    }
}

