/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.authorizer.service.AdminAuthzService;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceOperations;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.authorizer.AuthorizationGroupManagerPrivate;
import com.ibm.ws.management.authorizer.AuthorizationGroups;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import com.ibm.wsspi.management.collaborator.AgentProxyCollaborator;
import com.ibm.wsspi.management.collaborator.AgentProxyServantCollaborator;
import java.security.Permission;
import javax.management.ObjectName;

public final class AuthorizationGroupManager
implements AdminAuthzServiceOperations {
    private static TraceComponent tc = Tr.register(AuthorizationGroupManager.class, "AuthorizationGroupManager", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    AuthorizationGroups groups = null;
    AdminAuthzService agService = null;
    String processType = null;
    String processName = null;
    private String uuid = AdminContext.peek();
    private static AuthorizationGroupManager agmgr = null;
    private ObjectName aGM = null;
    private ObjectName aGMPrivate = null;
    private ObjectName aGMPrivateProxy = null;

    public AuthorizationGroupManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthorizationGroupManager default constructor:" + this.uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthorizationGroupManager default constructor");
        }
    }

    public AuthorizationGroupManager(AdminAuthzService as) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthorizationGroupManager constructor: " + this.uuid);
        }
        this.agService = as;
        this.initialize();
        if (this.uuid == null) {
            agmgr = this;
        } else {
            AdminSubsystemServiceRegistry.addService((String)AuthorizationGroupManager.class.getName(), (Object)this);
        }
        this.activateMBean();
        if (this.inRegisteredServer()) {
            this.activatePrivateProxyMBean();
        } else if (this.inAASubsystem()) {
            this.activatePrivateMBean();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthorizationGroupManager constructor");
        }
    }

    public static AuthorizationGroupManager getInstance() {
        SecurityManager sm;
        String currentContext = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance:" + currentContext);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        if (currentContext == null) {
            return agmgr;
        }
        return (AuthorizationGroupManager)AdminSubsystemServiceRegistry.getService((String)AuthorizationGroupManager.class.getName());
    }

    public void initialize() {
        this.groups = AuthorizationGroups.getInstance();
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            this.processType = adminService.getProcessType();
            this.processName = adminService.getProcessName();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AuthorizationGroupManager.initialize", (String)"73", (Object)this);
        }
    }

    protected void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.deactivateMBean();
        this.deactivatePrivateMBean();
        this.deactivatePrivateProxyMBean();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    protected void redirectToAA() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "redirectToAA");
        }
        AdminServiceFactory.getAdminService().invoke(this.aGMPrivateProxy, "refreshAll", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "redirectToAA");
        }
    }

    public void refreshAll() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAll");
        }
        this.agService.refreshAll();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAll");
        }
    }

    public void refreshAllFinal() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAllFinal");
        }
        this.agService.refreshAllFinal();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAllFinal");
        }
    }

    public void refreshGroups(String[] groupNames) throws Exception {
        this.agService.refreshGroups(groupNames);
    }

    public void refreshAllGroups() throws Exception {
        this.agService.refreshAllGroups();
    }

    public void refreshAuthTables(String[] groupNames) throws Exception {
        this.agService.refreshAuthTables(groupNames);
    }

    public void refreshAllAuthTables() throws Exception {
        this.agService.refreshAllAuthTables();
    }

    public void refresh(String[] groupNames) throws Exception {
        this.agService.refresh(groupNames);
    }

    private void activateMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean");
        }
        MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
        DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator((Object)this, "AuthorizationGroupManager");
        this.aGM = mbeanFactory.activateMBean("AuthorizationGroupManager", (RuntimeCollaborator)collab, mbeanFactory.getConfigId("AuthorizationGroupManager"), null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateMBean");
        }
    }

    private void deactivateMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivateMBean");
        }
        if (this.aGM != null) {
            try {
                MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
                mbeanFactory.deactivateMBean(this.aGM);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.authorizer.AuthorizationGroupManager.deactivateMBean", (String)"238", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateMBean");
        }
    }

    private void activatePrivateMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activatePrivateMBean");
        }
        MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
        if (!AdminHelper.getPlatformHelper().isZOS() || AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm()) {
            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator((Object)this, "AuthorizationGroupManagerPrivate");
            this.aGMPrivate = mbeanFactory.activateMBean("AuthorizationGroupManagerPrivate", (RuntimeCollaborator)collab, "AuthorizationGroupManagerPrivate", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activatePrivateMBean");
        }
    }

    private void deactivatePrivateMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivatePrivateMBean");
        }
        if (this.aGMPrivate != null) {
            try {
                MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
                mbeanFactory.deactivateMBean(this.aGMPrivate);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.authorizer.AuthorizationGroupManager.deactivateMBeanPrivate", (String)"256", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivatePrivateMBean");
        }
    }

    private void activatePrivateProxyMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activatePrivateProxyMBean");
        }
        MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
        RuntimeCollaborator collab = AdminHelper.getPlatformHelper().isServantJvm() ? new AgentProxyServantCollaborator(AuthorizationGroupManagerPrivate.class) : new AgentProxyCollaborator(AuthorizationGroupManagerPrivate.class);
        this.aGMPrivateProxy = mbeanFactory.activateMBean("AuthorizationGroupManagerPrivate", collab, "AuthorizationGroupManagerPrivate", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activatePrivateProxyMBean");
        }
    }

    private void deactivatePrivateProxyMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivatePrivateProxyMBean");
        }
        if (this.aGMPrivateProxy != null) {
            try {
                MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
                mbeanFactory.deactivateMBean(this.aGMPrivateProxy);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.authorizer.AuthorizationGroupManager.deactivateMBeanPrivateProxy", (String)"284", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivatePrivateProxyMBean");
        }
    }

    private boolean inRegisteredServer() throws Exception {
        boolean result = false;
        boolean cellRegistered = AdminHelper.getInstance().isCellRegistered();
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (cellRegistered && processType.equals("UnManagedProcess")) {
            result = true;
        }
        return result;
    }

    private boolean inAASubsystem() throws Exception {
        boolean result = false;
        boolean cellRegistered = AdminContext.peek() != null;
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (cellRegistered && processType.equals("AdminAgent")) {
            result = true;
        }
        return result;
    }
}

