/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.authorizer.service.AdminAuthzService;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceEvent;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceListener;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.authorizer.AdminAuthorizerImpl;
import com.ibm.ws.management.authorizer.AdminAuthzComponentImpl;
import com.ibm.ws.management.authorizer.AuthorizationGroup;
import com.ibm.ws.management.authorizer.AuthorizationGroupManager;
import com.ibm.ws.management.authorizer.AuthorizationGroups;
import com.ibm.ws.management.authorizer.AuthzCache;
import com.ibm.ws.management.authorizer.GroupsParser;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.ws.management.authorizer.ResourceRelationHandler;
import com.ibm.ws.management.authorizer.RoleRelationHandler;
import com.ibm.ws.management.authorizer.RoleRelations;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public final class AdminAuthzServiceImpl
implements AdminAuthzService {
    private static TraceComponent tc = Tr.register(AdminAuthzServiceImpl.class, "AdminAuthzServiceImpl", "com.ibm.ws.management.authorizer");
    private ArrayList listeners = new ArrayList(4);
    private String cellName = null;
    private String nodeName = null;
    private String serverName = null;
    private AdminAuthorizerImpl aa = null;
    private AuthzCache authzCache = null;
    private RoleBasedConfigurator rbc = null;
    private String uuid = AdminContext.peek();
    protected RolebasedauthzFactory authFactory;
    private AdminAuthzComponentImpl component;
    private AuthorizationGroupManager agm = null;

    public AdminAuthzServiceImpl(AdminAuthzComponentImpl component2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminAuthzServiceImpl constructor:" + this.uuid);
        }
        this.component = component2;
        AuthorizationGroups.create();
        this.aa = AdminAuthorizerImpl.create();
        this.authzCache = new AuthzCache();
        this.aa.setAuthzCache(this.authzCache);
        if (this.uuid == null) {
            this.addService(AdminAuthzService.class);
        } else {
            AdminSubsystemServiceRegistry.addService((String)AdminAuthzService.class.getName(), (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminAuthzServiceImpl constructor");
        }
    }

    public void realStart() throws RuntimeError, RuntimeWarning {
        String curUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "realStart:" + curUUID);
        }
        try {
            SecurityService secService = (SecurityService)this.getService(SecurityService.class);
            AdminService adminService = AdminServiceFactory.getAdminService();
            this.cellName = adminService.getCellName();
            this.nodeName = adminService.getNodeName();
            this.serverName = adminService.getProcessName();
            this.aa.setCellName(this.cellName);
            this.aa.setNodeName(this.nodeName);
            this.aa.setServerName(this.serverName);
            GroupsParser groupsParser = new GroupsParser(new ResourceRelationHandler());
            groupsParser.loadConfigFile("com/ibm/ws/management/authorizer/xml/resourceTypeRelation.xml");
            groupsParser = new GroupsParser(new RoleRelationHandler());
            groupsParser.loadConfigFile("com/ibm/ws/management/authorizer/xml/roleRelation.xml");
            if (secService.isSecurityEnabled()) {
                RoleBasedConfigurator configurator = null;
                try {
                    this.rbc = configurator = secService.getConfigurator();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthzServiceImpl.realStart", (String)"1555", (Object)this);
                    throw new RuntimeError(e);
                }
                try {
                    this.refreshAllFinal();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthzServiceImpl.realStart", (String)"163", (Object)this);
                    throw new RuntimeError(e);
                }
                Repository repository2 = null;
                repository2 = this.uuid == null ? (Repository)this.getService(Repository.class) : (Repository)AdminSubsystemServiceRegistry.getService((String)Repository.class.getName());
                Object r = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "repository root: " + repository2.getRootURI());
                    }
                    ConfigService cfgService = ConfigServiceFactory.createConfigService((String)repository2.getRootURI(), (String)this.cellName, (String)this.nodeName, null);
                    if (null == this.agm) {
                        this.agm = new AuthorizationGroupManager(this);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthzServiceImpl.realStart", (String)"180", (Object)this);
                    throw new RuntimeError(e);
                }
                finally {
                    if (repository2 != null && curUUID == null) {
                        this.releaseService(repository2);
                    }
                }
                this.aa.setRoleBasedConfigurator(configurator);
                AdminAuthorizerFactory.create();
            }
            this.fireStartedEvent();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthzServiceImpl.realStart", (String)"192", (Object)this);
            throw new RuntimeError(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "realStart");
        }
    }

    public void realStop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "realStop");
        }
        if (this.agm != null) {
            this.agm.stop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "realStop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AdminAuthzServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", l);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AdminAuthzServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", l);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStartedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int SIZE = list.size();
            AdminAuthzServiceEvent e = new AdminAuthzServiceEvent(1);
            for (int i = 0; i < SIZE; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "notifying " + list.get(i));
                }
                ((AdminAuthzServiceListener)list.get(i)).stateChanged(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStartedEvent");
        }
    }

    public void refresh(String[] groupNames) throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAll() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAll");
        }
        if (this.aa != null && !this.aa.isCallerInRole("admin-authz", "adminsecuritymanager") && !this.aa.isCallerInRole("admin-authz", "administrator")) {
            throw new Exception("Access Denied");
        }
        if (this.inRegisteredServer()) {
            this.agm.redirectToAA();
        } else {
            this.refreshAllFinal();
            if (this.inAASubsystem()) {
                this.invokeOnAllRegisteredServers();
            } else if (this.inDmgr()) {
                this.invokeOnAllFederatedServers();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllFinal() throws Exception {
        String currentUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAllFinal:" + currentUUID);
        }
        if (this.aa != null && !this.aa.isCallerInRole("admin-authz", "adminsecuritymanager") && !this.aa.isCallerInRole("admin-authz", "administrator")) {
            throw new Exception("Access Denied");
        }
        if (this.rbc == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshAll");
            }
            return;
        }
        EtoolsCopyUtility copier = new EtoolsCopyUtility();
        Repository repository2 = null;
        repository2 = currentUUID == null ? (Repository)this.getService(Repository.class) : (Repository)AdminSubsystemServiceRegistry.getService((String)Repository.class.getName());
        AdminAuthorizerImpl adminAuthorizerImpl = this.aa;
        synchronized (adminAuthorizerImpl) {
            try {
                ArrayList<ConfigObject> allAuthzTableList = new ArrayList<ConfigObject>();
                this.authzCache.clear();
                ConfigService cfgService = ConfigServiceFactory.createConfigService((String)repository2.getRootURI(), (String)this.cellName, (String)this.nodeName, null);
                String authgroupDir = repository2.getRootURI() + "/cells/" + this.cellName + "/authorizationgroups/";
                Tr.debug(tc, "authgroupDir " + authgroupDir);
                File authgroupRoot = new File(authgroupDir);
                File[] authgroupRootList = authgroupRoot.listFiles();
                AuthorizationGroups authorizationGroups = AuthorizationGroups.getInstance();
                synchronized (authorizationGroups) {
                    block54: {
                        AuthorizationGroups.getInstance().flush();
                        try {
                            this.setCacheEnabled(cfgService);
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block54;
                            Tr.debug(tc, "Failed to check authz cache enabled");
                        }
                    }
                    for (int i = 0; authgroupRootList != null && i < authgroupRootList.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "auth group name: " + authgroupRootList[i].getName());
                        }
                        String agName = authgroupRootList[i].getName();
                        if (authgroupRootList[i] == null) continue;
                        String path = "/authorizationgroups/" + authgroupRootList[i].getName() + "/authorizationgroup.xml";
                        ConfigObject authgroup = (ConfigObject)cfgService.getDocumentObjects(cfgService.getScope(0), path).get(0);
                        AuthorizationGroup group = new AuthorizationGroup();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading group " + agName);
                        }
                        group.setAuthorizationGroupName(agName);
                        List members = authgroup.getObjectList("members");
                        if (members != null) {
                            for (ConfigObject agMember : members) {
                                String resName;
                                String savResName = resName = agMember.getString("resourceName", null);
                                String resType = agMember.getString("resourceType", null);
                                if (resName == null || resType == null) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Resource Name or Resource type cannot be null " + resName + " " + resType);
                                    continue;
                                }
                                resName = ResourceInstanceRelations.getInstance().convertCfgId(resName, resType);
                                List props = agMember.getObjectList("memberProperties");
                                ArrayList<String> parents = new ArrayList<String>();
                                if (props != null) {
                                    for (ConfigObject prop : props) {
                                        String parentResName = prop.getString("value", null);
                                        String parentResType = prop.getString("name", null);
                                        if (parentResName == null || parentResType == null) {
                                            if (!tc.isDebugEnabled()) continue;
                                            Tr.debug(tc, "Parent Resource Name or Parent Resource type cannot be null " + parentResName + " " + parentResType);
                                            continue;
                                        }
                                        parentResName = ResourceInstanceRelations.getInstance().convertCfgId(parentResName, parentResType);
                                        parents.add(parentResName);
                                    }
                                }
                                group.addResource(resName, resType, parents);
                                AuthorizationGroups.getInstance().addResource(resName, group);
                                if (!resType.equals("Application")) continue;
                                int ei = savResName.indexOf("/deployments/");
                                if (ei > 0) {
                                    savResName = savResName.substring(0, ei);
                                }
                                savResName = ResourceInstanceRelations.getInstance().convertCfgId(savResName, resType);
                                ArrayList<String> parents1 = new ArrayList<String>();
                                for (String p : parents) {
                                    parents1.add(p);
                                }
                                group.addResource(savResName, resType, parents1);
                                AuthorizationGroups.getInstance().addResource(savResName, group);
                            }
                        }
                        AuthorizationGroups.getInstance().addGroup(agName, group);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loaded all authorization groups ");
                }
                Object cellAt = null;
                String resourceName = "admin-authz.xml";
                String auditResourceName = "audit-authz.xml";
                try {
                    List atxList = cfgService.getDocumentObjects(cfgService.getScope(0), resourceName);
                    ConfigObject atx = (ConfigObject)atxList.get(0);
                    List auditList = null;
                    try {
                        auditList = cfgService.getDocumentObjects(cfgService.getScope(0), auditResourceName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ConfigObject auditObj = null;
                    if (auditList != null && auditList.size() > 0) {
                        auditObj = (ConfigObject)auditList.get(0);
                    }
                    ArrayList<ConfigObject> aList = new ArrayList<ConfigObject>();
                    aList.add(atx);
                    if (auditObj != null) {
                        aList.add(auditObj);
                    }
                    this.rbc.loadApplication("admin-authz", aList);
                    allAuthzTableList.add(atx);
                    if (auditObj != null) {
                        allAuthzTableList.add(auditObj);
                    }
                    this.updateRoleRelationsForCustomRoles(atx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loaded cell level authorization table ");
                }
                AuthorizationGroups gp = AuthorizationGroups.getInstance();
                Collection c = gp.getGroups();
                Iterator itr = c.iterator();
                ArrayList<String> removeList = new ArrayList<String>();
                while (itr.hasNext()) {
                    AuthorizationGroup ag = (AuthorizationGroup)itr.next();
                    String groupName = ag.getGroupName();
                    String filename = "/authorizationgroups/" + groupName + "/" + "admin-authz" + ".xml";
                    String auditFileName = "/authorizationgroups/" + groupName + "/" + "audit-authz.xml";
                    try {
                        ConfigObject at = null;
                        ConfigObject auditt = null;
                        try {
                            List atList = cfgService.getDocumentObjects(cfgService.getScope(0), filename);
                            at = (ConfigObject)atList.get(0);
                            List auditList = null;
                            try {
                                auditList = cfgService.getDocumentObjects(cfgService.getScope(0), filename);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (auditList != null && auditList.size() > 0) {
                                auditt = (ConfigObject)auditList.get(0);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (at != null) {
                            allAuthzTableList.add(at);
                            if (auditt != null) {
                                allAuthzTableList.add(auditt);
                            }
                            ArrayList<ConfigObject> aList = new ArrayList<ConfigObject>();
                            aList.add(at);
                            if (auditt != null) {
                                aList.add(auditt);
                            }
                            this.rbc.loadApplication("admin-authz-" + groupName, aList);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No Authorization table for authorization group " + groupName);
                            }
                            removeList.add(groupName);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "loaded authorization table " + filename);
                }
                for (String gName : removeList) {
                    gp.removeGroup(gName);
                }
                this.rbc.loadApplication("admin-authz-merge", allAuthzTableList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loaded mergedauthorization table ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (repository2 != null && currentUUID == null) {
                    this.releaseService(repository2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAllFinal");
        }
    }

    public void refreshGroups(String[] groupNames) throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAllGroups() throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAllAuthTables() throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAuthTables(String[] groupNames) throws Exception {
        throw new Exception("Not Implemented");
    }

    private void updateRoleRelationsForCustomRoles(ConfigObject at) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRoleRelationsForCustomRoles");
        }
        if (at == null) {
            return;
        }
        List roleAssignments = at.getObjectList("authorizations");
        if (roleAssignments == null) {
            return;
        }
        Iterator itr = roleAssignments.iterator();
        List monitorParents = RoleRelations.getInstance().getAllParentRoles("monitor");
        while (itr.hasNext()) {
            ConfigObject ra = (ConfigObject)itr.next();
            ArrayList<String> parentRoles = new ArrayList<String>();
            String roleName = ra.getObject("role").getString("roleName", null);
            parentRoles.add(roleName);
            if (roleName.equals("nobody") || roleName.equals("monitor") || monitorParents.contains(roleName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding roleName " + roleName + " as parent of nobody role");
            }
            RoleRelations.getInstance().addRoleRelations("nobody", parentRoles);
            RoleRelations.getInstance().addCustomRoles(roleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRoleRelationsForCustomRoles");
        }
    }

    private void setCacheEnabled(ConfigService cfgService) throws Exception {
        this.aa.setCacheDisabled();
        List r = cfgService.getDocumentObjects(cfgService.getScope(0), "cell.xml");
        ConfigObject cell = (ConfigObject)r.get(0);
        List props = cell.getObjectList("properties");
        if (props != null) {
            for (ConfigObject prop : props) {
                String useCache;
                if (!prop.getString("name", null).equals("enableAdminAuthorizationCache") || (useCache = prop.getString("value", null)) == null || !useCache.equals("true")) continue;
                this.aa.setCacheEnabled();
            }
        }
    }

    private void addService(Class clz) {
        if (this.component != null) {
            this.component.addService(clz);
        }
    }

    private Object getService(Class clz) throws RuntimeError {
        if (this.component != null) {
            return this.component.getService(clz);
        }
        try {
            return WsServiceRegistry.getService((Object)this, (Class)clz);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.authorizer.AdminAuthzServiceImpl.getService", (String)"%C", (Object)this);
            throw new RuntimeError(ex);
        }
    }

    private void releaseService(Object obj) {
        if (this.component != null) {
            this.component.releaseService(obj);
        }
    }

    private boolean inRegisteredServer() throws Exception {
        boolean result = false;
        boolean cellRegistered = AdminHelper.getInstance().isCellRegistered();
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (cellRegistered && processType.equals("UnManagedProcess")) {
            result = true;
        }
        return result;
    }

    private boolean inAASubsystem() throws Exception {
        boolean result = false;
        boolean cellRegistered = AdminContext.peek() != null;
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (cellRegistered && processType.equals("AdminAgent")) {
            result = true;
        }
        return result;
    }

    private boolean inDmgr() {
        boolean result = false;
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (processType.equals("DeploymentManager")) {
            result = true;
        }
        return result;
    }

    private void invokeOnAllRegisteredServers() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeOnAllRegisteredServers");
        }
        this.invokeOnAll("WebSphere:type=AuthorizationGroupManager,*", "refreshAllFinal");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeOnAllRegisteredServers");
        }
    }

    private void invokeOnAllFederatedServers() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeOnAllFederatedServers");
        }
        this.invokeOnAll("WebSphere:type=AuthorizationGroupManager,*", "refreshAll");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeOnAllFederatedServers");
        }
    }

    private void invokeOnAll(String query, String operation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeOnAll");
        }
        try {
            ObjectName on2 = new ObjectName(query);
            Set s = AdminServiceFactory.getAdminService().queryNames(on2, null);
            String processName = AdminServiceFactory.getAdminService().getProcessName();
            for (ObjectName on2 : s) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, on2.getKeyProperty("process") + " " + processName);
                }
                if (on2.getKeyProperty("process").equals(processName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshing " + on2.getKeyProperty("process"));
                }
                AdminServiceFactory.getAdminService().invoke(on2, operation, new Object[0], new String[0]);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.authorizer.AdminAuthzServiceImpl.invokeOnAll", (String)"708", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeOnAll");
        }
    }
}

