/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AdminHelperImpl
extends AdminHelper {
    private static EndPointMgr epMgr = null;
    private static Boolean cellRegistered = null;
    private static final String bundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceComponent tc = Tr.register(AdminHelper.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private boolean warningIssued = false;
    private Boolean useMultiHome = null;

    AdminHelperImpl() {
    }

    public String getNodeAgentName() {
        return this.getNodeAgentName(AdminServiceFactory.getAdminService().getNodeName());
    }

    public String getNodeAgentName(String nodeName) {
        EndPointMgr.NodeEndPoints neps = epMgr.getNodeEndPoints(nodeName);
        if (neps != null) {
            Map sepMap = neps.getServerEndPoints();
            for (EndPointMgr.ServerEndPoints seps : sepMap.values()) {
                if (!seps.getType().equals("NODE_AGENT")) continue;
                return seps.getName();
            }
        }
        return null;
    }

    public String getAdminAgentName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminAgentName");
        }
        String adminAgentName = null;
        Map nepMap = epMgr.getNodeEndPoints();
        if (nepMap != null) {
            for (EndPointMgr.NodeEndPoints neps : nepMap.values()) {
                Map sepMap = neps.getServerEndPoints();
                for (EndPointMgr.ServerEndPoints sep : sepMap.values()) {
                    if (!sep.getType().equals("ADMIN_AGENT")) continue;
                    adminAgentName = sep.getName();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminAgentName " + adminAgentName);
        }
        return adminAgentName;
    }

    public String getDeploymentManagerName() {
        Map nepMap = epMgr.getNodeEndPoints();
        if (nepMap != null) {
            for (EndPointMgr.NodeEndPoints neps : nepMap.values()) {
                Map sepMap = neps.getServerEndPoints();
                for (EndPointMgr.ServerEndPoints sep : sepMap.values()) {
                    if (!sep.getType().equals("DEPLOYMENT_MANAGER")) continue;
                    return sep.getName();
                }
            }
        }
        return null;
    }

    public String getNodeHostName(String nodeName) {
        Iterator sepi;
        EndPointMgr.ServerEndPoints seps;
        Map epMap;
        Map sepMap;
        String hostname;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeHostName", nodeName);
        }
        if ((hostname = epMgr.getNodeHostName(nodeName)) != null && !"".equals(hostname)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeHostName", hostname);
            }
            return hostname;
        }
        Tr.debug(tc, "getNodeHostName got '" + hostname + "' from ServerIndex.  Now looking for hostname from Endpoints");
        hostname = null;
        EndPointMgr.NodeEndPoints neps = epMgr.getNodeEndPoints(nodeName);
        if (neps != null && !(sepMap = neps.getServerEndPoints()).isEmpty() && !(epMap = (seps = (EndPointMgr.ServerEndPoints)(sepi = sepMap.values().iterator()).next()).getEndPoints()).isEmpty()) {
            for (EndPointMgr.EndPointInfo ep : epMap.values()) {
                hostname = ep.getHost();
                if (hostname.equals("*")) continue;
                Tr.debug(tc, "getNodeHostname " + hostname);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeHostName", hostname);
        }
        return hostname;
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalHost");
        }
        String host = this.getHostName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalHost");
        }
        return InetAddress.getByName(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostName() throws UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName");
        }
        String host = "";
        String nodeName = null;
        boolean pushed = false;
        try {
            String context = AdminContext.peek();
            if (context != null) {
                pushed = AdminContext.push(null);
            }
            nodeName = AdminServiceFactory.getAdminService().getNodeName();
        }
        catch (NullPointerException e) {
        }
        finally {
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (nodeName != null) {
            host = this.getNodeHostName(nodeName);
        }
        if (host == "") {
            host = InetAddress.getLocalHost().getHostName();
            if (host.indexOf(46) == -1) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            if (host.indexOf("127.0.0") > -1 && !this.warningIssued) {
                Tr.warning(tc, "ADMD0025W");
                this.warningIssued = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName", host);
        }
        return host;
    }

    public Boolean useMultiHome() {
        String useMultiHomeHostName;
        if (this.useMultiHome == null && (useMultiHomeHostName = System.getProperty("com.ibm.websphere.network.useMultiHome")) != null) {
            this.useMultiHome = Boolean.valueOf(useMultiHomeHostName);
        }
        return this.useMultiHome;
    }

    public static synchronized void setEndPointManager(EndPointMgr newEpMgr) {
        if (epMgr != null) {
            throw new IllegalArgumentException("EndPointMgr already set");
        }
        epMgr = newEpMgr;
    }

    public void audit(String msgKeyWithUser, String msgKeyWithoutUser, Object objs) {
        try {
            String msgKey;
            Object[] replacementText;
            String userID = SecurityHelper.getUserName();
            if (objs == null) {
                throw new AdminException("No audit data provided.");
            }
            if (objs.getClass().isArray()) {
                replacementText = (Object[])objs;
                if (replacementText.length < 2) {
                    throw new AdminException("Bad audit data provided.");
                }
            } else {
                replacementText = new Object[]{objs, null};
            }
            if (userID == null) {
                msgKey = msgKeyWithoutUser;
            } else {
                msgKey = msgKeyWithUser;
                replacementText[replacementText.length - 1] = new String(userID);
            }
            Tr.audit(tc, msgKey, replacementText);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.AdminHelperImpl.audit", (String)"183", (Object)((Object)this));
        }
    }

    public String getWasConfiguredSystemName() {
        String ownConfiguredSystemName;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWasConfiguredSystemName");
            }
            ownConfiguredSystemName = null;
            try {
                ConfigService configService = (ConfigService)WsServiceRegistry.getService((Object)((Object)this), ConfigService.class);
                List list = configService.getDocumentObjects(configService.getScope(4), "server.xml");
                ConfigObject object = (ConfigObject)list.get(0);
                List services = object.getObjectList("services");
                for (ConfigObject service : services) {
                    String typeName = service.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for services config type: " + typeName);
                    }
                    if (!typeName.equals("AdminService")) continue;
                    List properties = service.getObjectList("properties");
                    for (ConfigObject property : properties) {
                        if (!"was.ConfiguredSystemName".equals(property.getString("name", ""))) continue;
                        ownConfiguredSystemName = property.getString("value", null);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + ownConfiguredSystemName);
                    }
                }
                if (ownConfiguredSystemName != null) break block10;
                List components = object.getObjectList("components");
                for (ConfigObject component2 : components) {
                    String typeName = component2.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for component config type: " + typeName);
                    }
                    if (!typeName.equals("ApplicationServer")) continue;
                    List properties = component2.getObjectList("properties");
                    for (ConfigObject property : properties) {
                        if (!"was.ConfiguredSystemName".equals(property.getString("name", ""))) continue;
                        ownConfiguredSystemName = property.getString("value", null);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + ownConfiguredSystemName);
                    }
                    break;
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.AdminHelperImpl.getWasConfiguredSystemName", (String)"392", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWasConfiguredSystemName", ownConfiguredSystemName);
        }
        return ownConfiguredSystemName;
    }

    public synchronized boolean isCellRegistered() throws Exception {
        if (cellRegistered == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Determining if cell is registered");
            }
            try {
                ConfigService configService = (ConfigService)WsServiceRegistry.getService((Object)((Object)this), ConfigService.class);
                ConfigScope scope = configService.getScope(0);
                List resource = configService.getDocumentObjects(scope, "cell.xml");
                ConfigObject thisCell = (ConfigObject)resource.get(0);
                cellRegistered = thisCell.getBoolean("cellRegistered", false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellRegistered = " + cellRegistered);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.AdminHelperImpl.isCellRegisteed", (String)"431", (Object)((Object)this));
                throw e;
            }
        }
        return cellRegistered;
    }
}

