/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webxml;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigProperty;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlParser
extends DefaultHandler
implements JspXmlExtConfig {
    public static final String WEBAPP_DTD_PUBLIC_ID_22 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String WEBAPP_DTD_RESOURCE_PATH_22 = "/javax/servlet/resources/web-app_2_2.dtd";
    public static final String WEBAPP_DTD_PUBLIC_ID_23 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String WEBAPP_DTD_RESOURCE_PATH_23 = "/javax/servlet/resources/web-app_2_3.dtd";
    public static final String WEBAPP_DTD_PUBLIC_ID_24 = "http://java.sun.com/xml/ns/j2ee web-app_2_4.xsd";
    public static final String WEBAPP_DTD_RESOURCE_PATH_24 = "/javax/servlet/resources/web-app_2_4.xsd";
    protected SAXParser saxParser = null;
    protected boolean isServlet24 = false;
    protected boolean isServlet24_or_higher = false;
    protected boolean isServlet25_or_higher = false;
    protected StringBuffer chars = null;
    protected HashMap tagLibMap = new HashMap();
    protected String taglibUri = null;
    protected String taglibLocation = null;
    protected List jspPropertyGroups = new ArrayList();
    protected JspConfigPropertyGroup jspConfigPropertyGroup = null;
    protected List jspFileExtensions = new ArrayList();
    protected JspOptions options = null;
    protected Properties webConProperties = new Properties();

    public WebXmlParser(File outputDir) throws JspCoreException {
        try {
            String dir;
            this.options = new JspOptions(new Properties());
            if (outputDir == null && (dir = System.getProperty("java.io.tmpdir")) != null) {
                outputDir = new File(dir);
            }
            this.options.setOutputDir(outputDir.getCanonicalFile());
            this.saxParser = ParserFactory.newSAXParser(true, true);
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        catch (SAXException e) {
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
    }

    public void parseWebXml(InputStream is) throws JspCoreException {
        this.tagLibMap.clear();
        this.jspPropertyGroups.clear();
        try {
            ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getCause() != null) {
                throw new JspCoreException(e.getCause());
            }
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public Map getTagLibMap() {
        return new HashMap(this.tagLibMap);
    }

    public List getJspPropertyGroups() {
        return new ArrayList(this.jspPropertyGroups);
    }

    public boolean isServlet24() {
        return this.isServlet24;
    }

    public boolean isServlet24_or_higher() {
        return this.isServlet24_or_higher;
    }

    public boolean isServlet25_or_higher() {
        return this.isServlet25_or_higher;
    }

    public JspOptions getJspOptions() {
        return this.options;
    }

    private double getVersion(String v) {
        if (v != null) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2.3;
    }

    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        this.chars = new StringBuffer();
        if (elementName.equals("web-app")) {
            String version = attrs.getValue("version");
            if (version != null) {
                if (version.equals("2.4")) {
                    this.isServlet24 = true;
                }
                if (this.getVersion(version) >= 2.4) {
                    this.isServlet24_or_higher = true;
                }
                if (this.getVersion(version) >= 2.5) {
                    this.isServlet25_or_higher = true;
                }
            }
        } else if (elementName.equals("jsp-property-group")) {
            this.jspConfigPropertyGroup = new JspConfigPropertyGroup();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            if (this.chars == null) continue;
            this.chars.append(ch[start + i]);
        }
    }

    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (elementName.equals("taglib")) {
            this.tagLibMap.put(this.taglibUri, this.taglibLocation);
            this.taglibUri = null;
            this.taglibLocation = null;
        } else if (elementName.equals("taglib-uri")) {
            this.taglibUri = this.chars.toString().trim();
        } else if (elementName.equals("taglib-location")) {
            this.taglibLocation = this.chars.toString().trim();
        } else if (elementName.equals("jsp-property-group")) {
            this.jspPropertyGroups.add(this.jspConfigPropertyGroup);
            this.jspConfigPropertyGroup = null;
            this.isServlet24 = true;
        } else if (elementName.equals("url-pattern")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.addUrlPattern(this.chars.toString().trim());
            }
        } else if (elementName.equals("el-ignored")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(2, new Boolean(this.chars.toString().trim())));
                boolean elig = new Boolean(this.chars.toString().trim());
                if (elig) {
                    this.jspConfigPropertyGroup.add(new JspConfigProperty(9, new Boolean(true)));
                }
            }
        } else if (elementName.equals("scripting-invalid")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(3, new Boolean(this.chars.toString().trim())));
            }
        } else if (elementName.equals("include-prelude")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(5, this.chars.toString().trim()));
            }
        } else if (elementName.equals("include-coda")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(6, this.chars.toString().trim()));
            }
        } else if (elementName.equals("is-xml")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(1, new Boolean(this.chars.toString().trim())));
            }
        } else if (elementName.equals("trim-directive-whitespaces")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(8, new Boolean(this.chars.toString().trim())));
            }
        } else if (elementName.equals("deferred-syntax-allowed-as-literal")) {
            if (this.jspConfigPropertyGroup != null) {
                this.jspConfigPropertyGroup.add(new JspConfigProperty(7, new Boolean(this.chars.toString().trim())));
            }
        } else if (elementName.equals("page-encoding") && this.jspConfigPropertyGroup != null) {
            this.jspConfigPropertyGroup.add(new JspConfigProperty(4, this.chars.toString().trim()));
        }
        this.chars = null;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource isrc = null;
        String resourcePath = null;
        if (publicId.equals(WEBAPP_DTD_PUBLIC_ID_22)) {
            resourcePath = WEBAPP_DTD_RESOURCE_PATH_22;
        } else if (publicId.equals(WEBAPP_DTD_PUBLIC_ID_23)) {
            resourcePath = WEBAPP_DTD_RESOURCE_PATH_23;
        } else if (publicId.equals(WEBAPP_DTD_PUBLIC_ID_24)) {
            resourcePath = WEBAPP_DTD_RESOURCE_PATH_24;
            this.isServlet24 = true;
        }
        if (resourcePath != null) {
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            if (input == null) {
                System.out.println("publicId = " + publicId);
                System.out.println("resourcePath = " + resourcePath);
                throw new SAXException("jsp error internal dtd not found");
            }
            isrc = new InputSource(input);
        }
        return isrc;
    }

    public List getJspFileExtensions() {
        return this.jspFileExtensions;
    }

    public boolean containsServletClassName(String servletClassName) {
        return false;
    }

    public void setWebContainerProperties(Properties webConProperties) {
        this.webConProperties = webConProperties;
    }

    public Properties getWebContainerProperties() {
        return this.webConProperties;
    }
}

