/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagFileTagInfo;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.CleanupTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateTagFileResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateVisitor;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.InitTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.MethodWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateTagFileResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateTagFileVisitor
extends GenerateVisitor {
    protected GenerateTagFileResult result = null;
    protected TagFileResources tagFileFiles = null;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GenerateTagFileVisitor";

    public GenerateTagFileVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap, "TagFileValidate");
        this.result = new GenerateTagFileResult(visitorUsage.getJspVisitorDefinition().getId());
        this.tagFileFiles = (TagFileResources)inputMap.get("TagFileFiles");
        this.createWriter(this.tagFileFiles.getGeneratedSourceFile().getPath(), this.tagFileFiles.getClassName(), this.result.getCustomTagMethodJspIdMap());
    }

    public JspVisitorResult getResult() throws JspCoreException {
        this.closeWriter();
        return this.result;
    }

    public void visit(Document jspDocument, int visitCount) throws JspCoreException {
        ValidateTagFileResult validatorResult = (ValidateTagFileResult)this.resultMap.get("TagFileValidate");
        switch (visitCount) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase IMPORT_SECTION");
                }
                this.generateImportSection(validatorResult);
                break;
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase CLASS_SECTION");
                }
                this.generateClassSection(validatorResult);
                break;
            }
            case 3: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase STATIC_SECTION");
                }
                this.generateStaticSection();
                break;
            }
            case 4: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase INIT_SECTION");
                }
                this.generateInitSection(validatorResult);
                break;
            }
            case 5: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_INIT_SECTION");
                }
                this.generateDoTagInitSection(validatorResult);
                break;
            }
            case 6: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_SECTION");
                }
                this.generateDoTagSection(validatorResult, jspDocument);
                break;
            }
            case 7: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FINALLY_SECTION");
                }
                this.generateFinallySection();
            }
        }
        super.visit(jspDocument, visitCount);
        if (visitCount == 7) {
            this.writer.println("}");
            this.writer.println("}");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_WRITE");
            }
            boolean poolingTagMethodsCreated = false;
            for (MethodWriter methodWriter : this.methodWriterList) {
                MethodWriter w;
                if (methodWriter instanceof InitTaglibLookupWriter) {
                    w = (InitTaglibLookupWriter)methodWriter;
                    ((InitTaglibLookupWriter)w).complete();
                    poolingTagMethodsCreated = true;
                } else if (methodWriter instanceof CleanupTaglibLookupWriter) {
                    w = (CleanupTaglibLookupWriter)methodWriter;
                    ((CleanupTaglibLookupWriter)w).complete();
                    poolingTagMethodsCreated = true;
                }
                this.writer.printMultiLn(methodWriter.toString());
            }
            if (this.jspOptions.isUsePageTagPool() && !poolingTagMethodsCreated) {
                InitTaglibLookupWriter initTaglibLookupWriter = new InitTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                initTaglibLookupWriter.complete();
                this.writer.printMultiLn(initTaglibLookupWriter.toString());
                CleanupTaglibLookupWriter cleanupTaglibLookupWriter = new CleanupTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                cleanupTaglibLookupWriter.complete();
                this.writer.printMultiLn(cleanupTaglibLookupWriter.toString());
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FRAGMENT_HELPER");
            }
            if (this.fragmentHelperClassWriter.isUsed()) {
                this.fragmentHelperClassWriter.generatePostamble();
                this.writer.printMultiLn(this.fragmentHelperClassWriter.toString());
            }
            this.writer.println("}");
        }
    }

    protected void generateImportSection(ValidateTagFileResult validatorResult) {
        TagFileInfo tfi = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagLibraryInfoImpl tli = (TagLibraryInfoImpl)tfi.getTagInfo().getTagLibrary();
        String tagFilePath = null;
        if (tfi.getPath().startsWith("/WEB-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/WEB-INF/tags") + 13);
        } else if (tfi.getPath().startsWith("/META-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/META-INF/tags") + 14);
        }
        tagFilePath = tagFilePath.substring(0, tagFilePath.lastIndexOf("/"));
        tagFilePath = tagFilePath.replace('/', '.');
        String tagFilePackageName = "com.ibm.ws.jsp.tagfile." + tli.getOriginatorId();
        if (tagFilePath.length() > 0) {
            tagFilePackageName = tagFilePackageName + tagFilePath;
        }
        this.writer.println("package " + tagFilePackageName + ";");
        this.writer.println();
        for (int i = 0; i < Constants.STANDARD_IMPORTS.length; ++i) {
            this.writer.println("import " + Constants.STANDARD_IMPORTS[i] + ";");
        }
        this.writer.println();
    }

    protected void generateClassSection(ValidateTagFileResult validatorResult) {
        this.writer.println();
        this.writer.print("public class " + this.tagFileFiles.getClassName() + " extends javax.servlet.jsp.tagext.SimpleTagSupport");
        TagFileInfo tfi = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagInfo ti = tfi.getTagInfo();
        if (ti.hasDynamicAttributes()) {
            this.writer.println();
            this.writer.print(" implements javax.servlet.jsp.tagext.DynamicAttributes");
        }
        this.writer.println(" {");
        GeneratorUtils.generateFactoryInitialization(this.writer);
        this.writer.println();
    }

    protected void generateStaticSection() {
        this.writer.println();
        this.writer.println("static {");
    }

    protected void generateInitSection(ValidateTagFileResult validatorResult) throws JspCoreException {
        int i;
        int i2;
        TagFileInfo tfi = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagInfo ti = tfi.getTagInfo();
        boolean aliasSeen = false;
        TagVariableInfo[] tagVars = ti.getTagVariableInfos();
        for (i2 = 0; i2 < tagVars.length; ++i2) {
            if (tagVars[i2].getNameFromAttribute() == null || tagVars[i2].getNameGiven() == null) continue;
            aliasSeen = true;
            break;
        }
        this.writer.println("}");
        this.writer.println();
        GeneratorUtils.generateInitSectionCode(this.writer, GeneratorUtils.TAG_FILE_TYPE);
        this.writer.println();
        GeneratorUtils.generateELFunctionCode(this.writer, validatorResult);
        this.writer.println("private JspContext jspContext;");
        this.writer.println("private java.io.Writer _jspx_sout;");
        if (aliasSeen) {
            this.writer.println("public void setJspContext(JspContext ctx, java.util.Map aliasMap) {");
        } else {
            this.writer.println("public void setJspContext( JspContext ctx ) {");
        }
        this.writer.println("super.setJspContext(ctx);");
        this.writer.println("java.util.ArrayList _jspx_nested = null;");
        this.writer.println("java.util.ArrayList _jspx_at_begin = null;");
        this.writer.println("java.util.ArrayList _jspx_at_end = null;");
        for (i2 = 0; i2 < tagVars.length; ++i2) {
            switch (tagVars[i2].getScope()) {
                case 0: {
                    this.writer.println("if (_jspx_nested == null)");
                    this.writer.println("_jspx_nested = new java.util.ArrayList();");
                    this.writer.print("_jspx_nested.add(");
                    break;
                }
                case 1: {
                    this.writer.println("if (_jspx_at_begin == null)");
                    this.writer.println("_jspx_at_begin = new java.util.ArrayList();");
                    this.writer.print("_jspx_at_begin.add(");
                    break;
                }
                case 2: {
                    this.writer.println("if (_jspx_at_end == null)");
                    this.writer.println("_jspx_at_end = new java.util.ArrayList();");
                    this.writer.print("_jspx_at_end.add(");
                }
            }
            this.writer.print(GeneratorUtils.quote(tagVars[i2].getNameGiven()));
            this.writer.print(");");
            this.writer.println();
        }
        if (aliasSeen) {
            this.writer.println("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, aliasMap);");
        } else {
            this.writer.println("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, null);");
        }
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public JspContext getJspContext() {");
        this.writer.println("return this.jspContext;");
        this.writer.println("}");
        if (ti.hasDynamicAttributes()) {
            this.writer.println("private java.util.HashMap _jspx_dynamic_attrs = new java.util.HashMap();");
        }
        TagAttributeInfo[] attrInfos = ti.getAttributes();
        for (i = 0; i < attrInfos.length; ++i) {
            this.writer.print("private ");
            if (attrInfos[i].isFragment()) {
                this.writer.print("javax.servlet.jsp.tagext.JspFragment ");
            } else {
                this.writer.print(GeneratorUtils.toJavaSourceType(attrInfos[i].getTypeName()));
                this.writer.print(" ");
            }
            this.writer.print(attrInfos[i].getName());
            this.writer.print(";");
            this.writer.println();
        }
        this.writer.println();
        if (attrInfos != null) {
            for (i = 0; i < attrInfos.length; ++i) {
                this.writer.print("public ");
                if (attrInfos[i].isFragment()) {
                    this.writer.print("javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    this.writer.print(GeneratorUtils.toJavaSourceType(attrInfos[i].getTypeName()));
                    this.writer.print(" ");
                }
                this.writer.print(GeneratorUtils.toGetterMethod(attrInfos[i].getName()));
                this.writer.print(" {");
                this.writer.println();
                this.writer.print("return this.");
                this.writer.print(attrInfos[i].getName());
                this.writer.print(";");
                this.writer.println();
                this.writer.println("}");
                this.writer.println();
                this.writer.print("public void ");
                this.writer.print(GeneratorUtils.toSetterMethodName(attrInfos[i].getName()));
                if (attrInfos[i].isFragment()) {
                    this.writer.print("(javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    this.writer.print("(");
                    this.writer.print(GeneratorUtils.toJavaSourceType(attrInfos[i].getTypeName()));
                    this.writer.print(" ");
                }
                this.writer.print(attrInfos[i].getName());
                this.writer.print(") {");
                this.writer.println();
                this.writer.print("this.");
                this.writer.print(attrInfos[i].getName());
                this.writer.print(" = ");
                this.writer.print(attrInfos[i].getName());
                this.writer.print(";");
                this.writer.println();
                this.writer.print("jspContext.setAttribute(");
                this.writer.print(GeneratorUtils.quote(attrInfos[i].getName()));
                this.writer.print(", ");
                this.writer.print(attrInfos[i].getName());
                this.writer.print(");");
                this.writer.println("}");
                this.writer.println();
            }
        }
        if (ti.hasDynamicAttributes()) {
            this.writer.println("public void setDynamicAttribute(String uri, String localName, Object value) throws javax.servlet.jsp.JspException {");
            this.writer.println("if (uri == null) _jspx_dynamic_attrs.put(localName, value);");
            this.writer.println("}");
        }
    }

    protected void generateDoTagInitSection(ValidateTagFileResult validatorResult) {
        TagFileInfo tfi = (TagFileInfo)this.inputMap.get("TagFileInfo");
        TagInfo ti = tfi.getTagInfo();
        this.writer.println("public void doTag() throws javax.servlet.jsp.JspException, java.io.IOException {");
        this.writer.println("PageContext pageContext = (PageContext)jspContext;");
        this.writer.println("javax.servlet.http.HttpServletRequest request = (javax.servlet.http.HttpServletRequest) pageContext.getRequest();");
        this.writer.println("javax.servlet.http.HttpServletResponse response = (javax.servlet.http.HttpServletResponse) pageContext.getResponse();");
        this.writer.println("javax.servlet.http.HttpSession session = pageContext.getSession();");
        this.writer.println("javax.servlet.ServletContext application = pageContext.getServletContext();");
        this.writer.println("javax.servlet.ServletConfig config = pageContext.getServletConfig();");
        this.writer.println("javax.servlet.jsp.JspWriter out = jspContext.getOut();");
        this.writer.println();
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup();");
            this.writer.println();
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = new java.util.HashMap();");
            this.writer.println();
        }
        this.writer.println("_jspInit(config);");
        this.writer.println();
        this.writer.println("jspContext.getELContext().putContext(JspContext.class,jspContext);");
        boolean varMapperInit = false;
        TagAttributeInfo[] attrInfos = ti.getAttributes();
        for (int i = 0; i < attrInfos.length; ++i) {
            String attrName = attrInfos[i].getName();
            if (attrInfos[i].isDeferredMethod() || attrInfos[i].isDeferredValue()) {
                if (!varMapperInit) {
                    this.writer.print("javax.el.VariableMapper _jspx_varmap= jspContext.getELContext().getVariableMapper();");
                    this.writer.println();
                    varMapperInit = true;
                }
                this.writer.print("javax.el.ValueExpression _jspx_ve");
                this.writer.print(Integer.toString(i));
                this.writer.print(" = _jspx_varmap.setVariable(");
                this.writer.print(GeneratorUtils.quote(attrName));
                this.writer.print(", ");
                if (attrInfos[i].isDeferredMethod()) {
                    this.writer.print("_el_expressionfactory");
                    this.writer.print(".createValueExpression(");
                    this.writer.print(GeneratorUtils.toGetterMethod(attrName));
                    this.writer.print(",javax.el.MethodExpression.class)");
                } else {
                    this.writer.print(GeneratorUtils.toGetterMethod(attrName));
                }
                this.writer.print(");");
                this.writer.println();
                continue;
            }
            this.writer.print("if (" + GeneratorUtils.toGetterMethod(attrName) + " != null) ");
            this.writer.print(" pageContext.setAttribute(");
            this.writer.print(GeneratorUtils.quote(attrName));
            this.writer.print(", ");
            this.writer.print(GeneratorUtils.toGetterMethod(attrName));
            this.writer.print(");");
            this.writer.println();
        }
        if (ti.hasDynamicAttributes()) {
            this.writer.print("pageContext.setAttribute(\"");
            this.writer.print(((TagFileTagInfo)ti).getDynamicAttributesMapName());
            this.writer.print("\", _jspx_dynamic_attrs);");
            this.writer.println();
        }
    }

    protected void generateDoTagSection(ValidateTagFileResult validatorResult, Document jspDocument) {
        this.writer.println("try {");
        if (this.jspConfiguration.isXml()) {
            boolean omitXmlDeclaration = true;
            Element outputElement = null;
            if (jspDocument.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").getLength() > 0) {
                outputElement = (Element)jspDocument.getDocumentElement().getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").item(0);
                String s = outputElement.getAttribute("omit-xml-declaration");
                if (s.equalsIgnoreCase("no") || s.equalsIgnoreCase("false")) {
                    omitXmlDeclaration = false;
                } else if (s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("true")) {
                    omitXmlDeclaration = true;
                }
            }
            if (!omitXmlDeclaration) {
                String pageEncoding = validatorResult.getPageEncoding();
                if ((pageEncoding == null || pageEncoding.equals("")) && ((pageEncoding = this.jspConfiguration.getPageEncoding()) == null || pageEncoding.equals(""))) {
                    pageEncoding = "UTF-8";
                }
                this.writer.println("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + pageEncoding + "\\\"?>\\n\");");
            }
            String doctype = "";
            if (outputElement != null) {
                doctype = outputElement.getAttribute("doctype-root-element");
            }
            if (outputElement != null && !doctype.equals("")) {
                String docTypeRootElement = outputElement.getAttribute("doctype-root-element");
                String docTypeSystem = outputElement.getAttribute("doctype-system");
                String docTypePublic = outputElement.getAttribute("doctype-public");
                this.writer.print("out.write(\"<!DOCTYPE " + docTypeRootElement);
                if (!docTypePublic.equals("")) {
                    this.writer.print(" PUBLIC \\\"" + docTypePublic + "\\\" \\\"" + docTypeSystem + "\\\">\\n\");");
                    this.writer.println();
                } else {
                    this.writer.print(" SYSTEM \\\"" + docTypeSystem + "\\\">\\n\");");
                    this.writer.println();
                }
            }
        }
    }

    protected void generateFinallySection() {
        this.writer.println("} catch( Throwable t ) {");
        this.writer.println("if( t instanceof javax.servlet.jsp.SkipPageException )");
        this.writer.println("    throw (javax.servlet.jsp.SkipPageException) t;");
        this.writer.println("if( t instanceof java.io.IOException )");
        this.writer.println("    throw (java.io.IOException) t;");
        this.writer.println("if( t instanceof IllegalStateException )");
        this.writer.println("    throw (IllegalStateException) t;");
        this.writer.println("if( t instanceof javax.servlet.jsp.JspException )");
        this.writer.println("    throw (javax.servlet.jsp.JspException) t;");
        this.writer.println("throw new javax.servlet.jsp.JspException(t);");
        this.writer.println("} finally {");
        this.writer.println("jspContext.getELContext().putContext(JspContext.class,super.getJspContext());");
        this.writer.println("((org.apache.jasper.runtime.JspContextWrapper) jspContext).syncEndTagFile();");
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("cleanupTaglibLookup(_jspx_TagLookup);");
        }
    }
}

