/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.CleanupTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateJspResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateVisitor;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.InitTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.JavaFileWriter;
import com.ibm.ws.jsp.translator.visitor.generator.MethodWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateJspResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateJspVisitor
extends GenerateVisitor {
    protected GenerateJspResult result = null;
    protected ArrayList interfaces = new ArrayList();
    protected String jspServletBase = "com.ibm.ws.jsp.runtime.HttpJspBase";
    protected String serviceMethodName = "_jspService";
    protected String jspClassName = null;
    protected String jspPackageName = null;
    protected String jspSourceFileName = null;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GenerateJspVisitor";

    public GenerateJspVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap, "JspValidate");
        this.result = new GenerateJspResult(visitorUsage.getJspVisitorDefinition().getId());
        JspResources jspFiles = (JspResources)inputMap.get("JspFiles");
        this.jspClassName = jspFiles.getClassName();
        this.jspPackageName = jspFiles.getPackageName();
        this.jspSourceFileName = jspFiles.getGeneratedSourceFile().toString();
        this.jspSourceFileName = this.jspSourceFileName.replace('\\', '/');
        this.createWriter(jspFiles.getGeneratedSourceFile().getPath(), this.jspClassName, this.result.getCustomTagMethodJspIdMap());
    }

    public JspVisitorResult getResult() throws JspCoreException {
        this.closeWriter();
        return this.result;
    }

    public void visit(Document jspDocument, int visitCount) throws JspCoreException {
        ValidateJspResult validatorResult = (ValidateJspResult)this.resultMap.get("JspValidate");
        boolean genSessionVariable = validatorResult.isGenSessionVariable();
        switch (visitCount) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase IMPORT_SECTION");
                }
                this.generateImportSection(validatorResult);
                break;
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase CLASS_SECTION");
                }
                this.generateClassSection(validatorResult);
                break;
            }
            case 3: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase STATIC_SECTION");
                }
                this.generateStaticSection();
                break;
            }
            case 4: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase INIT_SECTION");
                }
                this.generateInitSection(validatorResult);
                break;
            }
            case 5: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_INIT_SECTION");
                }
                this.generateServiceInitSection(validatorResult, genSessionVariable);
                break;
            }
            case 6: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_SECTION");
                }
                this.generateServiceSection(validatorResult, genSessionVariable, jspDocument);
                break;
            }
            case 7: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FINALLY_SECTION");
                }
                this.generateFinallySection();
            }
        }
        super.visit(jspDocument, visitCount);
        if (visitCount == 7) {
            this.writer.println("}");
            this.writer.println("}");
            boolean poolingTagMethodsCreated = false;
            for (MethodWriter methodWriter : this.methodWriterList) {
                MethodWriter w;
                if (methodWriter instanceof InitTaglibLookupWriter) {
                    w = (InitTaglibLookupWriter)methodWriter;
                    ((InitTaglibLookupWriter)w).complete();
                    poolingTagMethodsCreated = true;
                } else if (methodWriter instanceof CleanupTaglibLookupWriter) {
                    w = (CleanupTaglibLookupWriter)methodWriter;
                    ((CleanupTaglibLookupWriter)w).complete();
                }
                this.writer.printMultiLn(methodWriter.toString());
            }
            if ((this.jspOptions.isUsePageTagPool() || this.jspOptions.isUseThreadTagPool()) && !poolingTagMethodsCreated) {
                InitTaglibLookupWriter initTaglibLookupWriter = new InitTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                initTaglibLookupWriter.complete();
                this.writer.printMultiLn(initTaglibLookupWriter.toString());
                CleanupTaglibLookupWriter cleanupTaglibLookupWriter = new CleanupTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                cleanupTaglibLookupWriter.complete();
                this.writer.printMultiLn(cleanupTaglibLookupWriter.toString());
            }
            if (this.fragmentHelperClassWriter.isUsed()) {
                this.fragmentHelperClassWriter.generatePostamble();
                this.writer.printMultiLn(this.fragmentHelperClassWriter.toString());
            }
            this.writer.println("}");
            if (this.jspOptions.isKeepGenerated()) {
                this.writer.println("/*");
                this.writer.println(this.jspSourceFileName + " was generated @ " + new Date());
                this.writer.println(GeneratorUtils.fullClassfileInformation);
                this.writer.println(" ");
                this.writer.println("********************************************************");
                this.writer.println("The JSP engine configuration parameters were set as follows:");
                this.writer.println(this.jspOptions.toString());
                this.writer.println("********************************************************");
                this.writer.println("The following JSP Configuration Parameters were obtained from web.xml:");
                this.writer.println(" ");
                this.writer.println("prelude list = [" + this.jspConfiguration.getPreludeList() + "]");
                this.writer.println("coda list = [" + this.jspConfiguration.getCodaList() + "]");
                this.writer.println("elIgnored = [" + this.jspConfiguration.elIgnored() + "]");
                this.writer.println("pageEncoding = [" + this.jspConfiguration.getPageEncoding() + "]");
                this.writer.println("isXML = [" + this.jspConfiguration.isXml() + "]");
                this.writer.println("scriptingInvalid = [" + this.jspConfiguration.scriptingInvalid() + "]");
                this.writer.println("trimDirectiveWhitespaces = [" + this.jspConfiguration.isTrimDirectiveWhitespaces() + "]");
                this.writer.println("deferredSyntaxAllowedAsLiteral = [" + this.jspConfiguration.isDeferredSyntaxAllowedAsLiteral() + "]");
                this.writer.println("*/");
            }
        }
    }

    protected void generateImportSection(ValidateJspResult validatorResult) {
        String servletPackageName = this.jspPackageName;
        this.writer.println("package " + servletPackageName + ";");
        this.writer.println();
        for (int i = 0; i < Constants.STANDARD_IMPORTS.length; ++i) {
            this.writer.println("import " + Constants.STANDARD_IMPORTS[i] + ";");
        }
        this.writer.println();
    }

    protected void generateClassSection(ValidateJspResult validatorResult) {
        this.writer.println();
        this.writer.print("public final class " + this.jspClassName + " extends ");
        String extendsClass = validatorResult.getExtendsClass();
        this.writer.print(extendsClass == null ? this.jspServletBase : extendsClass);
        this.interfaces.add("com.ibm.ws.jsp.runtime.JspClassInformation");
        boolean singleThreaded = validatorResult.isSingleThreaded();
        if (singleThreaded) {
            this.interfaces.add("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.print("     implements");
            for (int i = 0; i < this.interfaces.size() - 1; ++i) {
                this.writer.print(" " + this.interfaces.get(i) + ",");
            }
            this.writer.print(" " + this.interfaces.get(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.println();
        GeneratorUtils.generateFactoryInitialization(this.writer);
        this.writer.println();
        GeneratorUtils.generateDependencyList(this.writer, validatorResult, this.context, this.jspOptions.isTrackDependencies());
        this.writer.println();
        GeneratorUtils.generateInjectionSection(this.writer);
        this.writer.println();
        GeneratorUtils.generateVersionInformation(this.writer, this.jspOptions.isDebugEnabled());
        if (validatorResult.getInfo() != null) {
            this.writer.println();
            this.writer.println("public String getServletInfo() {");
            this.writer.print("return ");
            this.writer.print(GeneratorUtils.quote(validatorResult.getInfo()));
            this.writer.println(";");
            this.writer.print("}");
            this.writer.println();
        }
    }

    protected void generateStaticSection() {
        this.writer.println();
        this.writer.println("static {");
    }

    protected void generateInitSection(ValidateJspResult validatorResult) throws JspCoreException {
        this.writer.println("}");
        this.writer.println();
        GeneratorUtils.generateInitSectionCode(this.writer, GeneratorUtils.JSP_FILE_TYPE);
        this.writer.println();
        GeneratorUtils.generateELFunctionCode(this.writer, validatorResult);
        this.writer.println();
    }

    protected void generateServiceInitSection(ValidateJspResult validatorResult, boolean genSessionVariable) {
        boolean isErrorPage;
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws java.io.IOException, ServletException {");
        this.writer.println();
        this.result.setServiceMethodLineNumber(((JavaFileWriter)this.writer).getCurrentLineNumber());
        this.writer.println("PageContext pageContext = null;");
        if (genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (isErrorPage = validatorResult.isErrorPage()) {
            this.writer.println("Throwable exception = org.apache.jasper.runtime.JspRuntimeLibrary.getThrowable(request);");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println();
        this.writer.println("JspWriter _jspx_out = null;");
        this.writer.println();
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup();");
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup(request);");
        }
    }

    protected void generateServiceSection(ValidateJspResult validatorResult, boolean genSessionVariable, Document jspDocument) {
        this.writer.println();
        this.writer.println("try {");
        this.writer.println();
        String contentType = validatorResult.getContentType();
        boolean autoResponseEncoding = this.jspOptions.isAutoResponseEncoding();
        if (contentType == null) {
            contentType = this.jspConfiguration.isXml() ? "text/xml" : "text/html";
        }
        if (contentType.indexOf("charset=") < 0) {
            if (this.jspConfiguration.isXml()) {
                if (!autoResponseEncoding) {
                    contentType = contentType + ";charset=UTF-8";
                }
            } else {
                String pageEncoding = validatorResult.getPageEncoding();
                if (pageEncoding != null && !pageEncoding.equals("")) {
                    contentType = contentType + ";charset=" + pageEncoding;
                } else {
                    String responseEncoding = this.jspConfiguration.getResponseEncoding();
                    if (responseEncoding != null && !responseEncoding.equals("")) {
                        contentType = contentType + ";charset=" + responseEncoding;
                    } else {
                        logger.logp(Level.FINEST, CLASS_NAME, "generateServiceSection", "JSP did not specify charset; defer to webcontainer");
                    }
                }
            }
        }
        this.writer.println("response.setContentType(" + this.writer.quoteString(contentType) + ");");
        String error = validatorResult.getError();
        int bufferSize = validatorResult.getBufferSize();
        boolean autoFlush = validatorResult.isAutoFlush();
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response, " + this.writer.quoteString(error) + ", " + genSessionVariable + ", " + bufferSize + ", " + autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
        this.writer.println("_jspx_out = out;");
        this.writer.println();
        if (this.jspConfiguration.isXml()) {
            boolean omitXmlDeclaration = false;
            if (jspDocument.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "root").getLength() > 0) {
                omitXmlDeclaration = true;
            }
            Element outputElement = null;
            if (jspDocument.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").getLength() > 0) {
                outputElement = (Element)jspDocument.getDocumentElement().getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").item(0);
                String s = outputElement.getAttribute("omit-xml-declaration");
                if (s.equalsIgnoreCase("no") || s.equalsIgnoreCase("false")) {
                    omitXmlDeclaration = false;
                } else if (s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("true")) {
                    omitXmlDeclaration = true;
                }
            }
            if (!omitXmlDeclaration) {
                String pageEncoding = validatorResult.getPageEncoding();
                if ((pageEncoding == null || pageEncoding.equals("")) && ((pageEncoding = this.jspConfiguration.getPageEncoding()) == null || pageEncoding.equals(""))) {
                    pageEncoding = "UTF-8";
                }
                this.writer.println("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + pageEncoding + "\\\"?>\\n\");");
            }
            String doctype = "";
            if (outputElement != null) {
                doctype = outputElement.getAttribute("doctype-root-element");
            }
            if (outputElement != null && !doctype.equals("")) {
                String docTypeRootElement = outputElement.getAttribute("doctype-root-element");
                String docTypeSystem = outputElement.getAttribute("doctype-system");
                String docTypePublic = outputElement.getAttribute("doctype-public");
                this.writer.print("out.write(\"<!DOCTYPE " + docTypeRootElement);
                if (!docTypePublic.equals("")) {
                    this.writer.print(" PUBLIC \\\"" + docTypePublic + "\\\" \\\"" + docTypeSystem + "\\\">\\n\");");
                    this.writer.println();
                } else {
                    this.writer.print(" SYSTEM \\\"" + docTypeSystem + "\\\">\\n\");");
                    this.writer.println();
                }
            }
        }
    }

    protected void generateFinallySection() {
        this.writer.println();
        this.writer.println("} catch (Throwable t) {");
        this.writer.println("if (!(t instanceof javax.servlet.jsp.SkipPageException)){");
        this.writer.println("out = _jspx_out;");
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.println("out.clearBuffer();");
        this.writer.println("if (pageContext != null) pageContext.handlePageException(t);");
        this.writer.println("}");
        this.writer.println("else if (t instanceof com.ibm.ws.jsp.runtime.WsSkipPageException){");
        this.writer.println("((com.ibm.ws.jsp.runtime.WsSkipPageException)t).printStackTraceIfTraceEnabled();");
        this.writer.println("}");
        this.writer.println("} finally {");
        this.writer.println("_jspxFactory.releasePageContext(pageContext);");
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("cleanupTaglibLookup(_jspx_TagLookup);");
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("cleanupTaglibLookup(request, _jspx_TagLookup);");
        }
    }
}

