/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import java.io.File;
import java.util.StringTokenizer;

public class NameMangler {
    public static String[] keywords;
    public static String[] keywordsSlash;

    public static final String mangleName(String name) {
        int iSep = name.lastIndexOf(47) + 1;
        int iEnd = name.length();
        String convertedClassName = name.substring(iSep, iEnd);
        if (name.endsWith(".jsp")) {
            convertedClassName = convertedClassName.substring(0, convertedClassName.length() - 4);
        } else if (name.indexOf(".") > -1) {
            convertedClassName = convertedClassName.replace('.', '_');
        }
        return NameMangler.mangleString(convertedClassName);
    }

    public static final String mangleClassName(String jspFileName) {
        return "_" + NameMangler.mangleName(jspFileName);
    }

    public static final String mangleChar(char ch) {
        return NameMangler.mangleChar(ch, false);
    }

    public static final String mangleChar(char ch, boolean shouldMangleLetterDigit) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        if (!shouldMangleLetterDigit && Character.isLetterOrDigit(ch)) {
            return "" + ch;
        }
        return "_" + Integer.toHexString(ch).toUpperCase() + "_";
    }

    public static String mangleString(String name) {
        StringBuffer modifiedName = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '/') {
                modifiedName.append(name.substring(i, i + 1));
                continue;
            }
            modifiedName.append(NameMangler.mangleChar(name.charAt(i)));
        }
        return modifiedName.toString();
    }

    public static String handlePackageName(String mangledDirName) {
        mangledDirName = mangledDirName.replace('\\', '/');
        String mangledDirNameBuff = NameMangler.mangleString(mangledDirName);
        mangledDirName = NameMangler.handleReservedWords(mangledDirNameBuff.toString());
        mangledDirName = NameMangler.removeLeadingSlashes(new StringBuffer(mangledDirName));
        mangledDirName = NameMangler.handlePackageStartingWithDigits(mangledDirName);
        return NameMangler.convertFileSepCharToPackageChar(mangledDirName);
    }

    public static String handlePackageStartingWithDigits(String mangledDirName) {
        StringBuffer tmpPackageName = new StringBuffer();
        StringTokenizer st = new StringTokenizer(mangledDirName, "/", true);
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (Character.isDigit(currToken.charAt(0))) {
                tmpPackageName.append(NameMangler.mangleChar(currToken.charAt(0), true));
                tmpPackageName.append(currToken.substring(1));
                continue;
            }
            tmpPackageName.append(currToken);
        }
        return tmpPackageName.toString();
    }

    public static String removeLeadingSlashes(StringBuffer buff) {
        int index = 0;
        while (buff.charAt(index) == '/') {
            ++index;
        }
        String currString = buff.toString();
        return currString.substring(index);
    }

    public static String convertFileSepCharToPackageChar(String pathName) {
        if (pathName != null) {
            String packageName;
            pathName = pathName.replace('.', '_');
            pathName = pathName.replace('\\', '/');
            pathName = packageName = pathName.replace('/', '.');
        }
        return pathName;
    }

    public static String handleReservedWords(String pathName) {
        String packageSep = "/";
        for (int i = 0; i < keywords.length; ++i) {
            boolean found;
            boolean bl = found = pathName.indexOf(keywordsSlash[i]) > -1 || pathName.startsWith(keywords[i]);
            if (!found) continue;
            StringTokenizer st = new StringTokenizer(pathName, packageSep, true);
            StringBuffer pathNameBuffer = new StringBuffer();
            while (st.hasMoreTokens()) {
                String currToken = st.nextToken();
                if (currToken.equals(keywords[i])) {
                    String mgChar = NameMangler.mangleChar(currToken.charAt(0), true);
                    String balance = currToken.substring(1);
                    pathNameBuffer.append(mgChar + balance);
                    continue;
                }
                pathNameBuffer.append(currToken);
            }
            pathName = pathNameBuffer.toString();
        }
        return pathName;
    }

    static {
        String[] _keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        keywords = _keywords;
        keywordsSlash = new String[_keywords.length];
        for (int i = 0; i < _keywords.length; ++i) {
            NameMangler.keywordsSlash[i] = "/" + _keywords[i];
        }
    }
}

