/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.utils.FileLocker;
import com.ibm.ws.jsp.translator.utils.JspTranslationResult;
import com.ibm.ws.jsp.translator.utils.SDEInstaller;
import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.smap.SmapVisitorResult;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspClassFactory;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagFileInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JspTranslatorUtil {
    private static final String JSP_TRANSLATION_ID = "JspTranslation";
    private static final String DEBUG_JSP_TRANSLATION_ID = "DebugJspTranslation";
    private static final String TAGFILE_TRANSLATION_ID = "TagFileTranslation";
    private static final String DEBUG_TAGFILE_TRANSLATION_ID = "DebugTagFileTranslation";
    private static final String IN_MEMORY_JSP_TRANSLATION_ID = "InMemoryJspTranslation";
    private static final String IN_MEMORY_DEBUG_JSP_TRANSLATION_ID = "InMemoryDebugJspTranslation";
    private static final String IN_MEMORY_TAGFILE_TRANSLATION_ID = "InMemoryTagFileTranslation";
    private static final String IN_MEMORY_DEBUG_TAGFILE_TRANSLATION_ID = "InMemoryDebugTagFileTranslation";
    private static String separatorString = System.getProperty("line.separator");
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil";

    public static JspCompilerResult translateJspAndCompile(JspResources jspResources, JspTranslationContext context, JspConfiguration config, JspOptions options, TagLibraryCache tlc, boolean forceTagFileTranslation, List compilerOptions) throws JspCoreException {
        boolean fileLock = true;
        boolean isZOS = options.isZOS();
        JspCompilerResult compileResult = null;
        long startTranslationTime = System.currentTimeMillis();
        FileLocker zosFileLocker = null;
        if (isZOS) {
            zosFileLocker = (FileLocker)new JspClassFactory().getInstanceOf("FileLocker");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "begin translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
        }
        JspTranslationResult translationResult = null;
        try {
            translationResult = JspTranslatorUtil.translateJsp(jspResources, context, config, options, tlc, forceTagFileTranslation, compilerOptions);
        }
        catch (JspTranslationException e) {
            String filePath = e.getFilePath();
            JspTranslationException finalException = null;
            if (filePath != null && !filePath.equals(jspResources.getInputSource().getRelativeURL())) {
                finalException = new JspTranslationException("jsp.error.exception.caught.translating.included.file", new Object[]{jspResources.getInputSource().getRelativeURL(), separatorString + e.getLocalizedMessage() + separatorString});
            } else {
                String msg = jspResources.getInputSource().getRelativeURL() + ":  " + separatorString + e.getLocalizedMessage() + separatorString;
                finalException = new JspTranslationException("jsp.error.exception.caught.translating", new Object[]{msg});
            }
            finalException.setStackTrace(e.getStackTrace());
            throw finalException;
        }
        long endTranslationTime = System.currentTimeMillis();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "translateJspAndCompile", "completed translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "] time = " + (endTranslationTime - startTranslationTime) + "ms");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "translateJspAndCompile", "begin compile phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
        }
        if (isZOS && zosFileLocker != null) {
            fileLock = zosFileLocker.obtainFileLock(jspResources.getGeneratedSourceFile().getName());
        }
        if (translationResult.getTagFileCompileResult() != null && translationResult.getTagFileCompileResult().getCompilerReturnValue() != 0) {
            compileResult = translationResult.getTagFileCompileResult();
        } else {
            JspResources[] dependencies = null;
            if (translationResult.getTagFileDependencyList().size() > 0) {
                dependencies = new JspResources[translationResult.getTagFileDependencyList().size()];
                dependencies = translationResult.getTagFileDependencyList().toArray(dependencies);
            }
            if (fileLock) {
                JspCompiler compiler = context.getJspCompilerFactory().createJspCompiler();
                compileResult = compiler.compile(new JspResources[]{jspResources}, dependencies, translationResult.getJspLineIds(), compilerOptions);
                boolean logOutput = false;
                if (compileResult.getCompilerReturnValue() == 0) {
                    if (options.isVerbose() || options.isDeprecation() || compilerOptions != null && (compilerOptions.contains("-verbose") || compilerOptions.contains("-deprecation"))) {
                        logOutput = true;
                    }
                    if (translationResult.hasSmap()) {
                        SmapGenerator smapGenerator = translationResult.getSmapGenerator(jspResources.getInputSource().getAbsoluteURL().toExternalForm());
                        JspTranslatorUtil.installSmap(jspResources, smapGenerator);
                    }
                    jspResources.sync();
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "translateJspAndCompile", "complete compile phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                }
                if (logOutput && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                    logger.logp(Level.WARNING, CLASS_NAME, "translateJspAndCompile", "[" + compileResult.getCompilerMessage() + "]");
                }
                if (isZOS && zosFileLocker != null) {
                    zosFileLocker.releaseFileLock(jspResources.getGeneratedSourceFile().getName());
                }
            }
        }
        return compileResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JspTranslationResult translateJsp(JspResources jspResources, JspTranslationContext context, JspConfiguration config, JspOptions options, TagLibraryCache tlc, boolean forceTagFileTranslation, List compilerOptions) throws JspCoreException {
        JspTranslator jspTranslator;
        HashMap resultMap;
        JspTranslationResult translationResult = new JspTranslationResult();
        Integer JspIdConsumerCounter = new Integer(-1);
        Object JspIdConsumerPrefix = null;
        ArrayList tagFileDependencyIdList = new ArrayList();
        JspVisitorInputMap inputMap = new JspVisitorInputMap();
        inputMap.put("TagFileDependencies", tagFileDependencyIdList);
        inputMap.put("TagLibraryCache", tlc);
        inputMap.put("JspFiles", jspResources);
        inputMap.put("JspOptions", options);
        inputMap.put("JspUri", jspResources.getInputSource().getRelativeURL());
        inputMap.put("JspIdConsumerCounter", JspIdConsumerCounter);
        inputMap.put("JspIdConsumerPrefix", JspIdConsumerPrefix);
        String jspVisitorCollectionId = null;
        String tagFileVisitorCollectionId = null;
        if (!options.isUseInMemory()) {
            jspVisitorCollectionId = JSP_TRANSLATION_ID;
            tagFileVisitorCollectionId = TAGFILE_TRANSLATION_ID;
            if (options.isDebugEnabled()) {
                jspVisitorCollectionId = DEBUG_JSP_TRANSLATION_ID;
                tagFileVisitorCollectionId = DEBUG_TAGFILE_TRANSLATION_ID;
            }
        } else {
            jspVisitorCollectionId = IN_MEMORY_JSP_TRANSLATION_ID;
            tagFileVisitorCollectionId = IN_MEMORY_TAGFILE_TRANSLATION_ID;
            if (options.isDebugEnabled()) {
                jspVisitorCollectionId = IN_MEMORY_DEBUG_JSP_TRANSLATION_ID;
                tagFileVisitorCollectionId = IN_MEMORY_DEBUG_TAGFILE_TRANSLATION_ID;
            }
        }
        if ((resultMap = (jspTranslator = JspTranslatorFactory.getFactory().createTranslator(jspVisitorCollectionId, jspResources.getInputSource(), context, config, options, tlc.getImplicitTagLibPrefixMap())).processVisitors(inputMap)).containsKey("Smap")) {
            SmapVisitorResult smapResult = (SmapVisitorResult)resultMap.get("Smap");
            translationResult.addSmapGenerator(jspResources.getInputSource().getAbsoluteURL().toExternalForm(), smapResult.getSmapGenerator());
        }
        translationResult.addJspLineIds(jspResources, jspTranslator.getDocument());
        if (tagFileDependencyIdList.size() > 0) {
            Object lock = tlc.getTagFileLock(tagFileDependencyIdList);
            try {
                Object object = lock;
                synchronized (object) {
                    ArrayList<TagFileResources> tagFilesToCompile = new ArrayList<TagFileResources>();
                    ArrayList<TagFileResources> tagFilesNotToCompile = new ArrayList<TagFileResources>();
                    ArrayList tagFileIds = new ArrayList();
                    for (TagFileId tagFileId : tagFileDependencyIdList) {
                        TagLibraryInfoImpl tli = tlc.getTagLibraryInfo(tagFileId.getUri(), tagFileId.getPrefix(), jspResources.getInputSource().getRelativeURL());
                        TagFileInfo tfi = tli.getTagFile(tagFileId.getTagName());
                        JspInputSource tagFileInputSource = context.getJspInputSourceFactory().copyJspInputSource(tli.getInputSource(), tfi.getPath());
                        TagFileResources tagFileResources = context.getJspResourcesFactory().createTagFileResources(tagFileInputSource, tfi);
                        tagFileResources = tlc.getTagFileResources(tagFileResources);
                        translationResult.getTagFileDependencyList().add(tagFileResources);
                        if (forceTagFileTranslation && !tagFileResources.getGeneratedSourceFile().getParentFile().exists()) {
                            tagFileResources.getGeneratedSourceFile().getParentFile().mkdirs();
                        }
                        if (forceTagFileTranslation || tagFileResources.isOutdated()) {
                            JspConfiguration tagConfiguration = config.createEmptyJspConfiguration();
                            if (tli != null && tli.getRequiredVersion() != null) {
                                tagConfiguration.setJspVersion(tli.getRequiredVersion());
                            }
                            tagConfiguration.setElIgnored(config.elIgnored());
                            JspTranslator tagFileTranslator = JspTranslatorFactory.getFactory().createTranslator(tagFileVisitorCollectionId, tagFileInputSource, context, tagConfiguration, options, tlc.getImplicitTagLibPrefixMap());
                            JspVisitorInputMap tagFileInputMap = new JspVisitorInputMap();
                            tagFileInputMap.put("JspOptions", options);
                            tagFileInputMap.put("TagLibraryCache", tlc);
                            tagFileInputMap.put("TagFileFiles", tagFileResources);
                            tagFileInputMap.put("TagFileInfo", tfi);
                            tagFileInputMap.put("isTagFile", new Boolean(true));
                            tagFileInputMap.put("JspUri", jspResources.getInputSource().getRelativeURL());
                            HashMap results = tagFileTranslator.processVisitors(tagFileInputMap);
                            if (results.containsKey("Smap")) {
                                SmapVisitorResult smapResult = (SmapVisitorResult)results.get("Smap");
                                translationResult.addSmapGenerator(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm(), smapResult.getSmapGenerator());
                            }
                            JspTranslationResult.loadJspIdList(tagFileResources, tagFileTranslator.getDocument().getDocumentElement(), tagFileIds);
                            tagFileResources.syncGeneratedSource();
                            tagFilesToCompile.add(tagFileResources);
                            continue;
                        }
                        tagFilesNotToCompile.add(tagFileResources);
                    }
                    if (tagFilesToCompile.size() > 0) {
                        JspResources[] resourcesToCompile = new JspResources[tagFilesToCompile.size()];
                        resourcesToCompile = tagFilesToCompile.toArray(resourcesToCompile);
                        JspCompiler compiler = context.getJspCompilerFactory().createJspCompiler();
                        JspResources[] dependencies = null;
                        if (tagFilesNotToCompile.size() > 0) {
                            dependencies = new JspResources[tagFilesNotToCompile.size()];
                            dependencies = tagFilesNotToCompile.toArray(dependencies);
                        }
                        JspCompilerResult compileResult = compiler.compile(resourcesToCompile, dependencies, tagFileIds, compilerOptions);
                        translationResult.setTagFileCompileResult(compileResult);
                        JspTranslatorUtil.syncTagFileFiles(options, tagFilesToCompile, translationResult);
                    }
                }
            }
            finally {
                tlc.releaseTagFileLock(tagFileDependencyIdList);
            }
        }
        return translationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncTagFileFiles(JspOptions options, List translatedTagFiles, JspTranslationResult translationResult) throws JspCoreException {
        Iterator itr = translatedTagFiles.iterator();
        while (itr.hasNext()) {
            TagFileResources tagFileResources;
            TagFileResources tagFileResources2 = tagFileResources = (TagFileResources)itr.next();
            synchronized (tagFileResources2) {
                tagFileResources.sync();
                if (translationResult.hasSmap()) {
                    SmapGenerator smapGenerator = translationResult.getSmapGenerator(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm());
                    JspTranslatorUtil.installSmap(tagFileResources, smapGenerator);
                }
            }
        }
    }

    public static void installSmap(JspResources jspResources, SmapGenerator smapGenerator) throws JspCoreException {
        int inx = jspResources.getGeneratedSourceFile().getPath().lastIndexOf(".java");
        String classFilePath = jspResources.getGeneratedSourceFile().getPath().substring(0, inx) + ".class";
        File classFile = new File(classFilePath);
        if (smapGenerator != null) {
            try {
                SDEInstaller.install(classFile, smapGenerator);
            }
            catch (IOException e) {
                throw new JspCoreException(e);
            }
        }
    }

    public static void printTagFileFiles(List translatedTagFileFiles) throws JspCoreException {
        for (TagFileResources tagFileResources : translatedTagFileFiles) {
            System.out.println("JspTranslatorUtil printTagFileFiles() " + tagFileResources.toString());
        }
    }

    public static boolean isExpression(String token) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token)", "isExpression(String token)  token = [" + token + "]");
        }
        boolean bool = JspTranslatorUtil.isExpression(token, true);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token)", "isExpression(String token)  returning = [" + bool + "]");
        }
        return bool;
    }

    public static boolean isExpression(String token, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) value= [" + token + "] isXml= [" + isXml + "]");
        }
        if (isXml) {
            openExpr = "%=";
            closeExpr = "%";
        } else {
            openExpr = "<%=";
            closeExpr = "%>";
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) openExpr= [" + openExpr + "] closeExpr= [" + closeExpr + "]");
        }
        if (token.startsWith(openExpr) && token.endsWith(closeExpr)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) returning true");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) returning false");
        }
        return false;
    }

    public static boolean isELInterpreterInput(String token, JspConfiguration jspConfig) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration)", "isELInterpreterInput(String, JspConfiguration) value= [" + token + "]");
        }
        return JspTranslatorUtil.isELInterpreterInput(token, jspConfig, !jspConfig.isDeferredSyntaxAllowedAsLiteral());
    }

    public static boolean isELInterpreterInput(String token, JspConfiguration jspConfig, boolean checkDeferred) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) value= [" + token + "]");
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) jspConfiguration.elIgnored() =[" + jspConfig.elIgnored() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) checkDeferred =[" + checkDeferred + "]");
        }
        boolean isELValue = false;
        if (!jspConfig.elIgnored()) {
            int immediateIndex = token.indexOf("${");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) index of ${= [" + immediateIndex + "]");
            }
            int deferredIndex = token.indexOf("#{");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) index of #{= [" + deferredIndex + "]");
            }
            int index = -1;
            if (immediateIndex != -1) {
                index = immediateIndex;
            } else if (deferredIndex != -1 && checkDeferred) {
                index = deferredIndex;
            }
            if (index != -1) {
                char prevChar = ' ';
                if (index > 0) {
                    prevChar = token.charAt(index - 1);
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) prevChar= [" + prevChar + "]");
                }
                if (prevChar != '\\') {
                    isELValue = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) isELValue= [" + isELValue + "]");
                }
            }
        }
        return isELValue;
    }

    public static boolean isExpression(String token, boolean isXml, JspConfiguration jspConfig, boolean checkDeferred) {
        boolean isExpression = JspTranslatorUtil.isExpression(token, isXml);
        boolean isELInput = JspTranslatorUtil.isELInterpreterInput(token, jspConfig, checkDeferred);
        return isExpression || isELInput;
    }

    public static void printAllElements(HashMap processedDocuments) {
        for (String key : processedDocuments.keySet()) {
            Document document = (Document)processedDocuments.get(key);
            JspTranslatorUtil.printElements(document.getDocumentElement(), 0);
        }
    }

    public static void printElements(Element element, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("\t");
        }
        System.out.println("Element - " + element.getNodeName());
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            for (int j = 0; j < level; ++j) {
                System.out.print("\t");
            }
            System.out.println("Attr - " + attr.getName() + " : " + attr.getValue() + " : " + attr.getNamespaceURI());
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                Element childElement = (Element)n;
                System.out.println();
                JspTranslatorUtil.printElements(childElement, level + 1);
                continue;
            }
            if (!(n instanceof CDATASection)) continue;
            System.out.println();
            CDATASection cdata = (CDATASection)n;
            for (int j = 0; j < level + 1; ++j) {
                System.out.print("\t");
            }
            String s = cdata.getData();
            s = s.replaceAll("\r", "");
            s = s.replaceAll("\n", "{cr}");
            System.out.println("CDATA - [" + s + "]");
        }
    }

    public static Class toClass(String type, ClassLoader loader) throws ClassNotFoundException {
        Class<Comparable<Boolean>> c = null;
        int i0 = type.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i = 0; i < type.length(); ++i) {
                if (type.charAt(i) != '[') continue;
                ++dims;
            }
            type = type.substring(0, i0);
        }
        if ("boolean".equals(type)) {
            c = Boolean.TYPE;
        } else if ("char".equals(type)) {
            c = Character.TYPE;
        } else if ("byte".equals(type)) {
            c = Byte.TYPE;
        } else if ("short".equals(type)) {
            c = Short.TYPE;
        } else if ("int".equals(type)) {
            c = Integer.TYPE;
        } else if ("long".equals(type)) {
            c = Long.TYPE;
        } else if ("float".equals(type)) {
            c = Float.TYPE;
        } else if ("double".equals(type)) {
            c = Double.TYPE;
        } else {
            if ("void".equals(type)) {
                return Void.class;
            }
            if (type.indexOf(91) < 0) {
                c = loader.loadClass(type);
            }
        }
        if (dims == 0) {
            return c;
        }
        if (dims == 1) {
            return Array.newInstance(c, 1).getClass();
        }
        return Array.newInstance(c, new int[dims]).getClass();
    }

    public static boolean hasJspBody(Element element) {
        boolean hasJspBody = false;
        boolean jspBodyFound = false;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Node child = children.item(i);
            if (!(child instanceof Element) || (childElement = (Element)child).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("body") || !childElement.hasChildNodes()) continue;
            hasJspBody = true;
            break;
        }
        return hasJspBody;
    }

    public static boolean hasBody(Element element) {
        boolean hasBody = false;
        NodeList children = element.getChildNodes();
        boolean attrOrBodyTagFound = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element childElement = (Element)child;
                if (childElement.getNamespaceURI() != null && childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                    if (childElement.getLocalName().equals("attribute") || childElement.getLocalName().equals("body")) {
                        attrOrBodyTagFound = true;
                        continue;
                    }
                    hasBody = true;
                    break;
                }
                hasBody = true;
                break;
            }
            if (child.getNodeType() != 4) continue;
            hasBody = true;
        }
        if (attrOrBodyTagFound && hasBody) {
            hasBody = false;
        }
        return hasBody;
    }

    public static boolean booleanValue(String s) {
        boolean allowYesToMeanTrue = true;
        return JspTranslatorUtil.booleanValue(s, allowYesToMeanTrue);
    }

    public static boolean booleanValue(String s, boolean allowYesToMeanTrue) {
        boolean b = false;
        if (s != null) {
            b = s.equalsIgnoreCase("yes") && allowYesToMeanTrue ? true : Boolean.valueOf(s);
        }
        return b;
    }
}

