/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TldParser
extends DefaultHandler {
    protected static Logger logger;
    protected static Level logLevel;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TldParser";
    public static final String TAGLIB_DTD_PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_11 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd";
    public static final String TAGLIB_DTD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_12 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd";
    public static final String XMLSCHEMA_DTD_PUBLIC_ID = "-//W3C//DTD XMLSCHEMA 200102//EN";
    public static final String XMLSCHEMA_DTD_RESOURCE_PATH = "/javax/servlet/resources/XMLSchema.dtd";
    public static final String DATATYPES_DTD_PUBLIC_ID = "datatypes";
    public static final String DATATYPES_DTD_RESOURCE_PATH = "/javax/servlet/resources/datatypes.dtd";
    public static final String TAGLIB_XSD_SYSTEM_ID_20 = "web-jsptaglibrary_2_0.xsd";
    public static final String TAGLIB_XSD_RESOURCE_PATH_20 = "/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd";
    public static final String J2EE14_XSD_SYSTEM_ID = "j2ee_1_4.xsd";
    public static final String J2EE14_XSD_RESOURCE_PATH = "/javax/servlet/resources/j2ee_1_4.xsd";
    public static final String XML_XSD_SYSTEM_ID = "http://www.w3.org/2001/xml.xsd";
    public static final String XML_XSD_RESOURCE_PATH = "/javax/servlet/resources/xml.xsd";
    public static final String WEB_SERVICE_CLIENT_XSD_SYSTEM_ID = "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd";
    public static final String WEB_SERVICE_CLIENT_XSD_RESOURCE_PATH = "/javax/servlet/resources/j2ee_web_services_client_1_1.xsd";
    protected static final int TAGLIB_ELEMENT = 1;
    protected static final int TAG_ELEMENT = 2;
    protected static final int TAGFILE_ELEMENT = 3;
    protected static final int FUNCTION_ELEMENT = 4;
    protected static final int ATTRIBUTE_ELEMENT = 5;
    protected static final int DEFERRED_VALUE_ELEMENT = 6;
    protected static String[] elementTypes;
    protected int currentElement = 0;
    protected JspCoreContext ctxt = null;
    protected JspConfigurationManager configManager = null;
    protected ClassLoader classloader = null;
    protected SAXParser saxParser = null;
    protected TagLibraryInfoImpl tli = null;
    protected List<TagInfo> tags = new ArrayList<TagInfo>();
    protected String tagName = null;
    protected String tagDescription = null;
    protected String tagClassName = null;
    protected String teiClassName = null;
    protected String bodyContent = "JSP";
    protected String displayName = null;
    protected String smallIcon = null;
    protected String largeIcon = null;
    protected boolean dynamicAttributes = false;
    protected List<TagAttributeInfo> attributes = new ArrayList<TagAttributeInfo>();
    protected String attributeName = null;
    protected boolean required = false;
    protected String type = null;
    protected boolean reqTime = false;
    protected boolean fragment = false;
    protected boolean deferredValue = false;
    protected boolean deferredMethod = false;
    protected String expectedType = null;
    protected String methodSignature = null;
    protected List<TagVariableInfo> variables = new ArrayList<TagVariableInfo>();
    protected String nameGiven = null;
    protected String nameFromAttribute = null;
    protected String variableClassName = "java.lang.String";
    protected boolean declare = true;
    protected int scope = 0;
    protected List<TagFileInfo> tagFiles = new ArrayList<TagFileInfo>();
    protected String tagFileName = null;
    protected String path = null;
    protected List<FunctionInfo> functions = new ArrayList<FunctionInfo>();
    protected String functionName = null;
    protected String functionClass = null;
    protected String functionSignature = null;
    protected String validatorClass = null;
    protected HashMap<String, String> validatorInitParams = null;
    protected String paramName = null;
    protected String paramValue = null;
    protected StringBuffer chars = null;
    protected List<String> eventListenerList = new ArrayList<String>();
    protected String tldLocation = null;

    public TldParser(JspCoreContext ctxt, JspConfigurationManager configManager, boolean validateTLDs, ClassLoader classloader) throws JspCoreException {
        this(ctxt, configManager, validateTLDs);
        if (classloader != null) {
            this.classloader = classloader;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "TldParser(JspCoreContext, JspConfigurationManager, boolean, ClassLoader)", "ctxt= [" + ctxt + "]  configManager= [" + configManager + "] validateTLDs= [" + validateTLDs + "] classloader= [" + classloader + "]");
        }
    }

    public TldParser(JspCoreContext ctxt, JspConfigurationManager configManager, boolean validateTLDs) throws JspCoreException {
        this.ctxt = ctxt;
        this.configManager = configManager;
        this.classloader = ctxt.getJspClassloaderContext().getClassLoader();
        ClassLoader oldLoader = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader(TldParser.class.getClassLoader());
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            if (validateTLDs) {
                saxFactory.setFeature("http://xml.org/sax/features/validation", true);
                saxFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            this.saxParser = saxFactory.newSAXParser();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                logger.logp(logLevel, CLASS_NAME, "TldParser(JspCoreContext, JspConfigurationManager, boolean)", "ctxt= [" + ctxt + "]  configManager= [" + configManager + "] validateTLDs= [" + validateTLDs + "] saxParser= [" + this.saxParser + "]");
            }
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        catch (SAXException e) {
            throw new JspCoreException(e);
        }
        finally {
            ThreadContextHelper.setClassLoader(oldLoader);
        }
    }

    private void reset() {
        this.resetTagFile();
        this.resetTag();
        this.resetFunction();
        this.resetVariable();
        this.resetAttribute();
        this.resetValidator();
        this.tags.clear();
        this.tagFiles.clear();
        this.functions.clear();
        this.eventListenerList.clear();
    }

    private void resetTagFile() {
        this.tagFileName = null;
        this.path = null;
    }

    private void resetTag() {
        this.tagName = null;
        this.tagClassName = null;
        this.teiClassName = null;
        this.bodyContent = "JSP";
        this.tagDescription = null;
        this.displayName = null;
        this.smallIcon = null;
        this.largeIcon = null;
        this.dynamicAttributes = false;
        this.attributes.clear();
        this.variables.clear();
    }

    private void resetFunction() {
        this.functionClass = null;
        this.functionSignature = null;
        this.functionName = null;
    }

    private void resetVariable() {
        this.nameGiven = null;
        this.nameFromAttribute = null;
        this.variableClassName = "java.lang.String";
        this.declare = true;
        this.scope = 0;
    }

    private void resetAttribute() {
        this.attributeName = null;
        this.required = false;
        this.type = null;
        this.reqTime = false;
        this.fragment = false;
        this.deferredValue = false;
        this.deferredMethod = false;
        this.expectedType = null;
        this.methodSignature = null;
    }

    private void resetValidator() {
        this.validatorClass = null;
        this.validatorInitParams = null;
        this.paramName = null;
        this.paramValue = null;
    }

    public TagLibraryInfoImpl parseTLD(JspInputSource inputSource, String tldOriginatorId) throws JspCoreException {
        this.tldLocation = inputSource.getRelativeURL();
        this.tli = new TagLibraryInfoImpl(tldOriginatorId, inputSource);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, String)", "inputSource= [" + inputSource + "]  tldOriginatorId= [" + tldOriginatorId + "]");
        }
        try {
            this.parse(inputSource.getInputStream());
        }
        catch (SAXException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, String)", "returning tli= [" + this.tli + "]");
        }
        return this.tli;
    }

    public TagLibraryInfoImpl parseTLD(JspInputSource inputSource, InputStream is, String tldOriginatorId) throws JspCoreException {
        this.tldLocation = inputSource.getRelativeURL();
        this.tli = new TagLibraryInfoImpl(tldOriginatorId, inputSource);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, InputStream, String)", "inputSource= [" + inputSource + "]  InputStream=[" + is + "] tldOriginatorId= [" + tldOriginatorId + "]");
        }
        try {
            this.parse(is);
        }
        catch (SAXException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            this.tli = null;
            this.logParseErrorMessage(e);
            throw new JspCoreException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "parseTLD(JspInputSource, InputStream, String)", "returning tli= [" + this.tli + "]");
        }
        return this.tli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream is) throws SAXException, IOException {
        this.reset();
        try {
            ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        this.chars = new StringBuffer();
        if (elementName.equals("taglib")) {
            this.currentElement = 1;
            String ver = attrs.getValue("version");
            if (ver != null) {
                this.tli.setRequiredVersion(ver.trim());
            }
        } else if (elementName.equals("tag")) {
            this.currentElement = 2;
        } else if (elementName.equals("tag-file")) {
            this.currentElement = 3;
        } else if (elementName.equals("function")) {
            this.currentElement = 4;
        } else if (elementName.equals("attribute")) {
            this.currentElement = 5;
        } else if (elementName.equals("deferred-value")) {
            this.currentElement = 6;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "startElement", "currentElement= [" + elementTypes[this.currentElement - 1] + "]");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            if (this.chars == null) continue;
            this.chars.append(ch[start + i]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
            TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "namespaceURI= [" + namespaceURI + "] localName= [" + localName + "] elementName=[" + elementName + "]");
        }
        if (elementName.equals("tlibversion") || elementName.equals("tlib-version")) {
            this.tli.setTlibversion(this.chars.toString().trim());
        } else if (elementName.equals("jspversion") || elementName.equals("jsp-version")) {
            this.tli.setRequiredVersion(this.chars.toString().trim());
        } else if (elementName.equals("shortname") || elementName.equals("short-name")) {
            this.tli.setShortName(this.chars.toString().trim());
        } else if (elementName.equals("uri")) {
            this.tli.setReliableURN(this.chars.toString().trim());
        } else if (elementName.equals("info") || elementName.equals("description")) {
            switch (this.currentElement) {
                case 1: {
                    this.tli.setInfoString(this.chars.toString().trim());
                    break;
                }
                case 2: {
                    this.tagDescription = this.chars.toString().trim();
                }
            }
        } else if (elementName.equals("tag")) {
            tagAttributes = new TagAttributeInfo[this.attributes.size()];
            if (this.attributes.size() > 0) {
                tagAttributes = this.attributes.toArray(tagAttributes);
            }
            tagVariables = new TagVariableInfo[this.variables.size()];
            if (this.variables.size() > 0) {
                tagVariables = this.variables.toArray(tagVariables);
            }
            tei = null;
            if (this.teiClassName != null) {
                if (this.teiClassName.trim().equals("")) {
                    TldParser.logger.logp(Level.WARNING, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "TagExtraInfo specified in tld without a value.  tld=[" + this.tldLocation + "]");
                } else {
                    try {
                        tei = (TagExtraInfo)this.classloader.loadClass(this.teiClassName).newInstance();
                    }
                    catch (Exception e) {
                        message = JspCoreException.getMsg("jsp.error.failed.load.tei.class", new Object[]{this.teiClassName});
                        message = message + " from " + this.tldLocation;
                        TldParser.logger.logp(Level.WARNING, "com.ibm.ws.jsp.taglib.TldParser", "endElement", message);
                    }
                }
            }
            tag = new TagInfo(this.tagName, this.tagClassName, this.bodyContent, this.tagDescription, this.tli, tei, tagAttributes, this.displayName, this.smallIcon, this.largeIcon, tagVariables, this.dynamicAttributes);
            this.tags.add(tag);
            this.resetTag();
            this.currentElement = 1;
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] TagInfo tag= [" + tag + "]");
            }
        } else if (elementName.equals("tag-file")) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(Level.FINEST)) {
                    TldParser.logger.logp(Level.FINEST, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "about to do tagfilescan for = [" + this.path + " " + this.tagFileName + "]");
                }
                jspOptions = new JspOptions();
                tagFileInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.tli.getInputSource(), this.path);
                jspTranslator = JspTranslatorFactory.getFactory().createTranslator("TagFileScan", tagFileInputSource, this.ctxt, this.configManager.createJspConfiguration(), jspOptions, new HashMap<K, V>());
                inputMap = new JspVisitorInputMap();
                inputMap.put("TagLibraryInfo", this.tli);
                inputMap.put("TagFileName", this.tagFileName);
                inputMap.put("TagFilePath", this.path);
                results = jspTranslator.processVisitors(inputMap);
                result = (TagFileScanResult)results.get("TagFileScan");
                tfi = new TagFileInfo(this.tagFileName, this.path, result.getTagInfo());
                this.tagFiles.add(tfi);
                this.resetTagFile();
                this.currentElement = 1;
                if (!TraceComponent.isAnyTracingEnabled() || !TldParser.logger.isLoggable(TldParser.logLevel)) ** GOTO lbl279
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "TldParser elementName= [" + elementName + "] TagFileInfo tfi= [" + tfi + "]");
            }
            catch (JspCoreException e) {
                throw new SAXException(e);
            }
        } else if (elementName.equals("function")) {
            fi = new FunctionInfo(this.functionName, this.functionClass, this.functionSignature);
            this.functions.add(fi);
            this.resetFunction();
            this.currentElement = 1;
        } else if (elementName.equals("name")) {
            switch (this.currentElement) {
                case 3: {
                    this.tagFileName = this.chars.toString().trim();
                    break;
                }
                case 2: {
                    this.tagName = this.chars.toString().trim();
                    break;
                }
                case 4: {
                    this.functionName = this.chars.toString().trim();
                    break;
                }
                case 5: {
                    this.attributeName = this.chars.toString().trim();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] currentElement= [" + TldParser.elementTypes[this.currentElement - 1] + "]");
            }
        } else if (elementName.equals("path")) {
            this.path = this.chars.toString().trim();
        } else if (elementName.equals("tag-class") || elementName.equals("tagclass")) {
            this.tagClassName = this.chars.toString().trim();
        } else if (elementName.equals("tei-class") || elementName.equals("teiclass")) {
            this.teiClassName = this.chars.toString().trim();
        } else if (elementName.equals("body-content") || elementName.equals("bodycontent")) {
            this.bodyContent = this.chars.toString().trim();
        } else if (elementName.equals("variable")) {
            tvi = new TagVariableInfo(this.nameGiven, this.nameFromAttribute, this.variableClassName, this.declare, this.scope);
            this.variables.add(tvi);
            this.resetVariable();
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] TagVariableInfo= [" + tvi + "]");
            }
        } else if (elementName.equals("attribute")) {
            if (this.fragment) {
                this.type = "javax.servlet.jsp.tagext.JspFragment";
                this.reqTime = true;
            }
            if (!this.reqTime) {
                this.type = "java.lang.String";
            }
            if (this.deferredValue && this.expectedType == null) {
                this.expectedType = "java.lang.Object";
            }
            tai = new TagAttributeInfo(this.attributeName, this.required, this.type, this.reqTime, this.fragment, null, this.deferredValue, this.deferredMethod, this.expectedType, this.methodSignature);
            this.attributes.add(tai);
            this.resetAttribute();
            this.currentElement = 2;
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] TagAttributeInfo= [" + tai + "]");
            }
        } else if (elementName.equals("required")) {
            requiredString = this.chars.toString().trim();
            this.required = requiredString.equalsIgnoreCase("yes") != false || requiredString.equalsIgnoreCase("true") != false;
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] required= [" + this.required + "]");
            }
        } else if (elementName.equals("rtexprvalue")) {
            reqTimeString = this.chars.toString().trim();
            this.reqTime = reqTimeString.equalsIgnoreCase("yes") != false || reqTimeString.equalsIgnoreCase("true") != false;
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] reqTime= [" + this.reqTime + "]");
            }
        } else if (elementName.equals("deferred-value")) {
            this.deferredValue = true;
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] deferredValue= [" + this.deferredValue + "] type= [" + this.type + "]");
            }
        } else if (elementName.equals("deferred-method")) {
            this.deferredMethod = true;
            if (this.methodSignature == null) {
                this.methodSignature = "java.lang.Object method()";
            }
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] deferredMethod= [" + this.deferredMethod + "] methodSignature= [" + this.methodSignature + "]");
            }
        } else if (elementName.equals("method-signature")) {
            this.methodSignature = this.chars.toString().trim();
            this.methodSignature = this.methodSignature != null && this.methodSignature.length() > 0 ? this.methodSignature.trim() : "java.lang.Object method()";
            if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] methodSignature= [" + this.methodSignature + "]");
            }
        } else if (!elementName.equals("listener")) {
            if (elementName.equals("listener-class")) {
                this.eventListenerList.add(this.chars.toString().trim());
            } else if (elementName.equals("type")) {
                switch (this.currentElement) {
                    case 2: 
                    case 5: {
                        this.type = this.chars.toString().trim();
                        if (!TraceComponent.isAnyTracingEnabled() || !TldParser.logger.isLoggable(TldParser.logLevel)) break;
                        TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] tagDescription= [" + this.tagDescription + "]");
                        break;
                    }
                    case 6: {
                        this.expectedType = this.chars.toString().trim();
                        if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                            TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] expectedType= [" + this.expectedType + "]");
                        }
                        this.currentElement = 5;
                    }
                }
            } else if (elementName.equals("function-class")) {
                this.functionClass = this.chars.toString().trim();
            } else if (elementName.equals("function-signature")) {
                this.functionSignature = this.chars.toString().trim();
            } else if (elementName.equals("dynamic-attributes")) {
                dynamicAttributesString = this.chars.toString().trim();
                this.dynamicAttributes = dynamicAttributesString.equalsIgnoreCase("yes") != false || dynamicAttributesString.equalsIgnoreCase("true") != false;
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] dynamicAttributes= [" + this.dynamicAttributes + "]");
                }
            } else if (elementName.equals("fragment")) {
                fragmentString = this.chars.toString().trim();
                this.fragment = fragmentString.equalsIgnoreCase("yes") != false || fragmentString.equalsIgnoreCase("true") != false;
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] fragment= [" + this.fragment + "]");
                }
            } else if (elementName.equals("name-given")) {
                this.nameGiven = this.chars.toString().trim();
            } else if (elementName.equals("name-from-attribute")) {
                this.nameFromAttribute = this.chars.toString().trim();
            } else if (elementName.equals("variable-class")) {
                this.variableClassName = this.chars.toString().trim();
            } else if (elementName.equals("declare")) {
                declareString = this.chars.toString().trim();
                this.declare = declareString.equalsIgnoreCase("yes") != false || declareString.equalsIgnoreCase("true") != false;
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] declare= [" + this.declare + "]");
                }
            } else if (elementName.equals("scope")) {
                strScope = this.chars.toString().trim();
                if (strScope.equals("AT_BEGIN")) {
                    this.scope = 1;
                } else if (strScope.equals("NESTED")) {
                    this.scope = 0;
                } else if (strScope.equals("AT_END")) {
                    this.scope = 2;
                }
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] scope= [" + this.scope + "]");
                }
            } else if (elementName.equals("validator")) {
                if (this.validatorClass != null) {
                    if (this.validatorClass.trim().equals("")) {
                        TldParser.logger.logp(Level.WARNING, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "TagLibraryValidator specified in tld without a value.  tld=[" + this.tldLocation + "]");
                    } else {
                        try {
                            tlvClass = this.classloader.loadClass(this.validatorClass);
                            this.tli.setTabLibraryValidator(tlvClass, this.validatorInitParams);
                        }
                        catch (Exception e) {
                            message = JspCoreException.getMsg("jsp.error.failed.load.tlv.class", new Object[]{this.validatorClass});
                            TldParser.logger.logp(Level.FINE, "com.ibm.ws.jsp.taglib.TldParser", "endElement", message, e);
                            throw new SAXException(message);
                        }
                    }
                }
                this.resetValidator();
            } else if (elementName.equals("validator-class")) {
                this.validatorClass = this.chars.toString().trim();
            } else if (elementName.equals("init-param")) {
                if (this.validatorInitParams == null) {
                    this.validatorInitParams = new HashMap<K, V>();
                }
                this.validatorInitParams.put(this.paramName, this.paramValue);
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] paramName= [" + this.paramName + "] paramValue= [" + this.paramValue + "]");
                }
            } else if (elementName.equals("param-name")) {
                this.paramName = this.chars.toString().trim();
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] paramName= [" + this.paramName + "]");
                }
            } else if (elementName.equals("param-value")) {
                this.paramValue = this.chars.toString().trim();
                if (TraceComponent.isAnyTracingEnabled() && TldParser.logger.isLoggable(TldParser.logLevel)) {
                    TldParser.logger.logp(TldParser.logLevel, "com.ibm.ws.jsp.taglib.TldParser", "endElement", "elementName= [" + elementName + "] paramValue= [" + this.paramValue + "]");
                }
            } else if (elementName.equals("small-icon")) {
                this.smallIcon = this.chars.toString().trim();
            } else if (elementName.equals("large-icon")) {
                this.largeIcon = this.chars.toString().trim();
            } else if (elementName.equals("taglib")) {
                this.tli.setTags(this.tags);
                this.tli.setTagFiles(this.tagFiles);
                this.tli.setFunctions(this.functions);
                this.currentElement = 0;
            } else if (elementName.equals("display-name")) {
                this.displayName = this.chars.toString().trim();
            }
        }
lbl279:
        // 45 sources

        this.chars = null;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource isrc = null;
        String resourcePath = null;
        if (publicId != null) {
            if (publicId.equals(TAGLIB_DTD_PUBLIC_ID_11)) {
                resourcePath = TAGLIB_DTD_RESOURCE_PATH_11;
            } else if (publicId.equals(TAGLIB_DTD_PUBLIC_ID_12)) {
                resourcePath = TAGLIB_DTD_RESOURCE_PATH_12;
            } else if (publicId.equals(XMLSCHEMA_DTD_PUBLIC_ID)) {
                resourcePath = XMLSCHEMA_DTD_RESOURCE_PATH;
            } else if (publicId.equals(DATATYPES_DTD_PUBLIC_ID)) {
                resourcePath = DATATYPES_DTD_RESOURCE_PATH;
            }
        } else if (systemId != null) {
            if (systemId.endsWith(TAGLIB_XSD_SYSTEM_ID_20)) {
                resourcePath = TAGLIB_XSD_RESOURCE_PATH_20;
            } else if (systemId.endsWith(J2EE14_XSD_SYSTEM_ID)) {
                resourcePath = J2EE14_XSD_RESOURCE_PATH;
            } else if (systemId.equals(XML_XSD_SYSTEM_ID)) {
                resourcePath = XML_XSD_RESOURCE_PATH;
            } else if (systemId.equals(WEB_SERVICE_CLIENT_XSD_SYSTEM_ID)) {
                resourcePath = WEB_SERVICE_CLIENT_XSD_RESOURCE_PATH;
            }
        }
        if (resourcePath != null) {
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            if (input == null) {
                throw new SAXException(JspCoreException.getMsg("jsp.error.internal.dtd.not.found") + "[" + resourcePath + "]");
            }
            isrc = new InputSource(input);
            isrc.setSystemId(systemId);
        }
        return isrc;
    }

    public void error(SAXParseException arg0) throws SAXException {
        throw arg0;
    }

    public void fatalError(SAXParseException arg0) throws SAXException {
        throw arg0;
    }

    public void warning(SAXParseException arg0) throws SAXException {
        String origMessage = arg0.getMessage();
        String newMessage = "Parser warning during parse of Tag Library [" + this.tldLocation + "]";
        if (origMessage != null) {
            newMessage = newMessage + ": " + origMessage;
        }
        logger.logp(Level.WARNING, CLASS_NAME, "warning", newMessage);
    }

    private void logParseErrorMessage(Exception e) {
        String origMessage = e.getMessage();
        String newMessage = "Failed to parse Tag Library [" + this.tldLocation + "]";
        if (origMessage != null) {
            newMessage = newMessage + ": " + origMessage;
        }
        logger.logp(Level.SEVERE, CLASS_NAME, "logParseErrorMessage", newMessage);
    }

    static {
        logLevel = Level.FINEST;
        logger = Logger.getLogger("com.ibm.ws.jsp");
        elementTypes = new String[]{"TAGLIB_ELEMENT", "TAG_ELEMENT", "TAGFILE_ELEMENT", "FUNCTION_ELEMENT", "ATTRIBUTE_ELEMENT", "DEFERRED_VALUE_ELEMENT"};
    }
}

