/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.runtime.TagArray;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.ws.util.WSThreadLocal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspThreadPoolListener
implements ThreadPoolListener {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.runtime.JspThreadPoolListener";
    private static Hashtable threadLocals = new Hashtable();

    JspThreadPoolListener() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspThreadPoolListener", "created JspThreadPoolListener");
        }
    }

    public void threadPoolCreated(ThreadPool tp) {
    }

    public void threadCreated(ThreadPool tp, int poolSize) {
    }

    public void threadStarted(ThreadPool tp, int activeThreads, int maxThreads) {
    }

    public void threadReturned(ThreadPool tp, int activeThreads, int maxThreads) {
    }

    public void threadDestroyed(ThreadPool tp, int poolSize) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "tp= [" + tp + "]  poolSize= [" + poolSize + "]");
        }
        Integer threadId = new Integer(Thread.currentThread().hashCode());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "threadId= [" + threadId + "]");
        }
        WSThreadLocal thr = (WSThreadLocal)threadLocals.get(threadId);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "thr from Hashtable= [" + thr + "]");
        }
        if (thr != null) {
            Map threadPoolMap = null;
            threadPoolMap = (Map)thr.get();
            if (threadPoolMap != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "map from threadLocal : [" + threadPoolMap + "]");
                }
                for (String webAppKey : threadPoolMap.keySet()) {
                    HashMap webAppPool = (HashMap)threadPoolMap.get(webAppKey);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "webAppKey = [" + webAppKey + "]");
                        logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "map from webAppPoolMap = [" + webAppPool + "]");
                    }
                    if (webAppPool == null) continue;
                    for (String tagKey : webAppPool.keySet()) {
                        TagArray tagArray = (TagArray)webAppPool.get(tagKey);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "tagKey = [" + tagKey + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "tagArray = [" + tagArray + "]");
                        }
                        if (tagArray == null) continue;
                        tagArray.releaseTags();
                        tagArray = null;
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "released tags and set tagArray to null");
                    }
                    webAppPool.clear();
                    webAppPool = null;
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "cleared webAppPool and setwebAppPool map to null");
                }
                threadPoolMap = null;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "threadDestroyed", "cleared threadPoolMap and set threadPoolMap to null");
                }
            }
        }
    }

    public static void addThreadLocal(WSThreadLocal wst, Integer threadId) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "addThreadLocal", "wst= [" + wst + "]");
            logger.logp(Level.FINER, CLASS_NAME, "addThreadLocal", "threadId= [" + threadId + "]");
        }
        threadLocals.put(threadId, wst);
    }
}

