/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.runtime.TagArray;
import com.ibm.ws.jsp.taglib.annotation.AnnotationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ContextListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private boolean isUseThreadTagPool = false;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.runtime.ContextListener";

    public void setIsUseThreadTagPool(boolean b) {
        this.isUseThreadTagPool = b;
    }

    public void contextDestroyed(ServletContextEvent event2) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "event = [" + event2 + "] for context: [" + event2.getServletContext().getServletContextName() + "]");
        }
        if (this.isUseThreadTagPool) {
            Map webAppPoolMap = (Map)event2.getServletContext().getAttribute("com.ibm.ws.jsp.tagpoolmap");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "webAppPoolMap = [" + webAppPoolMap + "]");
            }
            if (webAppPoolMap != null) {
                for (Integer threadId : webAppPoolMap.keySet()) {
                    Map m = (Map)webAppPoolMap.get(threadId);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "threadId = [" + threadId + "]");
                        logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "map from webAppPoolMap = [" + m + "]");
                    }
                    if (m == null) continue;
                    for (String tagKey : m.keySet()) {
                        TagArray tagArray = (TagArray)m.get(tagKey);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "tagKey = [" + tagKey + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "tagArray = [" + tagArray + "]");
                        }
                        if (tagArray == null) continue;
                        tagArray.releaseTags();
                        tagArray = null;
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "released tags and set tagArray to null");
                    }
                    m.clear();
                    m = null;
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "cleared map and set map to null");
                }
                webAppPoolMap.clear();
                webAppPoolMap = null;
                event2.getServletContext().removeAttribute("com.ibm.ws.jsp.tagpoolmap");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "cleared webAppPoolMap, set webAppPoolMap to null and removed attribute from servletcontext [com.ibm.ws.jsp.tagpoolmap]");
                }
            }
        }
        AnnotationHandler annotationHandlerRemoved = AnnotationHandler.removeAnnotationHandler(event2.getServletContext());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            if (annotationHandlerRemoved != null) {
                logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "cleared Annotation for Servlet Context.");
            } else {
                logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "no Annotation for Servlet Context found.");
            }
        }
    }

    public void contextInitialized(ServletContextEvent event2) {
        if (this.isUseThreadTagPool) {
            event2.getServletContext().setAttribute("com.ibm.ws.jsp.tagpoolmap", new HashMap());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "contextInitialized", "set attribute on servletcontext = [com.ibm.ws.jsp.tagpoolmap]  for context: [" + event2.getServletContext().getServletContextName() + "]");
            }
        }
    }
}

