/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.admin;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.jsf.util.FacesMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ListJSFImplementationCommand
extends AbstractAdminCommand {
    private static final String CLASS_NAME = "com.ibm.ws.jsf.admin.ListJSFImplementation";
    private static transient Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private ConfigService _service = null;
    private Session _session = null;
    private String _appName = "";
    private ObjectName _deployment = null;

    public ListJSFImplementationCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public ListJSFImplementationCommand(CommandData inCommandData) throws CommandNotFoundException, CommandLoadException {
        super(inCommandData);
    }

    public void validate() throws CommandValidationException {
        this._service = this.getConfigService();
        this._session = this.getConfigSession();
        this._appName = (String)this.getTargetObject();
        ObjectName[] matches = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Deployment", null);
            matches = this._service.queryConfigObjects(this._session, null, pattern, null);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "validate", " found " + matches.length + " deployment objects");
            }
            for (int i = 0; i < matches.length; ++i) {
                String displayName = ConfigServiceHelper.getDisplayName(matches[i]);
                if (!displayName.equals(this._appName)) continue;
                this._deployment = matches[i];
                if (!log.isLoggable(Level.FINE)) continue;
                log.logp(Level.FINE, CLASS_NAME, "validate", " deploymentObject matched the target");
            }
            if (this._deployment == null) {
                throw new CommandValidationException(FacesMessages.getMsg("jsf.error.unable.locate.app", new Object[]{this._appName}));
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (ConnectorException e) {
            throw new CommandValidationException(e.getMessage());
        }
    }

    public void execute() {
        CommandResultImpl result = new CommandResultImpl();
        this._service = this.getConfigService();
        this._session = this.getConfigSession();
        String impl = "SunRI1.2";
        try {
            this.validate();
            if (this.findMyFacesRef()) {
                impl = "MyFaces1.2";
            }
            result.setResult(impl);
        }
        catch (CommandException e) {
            result.setException(e);
        }
        this.setCommandResult(result);
    }

    private boolean findMyFacesRef() throws CommandException {
        ObjectName[] matches = null;
        try {
            matches = this.getWebModules();
            for (int i = 0; i < matches.length; ++i) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Classloader");
                ObjectName[] classloaders = this._service.queryConfigObjects(this._session, matches[i], pattern, null);
                for (int j = 0; j < classloaders.length; ++j) {
                    if (!this.containsReferenceToMyFaces(classloaders[j])) continue;
                    return true;
                }
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandException(e);
        }
        catch (ConnectorException e) {
            throw new CommandException(e);
        }
        return false;
    }

    private boolean containsReferenceToMyFaces(ObjectName classloader) throws ConfigServiceException, ConnectorException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "containsReferenceToMyFaces", "looking for MyFaces library in classloader " + classloader);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "LibraryRef");
        ObjectName[] libraryRefs = this._service.queryConfigObjects(this._session, classloader, pattern, null);
        for (int i = 0; i < libraryRefs.length; ++i) {
            ObjectName library = libraryRefs[i];
            String name = (String)this._service.getAttribute(this._session, library, "libraryName");
            if (!name.equals("com.ibm.org.apache.myfaces1_2")) continue;
            return true;
        }
        return false;
    }

    private ObjectName[] getWebModules() throws ConfigServiceException, ConnectorException {
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "WebModuleDeployment");
        return this._service.queryConfigObjects(this._session, this._deployment, pattern, null);
    }
}

