/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.actionengine.Environment;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentUtils {
    private static final String S_COMMA = "\\,";
    public static final String S_CONNECTED_ARG = "connected";
    public static final String S_DISCONNECTED_ARG = "disconnected";
    private static final Logger LOGGER = LoggerFactory.createLogger(EnvironmentUtils.class);
    private static final String S_CLASS_NAME = EnvironmentUtils.class.getName();

    public static Environment getEnvironment(String sEnvironment) {
        LOGGER.entering(S_CLASS_NAME, "getEnvironment");
        Environment result = null;
        if (Environment.LOCAL.getValue().equals(sEnvironment)) {
            result = Environment.LOCAL;
        } else if (Environment.REMOTE_CONNECTED.getValue().equals(sEnvironment)) {
            result = Environment.REMOTE_CONNECTED;
        } else if (S_CONNECTED_ARG.equals(sEnvironment)) {
            result = Environment.REMOTE_CONNECTED;
        } else if (Environment.REMOTE_DISCONNECTED.getValue().equals(sEnvironment)) {
            result = Environment.REMOTE_DISCONNECTED;
        } else if (S_DISCONNECTED_ARG.equals(sEnvironment)) {
            result = Environment.REMOTE_DISCONNECTED;
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getEnvironment", "The value " + sEnvironment + " is of an unknown type.");
            LOGGER.exiting(S_CLASS_NAME, "getEnvironment");
            return Environment.LOCAL;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getEnvironment", "The environment is " + result.getValue());
        LOGGER.exiting(S_CLASS_NAME, "getEnvironment");
        return result;
    }

    public static List<Environment> split(String sCommaSeparatedString) {
        LOGGER.entering(S_CLASS_NAME, "split");
        if (sCommaSeparatedString == null) {
            LOGGER.exiting(S_CLASS_NAME, "split");
            return null;
        }
        ArrayList<Environment> listActionModes = null;
        if (sCommaSeparatedString != null) {
            listActionModes = new ArrayList<Environment>();
            String[] modes = sCommaSeparatedString.split(S_COMMA);
            for (int i = 0; i < modes.length; ++i) {
                listActionModes.add(EnvironmentUtils.getEnvironment(modes[i].trim()));
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "split");
        return listActionModes;
    }
}

