/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.DefaulterConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultValueManager {
    private Map<String, DefaulterConfigAction> m_mapDefaulters = null;
    private String m_sTemplatePath = "";
    private String m_sActionRegistry = "";
    private static final String S_TEMPLATE_PATH = "templatePath";
    private static final String S_EMPTY = "";
    private static final String S_DEFAULT_VALUE = null;
    private static final Logger LOGGER = LoggerFactory.createLogger(DefaultValueManager.class);
    private static final String S_CLASS_NAME = DefaultValueManager.class.getName();

    public DefaultValueManager(String sTemplatePath, String sActionRegistry) {
        LOGGER.entering(DefaultValueManager.class.getName(), "DefaultValueManager");
        this.initialize(sTemplatePath, sActionRegistry);
        LOGGER.exiting(DefaultValueManager.class.getName(), "DefaultValueManager");
    }

    public DefaultValueManager() {
        LOGGER.entering(DefaultValueManager.class.getName(), "DefaultValueManager");
        String sTemplatePath = DefaultValueManager.determineTemplatePath();
        String sActionRegistry = DefaultValueManager.determineActionRegistry();
        this.initialize(sTemplatePath, sActionRegistry);
        LOGGER.exiting(DefaultValueManager.class.getName(), "DefaultValueManager");
    }

    public DefaultValueManager(Map mapDefaulters) {
        LOGGER.entering(DefaultValueManager.class.getName(), "DefaultValueManager");
        String sTemplatePath = DefaultValueManager.determineTemplatePath();
        String sActionRegistry = DefaultValueManager.determineActionRegistry();
        this.initialize(sTemplatePath, sActionRegistry, mapDefaulters);
        LOGGER.exiting(DefaultValueManager.class.getName(), "DefaultValueManager");
    }

    public void reinitialize() {
        LOGGER.entering(DefaultValueManager.class.getName(), "reinitialize");
        this.m_mapDefaulters = null;
        this.initialize(this.m_sTemplatePath, this.m_sActionRegistry);
        LOGGER.exiting(DefaultValueManager.class.getName(), "reinitialize");
    }

    public String getDefaultValue(String sArgumentKey) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValue");
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(new Hashtable());
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        DefaulterConfigAction defaulter = this.m_mapDefaulters.get(sArgumentKey);
        String sDefaultValue = this.getDefaultValueFromDefaulter(defaulter);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultValue", "Argument " + sArgumentKey + " was defaulted to: " + sDefaultValue);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValue");
        return sDefaultValue;
    }

    public Hashtable getDefaultValues(String[] saArgumentKeys, Map mapAllActionArguments) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValues");
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllActionArguments);
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        Hashtable hashtableDefaultVAlues = this.getDefaultValues(saArgumentKeys);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValues");
        return hashtableDefaultVAlues;
    }

    public Hashtable getDefaultValues(List listArgKeys, Map mapAllActionArguments) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValues");
        String[] saArgumentKeys = this.convertListToStringArray(listArgKeys);
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllActionArguments);
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        Hashtable hashtableDefaultValues = this.getDefaultValues(saArgumentKeys);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValues");
        return hashtableDefaultValues;
    }

    public String[] getAllArgsInDefaultingOrder(String[] saArgumentKeys) {
        int i;
        Hashtable<ConfigAction, String> mapDefaultersToArgs = new Hashtable<ConfigAction, String>();
        Vector<ConfigAction> listDefaultersToRun = new Vector<ConfigAction>();
        if (saArgumentKeys != null) {
            for (i = 0; i < saArgumentKeys.length; ++i) {
                ConfigAction caDefaulter = this.m_mapDefaulters.get(saArgumentKeys[i]);
                if (caDefaulter == null) continue;
                listDefaultersToRun.add(caDefaulter);
                mapDefaultersToArgs.put(caDefaulter, saArgumentKeys[i]);
            }
        }
        Collections.sort(listDefaultersToRun);
        String[] saArgsInOrder = new String[listDefaultersToRun.size()];
        for (i = 0; i < listDefaultersToRun.size(); ++i) {
            saArgsInOrder[i] = (String)mapDefaultersToArgs.get(listDefaultersToRun.get(i));
        }
        return saArgsInOrder;
    }

    public boolean isArgumentAvailableForDefaulting(String sArgumentKey) {
        LOGGER.entering(DefaultValueManager.class.getName(), "isArgumentAvailableForDefaulting");
        ConfigAction defaulter = this.m_mapDefaulters.get(sArgumentKey);
        LOGGER.exiting(DefaultValueManager.class.getName(), "isArgumentAvailableForDefaulting");
        return defaulter != null;
    }

    public String getActionRegistry() {
        return this.m_sActionRegistry;
    }

    public String getTemplatePath() {
        return this.m_sTemplatePath;
    }

    public String toString() {
        return this.getActionRegistry();
    }

    private void initialize(String sTemplatePath, String sActionRegistry) {
        LOGGER.entering(DefaultValueManager.class.getName(), "initialize");
        this.m_sTemplatePath = sTemplatePath;
        this.m_sActionRegistry = sActionRegistry;
        if (sTemplatePath != null && sActionRegistry != null && !sTemplatePath.equals(S_EMPTY) && !sActionRegistry.equals(S_EMPTY)) {
            Properties propertiesStored = SystemPropertiesUtils.getCurrentSystemProperties();
            System.setProperty("WS_CMT_ACTION_REGISTRY", sActionRegistry);
            this.m_mapDefaulters = ConfigManager.getDefaulterHashtable(sTemplatePath);
            SystemPropertiesUtils.resetSystemProperties(propertiesStored);
        } else {
            this.m_mapDefaulters = new Hashtable<String, DefaulterConfigAction>();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Created DefaultValueManager with templatePath=" + sTemplatePath + ", actionRegistry=" + sActionRegistry);
        LOGGER.exiting(DefaultValueManager.class.getName(), "initialize");
    }

    private void initialize(String sTemplatePath, String sActionRegistry, Map mapRegisteredDefaulters) {
        LOGGER.entering(DefaultValueManager.class.getName(), "initialize");
        this.m_sTemplatePath = sTemplatePath;
        this.m_sActionRegistry = sActionRegistry;
        this.m_mapDefaulters = sTemplatePath != null && sActionRegistry != null && !sTemplatePath.equals(S_EMPTY) && !sActionRegistry.equals(S_EMPTY) ? mapRegisteredDefaulters : new Hashtable<String, DefaulterConfigAction>();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Created DefaultValueManager with templatePath=" + sTemplatePath + ", actionRegistry=" + sActionRegistry);
        LOGGER.exiting(DefaultValueManager.class.getName(), "initialize");
    }

    private Hashtable getDefaultValues(String[] saArgumentKeys) {
        DefaulterConfigAction caDefaulter;
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValues");
        Hashtable<String, String> hastableDefaultValues = new Hashtable<String, String>(saArgumentKeys.length);
        Vector<DefaulterConfigAction> listDefaultersToRun = new Vector<DefaulterConfigAction>();
        Hashtable<DefaulterConfigAction, String> mapConfigActionsToArgumentKeys = new Hashtable<DefaulterConfigAction, String>(saArgumentKeys.length);
        for (int i = 0; i < saArgumentKeys.length; ++i) {
            caDefaulter = this.m_mapDefaulters.get(saArgumentKeys[i]);
            if (caDefaulter == null) continue;
            listDefaultersToRun.add(caDefaulter);
            mapConfigActionsToArgumentKeys.put(caDefaulter, saArgumentKeys[i]);
        }
        Collections.sort(listDefaultersToRun);
        for (int j = 0; j < listDefaultersToRun.size(); ++j) {
            caDefaulter = (DefaulterConfigAction)listDefaultersToRun.get(j);
            String sDefaultValue = this.getDefaultValueFromDefaulter(caDefaulter);
            String sArgumentKey = (String)mapConfigActionsToArgumentKeys.get(caDefaulter);
            if (sDefaultValue != null) {
                hastableDefaultValues.put(sArgumentKey, sDefaultValue);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultValues", "Argument " + sArgumentKey + " was defaulted to: " + sDefaultValue);
                System.setProperty(sArgumentKey, sDefaultValue);
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultValues", "Argument " + sArgumentKey + " was not defaulted ");
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValues");
        return hastableDefaultValues;
    }

    private String getDefaultValueFromDefaulter(DefaulterConfigAction defaulter) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValueFromDefaulter");
        if (defaulter == null || !defaulter.doIRun()) {
            return S_DEFAULT_VALUE;
        }
        String sDefaultValue = defaulter.executeDefaulter();
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValueFromDefaulter");
        return sDefaultValue;
    }

    private Map addTemplateSpecificArguments(Map mapAllActionArguments) {
        LOGGER.entering(DefaultValueManager.class.getName(), "addTemplateSpecificArguments");
        Hashtable<String, String> mapTemplateSpecific = new Hashtable<String, String>(mapAllActionArguments);
        if (mapTemplateSpecific.containsKey(S_TEMPLATE_PATH) && this.getTemplatePath() != null) {
            mapTemplateSpecific.put(S_TEMPLATE_PATH, this.getTemplatePath());
        }
        if (this.getTemplatePath() != null) {
            mapTemplateSpecific.put("WS_CMT_CONF_DIR", this.getTemplatePath());
        }
        if (this.getActionRegistry() != null) {
            mapTemplateSpecific.put("WS_CMT_ACTION_REGISTRY", this.getActionRegistry());
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "addTemplateSpecificArguments");
        return mapTemplateSpecific;
    }

    private String[] convertListToStringArray(List listArgs) {
        LOGGER.entering(DefaultValueManager.class.getName(), "convertVectorToStringArray");
        String[] saArgs = new String[listArgs.size()];
        for (int i = 0; i < listArgs.size(); ++i) {
            saArgs[i] = (String)listArgs.get(i);
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "convertVectorToStringArray");
        return saArgs;
    }

    private static String determineActionRegistry() {
        LOGGER.entering(DefaultValueManager.class.getName(), "determineActionRegistry");
        LOGGER.exiting(DefaultValueManager.class.getName(), "determineActionRegistry");
        return ArgumentValueFetcher.getArgumentValue("WS_CMT_ACTION_REGISTRY");
    }

    private static String determineTemplatePath() {
        LOGGER.entering(DefaultValueManager.class.getName(), "determineTemplatePath");
        LOGGER.exiting(DefaultValueManager.class.getName(), "determineTemplatePath");
        return ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR");
    }
}

