/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.tests;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.execengine.ExecEngine;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestExecEngine
extends TestCase {
    private static final String S_PATH = "PATH";
    private static final String[] AS_EXTRACT_PATH_UNIX = new String[]{"sh", "-c", "echo ${PATH}"};
    private static final String[] AS_EXTRACT_PATH_WINDOWS = new String[]{"cmd.exe", "/c", "echo %PATH%"};

    public TestExecEngine(String sTestName) {
        super(sTestName);
    }

    public void testExecEngineUNIX() {
        ExecEngine ee = new ExecEngine();
        ee.executeIncomingArguments(AS_EXTRACT_PATH_UNIX, ConfigManagerConstants.getProcessTimeOutTime());
        String sPATH1 = ee.getProcessStdOut();
        String sPATH2 = PlatformConstants.getEnvironmentVariableValue(S_PATH);
        System.out.println("PATH1: " + sPATH1);
        System.out.println("PATH2: " + sPATH2);
        Assert.assertEquals((String)sPATH1.trim(), (String)sPATH2.trim());
    }

    public void testExecEngineWindows() {
        ExecEngine ee = new ExecEngine();
        ee.executeIncomingArguments(AS_EXTRACT_PATH_WINDOWS, ConfigManagerConstants.getProcessTimeOutTime());
        String sPATH1 = ee.getProcessStdOut();
        String sPATH2 = PlatformConstants.getEnvironmentVariableValue(S_PATH);
        Assert.assertEquals((String)sPATH1.trim(), (String)sPATH2.trim());
    }

    public void testExecEngine() {
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            this.testExecEngineUNIX();
        } else {
            this.testExecEngineWindows();
        }
    }
}

