/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.osutils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetPlatform {
    private static final Logger LOGGER = LoggerFactory.createLogger(TargetPlatform.class);
    private static Platform f_os = null;
    public static final String S_REMOTE_OS_ARG = "remoteOS";
    private static final String S_COMMA = ",";
    private static String S_SPACE;

    public static boolean isLinux() {
        LOGGER.entering(TargetPlatform.class.getName(), "isLinux");
        boolean isLinux = TargetPlatform.getPlatform().equals((Object)Platform.LINUX);
        if (isLinux) {
            LOGGER.logp(Level.FINE, TargetPlatform.class.getName(), "isLinux", "Current platform was not detected as a Linux system");
        }
        LOGGER.exiting(TargetPlatform.class.getName(), "isLinux");
        return isLinux;
    }

    public static boolean isWindows() {
        LOGGER.entering(TargetPlatform.class.getName(), "isWindows");
        boolean isWindows = TargetPlatform.getPlatform().equals((Object)Platform.WINDOWS);
        if (isWindows) {
            LOGGER.logp(Level.FINE, TargetPlatform.class.getName(), "isWindows", "Current platform was not detected as a Windows system");
        }
        LOGGER.exiting(TargetPlatform.class.getName(), "isWindows");
        return isWindows;
    }

    public static boolean isOS400() {
        LOGGER.entering(TargetPlatform.class.getName(), "isOS400");
        boolean isOS400 = TargetPlatform.getPlatform().equals((Object)Platform.OS400);
        if (isOS400) {
            LOGGER.logp(Level.FINE, TargetPlatform.class.getName(), "isOS400", "Current platform was not detected as a os400 system");
        }
        LOGGER.exiting(TargetPlatform.class.getName(), "isOS400");
        return isOS400;
    }

    public static boolean isZOS() {
        LOGGER.entering(TargetPlatform.class.getName(), "isZOS");
        boolean isZOS = TargetPlatform.getPlatform().equals((Object)Platform.Z_OS);
        if (isZOS) {
            LOGGER.logp(Level.FINE, TargetPlatform.class.getName(), "isZOS", "Current platform was not detected as a z/OS system");
        }
        LOGGER.exiting(TargetPlatform.class.getName(), "isZOS");
        return isZOS;
    }

    public static Platform getPlatform() {
        LOGGER.entering(TargetPlatform.class.getName(), "getPlatform");
        String sRemoteOS = System.getProperty(S_REMOTE_OS_ARG);
        if (sRemoteOS != null) {
            LOGGER.exiting(TargetPlatform.class.getName(), "getPlatform");
            return TargetPlatform.convertToPlatform(sRemoteOS);
        }
        LOGGER.exiting(TargetPlatform.class.getName(), "getPlatform");
        LOGGER.logp(Level.FINE, TargetPlatform.class.getName(), "getPlatform", "Platform is " + f_os.getValue());
        return f_os;
    }

    public static String getPlatformName() {
        LOGGER.entering(TargetPlatform.class.getName(), "getPlatformName");
        LOGGER.exiting(TargetPlatform.class.getName(), "getPlatformName");
        return TargetPlatform.getPlatform().getValue();
    }

    public static String getValidPlatforms() {
        return Platform.AIX.getValue() + S_COMMA + S_SPACE + Platform.HPUX.getValue() + S_COMMA + S_SPACE + Platform.SOLARIS.getValue() + S_COMMA + S_SPACE + Platform.LINUX.getValue() + S_COMMA + S_SPACE + Platform.WINDOWS.getValue() + S_COMMA + S_SPACE + Platform.Z_OS.getValue() + S_COMMA + S_SPACE + Platform.OS400.getValue();
    }

    private static Platform convertToPlatform(String sPlatform) {
        LOGGER.entering(TargetPlatform.class.getName(), "convertToPlatform");
        Platform result = null;
        if (sPlatform.equals(Platform.AIX.getValue())) {
            result = Platform.AIX;
        } else if (sPlatform.equals(Platform.HPUX.getValue())) {
            result = Platform.HPUX;
        } else if (sPlatform.equals(Platform.SOLARIS.getValue())) {
            result = Platform.SOLARIS;
        } else if (sPlatform.equals(Platform.LINUX.getValue())) {
            result = Platform.LINUX;
        } else if (sPlatform.equals(Platform.WINDOWS.getValue())) {
            result = Platform.WINDOWS;
        } else if (sPlatform.equals(Platform.Z_OS.getValue())) {
            result = Platform.Z_OS;
        } else if (sPlatform.equals(Platform.OS400.getValue())) {
            result = Platform.OS400;
        } else {
            LOGGER.logp(Level.WARNING, TargetPlatform.class.getName(), "convertToPlatform", "The platform " + sPlatform + " is of an unknown type.");
            result = Platform.UNKNOWN;
        }
        LOGGER.logp(Level.FINE, TargetPlatform.class.getName(), "convertToPlatform", "Platform is " + result.getValue());
        LOGGER.exiting(TargetPlatform.class.getName(), "convertToPlatform");
        return result;
    }

    public static void setPlatform(String sPlatform) {
        LOGGER.entering(TargetPlatform.class.getName(), "setPlatform");
        f_os = TargetPlatform.convertToPlatform(sPlatform);
        LOGGER.exiting(TargetPlatform.class.getName(), "setPlatform");
    }

    static {
        TargetPlatform.setPlatform(PlatformConstants.getCurrentPlatformName());
        S_SPACE = " ";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        UNKNOWN(""),
        AIX("aix"),
        HPUX("hpux"),
        SOLARIS("solaris"),
        LINUX("linux"),
        WINDOWS("windows"),
        Z_OS("zos"),
        OS400("os400");

        private final String value;

        private Platform(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

