/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.osutils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.ProcessEnvironment;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PlatformConstants {
    public static final int N_UNKNOWN = 0;
    public static final String S_UNKNOWN = "";
    public static final int N_AIX = 1;
    public static final String S_AIX = "aix";
    public static final int N_HPUX = 2;
    public static final String S_HPUX = "hpux";
    public static final int N_SOLARIS = 3;
    public static final String S_SOLARIS = "solaris";
    public static final int N_LINUX = 4;
    public static final String S_LINUX = "linux";
    public static final int N_WINDOWS = 5;
    public static final String S_WINDOWS = "windows";
    public static final int N_Z_OS = 6;
    public static final String S_Z_OS = "zos";
    public static final int N_OS400 = 7;
    public static final String S_OS400 = "os400";
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final int N_UNDEFINED = -1;
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS390_PATTERN = "^.*os/390.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String[] AS_NETSCAPE = new String[]{"netscape"};
    private static final String[] AS_MOZILLA = new String[]{"mozilla"};
    private static final String[] AS_IEXPLORE = new String[]{"cmd.exe", "/c", "\"start iexplore\""};
    private static final String[] AS_NONE = new String[]{""};
    private static final String[] AS_SHELL_EXEC_WIN = new String[]{"cmd.exe", "/c"};
    private static final String[] AS_SHELL_EXEC_UNIX = new String[]{"sh", "-c"};
    private static final String[] AS_SHELL_EXEC_OS400 = new String[]{"/usr/bin/sh", "-c"};
    private static final String[] AS_EMPTY = new String[0];
    private static final String S_WSADMIN_UNIX = "wsadmin.sh";
    private static final String S_WSADMIN_WINDOWS = "wsadmin.bat";
    private static final String S_WSADMIN_OS400 = "wsadmin";
    private static final String S_ANT_UNIX = "ant.sh";
    private static final String S_ANT_WINDOWS = "ant.bat";
    private static final String S_ANT_OS400 = "ant";
    private static final String S_WS_ANT_UNIX = "ws_ant.sh";
    private static final String S_WS_ANT_WINDOWS = "ws_ant.bat";
    private static final String S_WS_ANT_OS400 = "ws_ant";
    private static final String S_SPACE = " ";
    private static final String S_QUOTE = "\"";
    private static final String S_DOLLAR = "$";
    private static final String S_PERCENTAGE = "%";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_START = "{";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_STOP = "}";
    private static final String S_DOT = ".";
    private static final String S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES = "^.*\\s.*$";
    private static final char C_QUOTE = '\"';
    private static final char C_SPACE = ' ';
    private static final String S_CP1250 = "Cp1250";
    private static final String S_CP1251 = "Cp1251";
    private static final String S_CP1252 = "Cp1252";
    private static final String S_CP1253 = "Cp1253";
    private static final String S_CP1254 = "Cp1254";
    private static final String S_CP1255 = "Cp1255";
    private static final String S_CP1256 = "Cp1256";
    private static final String S_CP1257 = "Cp1257";
    private static final String S_CP852 = "Cp852";
    private static final String S_CP855 = "Cp855";
    private static final String S_CP866 = "Cp866";
    private static final String S_CP850 = "Cp850";
    private static final String S_CP737 = "Cp737";
    private static final String S_CP857 = "Cp857";
    private static final String S_CP862 = "Cp862";
    private static final String S_CP720 = "Cp720";
    private static final String S_CP775 = "Cp775";
    private static final String S_CP1047 = "Cp1047";
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_JAVA_USER_LANGUAGE_PROPERTY = "user.language";
    private static final String S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY = "sr";
    private static int nPlatformNumber = -1;
    private static final Logger LOGGER = LoggerFactory.createLogger(PlatformConstants.class);
    private static final String S_CLASS_NAME = PlatformConstants.class.getName();

    public static String[] getWebBrowserForThisPlatform() {
        LOGGER.entering(PlatformConstants.class.getName(), "getWebBrowserForThisPlatform");
        Object[] asBrowser = null;
        switch (PlatformConstants.getCurrentPlatform()) {
            case 1: 
            case 2: 
            case 3: {
                asBrowser = AS_NETSCAPE;
                break;
            }
            case 4: {
                asBrowser = AS_MOZILLA;
                break;
            }
            case 5: {
                asBrowser = AS_IEXPLORE;
                break;
            }
            case 6: {
                asBrowser = AS_NONE;
                break;
            }
            case 7: {
                asBrowser = AS_NONE;
                break;
            }
            default: {
                asBrowser = AS_NETSCAPE;
            }
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getWebBrowserForThisPlatform", "The web browser command for this platform is: " + LogUtils.getArrayAsALoggableString(asBrowser));
        LOGGER.exiting(PlatformConstants.class.getName(), "getWebBrowserForThisPlatform");
        return asBrowser;
    }

    public static String getFileSystemPathSeparator() {
        LOGGER.entering(PlatformConstants.class.getName(), "getFileSystemPathSeparator");
        LOGGER.exiting(PlatformConstants.class.getName(), "getFileSystemPathSeparator");
        return File.separator;
    }

    public static String[] getShellExecPrefixForCurrentPlatform() {
        LOGGER.entering(PlatformConstants.class.getName(), "getShellExecPrefixForCurrentPlatform");
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getShellExecPrefixForCurrentPlatform", "Platform is UNIX, returning " + LogUtils.getArrayAsALoggableString(AS_SHELL_EXEC_UNIX) + " as shell exec prefix");
            LOGGER.exiting(PlatformConstants.class.getName(), "getShellExecPrefixForCurrentPlatform");
            return (String[])AS_SHELL_EXEC_UNIX.clone();
        }
        if (PlatformConstants.isCurrentPlatformWindows()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getShellExecPrefixForCurrentPlatform", "Platform is Windows, returning " + LogUtils.getArrayAsALoggableString(AS_SHELL_EXEC_WIN) + " as shell exec prefix");
            LOGGER.exiting(PlatformConstants.class.getName(), "getShellExecPrefixForCurrentPlatform");
            return (String[])AS_SHELL_EXEC_WIN.clone();
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getShellExecPrefixForCurrentPlatform", "Platform is OS/400, returning " + LogUtils.getArrayAsALoggableString(AS_SHELL_EXEC_OS400) + " as shell exec prefix");
            LOGGER.exiting(PlatformConstants.class.getName(), "getShellExecPrefixForCurrentPlatform");
            return (String[])AS_SHELL_EXEC_OS400.clone();
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getShellExecPrefixForCurrentPlatform", "Platform not known (neither UNIX nor Windows) returning an empty string for shell exec prefix");
        LOGGER.exiting(PlatformConstants.class.getName(), "getShellExecPrefixForCurrentPlatform");
        return AS_EMPTY;
    }

    public static boolean isCurrentPlatformUNIX() {
        LOGGER.entering(PlatformConstants.class.getName(), "isCurrentPlatformUNIX");
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        if (nCurrentPlatform == 1 || nCurrentPlatform == 2 || nCurrentPlatform == 3 || nCurrentPlatform == 4 || nCurrentPlatform == 6) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isCurrentPlatformUNIX", "Current platform was detected as a UNIX system");
            LOGGER.exiting(PlatformConstants.class.getName(), "isCurrentPlatformUNIX");
            return true;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "isCurrentPlatformUNIX", "Current platform was not detected as a UNIX system");
        LOGGER.exiting(PlatformConstants.class.getName(), "isCurrentPlatformUNIX");
        return false;
    }

    public static boolean isCurrentPlatformWindows() {
        LOGGER.entering(PlatformConstants.class.getName(), "isCurrentPlatformWindows");
        if (PlatformConstants.getCurrentPlatform() == 5) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isCurrentPlatformWindows", "Current platform was detected as a Windows system");
            LOGGER.exiting(PlatformConstants.class.getName(), "isCurrentPlatformWindows");
            return true;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "isCurrentPlatformWindows", "Current platform was not detected as a Windows system");
        LOGGER.exiting(PlatformConstants.class.getName(), "isCurrentPlatformWindows");
        return false;
    }

    public static boolean isCurrentPlatformOS400() {
        LOGGER.entering(PlatformConstants.class.getName(), "isCurrentPlatformOS400");
        int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
        if (nCurrentPlatform == 7) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isCurrentPlatformOS400", "Current platform was detected as a OS/400 system");
            LOGGER.exiting(PlatformConstants.class.getName(), "isCurrentPlatformOS400");
            return true;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "isCurrentPlatformOS400", "Current platform was not detected as a OS/400 system");
        LOGGER.exiting(PlatformConstants.class.getName(), "isCurrentPlatformOS400");
        return false;
    }

    public static String getWSAdminInterpretorName() {
        LOGGER.entering(PlatformConstants.class.getName(), "getWSAdminInterpretorName");
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getWSAdminInterpretorName", "Assuming the wsadmin interperetor to be wsadmin.sh as the current platform was detected to be UNIX");
            LOGGER.exiting(PlatformConstants.class.getName(), "getWSAdminInterpretorName");
            return S_WSADMIN_UNIX;
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getWSAdminInterpretorName", "Assuming the wsadmin interperetor to be wsadmin as the current platform was detected to be OS/400");
            LOGGER.exiting(PlatformConstants.class.getName(), "getWSAdminInterpretorName");
            return S_WSADMIN_OS400;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getWSAdminInterpretorName", "Assuming the wsadmin interperetor to be wsadmin.bat as the current platform was detected to be Windows");
        LOGGER.exiting(PlatformConstants.class.getName(), "getWSAdminInterpretorName");
        return S_WSADMIN_WINDOWS;
    }

    public static String getANTInterpretorName() {
        LOGGER.entering(PlatformConstants.class.getName(), "getANTInterpretorName");
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getANTInterpretorName", "Assuming the ANT interperetor to be ant.sh as the current platform was detected to be UNIX");
            LOGGER.exiting(PlatformConstants.class.getName(), "getANTInterpretorName");
            return S_ANT_UNIX;
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getANTInterpretorName", "Assuming the ANT interperetor to be ant as the current platform was detected to be OS/400");
            LOGGER.exiting(PlatformConstants.class.getName(), "getANTInterpretorName");
            return S_ANT_OS400;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getANTInterpretorName", "Assuming the ANT interperetor to be ant.bat as the current platform was detected to be Windows");
        LOGGER.exiting(PlatformConstants.class.getName(), "getANTInterpretorName");
        return S_ANT_WINDOWS;
    }

    public static String getWSANTInterpretorName() {
        LOGGER.entering(PlatformConstants.class.getName(), "getANTInterpretorName");
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getANTInterpretorName", "Assuming the ANT interperetor to be ws_ant.sh as the current platform was detected to be UNIX");
            LOGGER.exiting(PlatformConstants.class.getName(), "getANTInterpretorName");
            return S_WS_ANT_UNIX;
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getANTInterpretorName", "Assuming the ANT interperetor to be ws_ant as the current platform was detected to be OS/400");
            LOGGER.exiting(PlatformConstants.class.getName(), "getANTInterpretorName");
            return S_WS_ANT_OS400;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getANTInterpretorName", "Assuming the ANT interperetor to be ws_ant.bat as the current platform was detected to be Windows");
        LOGGER.exiting(PlatformConstants.class.getName(), "getANTInterpretorName");
        return S_WS_ANT_WINDOWS;
    }

    public static String convertExecArrayToPlatformSpecificExecCommand(String[] asExecArray) {
        LOGGER.entering(PlatformConstants.class.getName(), "convertExecArrayToPlatformSpecificExecCommand");
        Object[] asExecArrayCopy = new String[asExecArray.length];
        ArrayUtils.cloneArray(asExecArrayCopy, asExecArray);
        PlatformConstants.quoteStringsWithSpacesInTheArray((String[])asExecArrayCopy);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "convertExecArrayToPlatformSpecificExecCommand", "Incoming exec string array was: " + LogUtils.getArrayAsALoggableString(asExecArray));
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "convertExecArrayToPlatformSpecificExecCommand", "Converted exec string array is: " + LogUtils.getArrayAsALoggableString(asExecArrayCopy));
        LOGGER.exiting(PlatformConstants.class.getName(), "convertExecArrayToPlatformSpecificExecCommand");
        return ArrayUtils.join(S_SPACE, asExecArrayCopy);
    }

    public static int getCurrentPlatform() {
        LOGGER.entering(PlatformConstants.class.getName(), "getCurrentPlatform");
        if (nPlatformNumber != -1) {
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return nPlatformNumber;
        }
        String locale = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        Locale l = new Locale(locale);
        String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase(l);
        if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as AIX");
            nPlatformNumber = 1;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 1;
        }
        if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as HP-UX");
            nPlatformNumber = 2;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 2;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as Solaris");
            nPlatformNumber = 3;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 3;
        }
        if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as Linux");
            nPlatformNumber = 4;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 4;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as Windows");
            nPlatformNumber = 5;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 5;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, sOSName) || Pattern.matches(S_OS390_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as zOS");
            nPlatformNumber = 6;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 6;
        }
        if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentPlatform", "Current platform was detected as OS/400");
            nPlatformNumber = 7;
            LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
            return 7;
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getCurrentPlatform", "Current platform could not be detected as any known platform");
        nPlatformNumber = 0;
        LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatform");
        return 0;
    }

    public static String getCurrentPlatformName() {
        LOGGER.entering(PlatformConstants.class.getName(), "getCurrentPlatformName");
        String sCurrentPlatformName = null;
        switch (PlatformConstants.getCurrentPlatform()) {
            case 1: {
                sCurrentPlatformName = S_AIX;
                break;
            }
            case 3: {
                sCurrentPlatformName = S_SOLARIS;
                break;
            }
            case 2: {
                sCurrentPlatformName = S_HPUX;
                break;
            }
            case 4: {
                sCurrentPlatformName = S_LINUX;
                break;
            }
            case 5: {
                sCurrentPlatformName = S_WINDOWS;
                break;
            }
            case 6: {
                sCurrentPlatformName = S_Z_OS;
                break;
            }
            case 7: {
                sCurrentPlatformName = S_OS400;
                break;
            }
            default: {
                sCurrentPlatformName = S_UNKNOWN;
            }
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getCurrentPlatformName", "The current platform was determined to be: " + sCurrentPlatformName);
        LOGGER.exiting(PlatformConstants.class.getName(), "getCurrentPlatformName");
        return sCurrentPlatformName;
    }

    public static String getEnvironmentVariableValue(String sName) {
        LOGGER.entering(PlatformConstants.class.getName(), "getEnvironmentVariableValue");
        LOGGER.exiting(PlatformConstants.class.getName(), "getEnvironmentVariableValue");
        return ProcessEnvironment.getEnvironmentVariableValue(sName);
    }

    public static String convertToShellVariable(String sName) {
        LOGGER.entering(PlatformConstants.class.getName(), "convertToShellVariable");
        if (PlatformConstants.isCurrentPlatformUNIX() || PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.exiting(PlatformConstants.class.getName(), "convertToShellVariable");
            return "${" + sName + S_UNIX_SHELL_VARIABLE_BRACKET_STOP;
        }
        if (PlatformConstants.isCurrentPlatformWindows()) {
            LOGGER.exiting(PlatformConstants.class.getName(), "convertToShellVariable");
            return S_PERCENTAGE + sName + S_PERCENTAGE;
        }
        LOGGER.exiting(PlatformConstants.class.getName(), "convertToShellVariable");
        return sName;
    }

    public static String convertToShellParam(String sParam) {
        LOGGER.entering(PlatformConstants.class.getName(), "convertToShellParam");
        if (sParam.matches(S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES) && !PlatformConstants.isQuoted(sParam)) {
            String sReturn = S_QUOTE + sParam + S_QUOTE;
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "convertToShellParam", "Incoming shell parameter was: " + sParam + ", converted is: " + sReturn);
            LOGGER.exiting(PlatformConstants.class.getName(), "convertToShellParam");
            return sReturn;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "convertToShellParam", "Incoming shell parameter was: " + sParam + ", converted is: " + sParam);
        LOGGER.exiting(PlatformConstants.class.getName(), "convertToShellParam");
        return sParam;
    }

    public static String getCurrentWorkingDirectory() {
        LOGGER.entering(PlatformConstants.class.getName(), "getCurrentWorkingDirectory");
        String sCurrentWorkingDirectory = new File(S_DOT + PlatformConstants.getFileSystemPathSeparator()).getAbsolutePath();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCurrentWorkingDirectory", "Current working directory is: " + sCurrentWorkingDirectory);
        LOGGER.entering(PlatformConstants.class.getName(), "getCurrentWorkingDirectory");
        return sCurrentWorkingDirectory;
    }

    public static String getSystemTempDirectory() {
        LOGGER.entering(PlatformConstants.class.getName(), "getSystemTempDirectory");
        String sTempDirectory = System.getProperty("java.io.tmpdir");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getSystemTempDirectory", "System temp directory is: " + sTempDirectory);
        LOGGER.entering(PlatformConstants.class.getName(), "getSystemTempDirectory");
        return sTempDirectory;
    }

    public static String getProperEncodingForCurrentOSShellScripts() {
        String sEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        if (PlatformConstants.isCurrentPlatformWindows()) {
            String currentEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
            return PlatformConstants.lookupEncoding(currentEncoding);
        }
        if (PlatformConstants.getCurrentPlatform() == 6) {
            return S_CP1047;
        }
        return sEncoding;
    }

    private static String lookupEncoding(String currentEncoding) {
        if (currentEncoding.equalsIgnoreCase(S_CP1252)) {
            return S_CP850;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1251)) {
            if (PlatformConstants.isSerbianCyrillic()) {
                return S_CP855;
            }
            return S_CP866;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1250)) {
            return S_CP852;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1253)) {
            return S_CP737;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1254)) {
            return S_CP857;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1255)) {
            return S_CP862;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1256)) {
            return S_CP720;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1257)) {
            return S_CP775;
        }
        return currentEncoding;
    }

    private static boolean isSerbianCyrillic() {
        String userLanguage = System.getProperty(S_JAVA_USER_LANGUAGE_PROPERTY);
        return userLanguage.equalsIgnoreCase(S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY);
    }

    private static void quoteStringsWithSpacesInTheArray(String[] asStringArrayToModify) {
        LOGGER.entering(PlatformConstants.class.getName(), "quoteStringsWithSpacesInTheArray");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "quoteStringsWithSpacesInTheArray", "Incoming string array is: " + LogUtils.getArrayAsALoggableString(asStringArrayToModify));
        for (int i = 0; i < asStringArrayToModify.length; ++i) {
            asStringArrayToModify[i] = PlatformConstants.convertToShellParam(asStringArrayToModify[i]);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "quoteStringsWithSpacesInTheArray", "Converted string array is: " + LogUtils.getArrayAsALoggableString(asStringArrayToModify));
        LOGGER.exiting(PlatformConstants.class.getName(), "quoteStringsWithSpacesInTheArray");
    }

    private static boolean isQuoted(String sToCheck) {
        LOGGER.entering(PlatformConstants.class.getName(), "isQuoted");
        boolean fQuoted = false;
        for (int i = 0; i < sToCheck.length(); ++i) {
            if (sToCheck.charAt(i) == '\"') {
                boolean bl = fQuoted = !fQuoted;
            }
            if (sToCheck.charAt(i) != ' ' || fQuoted) continue;
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isQuoted", "Incoming string " + sToCheck + " was not properly quoted");
            LOGGER.exiting(PlatformConstants.class.getName(), "isQuoted");
            return false;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "isQuoted", "Incoming string " + sToCheck + " was properly quoted");
        LOGGER.exiting(PlatformConstants.class.getName(), "isQuoted");
        return true;
    }
}

