/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.execengine;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamCollectionThread
extends Thread {
    private InputStream m_inputstream = null;
    private String m_sBuffer = "";
    private boolean m_fStopFlag = false;
    private static final String S_EOLN = "\n";
    private static final int N_SLEEP = 5;
    private static final Logger LOGGER = LoggerFactory.createLogger(StreamCollectionThread.class);
    private static final String S_CLASS_NAME = StreamCollectionThread.class.getName();
    private static final String S_I5OS_JOB_ENCODING = "os400.job.file.encoding";
    protected static final String S_EMPTY = "";

    public StreamCollectionThread(InputStream inputstream) {
        LOGGER.entering(StreamCollectionThread.class.getName(), "StreamCollectionThread");
        this.m_inputstream = inputstream;
        LOGGER.exiting(StreamCollectionThread.class.getName(), "StreamCollectionThread");
    }

    public void run() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "run");
        BufferedReader bufferedreaderIn = new BufferedReader(new InputStreamReader(this.m_inputstream));
        if (PlatformConstants.isCurrentPlatformOS400()) {
            try {
                String encoding = System.getProperty(S_I5OS_JOB_ENCODING);
                if (encoding != null) {
                    bufferedreaderIn = new BufferedReader(new InputStreamReader(this.m_inputstream, encoding));
                }
            }
            catch (UnsupportedEncodingException e) {
                bufferedreaderIn = new BufferedReader(new InputStreamReader(this.m_inputstream));
            }
        }
        String sIn = null;
        do {
            try {
                sIn = bufferedreaderIn.readLine();
                if (sIn != null) {
                    LOGGER.logp(Level.FINE, S_CLASS_NAME, "run", "Collected this string from the stream: " + sIn);
                    this.m_sBuffer = this.m_sBuffer + sIn + S_EOLN;
                }
                Thread.sleep(5L);
            }
            catch (IOException e) {
                LogUtils.logException(LOGGER, e);
            }
            catch (InterruptedException e) {
                LogUtils.logException(LOGGER, e);
            }
        } while (sIn != null || !this.shouldWeStopCollecting());
        LOGGER.exiting(StreamCollectionThread.class.getName(), "run");
    }

    public void startCollecting() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "startCollecting");
        this.m_fStopFlag = false;
        this.start();
        LOGGER.exiting(StreamCollectionThread.class.getName(), "startCollecting");
    }

    public void stopCollecting() throws InterruptedException {
        LOGGER.entering(StreamCollectionThread.class.getName(), "stopCollecting");
        this.m_fStopFlag = true;
        this.join();
        LOGGER.exiting(StreamCollectionThread.class.getName(), "stopCollecting");
    }

    public String toString() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "toString");
        LOGGER.exiting(StreamCollectionThread.class.getName(), "toString");
        return this.m_sBuffer;
    }

    private boolean shouldWeStopCollecting() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "shouldWeStopCollecting");
        LOGGER.exiting(StreamCollectionThread.class.getName(), "shouldWeStopCollecting");
        return this.m_fStopFlag;
    }
}

