/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.execengine;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.execengine.ProcessTimeoutThread;
import com.ibm.ws.install.configmanager.execengine.StreamCollectionThread;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.ParameterPassingUtils;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecEngine {
    private String m_sOut = null;
    private String m_sErr = null;
    private int m_nRetVal = -1;
    private static final Logger LOGGER = LoggerFactory.createLogger(ExecEngine.class);
    private static final String S_CLASS_NAME = ExecEngine.class.getName();

    public int executeIncomingArguments(String[] asArguments, int nTimeOut) {
        LOGGER.entering(ExecEngine.class.getName(), "executeIncomingArguments( String[], int )");
        LOGGER.exiting(ExecEngine.class.getName(), "executeIncomingArguments( String[], int )");
        return this.spawnProcess(asArguments);
    }

    public int executeIncomingArguments(Vector vsArgs, int nTimeOut) {
        LOGGER.entering(ExecEngine.class.getName(), "executeIncomingArguments( Vector, int )");
        String[] asArguments = new String[vsArgs.size()];
        for (int i = 0; i < vsArgs.size(); ++i) {
            asArguments[i] = (String)vsArgs.elementAt(i);
        }
        LOGGER.exiting(ExecEngine.class.getName(), "executeIncomingArguments( Vector, int )");
        return this.spawnProcess(asArguments);
    }

    public String getProcessStdOut() {
        LOGGER.entering(ExecEngine.class.getName(), "getProcessStdOut");
        if (this.m_sOut != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getProcessStdOut", "The process' standard out follows\n" + this.m_sOut);
        }
        LOGGER.exiting(ExecEngine.class.getName(), "getProcessStdOut");
        return this.m_sOut;
    }

    public String getProcessStdErr() {
        LOGGER.entering(ExecEngine.class.getName(), "getProcessStdErr");
        if (this.m_sErr != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getProcessStdErr", "The process' standard error follows\n" + this.m_sErr);
        }
        LOGGER.exiting(ExecEngine.class.getName(), "getProcessStdErr");
        return this.m_sErr;
    }

    public int getProcessRetCode() {
        LOGGER.entering(ExecEngine.class.getName(), "getProcessRetCode");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getProcessRetCode", "The process' return code was: " + this.m_nRetVal);
        LOGGER.exiting(ExecEngine.class.getName(), "getProcessRetCode");
        return this.m_nRetVal;
    }

    protected void doWaitForProcessToTerminateOrTimeOut(Process processThis) throws InterruptedException {
        LOGGER.entering(ExecEngine.class.getName(), "doWaitForProcessToTerminateOrTimeOut");
        ProcessTimeoutThread pttThisProcess = new ProcessTimeoutThread(processThis, ConfigManagerConstants.getProcessTimeOutTime());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doWaitForProcessToTerminateOrTimeOut", "Starting to time the process");
        pttThisProcess.startTiming();
        processThis.waitFor();
        pttThisProcess.stopTiming();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doWaitForProcessToTerminateOrTimeOut", "Stopped timing the process (it was not timed out)");
        LOGGER.exiting(ExecEngine.class.getName(), "doWaitForProcessToTerminateOrTimeOut");
    }

    private int spawnProcess(String[] asArguments) {
        LOGGER.entering(ExecEngine.class.getName(), "spawnProcess");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "spawnProcess", "Launching this command: " + LogUtils.getArrayAsALoggableString(asArguments));
        int nRetVal = -1;
        try {
            Process processThis = Runtime.getRuntime().exec(asArguments, ExecEngine.getEnvironmentalVariables());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "spawnProcess", "The launched process is: " + processThis.toString());
            StreamCollectionThread sctOutput = new StreamCollectionThread(processThis.getInputStream());
            StreamCollectionThread sctError = new StreamCollectionThread(processThis.getErrorStream());
            sctOutput.startCollecting();
            sctError.startCollecting();
            this.doWaitForProcessToTerminateOrTimeOut(processThis);
            sctOutput.stopCollecting();
            sctError.stopCollecting();
            this.m_sOut = sctOutput.toString();
            this.m_sErr = sctError.toString();
            nRetVal = this.m_nRetVal = processThis.exitValue();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "spawnProcess", "The process' return code was: " + this.m_nRetVal + ", the command was: " + LogUtils.getArrayAsALoggableString(asArguments));
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            nRetVal = -1;
        }
        catch (InterruptedException e) {
            LogUtils.logException(LOGGER, e);
            nRetVal = -1;
        }
        catch (IllegalThreadStateException e) {
            LogUtils.logException(LOGGER, e);
            nRetVal = -1;
        }
        LOGGER.exiting(ExecEngine.class.getName(), "spawnProcess");
        return nRetVal;
    }

    private static String[] getEnvironmentalVariables() {
        String[] saEnvVariables = ParameterPassingUtils.retrieveParametersAsArray(false);
        String[] saCurrentEnvVariables = ParameterPassingUtils.convertMapToParameterArray(System.getenv());
        String[] saAllVars = new String[saEnvVariables.length + saCurrentEnvVariables.length];
        ArrayUtils.appendArray(saAllVars, saCurrentEnvVariables, 0);
        ArrayUtils.appendArray(saAllVars, saEnvVariables, saCurrentEnvVariables.length);
        return saAllVars;
    }
}

