/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.actionengine.ant.utils.ANTTargetCaller;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.FileSetUtils;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.StringFormatUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;

public class ForEachAntTask
extends Task {
    private String m_sList = new String();
    private String m_sTarget = null;
    private String m_sPropertyName = null;
    private Hashtable m_hashtableParams = new Hashtable();
    private Vector m_vfilesets = new Vector();
    private String m_sErrorMessage = new String();
    private static final String S_COMMA = ",";
    private static final String S_DOTS = "...";
    private static final String S_EMPTY = "";
    private static final String S_NO_TARGET = "No target specified";
    private static final String S_NO_PROPERTY_NAME = "Missing property name";
    private static final String S_NO_LIST_OR_PATH = "No list or set of paths was specified";
    private static final String S_ANT_CALL = "antcall";
    private static final Logger LOGGER = LoggerFactory.createLogger(ForEachAntTask.class);
    private static final String S_CLASS_NAME = ForEachAntTask.class.getName();

    public void init() throws BuildException {
        LOGGER.entering(this.getClass().getName(), "init");
        super.init();
        this.m_sList = new String();
        this.m_sTarget = null;
        this.m_sPropertyName = null;
        this.m_hashtableParams = new Hashtable();
        this.m_sErrorMessage = new String();
        this.m_vfilesets = new Vector();
        LOGGER.exiting(this.getClass().getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(this.getClass().getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        if (this.m_sList.length() != 0) {
            this.callTargetWhileIteratingOverGivenList();
        }
        if (this.m_vfilesets.size() != 0) {
            this.callTargetWhileIteratingOverGivenFileSets();
        }
        LOGGER.exiting(this.getClass().getName(), "execute");
    }

    public void setTarget(String sTarget) {
        LOGGER.entering(this.getClass().getName(), "setTarget");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setTarget", "Called target set as: " + sTarget);
        this.m_sTarget = sTarget;
        LOGGER.exiting(this.getClass().getName(), "setTarget");
    }

    public void setList(String sList) {
        LOGGER.entering(this.getClass().getName(), "setList");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setList", "Incoming list set to: " + sList);
        this.m_sList = this.m_sList + sList;
        LOGGER.exiting(this.getClass().getName(), "setList");
    }

    public void setCounter(String sCounter) {
        LOGGER.entering(this.getClass().getName(), "setCounter");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setCounter", "Incoming counter set as: " + sCounter);
        this.addTheGivenCountersToOurInternalList(sCounter);
        LOGGER.exiting(this.getClass().getName(), "setCounter");
    }

    public void setPropertyName(String sPropertyName) {
        LOGGER.entering(this.getClass().getName(), "setPropertyName");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setPropertyName", "Incoming property name set to: " + sPropertyName);
        this.m_sPropertyName = sPropertyName;
        LOGGER.exiting(this.getClass().getName(), "setPropertyName");
    }

    public void addConfiguredParam(Property propertyThis) {
        LOGGER.entering(this.getClass().getName(), "addConfiguredParam");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addConfiguredParam", "Adding configured param: " + propertyThis.toString());
        this.m_hashtableParams.put(propertyThis.getName(), propertyThis.getValue());
        LOGGER.exiting(this.getClass().getName(), "addConfiguredParam");
    }

    public void addConfiguredFileset(FileSet filesetThis) {
        LOGGER.entering(this.getClass().getName(), "addConfiguredFileset");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addConfiguredFileset", "Added the fileset: " + filesetThis.toString());
        this.m_vfilesets.add(filesetThis);
        LOGGER.exiting(this.getClass().getName(), "addConfiguredFileset");
    }

    private void addTheGivenCountersToOurInternalList(String sCounter) {
        LOGGER.entering(this.getClass().getName(), "addTheGivenCountersToOurInternalList");
        int nIndexOfDots = sCounter.indexOf(S_DOTS);
        String sStartingDigit = sCounter.substring(0, nIndexOfDots);
        String sEndingDigit = sCounter.substring(nIndexOfDots + S_DOTS.length(), sCounter.length());
        String sCountersList = StringFormatUtils.getTheseNumbersAsACommaSeparatedList(sStartingDigit, sEndingDigit);
        this.m_sList = this.m_sList.length() != 0 ? this.m_sList + S_COMMA + sCountersList : sCountersList;
        LOGGER.exiting(this.getClass().getName(), "addTheGivenCountersToOurInternalList");
    }

    private void callTargetWhileIteratingOverGivenList() throws BuildException {
        LOGGER.entering(this.getClass().getName(), "callTargetWhileIteratingOverGivenList");
        StringTokenizer st = new StringTokenizer(this.m_sList, S_COMMA);
        while (st.hasMoreTokens()) {
            String sThis = st.nextToken().trim();
            this.callGivenTargetWithThisIterativePropertyValue(sThis);
        }
        LOGGER.exiting(this.getClass().getName(), "callTargetWhileIteratingOverGivenList");
    }

    private void callTargetWhileIteratingOverGivenFileSets() throws BuildException {
        LOGGER.entering(this.getClass().getName(), "callTargetWhileIteratingOverGivenFileSets");
        Vector vsFilePaths = FileSetUtils.getAllFilesInTheseFileSets(this.m_vfilesets, this.getProject());
        for (int i = 0; i < vsFilePaths.size(); ++i) {
            String sFilePathThis = (String)vsFilePaths.elementAt(i);
            this.callGivenTargetWithThisIterativePropertyValue(sFilePathThis);
        }
        LOGGER.exiting(this.getClass().getName(), "callTargetWhileIteratingOverGivenFileSets");
    }

    private void callGivenTargetWithThisIterativePropertyValue(String sValue) throws BuildException {
        LOGGER.entering(this.getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "callGivenTargetWithThisIterativePropertyValue", "Calling " + this.m_sTarget + " with property " + this.m_sPropertyName + " set to " + sValue);
        this.m_hashtableParams.put(this.m_sPropertyName, sValue);
        ANTTargetCaller.callTargetWithTheseValues(this.m_sTarget, this.m_hashtableParams, this.getProject(), this.getOwningTarget());
        LOGGER.exiting(this.getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(this.getClass().getName(), "doAllParamsCheckOutOk");
        if (this.m_sTarget == null) {
            this.m_sErrorMessage = S_NO_TARGET;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sPropertyName == null) {
            this.m_sErrorMessage = S_NO_PROPERTY_NAME;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sTarget.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_NO_TARGET;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sPropertyName.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_NO_PROPERTY_NAME;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_vfilesets.size() == 0 && this.m_sList == null) {
            this.m_sErrorMessage = S_NO_LIST_OR_PATH;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

